/* @(#)midinfo.c	19.1.1.2 (ESO-DMD) 04/28/03 15:57:13 */
/*===========================================================================
  Copyright (C) 1995,2003 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*+++++++++++++++++++++ Module MIDINFO +++++++++++++++++++++++++++++++++++++++
.LANGUAGE   C
.IDENTIFICATION  Module MIDINFO.C
.AUTHOR   Klaus Banse		ESO - Garching
.COMMENTS
holds TYPINFO, SHOWFCB, SHOWFCT
.KEYWORDS MIDAS Descriptors, Keywords
.ENVIRONMENT VMS and UNIX

.VERSION  [1.00]  880212: pull out from MIDDSC.C

 030422		last modif

------------------------------------------------------------------------*/
 
#include <fileexts.h>
 
#include <string.h>

/*

*/ 
 
#ifdef __STDC__
void MID_TYPINFO(char dtype , int dbytes , char * type , int ltype)
#else
void MID_TYPINFO(dtype,dbytes,type,ltype)
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE 
return descriptor/keyword type at current position
.RETURNS 
nothing
-----------------------------------------------------------------*/
char      dtype   /* IN: input character type I, R, D, L or C  */;
int	  dbytes  /* IN: no. of bytes per descriptor element  */;
char	  *type	  /* OUT: expanded descriptor type (e.g CHARACTER*22) */;
int	  ltype   /* IN: max length of above  */;
#endif 
{

static char	charac[9] = {'C','H','A','R','A','C','T','E','R'};
 
int   n, mm, cl;
 
 


/*  first we clear the type string  */
 
memset((void *)type,32,(size_t)ltype);
	
*type = dtype;

 
/*  already done for integer, logical, real + double precision   */
 
if (dtype != 'C') return;

 
/*  here for character arrays - that's where all the work is  */

if (dbytes == 1) return;


if (dbytes < 10)
   mm = 1;
else if (dbytes < 100)
   mm = 2;
else if (dbytes < 1000)
   mm = 3;
else if (dbytes < 10000)
   mm = 4;
else
   mm = 5;
 
cl = mm + 1;					/* bytes needed for *xxx */
	

/*  now see, how much is left  */
 
n = ltype - cl;				
if (n < 1)
   {
   *type = '*';
   *(type+1) = '*';
   *(type+2) = '*';
   return;
   }
else
   if (n > 9) n = 9;		/* minimize with length of  charac */
   	
(void) strncpy(type,charac,n);
(void) sprintf((type+n),"%d\n",dbytes);
}

/*

*/

 
#ifdef __STDC__
void MID_SHOWFCB(char *name)
#else
void MID_SHOWFCB(name)
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE 
display contents of FCB of that file
.RETURNS 
nothing
-----------------------------------------------------------------*/
char      *name;	/* IN: file name */
#endif 


{
char    cbuf[32], tbuf[40], outbuf[80];

int  imnoa;

struct  FCT_STRUCT *fctpntr;

struct  FCB_STRUCT *fcbp;




(void) SCFOPN(name,D_OLD_FORMAT,0,F_OLD_TYPE,&imnoa);
fctpntr = FCT.ENTRIES + imnoa;
fcbp = fctpntr->FZP;

(void) sprintf(outbuf,"FCB of file %s (imno %d)",name,imnoa);
SCTPUT(outbuf);
SCTPUT("   {");
SCTPUT("   RESERV5[4]  = blanks...");
(void) strncpy(cbuf,fcbp->BDTYPE,8);
cbuf[8] = '\0';
(void) sprintf(outbuf,"   BDTYPE[8]   = '%s'",cbuf);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   NDVAL       = %d",fcbp->NDVAL);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   RESERV0[20] = blanks...");
SCTPUT(outbuf);
(void) sprintf(outbuf,"   SWPSHORT    = '%c'",fcbp->SWPSHORT);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   SWPINT      = '%c'",fcbp->SWPINT);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   FLOTFMT     = '%c'",fcbp->FLOTFMT);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   DSCFLAG     = '%c'",fcbp->DSCFLAG);
SCTPUT(outbuf);
(void) strncpy(cbuf,fcbp->VERSION,8);
cbuf[8] = '\0';
if (strcmp(&cbuf[5],"010") == 0)
   (void) strcpy(tbuf,"old - before 01SEP");
else if (strcmp(&cbuf[5],"100") == 0)
   (void) strcpy(tbuf,"before 02SEP");
else if (strcmp(&cbuf[5],"101") == 0)
   (void) strcpy(tbuf,"before 03FEB");
else 
   (void) strcpy(tbuf,"since 03FEB");
(void) sprintf(outbuf,"   VERSION[8]  = '%s (%s)'",cbuf,tbuf);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   PROT        = %d",fcbp->PROT);
SCTPUT(outbuf) ;
(void) sprintf(outbuf,
      "   DATAINFO    = %d, %d, %d, %d, %d, %d (Naxis, Npix,d_fmt,1.d_byte)",
               fcbp->DATAINFO[0],fcbp->DATAINFO[1],fcbp->DATAINFO[2],
               fcbp->DATAINFO[3],fcbp->DATAINFO[4],fcbp->DATAINFO[5]);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   INCARN      = %d",fcbp->INCARN);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   PTRLDB      = %d",fcbp->PTRLDB);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   NOLDB       = %d",fcbp->NOLDB);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   LEXBDF      = %d",fcbp->LEXBDF);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   PEXBDF      = %d",fcbp->PEXBDF);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   ENDLDB      = %d, %d",
               fcbp->ENDLDB[0],fcbp->ENDLDB[1]);
SCTPUT(outbuf);
SCTPUT("   RESERV1[12] = blanks...");
SCTPUT("   RESERV4[6]  = blanks...");
(void) sprintf(outbuf,"   DIREXT      = %d",fcbp->DIREXT);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   DIRENTRY    = %d",fcbp->DIRENTRY);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   INLDB       = %d, %d",
               fcbp->INLDB[0],fcbp->INLDB[1]);
SCTPUT(outbuf);
SCTPUT("   RESERV2[24] = blanks...");
(void) sprintf(outbuf,"   DBEGIN      = %d",fcbp->DBEGIN);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   DFILLED     = %d (dscdir in use)",fcbp->DFILLED);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   DSIZE       = %d (dscdir allocated)",fcbp->DSIZE);
SCTPUT(outbuf) ;
(void) sprintf(outbuf,"   MAINSEG     = %d, %d, %d, %d, %d",
               fcbp->MAINSEG[0],fcbp->MAINSEG[1],fcbp->MAINSEG[2],
               fcbp->MAINSEG[3],fcbp->MAINSEG[4]);
SCTPUT(outbuf);
(void) strncpy(cbuf,fcbp->CREATE,28);
cbuf[28] = '\0';
(void) sprintf(outbuf,"   CREATE[28]  = '%s'",cbuf);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   CRETIM      = %d, %d",fcbp->CRETIM[0],fcbp->CRETIM[1]);
SCTPUT(outbuf);
SCTPUT("   RESERV3[272]= blanks...");
(void) sprintf(outbuf,"   FITSINFO    = %d, %d (nopix, offset in FITS file)",
               fcbp->FITSINFO[0],fcbp->FITSINFO[1]);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   NEXT        = %d",fcbp->NEXT);
SCTPUT(outbuf);
SCTPUT("   }");
SCTPUT("    ");
}

 
#ifdef __STDC__
void MID_SHOWFCT(char *name)
#else
void MID_SHOWFCT(name)
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE 
display contents of FCT of that file
.RETURNS 
nothing
-----------------------------------------------------------------*/
char      *name;	/* IN: file name */
#endif

{
char   outbuf[80];

int  imnoa;

struct  FCT_STRUCT *fctpntr;




(void) SCFOPN(name,D_OLD_FORMAT,0,F_OLD_TYPE,&imnoa);

(void) sprintf(outbuf,"FCT of file %s (imno %d)",name,imnoa);
SCTPUT(outbuf);
SCTPUT("   {");

fctpntr = FCT.ENTRIES + imnoa;
(void) sprintf(outbuf,"   NAMLEN      = %d",fctpntr->NAMLEN);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   IOCHAN      = %d",fctpntr->IOCHAN);
SCTPUT(outbuf);

#if vms
(void) sprintf(outbuf,"   FILEID(a),(b) = %d,%d",
              fctpntr->FILEIDA,fctpntr->FILEIDB);
#else
(void) sprintf(outbuf,"   FILEID      = %d",fctpntr->FILEID);
#endif

SCTPUT(outbuf);
(void) sprintf(outbuf,"   KAUX        = %d, %d, %d",
               fctpntr->KAUX[0],fctpntr->KAUX[1],fctpntr->KAUX[2]);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   SIZE        = %d",fctpntr->SIZE);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   PROT        = %d",fctpntr->PROT);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   COMPRESS    = %d",fctpntr->COMPRESS);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   NOBYTE      = %d",fctpntr->NOBYTE);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   FORMAT      = %d",fctpntr->FORMAT);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   PIXPBL      = %d",fctpntr->PIXPBL);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   STBLOK      = %d",fctpntr->STBLOK);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   DATTYP      = %d",fctpntr->DATTYP);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   FILTYP      = %d",fctpntr->FILTYP);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   FITSEXT     = %d",fctpntr->FITSEXT);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   LINK        = %d, %d",
               fctpntr->LINK[0],fctpntr->LINK[1]);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   NAME        = '%s'",fctpntr->NAME);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   PATH        = '%s'",fctpntr->PATH);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   BDADDR      = %x, %x, %x, %x",
               fctpntr->BDADDR[0],fctpntr->BDADDR[1],
               fctpntr->BDADDR[2],fctpntr->BDADDR[3]);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   PNTR        = %x",fctpntr->PNTR);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   CATALOG     = '%c%c'",
               fctpntr->CATALOG[0],fctpntr->CATALOG[1]);
SCTPUT(outbuf);
(void) sprintf(outbuf,"   ACCESS      = '%c'",fctpntr->ACCESS);
SCTPUT(outbuf);
SCTPUT("   }");
SCTPUT("    ");
}

