/* @(#)midldba.c	11.1.1.1 (ES0-DMD) 11/27/96 16:50:15 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*+++++++++++++++++++++ Module MIDLDBA +++++++++++++++++++++++++++++++++++++++
.LANGUAGE   C
.IDENTIFICATION  Module MIDLDBA
.AUTHOR   Klaus Banse		ESO - Garching
.KEYWORDS Local Descriptor Blocks
.ENVIRONMENT VMS and UNIX
.COMMENTS
holds interface RDLDB
.VERSION  [1.00]  920213: pulled over from midldb.c
.VERSION  [1.10]  930624: use II_SIZE for no. of bytes of long integer
.VERSION  [1.20]  930907: long int -> int !!!
------------------------------------------------------------------------*/
 
 
#include <fileexts.h>
 
 
#define BIT_0  0x1

/*

*/
 
MID_RDLDB(chanl,indx,typ,iatom,ratom,catom,first,alen,extens)

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
read an atom from the local descriptor block, LDB = 4 virtual blocks
.ALGORITHM
Each atom in the LDB is preceded by a header of 3 longwords.
The 1. longword holds the no. of data elements in that atom 
The 2. holds the block no.of next extension. If = -1, no extension exists.
The 3. holds the index of next extension 
.RETURNS 
nothing
-------------------------------------------------------------------------*/

int   chanl	/* IN : channel no. of frame */;
int   indx	/* IN : word # in LDB, where atom is to be read */;
int   typ	/* IN : type of atom 	1=I*4, 2=R*4, 3=character */;
int   first	/* IN : 1st  position of descriptor data to be accessed */;
int   *alen	/* IO : no. of values required, will be set to actual length \
                        of atom starting from pos. 1 specified via first \
			if = 0, only the header will be returned */;
int   *iatom	/* OUT: receives integer atom */;
float  *ratom	/* OUT: receives real atom */;
char   *catom	/* OUT: receives character atom */;
int   *extens	/* OUT: block no. + indx of next extension */;

{

int   felem, rlen, fchar;
int   n, left, slen, from, ldbfrom, ldbto;
int   blockno;
 
char   *ldbpntr;
 
register char  *cpntra, *cpntrb;
register int  nr;

 
/* save input stuff */
 
felem = first;
rlen = *alen;
				/* get 1. header longword = actual length */
*alen = LDB.LDBWORDS.IWORD[indx];
ldbpntr = (char *) &LDB; 


/*  get 2. header longword */
 
if (indx >= LDB_NDSCRW1) 
   {
   blockno = LDB.NEXT;
   (void) OSY_RVB(chanl,ldbpntr,2048,blockno);
   indx = -1;					/* so indx will be 0  */
   }

*extens = LDB.LDBWORDS.IWORD[++indx];	/* that's the next extension */
 

/*  get 3. header longword */

if (indx >= LDB_NDSCRW1) 
   {
   blockno = LDB.NEXT;
   (void) OSY_RVB(chanl,ldbpntr,2048,blockno);
   indx = -1;					/* so indx will be 0  */
   }
					/* the index of next extension */
*(extens+1) = LDB.LDBWORDS.IWORD[++indx];
if (rlen == 0) return;	               /* we just wanted the next extension...*/

 
/*  for character data, split offset into longwords + bytes  */
 
if (typ == 3)
   {
   felem = (felem-1)/II_SIZE ;
   fchar = first - (felem*II_SIZE) ;
   felem ++ ;
   }
 

/*  increment indx + read next LDB, if necessary */
 
indx += felem;
while (indx > LDB_NDSCRW1)
   {
   blockno = LDB.NEXT;
   (void) OSY_RVB(chanl,ldbpntr,2048,blockno);
   indx -= LDB_NDSCRW;
   }


/*  indx is now in [0,509] - initialize counters   */
 
from = 0;
 
if (typ != 3) 
   *alen = *alen - felem + 1 ;
else
   *alen = *alen - first + 1 ;
 
if (*alen > rlen)
   *alen = rlen;		/* total length to be transmitted */
else
   rlen = *alen;


/* branch according to 'typ'  */
 
more_data:
 
if (typ != 3)

	/*  integer + real atom */

   {
   left = LDB_NDSCRW - indx ;		/* no. of lw's left */
   if (rlen < left)			/* transfer in this blockno */
      slen = rlen;	
   else
      slen = left;

	/*  get start + end of LDB segm. */
 
   ldbfrom = indx;
   ldbto = ldbfrom + slen;
   n = from;
 
   if (typ == 1) 
      {
      for (nr=ldbfrom;nr<ldbto;nr++)
         iatom[n++] = LDB.LDBWORDS.IWORD[nr];
      }

   else
      {
      for (nr=ldbfrom;nr<ldbto;nr++)
         ratom[n++] = LDB.LDBWORDS.RWORD[nr];
      }
  
	/*  update pointers */

   rlen -= slen;
   indx += slen;
   from += slen;
   }
 
else
 
   {

	/*  character atom  */
   cpntra = (char *)&LDB.LDBWORDS;
 
   left = (LDB_NDSCRW - indx)*II_SIZE - fchar + 1;
   if (rlen > left)
      slen = left;
   else
      slen = rlen;
 
   ldbfrom = indx*II_SIZE + fchar - 1;

   cpntra = cpntra + ldbfrom;		/* point to first char. */
   cpntrb = catom + from;

   for (nr=0; nr<slen; nr++)		/* copy the stuff over ...  */
      *cpntrb++ = *cpntra++;

   fchar = 1;		/* here we are always at a longword boundary */
   rlen -= slen;
   indx += (slen+(II_SIZE-1))/II_SIZE ;
   from += slen;
   }


/*  read next LDB, if necessary */
 
if (indx > LDB_NDSCRW1)
   {
   blockno = LDB.NEXT;
   (void) OSY_RVB(chanl,ldbpntr,2048,blockno);
   indx = 0;
   }
 
if (rlen > 0) goto more_data;			/* store more data */
 
}
