/* @(#)midldbb.c	11.1.1.1 (ES0-DMD) 11/27/96 16:50:06 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*+++++++++++++++++++++ Module MIDLDBB +++++++++++++++++++++++++++++++++++++
.LANGUAGE   C
.IDENTIFICATION  Module MIDLDBB
.AUTHOR   Klaus Banse		ESO - Garching
.KEYWORDS Local Descriptor Blocks
.ENVIRONMENT VMS and UNIX
.COMMENTS
holds interface WRLDB
.VERSION  [1.00]  920213: pulled over from midldb.c
.VERSION  [1.10]  930907: long int -> int !!!
------------------------------------------------------------------------*/
 
 
#include <fileexts.h>
 
 
#define BIT_0  0x1

/*

*/

MID_WRLDB(chanl,indx,typ,iatom,ratom,catom,first,alen,extens)

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
write into an existing atom in the LDB (only the data is updated)
and return atom length (in data values) and next extension of atom
.ALGORITHM
Each atom in the LDB is preceded by a header of three 4-byte words
The 1. word holds the length of the atom in data elements,
the 2. holds the block no. of next extension. If = -1, no extension exists.
the 3. holds the indx of next extension 
.RETURNS 
nothing
-------------------------------------------------------------------------*/

int   chanl	/* IN : channel no. of frame */;
int   indx	/* IN : index in current LDB  */;
int   typ	/* IN : type of atom 1=I*4, 2=R*4, 3=character data */;
int   *iatom	/* IN : contains integer atom */;
char   *catom	/* IN : contains character atom */;
float  *ratom	/* IN : contains real atom */;
int   first    /* IN : position of descriptor data to be accessed */;
int   *alen	/* IO : no. of values required will be set to actual no. of \
			values modified, starting from 1st position specified \
                        via first */;
int   *extens	/* IO : returns block + indx of extension */;

{
 
int   n, felem, rlen, fchar;
int   left, slen, from, ldbfrom, ldbto;
int   blockno;
 
char   *ldbpntr, *cpntra, *cpntrb;
  
register int  nr;

 
/* save input stuff */
 
felem = first;
rlen = *alen;
				/* get 1. header 4-byte word = actual length */
*alen = LDB.LDBWORDS.IWORD[indx];
ldbpntr = (char *) &LDB; 


/*  get 2. header 4-byte words */
 
if (indx >= LDB_NDSCRW1) 
   {
   blockno = LDB.NEXT;
   (void) OSY_RVB(chanl,ldbpntr,2048,blockno);
   indx = -1;					/* so indx will be 0  */
   }
						/* that's the next extension */
*extens = LDB.LDBWORDS.IWORD[++indx];
 

/*  get 3. header 4-byte words */

if (indx == LDB_NDSCRW1) 
   {
   blockno = LDB.NEXT;
   (void) OSY_RVB(chanl,ldbpntr,2048,blockno);
   indx = -1;					/* so indx will be 0  */
   }
						/* indx of next extension */
*(extens+1) = LDB.LDBWORDS.IWORD[++indx]; 


/*  for character data, split offset into (integer) 4-byte words + bytes  */
 
if (typ == 3)
   {
   felem = (felem-1)/II_SIZE ;
   fchar = first - (felem*II_SIZE) ;
   felem ++ ;
   }
 

/*  increment indx + read next LDB, if necessary */
 
indx += felem;
while (indx > LDB_NDSCRW1)
   {
   blockno = LDB.NEXT;
   (void) OSY_RVB(chanl,ldbpntr,2048,blockno);
   indx -= LDB_NDSCRW;
   }


/*  indx is now in [0,509] - initialize counters   */
 
from = 0;
 
if (typ != 3) 
   *alen = *alen - felem + 1 ;
else
   *alen = *alen - first + 1 ;
 
if (*alen > rlen) 
   *alen = rlen;		/* total length to be transmitted */
else
   rlen = *alen;	


/* branch according to typ  */
 
more_data:
 
if (typ != 3)

	/*  integer + real atom */

   {
   left = LDB_NDSCRW - indx ;		/* no. of int's left */
   if (rlen < left)			/* transfer in this blockno */
      slen = rlen;	
   else
      slen = left;

	/*  get start + end of LDB segm. */
 
   ldbfrom = indx;
   ldbto = ldbfrom + slen;
   n = from;
 
   if (typ == 1) 
      {
      for (nr=ldbfrom;nr<ldbto;nr++)
         LDB.LDBWORDS.IWORD[nr] = iatom[n++];
      }
   else
      {
      for (nr=ldbfrom;nr<ldbto;nr++)
         LDB.LDBWORDS.RWORD[nr] = ratom[n++];
      }
  
	/*  update pointers */

   rlen -= slen;
   indx += slen;
   from += slen;
   }
 
else
 
   {

	/*  character atom  */
   cpntra = (char *) &LDB.LDBWORDS;
 
   left = (LDB_NDSCRW - indx)*II_SIZE - fchar + 1;
   if (rlen > left)
      slen = left;
   else
      slen = rlen;
 
   ldbfrom = indx*II_SIZE + fchar - 1;

   cpntra = cpntra  + ldbfrom;		/* point to first char. */
   cpntrb = catom + from;

   for (nr=0; nr<slen; nr++)		/* copy the stuff over ...  */
      *cpntra++ = *cpntrb++;

   fchar = 1;		/* here we are always at a 4-byte word boundary */
   rlen -= slen;
   indx += (slen+(II_SIZE-1))/II_SIZE ;
   from += slen;
   }


/*  save current LDB + read next LDB, if necessary */
 
blockno = LDB.BLKNUM;
n = OSY_WVB(chanl,ldbpntr,2048,blockno);
 
if (indx > LDB_NDSCRW1)
   {
   blockno = LDB.NEXT;
   n = OSY_RVB(chanl,ldbpntr,2048,blockno);
   indx = 0;
   }
 
if (rlen > 0) goto more_data;			/* store more data */
 
}
