/* @(#)osfile.h	19.1.1.1 (ESO-IPG) 02/25/03 13:50:37 */
/*+++++++++++++++++++
.TYPE                Header
.LANGUAGE            C
.IDENTIFICATION      osfile.h
.AUTHOR              Francois Ochsenbein [ESO-IPG]
.KEYWORDS            File Definitions
.ENVIRONMENT         Unix
.COMMENTS            Definitions related to File Management
.VERSION 1.0	04-Mar-1988  Creation   
.VERSION 1.1	31-Jan-1990  Removed filename operations (in filedef)
.VERSION 2.0	17-Feb-1992  filestatus structure for osfinfo here. CG.
.VERSION 2.1	13-Jul-1992  blocksize remove. SCO/PC does not support it. CG 
--------------------------------------------------------------------------*/

#ifndef  OSFILE_DEF 
#define  OSFILE_DEF      0

/*===========================================================================
 *		Basic Definitions
 *===========================================================================*/

#include <filedef.h>

/*===========================================================================
 *		File structure
 *===========================================================================*/

struct filestatus 		/* structure status (tbd) */
 { 
   long filesize;		/* file size in BYTES 	*/
   long date;           	/* Revision date 	*/
   int  owner;			/* owner (UID) id 	*/
   int  protection;		/* protection 		*/
  };

/*===========================================================================
 *			I/O Functions 
 *===========================================================================*/

#ifndef _TEMPLATES_
#include <compiler.h>
#endif

#if _TEMPLATES_
int  osaopen	(char *phname, int mode);
int  osaclose	(int fid);
int  osaread	(int fid, char *buffer, unsigned int nochar);
int  osawrite	(int fid, char *buffer, unsigned int nochar);
int  osawait	(int fid);
int  osaunix	(int fid);
long osaseek	(int fid, long offset, int mode);
long osasize	(int fid);

int  osdopen	(char *phname, int mode);
int  osdclose	(int fid);
int  osdread	(int fid, char *buffer, unsigned int nochar);
int  osdwrite	(int fid, char *buffer, unsigned int nochar);
int  osdputs	(int fid, char *buffer);
int  osdwait	(int fid);
int  osdunix	(int fid);
long osdseek	(int fid, long offset, int mode);
long osasize	(int fid);

int  osfop	(int /* actually char */ format, int record_length);
int  osfunix	(char *phname);
int  osfcreate	(char *phname, long nobytes, int protection);
int  osfdelete	(char *phname);
int  osfrename	(char *phname, char *newname);
/* int  osfinfo	(char *phname, struct filestatus *info); */
int  osfcontrol	(char *phname, int chmod_own, int prot_owner, int group);
/* int  osfdinfo	(int fid, struct filestatus *info); */

#else	/* No templates ... */
long osaseek(), osasize();
long osdseek(), osdsize();
#endif

/*===========================================================================
 *			I/O Macros
 *===========================================================================*/

#define osaflush	osawait		/* Just a more obvious name... */
#define osdflush	osdwait		/* Just a more obvious name... */

#define osatell(f)	osaseek(f,0L,FILE_CURRENT);
#define osdtell(f)	osdseek(f,0L,FILE_CURRENT);

#define  osaput(f,str)		osawrite(f,str,strlen(str))
#define  osdput(f,str)		osdwrite(f,str,strlen(str))
#define  osdputext(f,str)	osdwrite(f,str,sizeof(str)-1)

#define  osfchmod(f,mod)	osfcontrol(f,CHMOD,mod,0)
#define  osfchown(f,o,g)	osfcontrol(f,CHOWN,o,g)

#endif
