/* @(#)zdscext.h	14.1.1.1 (ESO-IPG) 09/16/99 10:02:01 */
/*

------------------------------ ZDSCEXT ------------------------------ 
 
layout of new large descriptor directory entry 

K. Banse	ESO - Garching		960829, 990405, 991214
 
*/	

char    DSC_FLAG;                       /* = Z   if new large descr. names */


struct	ZDIRDSC				/* 90 bytes (FCB_DIRENTRY = 30) */
	{
	char		NOBLK[2];
	unsigned short int	BYTELEM;
	int		NOELEM;
	int		START;
	int		INDEX;
	int		UNIT;
	int		HNOELEM;
	int		HSTART;
	int		HINDEX;
	char		TYPE;
	char		NAME[49];
	char		FREE[8];
	};


extern struct ZDIRDSC	ZDSCDIR_ENTRY;
extern struct ZDIRDSC	*ZDSC_PNTR;	/* will point to ZDSCDIR_ENTRY */
 

/*

	NOBLK	no. of basic direc_blocks 
                (= '1 ','2 ', '3 ')			       ch*2 )
		'1 ' only for padding
	BYTELEM	no. of bytes per descr. elements		I*2 )
	NOELEM	no. of elements in descriptor			I*4 )
	START	start block of descr. data			I*4 ) 32 bytes
	INDEX	offset within starting block with descr. data 	I*4 )
	UNIT	descr. units                 		        I*4 )
	HNOELEM	no. of elements in help	  			    )
		if no help for descr., set to 0			I*4 )
	HSTART	start block of help text			I*4 )
	HINDEX	offset within starting block with help text 	I*4 )


	TYPE	type of descriptor			       ch*1 )
                C(haracter), I(nteger), R(eal), D(ouble precision)   
	NAME	name of descriptor terminated by '\0'	      ch*49 ) 58 bytes
                => descriptor name is limited to 48 chars!
	FREE	reserve for later 			       ch*8 )


-----------------------------------------------------------------------


*/
