/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  1992 Observatoire de Lyon - St Genis Laval (FRANCE)
! IDENT        gendef.h
! LANGUAGE     C
!
! AUTHOR       A.Rousset
!
! KEYWORDS     
! PURPOSE      variables generales a l'application
! COMMENT      
! VERSION      1.0  1990-Jan-03 : Creation,   AR 
!
---------------------------------------------------------------------*/

#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <float.h>
#include <macro.h>

#ifndef MINSHORT
#define MINSHORT        SHRT_MIN
#define MININT          INT_MIN
#define MINLONG         LONG_MIN
#define MINDOUBLE       DBL_MIN
#define MINFLOAT        FLT_MIN
#endif
#ifndef MAXSHORT
#define MAXSHORT        SHRT_MAX
#define MAXINT          INT_MAX
#define MAXLONG         LONG_MAX
#define MAXDOUBLE       DBL_MAX
#define MAXFLOAT        FLT_MAX
#endif
#ifndef DMINEXP
#define DMINEXP         DBL_MIN_EXP
#define FMINEXP         FLT_MIN_EXP
#define DMAXEXP         DBL_MAX_EXP
#define FMAXEXP         FLT_MAX_EXP
#endif

#include <alloc.h>
#include <malloc.h>
#include <funcdef.h>
#include <funcdecl.h>
#include <soft_version.h>
#include <error_codes.h>

#define lg_name        80L
#define lg_ident       72L
#define lg_unit        48L
#define lg_label       16L
#define lg_hist        1024L
#define lg_version     4L

							/* default tables size */
#define tble_nb_row   450L  /* number of rows        */
#define tble_nb_col   256L  /* number of columns           */

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif
/*            debug  dynamic allocations          */
#ifdef Debug	
/* #include <dbmalloc.h> */
#endif

/*        General File type definitions:                             */

#define IMA_TYPE  'I'      /* type for image files */
#define TBL_TYPE  'T'      /* type for table files */

			/* type of file */

#define T_IMA1D  's'      /* type for 1D image */
#define T_IMA2D  'i'      /* type for 2D image */
#define T_TABLE  't'      /* type for table */
#define T_TIGER  'T'      /* type for tiger data cube */
#define T_TIGMAX 'M'      /* type for tiger maxima */

	/* content of the frame */

#define DONT_KNOW	0	/* unknown */
#define RAW_MPUP 	1	/* raw micro-pupils */
#define PRE_MPUP 	2	/* preprocessed micro-pupils */
#define RAW_CAL_FRAME 	3	/* raw calibration frame */
#define PRE_CAL_FRAME	4	/* preprocessed calibration frame */
#define RAW_CAL_CUBE	5	/* raw calibration datacube */
#define WAV_CAL_CUBE	6	/* wavelength calib calibration datacube */
#define	RAW_CON_FRAME	7	/* raw continuum frame */
#define	PRE_CON_FRAME	8	/* preprocessed continuum frame */
#define RAW_CON_CUBE    9	/* raw continuum datacube */
#define WAV_CON_CUBE	10	/* wavelength calib continuum datacube */
#define FLA_CON_CUBE	11	/* flat field continuum datacube */
#define FLAT_CUBE       30  	/* Flat cube */
#define RAW_SKY_FRAME	12	/* raw sky frame */ 
#define PRE_SKY_FRAME	13	/* preprocessed sky frame */
#define RAW_SKY_CUBE	14	/* raw sky datacube */
#define WAV_SKY_CUBE	15	/* wavelength calib sky datacube */
#define FLA_SKY_CUBE	16	/* flat fielded sky datacube */
#define	RAW_OBJ_FRAME	17	/* raw object frame */
#define	PRE_OBJ_FRAME	18	/* preprocessed object frame */
#define	RAW_OBJ_CUBE	19	/* raw object datacube */
#define	WAV_OBJ_CUBE	20	/* wavelength calib object datacube */
#define	FLA_OBJ_CUBE	21	/* flat fielded object datacube */
#define	COS_OBJ_CUBE	22	/* cosmic removed object datacube */
#define	FLX_OBJ_CUBE	23	/* flux calib object datacube */
#define THR_SPEC        32  	/* Throughput Spectrum */
#define	RAW_BIAS  	24	/* Raw Bias frame */
#define	DARK_FRAME	25	/* Dark frame */
#define	TBL_FILE	26	/* Table */
#define TBL_FILE_CAL    29  	/* Table of wavelength calibrated cube */
#define TBL_FILE_REF    31  	/* Table of Reference Wavelength */
#define	MSK_FILE	27	/* Mask */
#define	MAX_FILE	28	/* Maxima */
#define REC_IMAGE       33  	/* Reconstructed Image */
#define MER_OBJ_CUBE    35  	/* Merged Datacube */
#define DEBUG_FILE      36  	/* Debug File */
#define	BIAS_FRAME	37	/* Bias frame without overscan window */
#define	SKY_OBJ_CUBE	38	/* sky subtracted object datacube */
#define	LOSVD_RAW	39	/* Raw LOSVD */
#define	LOSVD_FIT	40	/* Fitted LOSVD */
#define	TBL_FLUX_REF	41	/* Table of Reference Flux */
#define	SKY_FILE_REF	42	/* Sky spectrum */
#define	SKY_FILE_VAR	43	/* Sky spectrum (variance) */
#define	COS_CON_CUBE	44	/* cosmic removed continuum datacube */
#define	COS_SKY_CUBE	45	/* cosmic removed sky datacube */
#define	HF_FLAT     	46	/* HF Flat-field */
#define FLT_CON_FRAME   47	/* flat-fielded continuum frame */
#define FLT_CAL_FRAME   48	/* flat-fielded calibration frame */
#define FLT_SKY_FRAME   49	/* flat-fielded sky frame */
#define FLT_OBJ_FRAME   50	/* flat-fielded object frame */
#define	SUPER_CLASS	99	/* SuperClass */

/*                      34         Frame Catalog (used by TCL/Tk) */

				/* global variables */

extern int DEBUG;
extern int VERBOSE;
extern int TK;
extern int ASK;
extern int ASK_BACK;
