/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  1992 Observatoire de Lyon - St Genis-Laval (France)
! IDENT        iofuncdecl.h
! LANGUAGE     C
! AUTHOR       A.Rousset
! KEYWORDS     
! PURPOSE      Functions declarations for usual i/o
! COMMENT      
! VERSION      4.0  1992-June-12 : Creation,   AR 
 ---------------------------------------------------------------------*/

/*    functions contained in iolib.c   */

void init_session(char **, int , char ***, char ***);
void exit_session(int);
void stop_by_user();
int RD_desc(void *, char *, short, int, void *);
int WR_desc(void *, char *, short, int, void *);
int delete_desc(void *, char *);
int write_file_class(void *anyfile,int type);
int read_file_class(void *anyfile);
int add_file_class(void *anyfile,int type);
int check_file_class(void *anyfile,int type);
int get_all_desc(void *, char ***);
int get_descr_type(void *, char *, short *);
int CP_non_std_desc(void *, void *);
int WR_history(void *, void *); 
int create_spec(SPECTRUM *, char *, int, double, double, short, char*, char*);
int header_spec(SPECTRUM *, char *, char *);
int open_spec(SPECTRUM *, char *, char *);
int close_spec(SPECTRUM *);
int delete_spec(SPECTRUM *);
int create_spec_mem(SPECTRUM *, int, double, double, short);
int create_frame(IMAGE2D*, char*, int*, double*, double*, short, char*, char*);
int header_frame(IMAGE2D *, char *, char *);
int open_frame(IMAGE2D *, char *, char *);
int close_frame(IMAGE2D *);
int delete_frame(IMAGE2D *);
int create_table(TABLE *, char *, int, int, char, char *); 
int open_table(TABLE *, char *, char *);
int close_table(TABLE *);
int handle_select_flag(TABLE *, char, char *);
int write_selection(TABLE *,int *, char *);
int get_col_ref (TABLE *, char *);
int get_col_info (TABLE *, int, int *, char *, char *);
int get_col_name (TABLE *, int, char *);
int create_col(TABLE *, char *, short, char, char *, char *);
int search_in_col (TABLE *, int, void *);
int delete_col (TABLE *, int);
int delete_row (TABLE *, int);
int RD_col(TABLE *, int, void *);
int RD_tbl(TABLE *, int, int, void *);
int WR_tbl(TABLE *, int, int, void *);
int WR_null(TABLE *, int, int);
int delete_table(TABLE *);
int create_cube(IMAGE3D*, char*, int*, double*, double*, short, char*, char*);
int header_cube(IMAGE3D *, char *, char *);
int open_cube(IMAGE3D *, char *, char *);
int close_cube(IMAGE3D *);
int delete_cube(IMAGE3D *);
int RD_catalog(char *, char *);

/*    functions contained in io_utils.c   */

int set_inputformat(char *);
int set_outputformat(char *);
int set_user_dataformat();
int get_iomode_code(short ,int);
int get_datatype_code(short , short );
short decode_datatype(short , short );
int sizeof_item(short );
void coord_frame(IMAGE2D *,int ,int , float *, float *);
void pixel_frame(IMAGE2D *, float, float, int *, int *);
int set_subspec(SPECTRUM *, double, double);
int subspec_minmax(SPECTRUM *);
int spec_minmax(SPECTRUM *);
int inter_spec(SPECTRUM *,SPECTRUM *);
int image_minmax(IMAGE2D *);
int flip_frame(IMAGE2D *);
int cube_minmax(IMAGE3D *);

/*    functions contained in io_misc.c   */

int set_path(Anyfile *, char *);
int set_inputformat(char *);
int set_outputformat(char *);
short user_dataformat(); 
void append_ima_extension(char *, short);
void append_tbl_extension(char *, short);
void append_datacube_extension(char *, short);
void remove_file_extension(char *);
char *file_format(char *);
int file_type(char *);
int get_iomode_code(short, int);
int get_datatype_code(short, short);
short decode_datatype(short, short);
int sizeof_item(short);
int alloc_spec_mem(SPECTRUM *, short);
int free_spec_mem(SPECTRUM *);
int alloc_frame_mem(IMAGE2D *, short);
int free_frame_mem(IMAGE2D *);
int alloc_cube_mem(IMAGE3D *, short);
int free_cube_mem(IMAGE3D *);
int alloc_new_desc(Anyfile *, short, int); 
int free_all_desc(Anyfile *);
int read_file_class(void *);
int check_file_class(void *, int);
int add_file_class(void *, int);
int write_file_class(void *, int);
int set_super_class(void *);
int unset_super_class(void *);
int fits_bitpix(short);
int fits_datatype(int);
int fits_non_std_desc(char *);
int copy_table_desc(void *, void *);

/* functions used in fit_poly.c (poly) */
void save_poly_nag(double *, long, SPECTRUM *);
double val_poly_nag(double, double *,long, double, double, int *);
int fit_poly_rej_nag(SPECTRUM *, long, double, double,int, double *,
    int *, double *, int *, double, double, int *);
int fit_poly_rej_nag_tab(double *, double *, double *, long, long, double, double,
    int, double *, int *, double *, int *, double, double, int *);
double val_minipoly(double, double *, long, double, double);
void save_minipoly_nag(double *, long, SPECTRUM *, double, double);
void fit_minipoly_rej_nag_tab(double *, double *, long, long, double, double,
    int, double *, double, double, int *, double *);
int fit_xpoly_rej_nag_tab(double *, double *, double *, long, long, double, double,
    int, double *, int *, double *, int *);
int fit_spline_nag(SPECTRUM *, double, double *, double *, long *, double *, 
		    double *);
int fit_spline_with_knots(double *, double *, int , double *, 
		    double *, long , double *, double *);
double val_spline_nag(double, double *, long, double *);

/* functions defined in version.c */
int set_version(char *);
int set_purpose(char *);
