/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  1992 Observatoire de Lyon - St Genis Laval (France)
! IDENT        doc_tex.c
! LANGUAGE     C
! AUTHOR       A. Rousset
! KEYWORDS     
! PURPOSE      Facility to create basic documentations in latex format 
! COMMENT      
! VERSION      4.0  1992-June-15 : Creation, AR
! VERSION      4.1  2002-Nov-27 : add path option to store the resulting file
------------------------------------------------------------------------------*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

#define OFF 0
#define ON  1

/*-----------------------------------------------------------------------------
!
!.blk               Facilities to print basic functions documentation
!
!.prog                             doc_tex()
!
!.purp        use C source files and generates a latex documentation
!             according to following specifications :
!
!             ! sign  indicates lines to be included in documentation
!                     (must be first character of the line )
!             .blk    indicates header of new logic block (small caps)
!             .prog   indicates name of the program which would be described
!                     further (printed in bold)
!             .func   indicates name of the function which would be described
!                     further (printed in bold)
!             .purp   indicates function purpose (printed in italics)
!             .return indicates function return code description
!             .desc   indicates function description (typewriter style)
!             .man    indicates man pages description (no print)
!             .ed     indicates end of previous description
!
!             others lines are printed in times roman (normal)
!
-----------------------------------------------------------------------------*/

int main(int argc, char *argv[])
{
	FILE *fd_in, *fd_out;
	char prog_name[80], tex_file[256], file_name[80], path[256];
	char buffer[256], buf_out[256];
	int len, verbatim, purpose, blk, found;
	void handle_special_char();
	int handle_spaces();

	if (argc > 3) {
		printf("Usage : doc_tex prog_name[.c]\n");
		exit(-1);
	}
	if (argc == 2)
		strcpy(path,".");
	else
		strcpy(path,argv[2]);
	strcpy(prog_name,argv[1]);
	len = strlen(prog_name);
	if (strcmp(&(prog_name[len-2]),".c") != 0) 
		strcat(prog_name,".c");
	len = strlen(prog_name);
	strncpy(file_name,prog_name,len-2);
	file_name[len-2] = '\0';
	sprintf(tex_file,"%s/%s.tex",path,file_name);

	if ((fd_in = fopen(prog_name,"r")) == NULL) {
		printf("Can't find %s\n",prog_name);	
		exit(-1);
	}
	if ((fd_out = fopen(tex_file,"w")) == NULL) {
		printf("Can't create temporary files\n");	
		exit(-1);
	}

	fputs("\\documentstyle[twocolumn]{article}\n",fd_out);
	fputs("\\oddsidemargin = -2cm\n",fd_out);
	fputs("\\evensidemargin = -2cm\n",fd_out);
	fputs("\\topmargin = -2cm\n",fd_out);
	fputs("\\textheight = 25cm\n",fd_out);
	fputs("\\textwidth = 19.5cm\n",fd_out);
	fputs("\\topsep = 0.1cm\n",fd_out);
	fputs("\\partopsep = 0.1cm\n",fd_out);
	fputs("\\pagestyle{plain}\n",fd_out);
	fputs("\\begin{document}\n",fd_out);
	fputs("\\footnotesize\n",fd_out);
	fputs("\\begin{tabbing}\n",fd_out);
	fputs("xxxxxxxxxxxxxx\\=xxx\\=xxxxx\\=xxxxx\\=xxxxx\\=xxxxx\\kill\n",fd_out);
	fputs("\\noindent\n",fd_out);
	verbatim = OFF;
	purpose = OFF;
	blk = OFF;
	found = 0;

	while (!feof(fd_in)) {
		fgets(buffer,80,fd_in);
		if (buffer[0] != '!') continue;	

		if (verbatim == OFF) 
			handle_special_char(buffer);

		if (strncmp(buffer,"!.blk",5) == 0) {
			found = 1;
			purpose = OFF;
            		blk = ON;
			fputs("\\end{tabbing}\n",fd_out);
			fputs("\\rm\n",fd_out);
/*			fputs("\\line(1,0){270}\n",fd_out);
			sprintf(buf_out,"{\\bf %s}\n",&(buffer[6]));
			fputs(buf_out,fd_out);
			fputs("\\end{center}\n",fd_out);
			fputs("\\line(1,0){270}\n",fd_out);
*/
			fputs("\\begin{center}\n",fd_out);
			sprintf(buf_out,"\\framebox(270,20)[c]{\\bf %s}\n",&(buffer[6]));
			fputs(buf_out,fd_out);
			fputs("\\end{center}\n",fd_out);
			fputs("\\begin{tabbing}\n",fd_out);
			fputs("xxxxxxxxx\\=xxx\\=xxxxxx\\=xxxxxx\\=xxxxxx\\=xxxxxx\\kill\n"
				,fd_out);
			fputs("\\noindent\n",fd_out);
			continue;
		} 
		if (strncmp(buffer,"!.prog",6) == 0) {
			found = 1;
			purpose = OFF;
            		if (blk == OFF) {
			    fputs("\\dashbox{1}(270,0)[t]{}\n",fd_out);
			    fputs("\\\\\n",fd_out);
			    fputs("\\\\\n",fd_out);
            		}
            		blk = OFF;
			sprintf(buf_out,"{\\em Program}\\>:\\> {\\bf %s}\\\\\n",
								&(buffer[7]));
			fputs(buf_out,fd_out);
			continue;
		} 
		if (strncmp(buffer,"!.func",6) == 0) {
			found = 1;
			purpose = OFF;
            		if (blk == OFF) {
			    fputs("\\dashbox{1}(270,0)[t]{}\n",fd_out);
			    fputs("\\\\\n",fd_out);
			    fputs("\\\\\n",fd_out);
            		}
            		blk = OFF;
			sprintf(buf_out,"{\\em Function}\\>:\\> {\\bf %s}\\\\\n",
								&(buffer[7]));
			fputs(buf_out,fd_out);
			continue;
		} 
		if (strncmp(buffer,"!.purp",6) == 0) {
			found = 1;
			purpose = ON;
			sprintf(buf_out,"\\em Purpose \\>:\\>{\\em %s}\\\\\n", &(buffer[7]));
			fputs(buf_out,fd_out);
			continue;
		} 
		if (strncmp(buffer,"!.return",7) == 0) {
			found = 1;
			purpose = ON;
			sprintf(buf_out,"\\em Returns \\>:\\>%s\\\\\n", &(buffer[8]));
			fputs(buf_out,fd_out);
			continue;
		} 
		if (strncmp(buffer,"!.desc",6) == 0) {
			found = 1;
			purpose = OFF;
			verbatim = ON;
			fputs("\\end{tabbing}\n",fd_out);
			fputs("\\begin{verbatim}\n",fd_out);
			continue;
		}
		if (strncmp(buffer,"!.ed",4) == 0) {
			found = 1;
			verbatim = OFF;
			fputs("\\end{verbatim}\n",fd_out);
			fputs("\\rm\n",fd_out);
			fputs("\\begin{tabbing}\n",fd_out);
			fputs("xxxxxxxxx\\=xxx\\=xxxxxx\\=xxxxxx\\=xxxxxx\\=xxxxxx\\kill\n"
				,fd_out);
			continue;
		}
		if (verbatim == OFF) {
			len = handle_spaces(&(buffer[1]));
			if (len > 0) {
				if (purpose == ON) 
					sprintf(buf_out,"\\>\\em %s\\\\\n", &(buffer[1]));
				else
					sprintf(buf_out,"%s\\\\\n",&(buffer[1]));
				fputs(buf_out,fd_out);
			}
		}
		else
			fputs(&(buffer[1]),fd_out);
	}
	if (verbatim == OFF)
		fputs("\\end{tabbing}\n",fd_out);

	fputs("\\end{document}\n",fd_out);
	fclose(fd_out);
	fclose(fd_in);
	if (!found) { /* not our document standard */ 
		unlink(tex_file);
	}
	return(0);
}

void handle_special_char(char *buffer)
{
	int i, j, len;

	for (i = 0; i<strlen(buffer); i++) {
		switch (buffer[i]) {

		case '#' :
		case '$' :
		case '%' :
		case '&' :
		case '~' :
		case '_' :
		case '^' :
		case '\\' :
		case '{' :
		case '}' :
			len = strlen(buffer);
			for (j=len;j>i;j--)
				buffer[j] = buffer[j-1];
			buffer[i] = '\\';
			buffer[len+1] = '\0';
			i++;
			break;

		default :
			break;
		}
	}
}
int handle_spaces(char *buffer)
{
	int i, j, len, not_nul_char = 0;

	for (i=0; i<strlen(buffer); i++)
		if ((buffer[i] != ' ') && (! iscntrl(buffer[i])))
			not_nul_char++;

	if (not_nul_char == 0)
		return(not_nul_char);

	for (i=0; i<strlen(buffer)-1; i++) {

		if (buffer[i] ==  ' ' && buffer[i+1] == ' ') { 
			len = strlen(buffer);
			for (j=i;buffer[j] == ' ' && j<len;j++);
			if (j<len) {
				strcpy(buffer+i+2,buffer+j);
				buffer[i] = '\\';
				buffer[i+1] = '>';
				buffer[len+1] = '\0';
				i++;
			}
		}
	}
	return(not_nul_char);
}
