/*

--------------------- FCB - Frame Control Block --------------------- 
	
on file MID_INCLUDE:fcbext.h
K. Banse	921113, 950711, 010307, 020312, 030109, 030812
	
*/
	
#define ENTRY_SIZE 30			/* old descr. entry length */
#define YENTRY_SIZE 100


struct FCB_STRUCT
	{
	char		RESERV5[4];	/* spare */
	char		BDTYPE[8];
	int		NDVAL;
	int		CLONY;
	char		RESERV0[16];	/* reserved for later use */
	char 		SWPSHORT;
	char 		SWPINT;
	char 		FLOTFMT;
	char 		DSCFLAG;	/* flag for descr. updates */
	char		VERSION[8];	/* SCFINF has to be in sync! */
	int		PROT;
	int		DATAINFO[6];	/* basic data information as integer */
	int		INCARN;
	int		PTRLDB;
	int		LEXBDF;
	int		PEXBDF;
	int		ENDLDB[2];
	int		NOLDB;		/* no. of LDBs */
	char		RESERV1[12];	/* spare */
	char 		RESERV4[6];	/* spare */
	short int	DIREXT;		/*  = 1500/2500/6000 bytes */
	int		DIRENTRY;	/*  = 30/100 bytes per entry */
	int		INLDB[2];	/* inital no. of LDBs  */
	char		RESERV2[24];	/* reserved for later use */
	int		DBEGIN;		/* initial size of dscdir */
	int		DFILLED;	/* increases in chunks of DIRENTRY */
	int		DSIZE;		/* increases in chunks of DIREXT */
	int		MAINSEG[5];
	char		CREATE[28];
	int		CRETIM[2];	/* creation time in secs. */
	char		RESERV3[272];	/* reserved for later use */
	int		FITSINFO[2];	/* Info for FITS files    */
	int		NEXT;
	};
	

/*

RESERV5 ...  FCB space reserved for future use		        C*4     4
BDTYPE  ...  frame type: IMAGE, TABLE, FITFILE, ...		C*8     8
NDVAL   ...  Number of data values.				I*4     4
CLONY   ...  = 1, if clones, = 0 if not				I*4	4
RESERV0 ...  FCB space reserved for future use 		        C*16   16
SWPSHORT     set according to <computer.h>                      C*1     1
		'=' for SWAPSHORT = 12, 's' for SWAPSHORT = 21
SWPINT       set according to <computer.h>                      C*1     1
		'=' for SWAPINT = 1234, 's' for SWAPINT = 4321
		'h' for SWAPINT = 2143, 'w' for SWAPINT = 3412
FLOTFMT      set according to <computer.h>                      C*1     1
		'=' for FLOATFMT = IEEEFLOAT
		'V' for FLOATFMT = VAXFLOAT
		'G' for FLOATFMT = VAXGFLOAT
		'H' for FLOATFMT = HPFLOAT
DSCFLAG ...  flag to indicate which version of the descriptor stuff 
	     is used 						C*1	1
		'Z' large format (old)
		'Y' new name+help format  
VERSION ...  Version in ASCII					C*8     8
		01FEB - VERS_010 (Z)
		01SEP - VERS_100 (Y)
		02FEB - VERS_100 (Y)
		02SEP - VERS_101 (Y)
		03FEB - VERS_105 (Y)
PROT    ...  protection flag                			I*4     4
DATAINFO ..  basic data info available outside Midas	    (6) I*4    24
[0] 	     Naxis
[1] 	     Npix[0]
[2] 	     Npix[1]
[3] 	     Npix[2]
[4] 	     data format, D_R4_FORMAT, etc.
[5] 	     first byte where pixel values are stored
	     (counting begins at 0, like in C)
INCARN  ...  Number of incarnations in frame - initialized to 1	I*4     4
             currently not used
PTRLDB  ...  Pointer to 1. Local Descriptor Block.		I*4     4
LEXBDF  ...  Logical Extension of BDF (last block)		I*4     4
PEXBDF  ...  Physical Extension of BDF (last block)		I*4     4
ENDLDB  ...  Last used LDB # and first free word in block   (2) I*4     8
NOLDB   ...  no. of LDBs (of 2048 bytes)			I*4     4
RESERV1 ...  spare 						C*12   12 
RESERV4 ...  spare  						C*6     6
DIREXT  ...  length of each extension of descriptor directory 
             currently = 6000 (in chars.)	                I*2     2
DIRENTRY     length of single entry in descr. directory 
             currently 100 (in chars.)	                        I*4     4
INLDB   ...  Initial no. of LDBs for dscdir + descr data    (2) I*4     8
RESERV2 ...  FCB space reserved for future use.		        C*24   24
DBEGIN  ...  inital size of dsc_directory 		 	I*4     4
DFILLED ...  length of descriptor directory currently in use 	I*4     4
	     increases in chunks of DIRENTRY bytes
DSIZE   ...  no. of allocated elements in descr. directory,  
	     initialized to min. no. of DIREXTs to hold space for 
	     (100 + 1) descrs + 3 LDB control ints (= 10112 bytes)
	     => initial value = 12000 (= 120 entries)		I*4     4
MAINSEG ...  Main Control Segment			    (5)	I*4    20
[0]          NOBYTE, no. of bytes per data value
[1]          FORMAT, format of data values:
	     see the different D_xx_FORMAT in midas_def.h
[2]          PIXPBL, no. of data values per page/block
[3]          STBLOK, no. of first block of data
[4]          LASTBLK, no. of last block of data
CREATE  ...  Creation time in ASCII				C*28   28
CRETIM  ...  Creation time in seconds (as long int)	    (2) I*4     8
RESERV3 ...  FCB space reserved for future use.		        C*272 272
FITSINFO ... FITS information  				    (2)	I*4     8
[0]          REFVAL, no. of pixels in original FITS file
[1]          OFFSET, offset of data in FITS file
NEXT    ...  Next Frame Control Block.				I*4     4
                                                                     -----
                                                                      512
*/
