/*===========================================================================
  Copyright (C) 1995,2003 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT  (c)  1994,2003  European Southern Observatory
.IDENT      fitsrdmui2.c
.LAUGUAGE   C
.AUTHOR     P.Grosbol/K.Banse   ESO/IPG
.KEYWORDS   FITS data matrix, decode, read
.VERSION    1.0  copied from fitsrdm.c
.COMMENT    read the prime data matrix of FITS file
            this is a stripped down version of fitsrdm.c
	    only for I2 and UI2 FITS data

 030811		last modif
---------------------------------------------------------------------*/

#include   <computer.h>            /* computer specific constants    */
#include   <fitsfmt.h>             /* general data definitions       */
#include   <fitsdef.h>             /* basic FITS definitions         */
#include   <fitsextvals.h>
#include   <midas_def.h>           /* MIDAS definitions              */

#define    MXFB              2880  /* max. size of scaling buffer    */
/*

*/

#ifdef __STDC__
int fitsrdmUI2(int mfd , BFDEF * bfdef , int size , int mfdt , char fmt,
            int Midas_flag)
#else
int fitsrdmUI2(mfd,bfdef,size,mfdt,fmt,Midas_flag)
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE       Read prime data matrix in FITS
.RETURN        error code - 0: OK, -1: error
---------------------------------------------------------------------*/
int       mfd;                 /* IN: MIDAS file descriptor          */
BFDEF     *bfdef;              /* IN: pointer to FITS header parm's  */
int       size;                /* IN: size of data matrix (bytes)    */
int       mfdt;                /* IN: MIDAS file desc. Groups table  */
char      fmt;                 /* IN: data format Original/Float     */
int       Midas_flag;	       /* IN: = 0, `usual' mode
                                      = 1, `internal FITS access'  */

#endif
{
register int   bf, k, ireg;
unsigned char  uc, *pb;
short          s, *ps;
unsigned short u, *pu;
int            dno, gno, pno, npix, n, fmm;
int            dn, pn, ndata, dfmt, pcnt, dsf, unit[4];
int            felem, i, *pi, mnvi, mxvi;
 
float          *pf, cuts[2];
 
double         d;
register double     dreg, fac, zero, *pd, mnvd, mxvd;
 
PDEF           *pp;
union { 
	float    f[2*MXFB];
	double     d[MXFB];
      } buf;
union { 
	unsigned char   *b;
	char            *c;
	short           *s;
	unsigned short  *u;
	int             *i;
	float           *f;
	double          *d;
      } p;


int    option, ifac;




/* we only come here, if bfdef->bitpix = 16 (or -16) */

mnvd = mxvd = 0.0;
pno = bfdef->pcount; pcnt = 0;             /* initiate counters     */
pp = bfdef->parm;
gno = 0;
bf = bfdef->bflag;
dfmt = bfdef->bitpix;
/* was: nb = (dfmt<0) ? -dfmt/8 : dfmt/8;
ndata = size/(nb*bfdef->gcount) - pno; dno = ndata; */
/* now: since nb = 2 */
ndata = size/(2*bfdef->gcount) - pno; dno = ndata;
fac = bfdef->bscale; zero = bfdef->bzero;
if ((fac > 0.999999) && (fac < 1.00001))
   ifac = 1;				/* no need to multiply with 1.0 */
else
   ifac = 0;
felem = 1;
fmm = ((bfdef->mflag != 3) && (0<size));
dsf = (bfdef->sflag || fmt=='F') ? -32 : dfmt;

/*
printf("UI2: dfmt = %d, bf = %d, fmm = %d, dsf = %d, pno = %d\n",
dfmt,bf,fmm,dsf,pno);
*/


while (0<size) 
   {                 /* read all data in prime matrix  */
   if ((n=dread(&p.c,FITSLR)) != FITSLR) 	/* read next data record  */
      {			
      if (size<=n) 
	 SCTPUT("Warning: incomplete FITS record read!");
      else 
         {
         int   unit;
         char  tbuf[80];

	 SCTPUT("Error: unexpected EOF");
         size /= 2; 
	 (void) sprintf(tbuf,"%d data values still missing",size);
         SCTPUT(tbuf);
	 if (0<=mfd) SCFCLO(mfd); mfd = -1;
         (void) SCKWRI("OUTPUTI",&size,16,1,&unit);	/* save value */
	 return NOFITS;
         }
      }

   if (size<n) n = size;
   size -= n;                     /* decrement remaining bytes      */
   npix = n/2; 
   if (!same_comp_i2) cvi2(p.s,npix,0); 

   do 
      {				/* scale all values if needed     */
      if (0<pno) 
         {			/* decode groups parameters       */
	 pn = (pno<npix) ? pno : npix;
	 pno -= pn; npix -= pn;
	 while (pn--) 
            {
	    d = pp->pscal * (*(p.s++)) + pp->pzero;
	    pcnt++; pp++;
            if (0<=mfdt) TCEWRD(mfdt,gno+1,pcnt,&d);
	    }
         }

      if (!pno && 0<dno && npix) 
         {				/* decode data values            */
	 dn = (dno<npix) ? dno : npix;
	 dno -= dn; npix -= dn;

         /* option = scale the data (unsigned int and int are equal) */
         /* format for minmax is float */

         if (bfdef->sflag) 
            {		
            pf = buf.f; s = bfdef->blank, ps = p.s;
            if (fmm)
               {			/* dsf = -32 */
               if (felem==1) mnvd = mxvd = (fac*(*ps)) + zero;
               if (bf)
                  { 
                  for (k=0; k<dn; k++, pf++, ps++)
                     {
                     if (*ps == s) 
                        toNULLFLOAT(*pf);
                     else
                        {
                        *pf = (fac * (*ps)) + zero;
                        dreg = (double) *pf;
                        if (dreg<mnvd)
                           mnvd = dreg;
                        else if (mxvd<dreg)
                           mxvd = dreg;
                        }
                     }
                  }
               else
                  {
                  if (ifac == 0)
                     {
                     for (k=0; k<dn; k++)
                        {
                        *pf = fac*(*ps++) + zero;
                        dreg = (double) *pf++;
                        if (dreg<mnvd)
                           mnvd = dreg;
                        else if (mxvd<dreg)
                           mxvd = dreg;
                        }
                     }
                  else
                     {
                     for (k=0; k<dn; k++)
                        {
                        *pf = (*ps++) + zero;
                        dreg = (double) *pf++;
                        if (dreg<mnvd)
                           mnvd = dreg;
                        else if (mxvd<dreg)
                           mxvd = dreg;
                        }
                     }
                  }
               }
            else
               {
               if (bf)
                  {
                  if (ifac == 0)
                     {
                     for (k=0; k<dn; k++, pf++, ps++) 
                        {
                        if (*ps==s) 
                           toNULLFLOAT(*pf);
                        else
                           *pf = fac*(*ps) + zero;
                        }
                     }
	          else
                     {
                     for (k=0; k<dn; k++, pf++, ps++) 
                        {
                        if (*ps==s) 
                           toNULLFLOAT(*pf);
                        else
                           *pf = *ps + zero;
                        }
                     }
                  }
               else
                  {
                  if (ifac == 0)
                     {
                     for (k=0; k<dn; k++)
                           *pf++ = fac*(*ps++) + zero;
                     }
	          else
                     {
                     for (k=0; k<dn; k++) *pf++ = (*ps++) + zero;
                     }
                  }
               }

            if (Midas_flag != 0)
	       MyPut(-32,felem,dn,(char *) buf.f);
            else
	       SCFPUT(mfd,felem,dn,(char *) buf.f);
	    }

         /* option = convert data to float (unsingend int and int are equal) */
         /* format for minmax is float */

         else if (fmt=='F') 
            { 	
            pf = buf.f; s = bfdef->blank, ps = p.s;
            if (fmm)
               {                        /* dsf = -32 */
               if (felem==1) mnvd = mxvd = (float) *ps;
               if (bf)
                  {
                  for (k=0; k<dn; k++, pf++, ps++)
                     {
                     if (*ps == s)
                        toNULLFLOAT(*pf);
                     else
                        {
                        *pf = (float) *ps;
                        dreg = (double) *pf;
                        if (dreg<mnvd)
                           mnvd = dreg;
                        else if (mxvd<dreg)
                           mxvd = dreg;
                        }
                     }
                  }
               else
                  {
                  for (k=0; k<dn; k++) 
                     {
                     *pf = (float) *ps++;
                     dreg = (double) *pf++;
                     if (dreg<mnvd)
                        mnvd = dreg;
                     else if (mxvd<dreg)
                        mxvd = dreg;
                     }
                  }
               }
            else
               {
               if (bf)
                  {
                  for (k=0; k<dn; k++, pf++, ps++)
                     {
                     if (*ps==s)
                        toNULLFLOAT(*pf);
                     else
                        *pf = (float) *ps;
                     }
                  }
               else
                  {
                  for (k=0; k<dn; k++) *pf++ = (float) *ps++;
                  }
               }

            if (Midas_flag != 0)
	       MyPut(-32,felem,dn,(char *) buf.f);
	    else
               SCFPUT(mfd,felem,dn,(char *) buf.f);
	    }

         /* option = take data as is (unsigned int and int are different) */
         /* format for minmax is same as original format */

         else 
            {		
	    if (dfmt == (-16))
               {
               pu = p.u; u = bfdef->blank; ps = p.s;
               if (fmm)
                  {				/* here dsf = dfmt */
                  if (felem==1) mnvi = mxvi = *ps + 32768;
                  if (bf)
                     {
                     for (k=0; k<dn; k++, pu++)
                        {
                        ireg = (int) *ps++;
                        if (ireg == u)
                           toNULLSHORT(*pu);
                        else
                           {
                           ireg += 32768;
                           if (ireg < mnvi)
                              mnvi = ireg;
                           else if (mxvi<ireg)
                              mxvi = ireg;
                           *pu = ireg;
                           }
                        }
                     }
                  else
                     {
                     for (k=0; k<dn; k++) 
                        {
                        ireg = (int) *ps++;
                        ireg += 32768;
                        if (ireg < mnvi)
                           mnvi = ireg;
                        else if (mxvi<ireg)
                           mxvi = ireg;
                        *pu++ = ireg;
                        }
                     }
                  }
               else
                  {
                  if (bf)
                     {
	             for (k=0; k<dn; k++, pu++, ps++) 
                        {
	                if (*ps == u) 
                           toNULLSHORT(*pu);
                        else
	                   *pu = *ps + 32768;
                        }
	             }
                  else
                     {
	             for (k=0; k<dn; k++) *pu++ = *ps++ + 32768;
	             }
                  }
               if (Midas_flag != 0)
	          MyPut(dfmt,felem,dn,(char *) p.u);
               else
	          SCFPUT(mfd,felem,dn,(char *) p.u);
	       }
            else		/* dfmt = 16 */
               {
	       ps = p.s; s = bfdef->blank;
               if (fmm)
                  {                          /* here dsf = dfmt */
                  if (felem==1) mnvi = mxvi = *ps;
                  if (bf)
                     {
                     for (k=0; k<dn; k++, ps++)
                        {
                        ireg = (int) *ps;
	                if (ireg == s) 
                           toNULLSHORT(*ps);
                        else
                           {
                           if (ireg<mnvi)
                              mnvi = ireg;
                           else if (mxvi<ireg)
                              mxvi = ireg;
                           }
                        }
                     }
                  else
                     {
                     for (k=0; k<dn; k++)
                        {
                        ireg = (int) *ps++;
                        if (ireg<mnvi)
                           mnvi = ireg;
                        else if (mxvi<ireg)
                           mxvi = ireg;
                        }
                     }
                  }
               else
                  {
                  if (bf) 
                     {
	             for (k=0; k<dn; k++, ps++)
                        {
	                if (*ps == s) toNULLSHORT(*ps);
                        }
	             }
                  }

               if (Midas_flag != 0)
                  MyPut(dfmt,felem,dn,(char *) p.s);
               else
                  SCFPUT(mfd,felem,dn,(char *) p.s);
	       }
	    }

         felem += dn;
         if (!dno) 
            {
            gno++;
            pno = bfdef->pcount; pcnt = 0;
            pp = bfdef->parm;
            dno = ndata;
            }
         }

      } while (npix && gno<bfdef->gcount);
   }


if (fmm) 
   {                         /* save computed min/max values  */
   if (dsf > -32) 
      {				/* handle also UI2 here */
      cuts[0] = (float)mnvi; cuts[1] = (float)mxvi;
      }
   else 
      {
      if (MAXFLOAT<mnvd) 
         mnvd = MAXFLOAT;
      else if (mnvd<MINFLOAT) 
         mnvd = MINFLOAT;
      if (MAXFLOAT<mxvd) 
         mxvd = MAXFLOAT;
      else if (mxvd<MINFLOAT) 
         mxvd = MINFLOAT;
      cuts[0] = (float)mnvd; cuts[1] = (float)mxvd;
      }
    SCDWRR(mfd,"LHCUTS",cuts,3,2,unit);

   }


if (Midas_flag == 0)
   {
   if (0<=mfd) SCFCLO(mfd);                       /* close data files  */
   if (0<=mfdt) { TCSINI(mfdt); TCTCLO(mfdt); }
   mfd = -1; mfdt = -1;
   }

return 0;
}


