/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  1992 Observatoire de Lyon - St Genis Laval (FRANCE)
! IDENT        tiger_items.h
! LANGUAGE     C
! 
! AUTHOR       A. Rousset
! 
! KEYWORDS     Tiger format definition 
! PURPOSE      
! COMMENT     
! VERSION      4.0  1992-June-15 : Creation    
!              4.1  2002-Oct-01 : Added quality flags
______________________________________________________________________________*/

#define LAB_COL_NO "NO"
#define LAB_COL_XLD "XD"
#define LAB_COL_YLD "YD"
#define LAB_COL_XLND "XND"
#define LAB_COL_YLND "YND"
#define LAB_COL_XTH_LD "XTHD"
#define LAB_COL_YTH_LD "YTHD"
#define LAB_COL_XTH_LND "XTHND"
#define LAB_COL_YTH_LND "YTHND"        
#define E3D_TIGER_EXT "TIGERTBL"

/*____________________ MAXIMA of cross-dispersion profiles __________________*/

typedef struct
{
    float xcoord;                 /* x coordinate of the maximum     */
    float intens;                 /* intensity found for the PSF     */
    float sigma[2];               /* width found for the PSF         */
    float alpha;                  /* alpha coef of the PSF           */

} max_param;

typedef struct
{
    float     ycoord;             /* y coordinate of this set        */
    int       nb_max;             /* number of maxima found          */
    max_param *maxima;            /* detailed list of maxima         */

} max_lines;

typedef struct            
{

  char config_name[lg_ident+1];

    struct                      /* enlarger :                     */
    {
      double gamma;             /* enlarging factor               */
    } enlarger;

    struct                      /* wedge (angles are in radian)   */
    {
      double theta_w;           /* rotation between the 2 prisms  */
    } wedges; 

    struct                      /* grating prism :                */
    {
      int index_coef;           /* - index of coefficient         */
      double A;                 /* - angle of the prism           */
      int    g_per_mm;          /* - number of grooves per mm     */
    } grism; 

    struct
    {
      double inf_util, sup_util;
    } filter;

    struct
    {
      float fratio;
    } telescope;

    struct
    {
      int nx, ny; 
	  float pixsize;
    } ccd;

    int nb_ycoords;         /* number of coordinates on Y axis */
    max_lines *line;        /* details of maxima line by line  */

} Maxima_Set;

/*________________________________ OPTICAL parameters ________________________*/

typedef struct
{
    struct                        /* enlarger :                     */
    {
      double gamma;               /* - enlarging factor             */

    } enlarger;

    struct                        /* collimator :                    */
    {
      double focal_length;        /* - focal length                  */
      double distor_coef[2];      /* - coefficient of  distortion    */
    } collimator; 

    struct                        /* wedge (angles are in radian)    */
    {
      int set;                    /* - 1 if wedge is present, else 0 */
      double A[2];                /* - angle of each prism  */
      double theta_w;             /* - angle of rotation between the 2 prisms */
      double theta_d;             /* - angle of rotation of the whole */
    } wedges; 

    struct                        /* grating prism :                 */
    {
      int  set;                   /* - 1 if grism is present, else 0 */
      char material[lg_label+1];  /* - name of material              */
      int index_coef;             /* - index of coefficient          */
      double *indices_coef;       /* - material coef. to compute n   */
      double A;                   /* - angle of the prism            */
      int    g_per_mm;            /* - number of grooves per mm      */
      double w_disp;              /* - wavelength dispersion         */
      double tilt1;               /* - first tilt angle (around x)   */
      double tilt2;               /* - second tilt angle (around y)  */
      double rot;                 /* - rotation angle (around z)     */  
    } grism; 

    struct                        /* camera :                        */
    {
      double focal_length;        /* - focal length                  */
      double distor_coef[2];      /* - coefficient of distortion     */
    } camera; 

    struct                        /* lens array :                    */
    {
      double dL;                  /* lens diameter (in mm)         */
      double lens_size_pix;       /* size of lens in CCD pixel      */
      double angle;               /* rotation angle Lens Array / CCD columns */
    } lens_array; 

    struct
    {
      double inf_util, sup_util;
      double central_util, width_util;
      double inf_total, sup_total;
      double central_total, width_total;
     } filter;

    struct
    {
      double xc, yc; /* distortion center */
    } center;

} Tiger_optics; 

typedef struct
{
  char focal_plane[lg_ident+1];
  char enlarger[lg_ident+1];
  char filter[lg_ident+1];
  char imaging[lg_ident+1];
  char sampler[lg_ident+1];
  char grism[lg_ident+1];
  char wedge[lg_ident+1];
  char camera_focus[lg_ident+1];
} Instrument;

typedef struct
{
  char name[lg_ident+1];
  double gain;
  int nx, ny;
  float pixsize; /* size in microns */
} Detector;

typedef struct
{
  double aperture;
  double central_obscuration;
  float fratio;
  double scale; /* arcsec by mm */
} Telescope;

typedef struct
{
  char name[lg_ident+1];
  char type;
} Calibration;


/*    functions contained in compat.c   */

int get_lenses_no_from_table(E3D_file *, int *);

int alloc_3D_max(Maxima_Set *, int, int);
int load_3D_max(Maxima_Set *, char *);
int save_3D_max(Maxima_Set *, char *);
int interpolate_noise(SPECTRUM *);

/*    functions contained in max_utils.c   */

double estimated_angle_with_ccd_columns(Maxima_Set *);
float distance_with_nearest_max(Maxima_Set *, float, float);

/*    functions contained in 3D_utils.c   */
void read_config_from_image(IMAGE2D *, char *, Tiger_optics *, Telescope *, Instrument *, Detector *);
void write_config_to_mask(void *, char *, Tiger_optics *,
			  Telescope *, Instrument *, Detector *);
void read_DOPT_from_mask(void *, Tiger_optics *);
void read_config_from_mask(void *, char *, Tiger_optics *,
			  Telescope *, Instrument *, Detector *);
void write_config_to_max(Maxima_Set *, char *, Tiger_optics *,
			 Telescope *, Detector *);
void compare_config_from_max(Maxima_Set *, char *, Tiger_optics *,
			  Telescope *, Detector *);
void compare_configs(Tiger_optics *, Tiger_optics *, Telescope *, Telescope *, 
		   Instrument *, Instrument *, Detector *, Detector *); 
void print_optics(Tiger_optics *);
void print_instrument(Instrument *);
void print_CCD(Detector *);
void print_telescope(Telescope *);

/* functions contained in optics_signature */
int set_optics_default_parameters(Tiger_optics *, char *);
int init_grism(Tiger_optics *, int, char *, double);
int set_grism(Tiger_optics *, double, double, double);
int set_collimator(Tiger_optics *, double, double);
int set_camera(Tiger_optics *, double, double);
int set_wedges(Tiger_optics *, double, double);
int tiger_optics_signature(Tiger_optics *,float, float,float *,float *,float, int);
int tiger_optics_nogrism(Tiger_optics *,float, float,float *,float *,float);
int inv_foc_red(Tiger_optics *,float, float,float *,float *);
int foc_red(Tiger_optics *,float, float,float *,float *);

/* functions contained in calib_shift */

int ParanoidCheck(IMAGE2D *, IMAGE2D *);
int ComputeShift(IMAGE2D *, IMAGE2D *, long *, long *, long *, long *, double *);           
