/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  2002 AIP, Potsdam, Germany
! IDENT        Euro3D.c
! LANGUAGE     C
! AUTHOR       S.F.Sanchez
! KEYWORDS
! PURPOSE      Library for the Visualization Tool
! COMMENT      Teel process
! VERSION      0.1  2003-Jan-29 : Creation, SF. Sanchez
------------------------------------------------------------------------------*/

#include <stdio.h> //For Standard I/O
#include <stdlib.h> //For Functions like ATOI
#include <ctype.h> //For Type check
#include <string.h> //For String manipulation
#include <math.h> //For Math functions
#include <IFU_io.h> //For Lyon I/O Library
#include <data_io.h> //For Lyon I/O data



/******************************
 * For Shared Memory
 ******************************/

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>



/******************************
 *To use PGPLOT
 *******************************/

#include <cpgplot.h> // PGPLOT



/*********************************************
 * Different procedures to read
 * the basic information on the SHM
 *********************************************/

/*
 * Limitation in shared memory due to the computer
 *
 */
#define MAX_SHM 33554432



int ask_slice(float **out_raw_data, int nb_spec, int index_w);
int ask_spectrum(float **out_raw_data, int specId, int npix, int index_start);
int ask_raw_data(float **out_raw_data, int nb_spec, int npix, int delta_n);
int ask_e3d_info(E3D_file *e3d_frame, int **n_spaxels, SPAXEL ***spaxels, int **index_start, int **npts, GROUP **groups);
int ask_load_e3d(char *input_filename);
int ask_delete_shm();
int load_mem_all (E3D_file e3d_image, int *n_spaxels,SPAXEL **spaxels,int *index_start, int *npts, int **address);
int server();
int load_e3d(char *filename, E3D_file *e3d_frame, int **n_spaxels, SPAXEL ***spaxels, int **index_start, int **npts, float **raw_data, float **raw_noise);
float* read_spax_int(int i_spec, int nb_spec, int npix);
int read_mem_group(GROUP **group,int key, int size);
int load_mem_group(GROUP *grupo, int key, int size, int *address);
int read_mem_int(int **out_int, int key, int size);
int load_mem_int(int *raw_data, int key, int size, int* address);
int  read_mem_char(char **out_shm,int key, int size);
char load_mem_char(char *raw_data, int key, int size, int* address);
int read_mem_spaxels(SPAXEL ***out_spax, int* n_spaxels, int key, int size);
int load_mem_spaxels(SPAXEL **spaxels, int* n_spaxels, int key, int size, int* address);
int read_mem_float(float **out_float, int key, int size);
int load_mem_float(float *raw_data, int key, int size, int* address);
float* read_mem_staked_spectra(int key, int size);
int load_mem_staked_spectra(float *raw_data, int key, int size, int* address);
int load_mem_e3d(E3D_file e3d_file, int key, int *address);
int read_mem_e3d(E3D_file* e3d_out, int key);
void palette(int type, float contra, float bright);
float Minimun(float a, float b);
float Maximun(float a, float b);
int draw_staked_spectra(int device_id, int p, float contra, float bright, float sign, float min, float max);
int image_plot(float *data, float datamin, float datamax, int l_naxes[2], int id, int p, float contra, float bright, float sign);
void plot_spaxel(int color_index,float x_c, float y_c, GROUP group);
