/******************************************************************************
 *
 * File:           minell.h
 *
 * Created:        24/02/2003
 *
 * Author:         Pavel Sakov
 *                 CSIRO Marine Research
 *
 * Purpose:        A header for the minimal ellipse stuff
 *
 * Revisions:      None
 *
 *****************************************************************************/

#if !defined(_MINELL_H)
#define _MINELL_H

#if !defined(_POINT_STRUCT)
#define _POINT_STRUCT
typedef struct {
    double x;
    double y;
    double z;
} point;
#endif

struct minell;
typedef struct minell minell;

minell* minell_build(int n, point p[]);
void minell_destroy(minell* me);
void minell_scalepoints(minell* me, int n, point points[]);
void minell_rescalepoints(minell* me, int n, point points[]);

#endif
