typedef float PLFLT;
#define PLFLT_MAX DBL_MAX
#define PLFLT_MIN DBL_MIN



void
my_griddata(PLFLT *x, PLFLT *y, PLFLT *z, int npts,
	     PLFLT *xg, int nptsx, PLFLT *yg,  int nptsy,
	     PLFLT **zg, int type, PLFLT data);

/* type of gridding algorithm for plgriddata() */

#define GRID_CSA    1 /* Bivariate Cubic Spline approximation */
#define GRID_DTLI   2 /* Delaunay Triangulation Linear Interpolation */
#define GRID_NNI    3 /* Natural Neighbors Interpolation */
#define GRID_NNIDW  4 /* Nearest Neighbors Inverse Distance Weighted */
#define GRID_NNLI   5 /* Nearest Neighbors Linear Interpolation */
#define GRID_NNAIDW 6 /* Nearest Neighbors Around Inverse Distance Weighted  */


void
my_abort(char *errormsg);

#define PL_OPT_FUNC             0x0100  /* Call handler function */
#define PL_OPT_BOOL             0x0200  /* Set *var = 1 */
#define PL_OPT_INT              0x0400  /* Set *var = atoi(optarg) */
#define PL_OPT_FLOAT            0x0800  /* Set *var = atof(optarg) */
#define PL_OPT_STRING           0x1000  /* Set var = optarg */
#define PI 3.14159


typedef struct {
    char *opt;
    int  (*handler)     (char *, char *, void *);
    void *client_data;
    void *var;
    long mode;
    char *syntax;
    char *desc;
} PLOptionTable;
