/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  2002 AIP, Potsdam, Germany
! IDENT        tk_e3d
! LANGUAGE     C
! AUTHOR       S.F.Sanchez
! KEYWORDS     
! PURPOSE      TK version of the Visualization tool, needs tk_e3d.tcl
! COMMENT      1st prototype
! VERSION      1.0  2003-Feb-06 : Creation, SF.
------------------------------------------------------------------------------*/
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <ctype.h> //For Type check
#include <tk.h>
#include <time.h>

#include <IFU_io.h> //For Lyon I/O Library
#include <data_io.h> //For Lyon I/O data

/******************************
 * For Shared Memory
 ******************************/

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#include "tkpgplot.h"
#include "cpgplot.h"

/************************************
 * NCARG
 ************************************/

//#include <ncarg/ncargC.h>
//#include <ncarg/gks.h>
//#include <ncarg/ngmath.h>


#include <pthread.h> //POXI Threads


#include <Euro3D.h>
#include <fft2d.h>
#include <my_math.h>
#include <my_convolve.h>
#include <gl_lsq.h>
#include <stats.h>

#define MAX_SHM 33554432

#define MAX_NUM_OBJ 10
#define MAX_NUM_SPEC 10
#define MAX_NUM_MAPS 10



//static int tcl_pgptxt(ClientData data, Tcl_Interp *interp, int argc, char *argv[]);
static int create_env(ClientData data, Tcl_Interp *interp, int argc, char *argv[]);
static int Demo_AppInit(Tcl_Interp *interp);
static void display_message(int device_id, char *text);
int open_device(Tcl_Interp *interp, char *device);
static close_device(int device_id);
int new_window(Tcl_Interp *interp, char *caller, char *cmd, char *device);

/**********************************************************************
 * Different funcions associated with the TK_Commands
**********************************************************************/

static int window_instance_command(ClientData data, Tcl_Interp *interp,
			       int argc, char *argv[]);
static int message_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int close_device_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int start_server_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int stop_server_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int clean_server_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int load_file_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int save_file_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int draw_raw_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int recolor_image_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int ask_e3d_info_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int bad_draw_raw_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int intensity_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int bc_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int plot_line_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int plot_spaxels_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int create_slice_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int plot_spectra_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int save_spectra_sel_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int load_spectra_sel_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int load_n_spectra_sel_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int nearest_spax_command(Tcl_Interp *interp, int argc, char *argv[]);
static int mark_range_command(Tcl_Interp *interp, int argc, char *argv[]);
static int create_obj_command(Tcl_Interp *interp, int argc, char *argv[]);
static int load_obj_command(Tcl_Interp *interp, int argc, char *argv[]);
static int create_spec_command(Tcl_Interp *interp, int argc, char *argv[]);
static int load_spec_command(Tcl_Interp *interp, int argc, char *argv[]);
static int plot_spectra_mem_command(Tcl_Interp *interp, int argc, char *argv[]);
static int sub_spec_command(Tcl_Interp *interp, int argc, char *argv[]);
static int skysub_command(Tcl_Interp *interp, int argc, char *argv[]);
static int div_spec_command(Tcl_Interp *interp, int argc, char *argv[]);

static int specarith_command(Tcl_Interp *interp, int argc, char *argv[]);
static int slicearith_command(Tcl_Interp *interp, int argc, char *argv[]);

static int create_map_command(Tcl_Interp *interp, int argc, char *argv[]);
static int plot_map_command(Tcl_Interp *interp, int argc, char *argv[]);

static int save_map_command(Tcl_Interp *interp, int argc, char *argv[]);
static int save_slice_command(Tcl_Interp *interp, int argc, char *argv[]);
static int theoretical_dar_command(Tcl_Interp *interp, int argc, char *argv[]);
static int correct_dar_command(Tcl_Interp *interp, int argc, char *argv[]);
static int empirical_dar_command(Tcl_Interp *interp, int argc, char *argv[]);
static int simple_dar_command(Tcl_Interp *interp, int argc, char *argv[]);
static int pm_dar_command(Tcl_Interp *interp, int argc, char *argv[]);
static int peak_dar_command(Tcl_Interp *interp, int argc, char *argv[]);


static int zoom_raw_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int release_raw_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int tcl_pgptxt_command(Tcl_Interp *interp, int argc, char *argv[]); 

static int save_spec_command(Tcl_Interp *interp, int argc, char *argv[]);
static int save_spec_table_command(Tcl_Interp *interp, int argc, char *argv[]);

/********************
 * Euro3d Definitions
 ********************/
int delta_n=512;
E3D_file e3d_image;
SPAXEL **spaxels;
int *n_spaxels,*index_start,*npts;
GROUP *groups;
double start_w, end_w, delta_w;
int npix,npix_w1,npix_w2;
int nb_spec,n_groups;
float *raw_data,*raw_noise;
int j;
float datamin,datamax;
float tr[]={0.0,1.0,0.0,0.0,0.0,1.0};
float minmax[2];
float x_min,y_min,x_max,y_max;

int i_slices[8][2];
int *i_spax; // Actual Selection of Spaxels == Obj 
int n_i_spax=0; //Number of elements in 'i_spax'
int *j_spax[MAX_NUM_OBJ]; // Array of Selection of Spaxels == Obj
int n_j_spax[MAX_NUM_OBJ]; // Array of their Number of elements
int que_j_spax=0; // Actual Obj selected.
int slice_index=0;
int i0_slice=0;


float *f_spec_now; // Array of Selection of Spectra
float *f_spec[MAX_NUM_SPEC]; // Array of Selection of Spectra
int n_f_spec=0; //Index of the actual selected spectra
int start_n_f_spec=0;

float *f_slice_now; // Array of Selection of Slices
float *f_slice[MAX_NUM_MAPS]; // Array of Selection of Spectra
//int n_f_spec=0; //Index of the actual selected spectra
//int start_n_f_spec=0;


float *map_data[MAX_NUM_MAPS];
int nx_map[MAX_NUM_MAPS],ny_map[MAX_NUM_MAPS];
int n_map=0;
float tr_map[8][MAX_NUM_MAPS];
int map_created[MAX_NUM_MAPS];
float dpix=0.2;

int server_started=0;


struct DAR *dars;
int loaded=0;
int spax_painted=0;
int dar_corrected=0;




int pintados[30];
int n_pintados=30;
int old_p[30];
int old_text_flag[30];
int n_sel_spec=0;
float old_max[30],old_min[30];
int old_spax_id[30];


int n_contours=15;
int contours_color=1;


float *tmp_data;

/*.......................................................................
 * After presenting a warning if the first argument is not the name
 * of the demo Tcl script, main() simply calls the standard Tk_Main()
 * to initialize Tcl/Tk and the demo package.
 * Input:
 *  argc     int    The number of command line arguments.
 *  argv    char*[] The array of command-line argument strings.
 * Output:
 *  return   int    0 - OK.
 *                  1 - Error.
 */

int main(int argc, char *argv[])
{
  char **argval, **arglabel;
  char *usage = "Usage: tk_test tk_test.tcl [tk-options].\n";
  init_session(argv,argc,&arglabel,&argval);
  set_control_level(WARNING);

  /*
   * We allow a certain number of slices
   */



/*
 * Check whether the first argument names a valid pgtkdemo
 * script file.
 */
  /*
  if(argc < 2 || *argv[1] == '-') {
    fprintf(stderr, usage);
    return 1;
  };
  */
/*
 * Start the application.
 */
  Tk_Main(argc, argv, Demo_AppInit);
  exit_session(0);
  return 0;
}


/*.......................................................................
 * This dummy fortran main allows pgtkdemo to be linked with the
 * f2c-compiled pgplot library.
 */
int MAIN__(void)
{
}

/*.......................................................................
 * This is the application initialization file that is called by Tk_Main().
 */
static int Demo_AppInit(Tcl_Interp *interp)
{
/*
 * Create the standard Tcl and Tk packages, plus the TkPgplot package.
 */
  if(Tcl_Init(interp)    == TCL_ERROR ||
     Tk_Init(interp)     == TCL_ERROR ||
     Tkpgplot_Init(interp) == TCL_ERROR)
    return 1;
/*
 * Create the TCL command used to initialization the demo.
 */
  Tcl_CreateCommand(interp, "create_env", create_env,(ClientData) Tk_MainWindow(interp), (Tcl_CmdDeleteProc *) NULL);

  return 0;
}

/*.......................................................................
 * This function provides the TCL command that creates a pgdemo
 * manipulation command. This opens the two given PGPLOT widgets to
 * PGPLOT, establishes a cursor handler and records the state of the
 * demo in a dynamically allocated container.
 *
 * Input:
 *  data      ClientData    The main window cast to ClientData.
 *  interp    Tcl_Interp *  The TCL intrepreter of the demo.
 *  argc             int    The number of command arguments.
 *  argv            char ** The array of 'argc' command arguments.
 *                          argv[0] = "create_env"
 *                          argv[1] = The name to give the new command.
 *                          argv[2] = The name of the image widget.
 *                          argv[3] = The name of the slice widget.
 * Output:
 *  return           int    TCL_OK    - Success.
 *                          TCL_ERROR - Failure.
 */
static int create_env(ClientData data, Tcl_Interp *interp, int argc, char *argv[])
{
  int dev_id;
  //  Pgdemo *demo;      /* The new widget instance object */
/*
 * Check that the right number of arguments was provided.
 */
  if(argc != 3) {
    Tcl_AppendResult(interp,
	     argv[0], ": Wrong number of arguments - should be \'",
	     argv[0], " new_command_name image_widget\'", NULL);
    return TCL_ERROR;
  };
/*
 * Allocate a context object for the command.
 */

  dev_id=new_window(interp, argv[0], argv[1], argv[2]);

  if(!dev_id)
    return TCL_ERROR;
  return TCL_OK;
}



/********************************************************************
 * Creates a new device
 ********************************************************************/

int open_device(Tcl_Interp *interp, char *device) {
  int dev_id;
  
  if (!(dev_id = cpgopen(device))) {
    Tcl_AppendResult(interp, "Unable to open widgets: ", device, NULL);
    return close_device(dev_id);
  };
  return dev_id;
}


/****************************************************
 * Close the device
 ****************************************************/

static close_device(int device_id) {
  cpgslct(device_id);
  cpgclos();
  return NULL;
}



/*.......................................................................
 * Display a "Please wait" message in the slice window.
 *
 * Input:
 *  demo     Pgdemo *   The demo instance object.
 */
static void display_message(int device_id, char *text)
{
/*
 * Clear the slice plot and replace it with instructional text.
 */
  cpgslct(device_id);
  cpgask(0);
  cpgpage();
  cpgsch(3.0f);
  cpgsvp(0.0, 1.0, 0.0, 1.0);
  cpgswin(0.0, 1.0, 0.0, 1.0);
  cpgmtxt("T", -2.0, 0.5, 0.5, text);

}


int new_window(Tcl_Interp *interp, char *caller, char *cmd, char *image_device) {
  int dev_id;


  if ((dev_id=open_device(interp, image_device))<=0) {
    Tcl_AppendResult(interp, "Unable to open widgets: ", image_device, NULL);
  }
  cpgslct(dev_id);


  Tcl_CreateCommand(interp, cmd, window_instance_command,NULL,NULL);
  /*
   * Return the command name.
   */
  Tcl_AppendResult(interp, cmd, NULL);

  return dev_id;
}

static int window_instance_command(ClientData data, Tcl_Interp *interp, int argc, char *argv[]) {

  char *command;

/*
 * We must have at least one command argument.
 */
  if(argc < 2) {
    Tcl_SetResult(interp, "Wrong number of arguments.", TCL_STATIC);
    return TCL_ERROR;
  };
  /*
   * Get the command-name argument.
   */
  command = argv[1];
  if(strcmp(command, "message") == 0)
    return message_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "close_device") == 0)
    return close_device_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "start_server") == 0)
    return start_server_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "stop_server") == 0)
    return stop_server_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "clean_server") == 0)
    return stop_server_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "load_file") == 0)
    return load_file_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "save_file") == 0)
    return save_file_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "draw_raw") == 0)
    return draw_raw_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "recolor_image") == 0)
    return recolor_image_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "ask_e3d_info") == 0)
    return ask_e3d_info_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "open_device") == 0)
    return open_device_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "close_device") == 0)
    return close_device_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "intensity") == 0)
    return intensity_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "bc") == 0)
    return bc_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "plot_line") == 0)
    return plot_line_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "plot_spaxels") == 0)
    return plot_spaxels_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "create_slice") == 0)
    return create_slice_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "plot_spectra") == 0)
    return plot_spectra_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "plot_spectra_mem") == 0)
    return plot_spectra_mem_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "save_spectra_sel") == 0)
    return save_spectra_sel_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "load_spectra_sel") == 0)
    return load_spectra_sel_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "load_n_spectra_sel") == 0)
    return load_n_spectra_sel_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "nearest_spax") == 0)
    return nearest_spax_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "mark_range") == 0)
    return mark_range_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "create_obj") == 0)
    return create_obj_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "load_obj") == 0)
    return load_obj_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "create_spec") == 0)
    return create_spec_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "load_spec") == 0)
    return load_spec_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "sub_spec") == 0)
    return sub_spec_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "skysub") == 0)
    return skysub_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "specarith") == 0)
    return specarith_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "slicearith") == 0)
    return slicearith_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "div_spec") == 0)
    return div_spec_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "create_map") == 0)
    return create_map_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "save_map") == 0)
    return save_map_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "save_spec") == 0)
    return save_spec_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "save_spec_table") == 0)
    return save_spec_table_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "save_slice") == 0)
    return save_slice_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "plot_map") == 0)
    return plot_map_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "theoretical_dar") == 0)
    return theoretical_dar_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "correct_dar") == 0)
    return correct_dar_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "empirical_dar") == 0)
    return empirical_dar_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "simple_dar") == 0)
    return simple_dar_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "pm_dar") == 0)
    return pm_dar_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "peak_dar") == 0)
    return peak_dar_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "zoom_raw") == 0)
    return zoom_raw_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "release_raw") == 0)
    return release_raw_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "tcl_pgptxt") == 0)
    return tcl_pgptxt_command(interp, argc - 2, argv + 2);

/*
 * Unknown command name.
 */
  Tcl_AppendResult(interp, argv[0], ": Unknown demo command \"",
		   argv[1], "\"", NULL);
  return TCL_ERROR;
}

/*
 * PGTXT
 */
static int tcl_pgptxt_command(Tcl_Interp *interp, int argc, char *argv[]) {
  float x,y,j,f,size,width;
  int color;
  char text[80];
  if(argc != 8) {
    Tcl_AppendResult(interp," tcl_pgptxt x y j f text size color width", NULL);
    return TCL_ERROR;
  };
  x=atof(argv[0]);
  y=atof(argv[1]);
  j=atof(argv[2]);
  f=atof(argv[3]);
  strcpy(text,argv[4]);
  size=atof(argv[5]);
  color=floor(atof(argv[6]));
  width=atof(argv[6]);
  cpgsch(size);
  cpgsci(color);
  cpgsfs(3.0);
  cpgptxt(x,y,j,f,text); 
  cpgsci(1);
  cpgsch(1.0);
  cpgsfs(1);
  return TCL_OK;
}



/*******************************************************
 *
 * Zoom the RAW data within certain pixels
 * 
 *******************************************************/
static int zoom_raw_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int i;
  int id;
  if(argc < 3 || *argv[1] == '-') {
    Tcl_AppendResult(interp, "use: zoom_raw pix1 pix2 dev_id", NULL);
    return TCL_ERROR;
  }
  npix_w1=atoi(argv[0]);
  npix_w2=atoi(argv[1]);
  id=atoi(argv[2]);
  if (npix_w1>npix_w2) {
    i=npix_w2;
    npix_w2=npix_w1;
    npix_w1=i;
  }
  if (npix_w1<0) npix_w1=0;
  if (npix_w2>npix) npix_w2=npix;
  pintados[id]=0;
  return TCL_OK;
}

/*******************************************************
 *
 * Release the Zoom the RAW data within certain pixels
 * 
 *******************************************************/
static int release_raw_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int id;
  if(argc < 1) {
    Tcl_AppendResult(interp, "use: release_raw dev_id", NULL);
    return TCL_ERROR;
  }
  id=atoi(argv[0]);
  npix_w1=0;
  npix_w2=npix;
  //  printf("%d %d %d",id,npix_w1,npix_w2);
  pintados[id]=0;
  return TCL_OK;
}


/**********************************
 * EMPIRICAL D.A.R. Correction
 *********************************/
static int empirical_dar_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int j,i,k,l,jj;
  float *slice;
  float tmp_tr[8];
  int nx_t,ny_t;
  float dpix_t=0.2;
  float *map_tmp,*map_zero;
  int comp_index,delta_index;
  double *img_data,*psf_data;

  int nx_peak,ny_peak;
  double peak;
  float dpix_tt=0.2;

  int *dnx,*dny,*i_lambda;
  float *fdnx,*fdny,*e_fdnx,*e_fdny,*fi_lambda,*fdnr;
  int nnn;
  int dnx0,dny0;
  float sig_dnx,sig_dny;

  int plot_all=0;


  float *a_x,*a_y;
  int *ia;
  float **covar;
  float chisq;
  int ma=3;
  
  float *x,*y1,*y2,*r;

  float min_dn,max_dn;

  float *dx,*e_dx,*dy,*e_dy,*xx;
  int n_d;

  int nulo_x=0;
  int nulo_y=0;

  if(argc < 2 ) {
    Tcl_AppendResult(interp, "plot_spectra comp_index delta_index dx plot_all", NULL);
    return TCL_ERROR;
  }
  
  comp_index=atoi(argv[0]);
  delta_index=atoi(argv[1]);

  dnx = (int *)malloc(((int)(npix/delta_index))*sizeof(int));
  dny = (int *)malloc(((int)(npix/delta_index))*sizeof(int));
  i_lambda = (int *)malloc(((int)(npix/delta_index))*sizeof(int));

  fdnx = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fdny = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fdnr = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fi_lambda = (float *)malloc(((float)(npix/delta_index))*sizeof(float));

  e_fdnx = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  e_fdny = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  nnn=0;

  printf("Started...");
  fflush(stdout);
  if (argc>2) {
    dpix_tt=atof(argv[2]);
  }
  if (argc>3) {
    plot_all=atoi(argv[3]);
  }

  
  if ((comp_index>-1)&&(comp_index<npix-delta_index)) {    
    slice = (float *)malloc((nb_spec)*sizeof(float));
    for (i=0;i<nb_spec;i++) {
      slice[i]=0.0;
      
      for (jj=0;jj<delta_index;jj++) {
	slice[i]=slice[i]+raw_data[comp_index+jj+i*npix];
      }
      
    }
    /*
     *
     */
    create_map(nb_spec,n_spaxels,spaxels,npts,slice,dpix_tt,&map_zero,x_min,x_max,y_min,y_max,&tmp_tr,&nx_t,&ny_t);
    img_data = (double *)malloc(nx_t*ny_t*sizeof(double));
    psf_data = (double *)malloc(nx_t*ny_t*sizeof(double));
    
    if (plot_all>1) {
      cpgslct(1);
      cpgpap(5,1.0);
      cpgask(0);
      cpgpage();
      cpgsch(0.9);
      cpgenv(0,nx_t,0,ny_t,1,0);
      cpgimag(map_zero,nx_t,ny_t,1,nx_t,1,ny_t,0,600,tr);
    }
    for (k=0;k<(nx_t*ny_t);k++) {
      psf_data[k]=(double)map_zero[k]*1.0;
    }

    cpgsch(0.9);
    for (j=0;j<npix-delta_index;j=j+delta_index) {
      i_lambda[nnn]=j+(int)(delta_index/2);

      for (i=0;i<nb_spec;i++) {
	for (jj=0;jj<delta_index;jj++) {
	  slice[i]=raw_data[j+jj+i*npix];
	}
	//	slice[i]=raw_data[j+i*npix];
      }
      create_map(nb_spec,n_spaxels,spaxels,npts,slice,dpix_tt,&map_tmp,x_min,x_max,y_min,y_max,&tmp_tr,&nx_t,&ny_t);
      for (k=0;k<(nx_t*ny_t);k++) {
	img_data[k]=(double)map_tmp[k]*1.0;
	//	printf("cut %f %f\n",img_data[k],map_tmp[k]);
      }
      /*
       * Now we crosscorrelate
       */
      if (plot_all>1) {
	cpgimag(map_tmp,nx_t,ny_t,1,nx_t,1,ny_t,0,600,tr);      
      }	
      my_crosscor(img_data,nx_t,ny_t,psf_data,nx_t,ny_t);      
      if (plot_all>1) {
      }
      /*
       * We look for the peak
       */
      nx_peak=0;
      ny_peak=0;
      peak=img_data[0];
      for (i=0;i<ny_t;i++) {
		for (k=0;k<nx_t;k++) {
	
	  if (peak<img_data[k+i*nx_t]) {
	    peak=img_data[k+i*nx_t];
	    nx_peak=k;
	    ny_peak=i;
	  }
	
	}
      }
      //      printf("%d %f %d %d %f\n",j,start_w+delta_w*j,nx_peak,ny_peak,peak);
      dnx[nnn]=nx_peak;
      dny[nnn]=ny_peak;
      nnn++;
      if (plot_all>1) {
	for (k=0;k<(nx_t*ny_t);k++) {
	  map_tmp[k]=(float)img_data[k]*1.0;
	}
	
	cpgimag(map_tmp,nx_t,ny_t,1,nx_t,1,ny_t,0.25*peak,peak*1.5,tr);
	//  cpgimag(map_tmp,nx_t,ny_t,1,nx_t,1,ny_t,0,peak*1.5,tr);
	//      image_plot(map_tmp,0,peak*2,nx_t,ny_t,1,tr);
      }

    }
    printf("Done\n");
    dnx0=dnx[(int)(((float)comp_index/delta_index+0.5))];
    dny0=dny[(int)(((float)comp_index/delta_index+0.5))];

    //    dnx0=mean(dnx,nnn);
    //dny0=mean(dny,nnn);
    //dny0=dny[(int)(((float)comp_index/delta_index+0.5))];
    min_dn=300.0;
    max_dn=-300.0;
    for (i=0;i<nnn;i++) {
      dnx[i]=dnx[i]-dnx0;
      dny[i]=dny[i]-dny0;
      fdnx[i]=(dnx[i])*dpix_tt;
      fdny[i]=(dny[i])*dpix_tt;
      fdnr[i]=sqrt(fdny[i]*fdny[i]+fdnx[i]*fdnx[i]);
      if (min_dn>fdnx[i]) min_dn=fdnx[i];
      if (max_dn<fdnx[i]) max_dn=fdnx[i];
      if (min_dn>fdny[i]) min_dn=fdny[i];
      if (max_dn<fdny[i]) max_dn=fdny[i];
      e_fdnx[i]=dpix_tt/2;
      e_fdny[i]=dpix_tt/2;
      fi_lambda[i]=i_lambda[i]*delta_w+start_w;
      //      printf("%8.2f %5.2f %5.2f\n",start_w+delta_w*i_lambda[i],dnx[i]*dpix_tt,dny[i]*dpix_tt);
    }
    min_dn-=dpix_tt;
    max_dn+=dpix_tt;

    sig_dnx=sigma(fdnx,nnn,0.0);
    sig_dny=sigma(fdny,nnn,0.0);

    //    printf("%f %f sig_dnx=%f sig_dny=%f\n",dnx0,dny0,sig_dnx,sig_dny);

    /*
     * We clean the data from 1sigma
     */
    xx=vector(1,nnn+1);
    dx=vector(1,nnn+1);
    dy=vector(1,nnn+1);
    e_dx=vector(1,nnn+1);
    e_dy=vector(1,nnn+1);
    n_d=0;
    dx[0]=0.0;
    dy[0]=0.0;
    for (i=0;i<nnn;i++) {
      //     if ((fabs(fdnx[i])<sig_dnx)&&(fabs(fdny[i])<sig_dny)) {
	dx[n_d]=fdnx[i];
	dy[n_d]=fdny[i];
	xx[n_d]=fi_lambda[i];
	//	printf("%f %f %f\n",xx[n_d],dx[n_d],dy[n_d]);
	if (i>0) {
	  if (dx[n_d]!=dx[n_d-1]) nulo_x=1;
	  if (dy[n_d]!=dy[n_d-1]) nulo_y=1;
	}
	n_d++;
	// }
    }
    printf("n_d=%d, %d, %d\n",n_d,nulo_x,nulo_y);
    /*
     * We update the information of the DAR
     */

    if ((nulo_x==1)&&(nulo_y==1)) {

      covar=matrix(1,ma,1,ma);
      ia=ivector(1,ma);
      a_x=vector(1,ma);
      a_y=vector(1,ma);
      for (k=1;k<=ma;k++) {
	a_x[k]=1.0/k;
	a_y[k]=1.0/k;
	ia[k]=1;
      }    
      
      
      

      /*
       * We take first the linear version...
       */    
      nulo_x=0;
      nulo_y=0;
      for(j=0;j<2;j++) {
	gl_lfit(xx,dx,e_fdnx,n_d-1,a_x,ia,2,covar,&chisq,poly_serie);
	gl_lfit(xx,dy,e_fdny,n_d-1,a_y,ia,2,covar,&chisq,poly_serie);
	//    free(covar);
	/*
	 * We make another clipping taking away 1 sigma
	 * from the relation.
	 */
	n_d=0;
	for (i=0;i<nnn;i++) {
	  if ((fabs(fdnx[i]-a_x[1]-a_x[2]*fi_lambda[i])<sig_dnx)&&(fabs(fdny[i]-a_y[1]-a_y[2]*fi_lambda[i])<sig_dny)) {
	    dx[n_d]=fdnx[i];
	    dy[n_d]=fdny[i];
	    xx[n_d]=fi_lambda[i];
	    if (i>0) {
	      if (dx[n_d]!=dx[n_d-1]) nulo_x=1;
	      if (dy[n_d]!=dy[n_d-1]) nulo_y=1;
	    }
	    n_d++;
	  }
	}
      }
      //    printf("%f %f, %f %f, n_d=%d\n",a_x[1],a_x[2],a_y[1],a_y[2],n_d);


      if ((nulo_x==1)&&(nulo_y==1)) {
	gl_lfit(xx,dx,e_fdnx,n_d-1,a_x,ia,ma,covar,&chisq,poly_serie);
	gl_lfit(xx,dy,e_fdny,n_d-1,a_y,ia,ma,covar,&chisq,poly_serie);
	x = (float *)malloc(npix*sizeof(float));
	y1 = (float *)malloc(npix*sizeof(float));
	y2 = (float *)malloc(npix*sizeof(float));
	r = (float *)malloc(npix*sizeof(float));
	if (plot_all==1) {
	  cpgopen("/xterm");
	  cpgask(0);
	  cpgsch(1.6);
	  cpgsubp(1,2);
	  cpgenv(start_w,npix*delta_w+start_w,(-1)*sig_dny,sig_dny,0,0);
	  cpglab("\\gl (Amstrongs)", "\\gDy (arcsec)", "D.A.R");
	  cpgpt(nnn,fi_lambda,fdny,4);
	  cpgerrb(2,nnn,fi_lambda,fdny,e_fdny,0.2);
	  cpgerrb(4,nnn,fi_lambda,fdny,e_fdny,0.4);
	  for (i=0;i<npix;i++) {
	    x[i]=start_w+delta_w*i;
	    y1[i]=0.0;
	    y2[i]=0.0;
	    for (j=0;j<ma;j++) {
	      y1[i]+=a_y[j+1]*pow(x[i],j);
	    }
	    
	  }
	  cpgline(npix,x,y1);
	  if (dar_corrected!=0) {
	    for (j=0;j<n_groups;j++) {
	      cpgsls(j+2);
	      cpgline(dars[j].n,x,dars[j].dy);
	    }
	  }
	  cpgsls(1);
	  cpgenv(start_w,npix*delta_w+start_w,(-1)*sig_dnx,sig_dnx,0,0);
	  cpglab("\\gl (Amstrongs)", "\\gDx (arcsec)", "");
	  cpgpt(nnn,fi_lambda,fdnx,4);
	  cpgerrb(2,nnn,fi_lambda,fdnx,e_fdnx,0.2);
	  cpgerrb(4,nnn,fi_lambda,fdnx,e_fdnx,0.4);
	  for (i=0;i<npix;i++) {
	    x[i]=start_w+delta_w*i;
	    y2[i]=0.0;
	    for (j=0;j<ma;j++) {
	      y2[i]+=a_x[j+1]*pow(x[i],j);
	    }
	  }
	  cpgline(npix,x,y2);
	  if (dar_corrected!=0) {
	    for (j=0;j<n_groups;j++) {
	      cpgsls(j+2);
	      cpgline(dars[j].n,x,dars[j].dx);
	    }
	  }
	  cpgsls(1);
	  cpgsubp(1,1);
	  
	  cpgclos();
	}
	
	

	
	
	for (j=0;j<n_groups;j++) {
	  dars[j].n=npix;
	  for (i=0;i<npix;i++) {
	    dars[j].dx[i]=y2[i];
	    dars[j].dy[i]=y1[i];
	  }
	}


	free(x);
	free(r);
	free(y1);
	free(y2);

      }

      free(covar);
      free(a_x);
      free(a_y);
      free(ia);

    }


    free(xx);
    free(dx);
    free(e_dx);
    free(dy);
    free(e_dy);


    
    //    free(r);
    free(i_lambda);
    printf("Aqui!\n");
    free(dnx);
    free(dny);
    free(fi_lambda);
    free(fdnx);
    free(fdny);
    free(fdnr);
    free(e_fdnx);
    free(e_fdny);
    free(img_data);
    free(psf_data);
    free(map_zero);
    free(map_tmp);
    free(slice);

    
    sprintf(interp->result,"Done");  
  } else {
    sprintf(interp->result,"Bad selection of comparison index");  
  }
  
  return TCL_OK;
}


/**********************************
 * SIMPLE EMPIRICAL D.A.R. Correction
 *********************************/
static int simple_dar_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int j,i,k,l,jj;
  float *slice;
  float tmp_tr[8];
  int nx_t,ny_t;
  float dpix_t=0.2;
  float *map_tmp,*map_zero;
  int comp_index,delta_index;

  int nx_peak,ny_peak;
  float peak;
  float dpix_tt=0.2;

  int *dnx,*dny,*i_lambda;
  float *fdnx,*fdny,*e_fdnx,*e_fdny,*fi_lambda,*fdnr;
  int nnn;
  int dnx0,dny0;
  float sig_dnx,sig_dny;

  int plot_all=0;


  float *a_x,*a_y;
  int *ia;
  float **covar;
  float chisq;
  int ma=3;
  
  float *x,*y1,*y2,*r;

  float min_dn,max_dn;

  float *dx,*e_dx,*dy,*e_dy,*xx;
  int n_d;

  int nulo_x=0;
  int nulo_y=0;

  if(argc < 2 ) {
    Tcl_AppendResult(interp, "plot_spectra comp_index delta_index dx plot_all", NULL);
    return TCL_ERROR;
  }
  
  comp_index=atoi(argv[0]);
  delta_index=atoi(argv[1]);

  dnx = (int *)malloc(((int)(npix/delta_index))*sizeof(int));
  dny = (int *)malloc(((int)(npix/delta_index))*sizeof(int));
  i_lambda = (int *)malloc(((int)(npix/delta_index))*sizeof(int));

  fdnx = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fdny = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fdnr = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fi_lambda = (float *)malloc(((float)(npix/delta_index))*sizeof(float));

  e_fdnx = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  e_fdny = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  nnn=0;

  printf("Started...");
  fflush(stdout);
  if (argc>2) {
    dpix_tt=atof(argv[2]);
  }
  if (argc>3) {
    plot_all=atoi(argv[3]);
  }

  
  if ((comp_index>-1)&&(comp_index<npix-delta_index)) {    
    slice = (float *)malloc((nb_spec)*sizeof(float));
    for (j=0;j<npix-delta_index;j=j+delta_index) {
      i_lambda[nnn]=j+(int)(delta_index/2);
      for (i=0;i<nb_spec;i++) {
	for (jj=0;jj<delta_index;jj++) {
	  slice[i]=raw_data[j+jj+i*npix];
	}
      }
      create_map(nb_spec,n_spaxels,spaxels,npts,slice,dpix_tt,&map_tmp,x_min,x_max,y_min,y_max,&tmp_tr,&nx_t,&ny_t);
      /*
       * We look for the peak
       */
      nx_peak=0;
      ny_peak=0;
      peak=map_tmp[0];
      for (i=0;i<ny_t;i++) {
	for (k=0;k<nx_t;k++) {	  
	  if (peak<map_tmp[k+i*nx_t]) {
	    peak=map_tmp[k+i*nx_t];
	    nx_peak=k;
	    ny_peak=i;
	  }
	  
	}
      }
      dnx[nnn]=nx_peak;
      dny[nnn]=ny_peak;
      nnn++;
    }
    printf("Done\n");
    dnx0=dnx[(int)(((float)comp_index/delta_index+0.5))];
    dny0=dny[(int)(((float)comp_index/delta_index+0.5))];
    min_dn=300.0;
    max_dn=-300.0;
    for (i=0;i<nnn;i++) {
      dnx[i]=dnx[i]-dnx0;
      dny[i]=dny[i]-dny0;
      fdnx[i]=(dnx[i])*dpix_tt;
      fdny[i]=(dny[i])*dpix_tt;
      fdnr[i]=sqrt(fdny[i]*fdny[i]+fdnx[i]*fdnx[i]);
      if (min_dn>fdnx[i]) min_dn=fdnx[i];
      if (max_dn<fdnx[i]) max_dn=fdnx[i];
      if (min_dn>fdny[i]) min_dn=fdny[i];
      if (max_dn<fdny[i]) max_dn=fdny[i];
      e_fdnx[i]=dpix_tt/2;
      e_fdny[i]=dpix_tt/2;
      fi_lambda[i]=i_lambda[i]*delta_w+start_w;
    }
    min_dn-=dpix_tt;
    max_dn+=dpix_tt;

    sig_dnx=sigma(fdnx,nnn,0.0);
    sig_dny=sigma(fdny,nnn,0.0);
    if (sig_dnx>0.5) sig_dnx=0.5;
    if (sig_dny>0.5) sig_dny=0.5;

    /*
     * We clean the data from 1sigma
     */
    xx=vector(1,nnn+1);
    dx=vector(1,nnn+1);
    dy=vector(1,nnn+1);
    e_dx=vector(1,nnn+1);
    e_dy=vector(1,nnn+1);
    n_d=0;
    dx[0]=0.0;
    dy[0]=0.0;
    for (i=0;i<nnn;i++) {
      //     if ((fabs(fdnx[i])<sig_dnx)&&(fabs(fdny[i])<sig_dny)) {
	dx[n_d]=fdnx[i];
	dy[n_d]=fdny[i];
	xx[n_d]=fi_lambda[i];
	//	printf("%f %f %f\n",xx[n_d],dx[n_d],dy[n_d]);
	if (i>0) {
	  if (dx[n_d]!=dx[n_d-1]) nulo_x=1;
	  if (dy[n_d]!=dy[n_d-1]) nulo_y=1;
	}
	n_d++;
	// }
    }
    //    printf("n_d=%d, %d, %d\n",n_d,nulo_x,nulo_y);
    /*
     * We update the information of the DAR
     */

    if ((nulo_x==1)&&(nulo_y==1)) {

      covar=matrix(1,ma,1,ma);
      ia=ivector(1,ma);
      a_x=vector(1,ma);
      a_y=vector(1,ma);
      for (k=1;k<=ma;k++) {
	a_x[k]=1.0/k;
	a_y[k]=1.0/k;
	ia[k]=1;
      }    
      
      
      

      /*
       * We take first the linear version...
       */    
      nulo_x=0;
      nulo_y=0;
      for(j=0;j<2;j++) {
	gl_lfit(xx,dx,e_fdnx,n_d-1,a_x,ia,2,covar,&chisq,poly_serie);
	gl_lfit(xx,dy,e_fdny,n_d-1,a_y,ia,2,covar,&chisq,poly_serie);
	//    free(covar);
	/*
	 * We make another clipping taking away 1 sigma
	 * from the relation.
	 */
	n_d=0;
	for (i=0;i<nnn;i++) {
	  if ((fabs(fdnx[i]-a_x[1]-a_x[2]*fi_lambda[i])<sig_dnx)&&(fabs(fdny[i]-a_y[1]-a_y[2]*fi_lambda[i])<sig_dny)) {
	    dx[n_d]=fdnx[i];
	    dy[n_d]=fdny[i];
	    xx[n_d]=fi_lambda[i];
	    if (i>0) {
	      if (dx[n_d]!=dx[n_d-1]) nulo_x=1;
	      if (dy[n_d]!=dy[n_d-1]) nulo_y=1;
	    }
	    n_d++;
	  }
	}
      }
      //    printf("%f %f, %f %f, n_d=%d\n",a_x[1],a_x[2],a_y[1],a_y[2],n_d);


      if ((nulo_x==1)&&(nulo_y==1)) {
	gl_lfit(xx,dx,e_fdnx,n_d-1,a_x,ia,ma,covar,&chisq,poly_serie);
	gl_lfit(xx,dy,e_fdny,n_d-1,a_y,ia,ma,covar,&chisq,poly_serie);
	x = (float *)malloc(npix*sizeof(float));
	y1 = (float *)malloc(npix*sizeof(float));
	y2 = (float *)malloc(npix*sizeof(float));
	r = (float *)malloc(npix*sizeof(float));
	if (plot_all==1) {
	  cpgopen("/xterm");
	  cpgask(0);
	  cpgsch(1.6);
	  cpgsubp(1,2);
	  cpgenv(start_w,npix*delta_w+start_w,(-1)*sig_dny,sig_dny,0,0);
	  cpglab("\\gl (Amstrongs)", "\\gDy (arcsec)", "D.A.R");
	  cpgpt(nnn,fi_lambda,fdny,4);
	  cpgerrb(2,nnn,fi_lambda,fdny,e_fdny,0.2);
	  cpgerrb(4,nnn,fi_lambda,fdny,e_fdny,0.4);
	  for (i=0;i<npix;i++) {
	    x[i]=start_w+delta_w*i;
	    y1[i]=0.0;
	    y2[i]=0.0;
	    for (j=0;j<ma;j++) {
	      y1[i]+=a_y[j+1]*pow(x[i],j);
	    }
	    
	  }
	  cpgline(npix,x,y1);
	  if (dar_corrected!=0) {
	    for (j=0;j<n_groups;j++) {
	      cpgsls(j+2);
	      cpgline(dars[j].n,x,dars[j].dy);
	    }
	  }
	  cpgsls(1);
	  cpgenv(start_w,npix*delta_w+start_w,(-1)*sig_dnx,sig_dnx,0,0);
	  cpglab("\\gl (Amstrongs)", "\\gDx (arcsec)", "");
	  cpgpt(nnn,fi_lambda,fdnx,4);
	  cpgerrb(2,nnn,fi_lambda,fdnx,e_fdnx,0.2);
	  cpgerrb(4,nnn,fi_lambda,fdnx,e_fdnx,0.4);
	  for (i=0;i<npix;i++) {
	    x[i]=start_w+delta_w*i;
	    y2[i]=0.0;
	    for (j=0;j<ma;j++) {
	      y2[i]+=a_x[j+1]*pow(x[i],j);
	    }
	  }
	  cpgline(npix,x,y2);
	  if (dar_corrected!=0) {
	    for (j=0;j<n_groups;j++) {
	      cpgsls(j+2);
	      cpgline(dars[j].n,x,dars[j].dx);
	    }
	  }
	  cpgsls(1);
	  cpgsubp(1,1);
	  
	  cpgclos();
	}
	
	

	
	
	for (j=0;j<n_groups;j++) {
	  dars[j].n=npix;
	  for (i=0;i<npix;i++) {
	    dars[j].dx[i]=y2[i];
	    dars[j].dy[i]=y1[i];
	  }
	}


	free(x);
	free(r);
	free(y1);
	free(y2);

      }

      free(covar);
      free(a_x);
      free(a_y);
      free(ia);

    }


    free(xx);
    free(dx);
    free(e_dx);
    free(dy);
    free(e_dy);


    
    //    free(r);
    free(i_lambda);
    printf("Aqui!\n");
    /*
    free(dnx);
    free(dny);
    free(fi_lambda);
    free(fdnx);
    free(fdny);
    free(fdnr);
    free(e_fdnx);
    free(e_fdny);
    free(map_zero);
    free(map_tmp);
    free(slice);
    */
    
    sprintf(interp->result,"Done");  
  } else {
    sprintf(interp->result,"Bad selection of comparison index");  
  }
  
  return TCL_OK;
}


/**********************************
 * PRINCIPAL MOMENTUM DAR D.A.R. Correction
 *********************************/
static int pm_dar_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int j,i,k,l,jj;
  float *slice;
  float tmp_tr[8];
  int nx_t,ny_t;
  float dpix_t=0.2;
  int comp_index,delta_index;

  int nx_peak,ny_peak;
  float peak;
  float dpix_tt=0.2;

  float *fdnx,*fdny,*e_fdnx,*e_fdny,*fi_lambda,*fdnr;
  int nnn;
  float fdnx0,fdny0;
  float sig_dnx,sig_dny;

  int plot_all=0;


  float *a_x,*a_y;
  int *ia;
  float **covar;
  float chisq;
  int ma=3;
  
  float *x,*y1,*y2,*r;

  float min_dn,max_dn;

  float *dx,*e_dx,*dy,*e_dy,*xx;
  int n_d;

  int nulo_x=0;
  int nulo_y=0;

  float suma;
  float x_suma;
  float y_suma;
  float valor;
  float x_c,y_c;
  if(argc < 2 ) {
    Tcl_AppendResult(interp, "plot_spectra comp_index delta_index plot_all dpix_tt", NULL);
    return TCL_ERROR;
  }
  
  comp_index=atoi(argv[0]);
  delta_index=atoi(argv[1]);

  fdnx = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fdny = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fdnr = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fi_lambda = (float *)malloc(((float)(npix/delta_index))*sizeof(float));

  e_fdnx = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  e_fdny = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  nnn=0;

  printf("Started...");
  fflush(stdout);

  if (argc>2) {
    dpix_tt=atof(argv[2]);
  }
  if (argc>3) {
    plot_all=atoi(argv[3]);
  }

    
  if ((comp_index>-1)&&(comp_index<npix-delta_index)) {    
    slice = (float *)malloc((nb_spec)*sizeof(float));
    for (j=0;j<npix-delta_index;j=j+delta_index) {
      fi_lambda[nnn]=(j+delta_index/2)*delta_w+start_w;      
      x_suma=0.0;
      y_suma=0.0;
      for (jj=0;jj<delta_index;jj++) {
	suma=0.0;	
	x_c=0.0;
	y_c=0.0;	
	for (i=0;i<nb_spec;i++) {
	  valor=raw_data[j+jj+i*npix];
	  suma=suma+valor;
	  for (k=0;k<n_spaxels[i];k++) {
	    x_c=x_c+spaxels[i][k].xpos/n_spaxels[i]*valor;
	    y_c=y_c+spaxels[i][k].ypos/n_spaxels[i]*valor;
	  }	
	}
	x_c=x_c/suma;
	y_c=y_c/suma;
	x_suma=x_suma+x_c;
	y_suma=y_suma+y_c;
      }

      fdnx[nnn]=x_suma/delta_index;
      fdny[nnn]=y_suma/delta_index;
      nnn++;
    }
    printf("Done\n");
    fdnx0=fdnx[(int)(((float)comp_index/delta_index+0.5))];
    fdny0=fdny[(int)(((float)comp_index/delta_index+0.5))];
    min_dn=300.0;
    max_dn=-300.0;
    for (i=0;i<nnn;i++) {
      fdnx[i]=fdnx[i]-fdnx0;
      fdny[i]=fdny[i]-fdny0;
      if (min_dn>fdnx[i]) min_dn=fdnx[i];
      if (max_dn<fdnx[i]) max_dn=fdnx[i];
      if (min_dn>fdny[i]) min_dn=fdny[i];
      if (max_dn<fdny[i]) max_dn=fdny[i];
      e_fdnx[i]=dpix_tt/2;
      e_fdny[i]=dpix_tt/2;
    }
    min_dn-=dpix_tt;
    max_dn+=dpix_tt;

    sig_dnx=sigma(fdnx,nnn,0.0);
    sig_dny=sigma(fdny,nnn,0.0);

    /*
     * We clean the data from 1sigma
     */
    xx=vector(1,nnn+1);
    dx=vector(1,nnn+1);
    dy=vector(1,nnn+1);
    e_dx=vector(1,nnn+1);
    e_dy=vector(1,nnn+1);
    n_d=0;
    dx[0]=0.0;
    dy[0]=0.0;
    for (i=0;i<nnn;i++) {
	dx[n_d]=fdnx[i];
	dy[n_d]=fdny[i];
	xx[n_d]=fi_lambda[i];
	if (i>0) {
	  if (dx[n_d]!=dx[n_d-1]) nulo_x=1;
	  if (dy[n_d]!=dy[n_d-1]) nulo_y=1;
	}
	n_d++;
    }
    //    printf("n_d=%d, %d, %d\n",n_d,nulo_x,nulo_y);

    /*
     * We update the information of the DAR
     */

    if ((nulo_x==1)&&(nulo_y==1)) {

      covar=matrix(1,ma,1,ma);
      ia=ivector(1,ma);
      a_x=vector(1,ma);
      a_y=vector(1,ma);
      for (k=1;k<=ma;k++) {
	a_x[k]=1.0/k;
	a_y[k]=1.0/k;
	ia[k]=1;
      }    
      
      
      

      /*
       * We take first the linear version...
       */    
      nulo_x=0;
      nulo_y=0;
      for(j=0;j<2;j++) {
	gl_lfit(xx,dx,e_fdnx,n_d-1,a_x,ia,2,covar,&chisq,poly_serie);
	gl_lfit(xx,dy,e_fdny,n_d-1,a_y,ia,2,covar,&chisq,poly_serie);
	//    free(covar);
	/*
	 * We make another clipping taking away 1 sigma
	 * from the relation.
	 */
	n_d=0;
	for (i=0;i<nnn;i++) {
	  if ((fabs(fdnx[i]-a_x[1]-a_x[2]*fi_lambda[i])<sig_dnx)&&(fabs(fdny[i]-a_y[1]-a_y[2]*fi_lambda[i])<sig_dny)) {
	    dx[n_d]=fdnx[i];
	    dy[n_d]=fdny[i];
	    xx[n_d]=fi_lambda[i];
	    if (i>0) {
	      if (dx[n_d]!=dx[n_d-1]) nulo_x=1;
	      if (dy[n_d]!=dy[n_d-1]) nulo_y=1;
	    }
	    n_d++;
	  }
	}
      }
      //    printf("%f %f, %f %f, n_d=%d\n",a_x[1],a_x[2],a_y[1],a_y[2],n_d);


      if ((nulo_x==1)&&(nulo_y==1)) {
	gl_lfit(xx,dx,e_fdnx,n_d-1,a_x,ia,ma,covar,&chisq,poly_serie);
	gl_lfit(xx,dy,e_fdny,n_d-1,a_y,ia,ma,covar,&chisq,poly_serie);
	x = (float *)malloc(npix*sizeof(float));
	y1 = (float *)malloc(npix*sizeof(float));
	y2 = (float *)malloc(npix*sizeof(float));
	r = (float *)malloc(npix*sizeof(float));
	if (plot_all==1) {
	  cpgopen("/xterm");
	  cpgask(0);
	  cpgsch(1.6);
	  cpgsubp(1,2);
	  cpgenv(start_w,npix*delta_w+start_w,(-1)*sig_dny,sig_dny,0,0);
	  cpglab("\\gl (Amstrongs)", "\\gDy (arcsec)", "D.A.R");
	  cpgpt(nnn,fi_lambda,fdny,4);
	  cpgerrb(2,nnn,fi_lambda,fdny,e_fdny,0.2);
	  cpgerrb(4,nnn,fi_lambda,fdny,e_fdny,0.4);
	  for (i=0;i<npix;i++) {
	    x[i]=start_w+delta_w*i;
	    y1[i]=0.0;
	    y2[i]=0.0;
	    for (j=0;j<ma;j++) {
	      y1[i]+=a_y[j+1]*pow(x[i],j);
	    }
	    
	  }
	  cpgline(npix,x,y1);
	  if (dar_corrected!=0) {
	    for (j=0;j<n_groups;j++) {
	      cpgsls(j+2);
	      cpgline(dars[j].n,x,dars[j].dy);
	    }
	  }
	  cpgsls(1);
	  cpgenv(start_w,npix*delta_w+start_w,(-1)*sig_dnx,sig_dnx,0,0);
	  cpglab("\\gl (Amstrongs)", "\\gDx (arcsec)", "");
	  cpgpt(nnn,fi_lambda,fdnx,4);
	  cpgerrb(2,nnn,fi_lambda,fdnx,e_fdnx,0.2);
	  cpgerrb(4,nnn,fi_lambda,fdnx,e_fdnx,0.4);
	  for (i=0;i<npix;i++) {
	    x[i]=start_w+delta_w*i;
	    y2[i]=0.0;
	    for (j=0;j<ma;j++) {
	      y2[i]+=a_x[j+1]*pow(x[i],j);
	    }
	  }
	  cpgline(npix,x,y2);
	  if (dar_corrected!=0) {
	    for (j=0;j<n_groups;j++) {
	      cpgsls(j+2);
	      cpgline(dars[j].n,x,dars[j].dx);
	    }
	  }
	  cpgsls(1);
	  cpgsubp(1,1);
	  
	  cpgclos();
	}
	
	

	
	
	for (j=0;j<n_groups;j++) {
	  dars[j].n=npix;
	  for (i=0;i<npix;i++) {
	    dars[j].dx[i]=y2[i];
	    dars[j].dy[i]=y1[i];
	    //	    printf ("%d %f %f\n",i,dars[j].dx[i],dars[j].dy[i]);
	  }
	}


	free(x);
	free(r);
	free(y1);
	free(y2);

      }

      free(covar);
      free(a_x);
      free(a_y);
      free(ia);

    }

    /*

    free(xx);
    free(dx);
    free(e_dx);
    free(dy);
    free(e_dy);
    */

    
    //    free(r);

    printf("Aqui!\n");
    /*
    free(dnx);
    free(dny);
    free(fi_lambda);
    free(fdnx);
    free(fdny);
    free(fdnr);
    free(e_fdnx);
    free(e_fdny);
    free(map_zero);
    free(map_tmp);
    free(slice);
    */
    
    sprintf(interp->result,"Done");  
  } else {
    sprintf(interp->result,"Bad selection of comparison index");  
  }
  
  return TCL_OK;
}


/**********************************
 * PEAK DAR D.A.R. Correction
 *********************************/
static int peak_dar_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int j,i,k,l,jj;
  float *slice;
  float tmp_tr[8];
  int nx_t,ny_t;
  float dpix_t=0.2;
  int comp_index,delta_index;

  int nx_peak,ny_peak;
  float peak;
  float dpix_tt=0.2;

  float *fdnx,*fdny,*e_fdnx,*e_fdny,*fi_lambda,*fdnr;
  int nnn;
  float fdnx0,fdny0;
  float sig_dnx,sig_dny;

  int plot_all=0;


  float *a_x,*a_y;
  int *ia;
  float **covar;
  float chisq;
  int ma=3;
  
  float *x,*y1,*y2,*r;

  float min_dn,max_dn;

  float *dx,*e_dx,*dy,*e_dy,*xx;
  int n_d;

  int nulo_x=0;
  int nulo_y=0;

  float suma;
  float x_suma;
  float y_suma;
  float valor;
  float x_c,y_c;
  float max_valor;
  if(argc < 2 ) {
    Tcl_AppendResult(interp, "plot_spectra comp_index delta_index plot_all dpix_tt", NULL);
    return TCL_ERROR;
  }
  
  comp_index=atoi(argv[0]);
  delta_index=atoi(argv[1]);

  fdnx = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fdny = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fdnr = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  fi_lambda = (float *)malloc(((float)(npix/delta_index))*sizeof(float));

  e_fdnx = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  e_fdny = (float *)malloc(((float)(npix/delta_index))*sizeof(float));
  nnn=0;

  printf("Started...");
  fflush(stdout);

  if (argc>2) {
    dpix_tt=atof(argv[2]);
  }
  if (argc>3) {
    plot_all=atoi(argv[3]);
  }

    
  if ((comp_index>-1)&&(comp_index<npix-delta_index)) {    
    slice = (float *)malloc((nb_spec)*sizeof(float));
    for (j=0;j<npix-delta_index;j=j+delta_index) {
      fi_lambda[nnn]=(j+delta_index/2)*delta_w+start_w;      
      suma=0.0;
      x_suma=0.0;
      y_suma=0.0;
      for (jj=0;jj<delta_index;jj++) {
	max_valor=-2000;
	for (i=0;i<nb_spec;i++) {
	  valor=raw_data[j+jj+i*npix];
	  if (max_valor<valor) {
	    max_valor=valor;
	    x_c=0.0;
	    y_c=0.0;
	    for (k=0;k<n_spaxels[i];k++) {
	      x_c=x_c+spaxels[i][k].xpos/n_spaxels[i];
	      y_c=y_c+spaxels[i][k].ypos/n_spaxels[i];
	    }	

	  }
	}
	x_suma=x_suma+x_c;
	y_suma=y_suma+y_c;
      }
      fdnx[nnn]=x_suma/delta_index;
      fdny[nnn]=y_suma/delta_index;
      //      printf("%d %f %f\n", nnn, fdnx[nnn],fdnx[nnn]);
      //      fi_lambda[nnn]=(j+(delta_index/2))*delta_w+start_w;
      nnn++;
    }
    printf("Done\n");
    fdnx0=fdnx[(int)(((float)comp_index/delta_index+0.5))];
    fdny0=fdny[(int)(((float)comp_index/delta_index+0.5))];
    min_dn=300.0;
    max_dn=-300.0;
    for (i=0;i<nnn;i++) {
      fdnx[i]=fdnx[i]-fdnx0;
      fdny[i]=fdny[i]-fdny0;
      if (min_dn>fdnx[i]) min_dn=fdnx[i];
      if (max_dn<fdnx[i]) max_dn=fdnx[i];
      if (min_dn>fdny[i]) min_dn=fdny[i];
      if (max_dn<fdny[i]) max_dn=fdny[i];
      e_fdnx[i]=dpix_tt/2;
      e_fdny[i]=dpix_tt/2;
    }
    min_dn-=dpix_tt;
    max_dn+=dpix_tt;

    sig_dnx=sigma(fdnx,nnn,0.0);
    sig_dny=sigma(fdny,nnn,0.0);

    /*
     * We clean the data from 1sigma
     */
    xx=vector(1,nnn+1);
    dx=vector(1,nnn+1);
    dy=vector(1,nnn+1);
    e_dx=vector(1,nnn+1);
    e_dy=vector(1,nnn+1);
    n_d=0;
    dx[0]=0.0;
    dy[0]=0.0;
    for (i=0;i<nnn;i++) {
	dx[n_d]=fdnx[i];
	dy[n_d]=fdny[i];
	xx[n_d]=fi_lambda[i];
	if (i>0) {
	  if (dx[n_d]!=dx[n_d-1]) nulo_x=1;
	  if (dy[n_d]!=dy[n_d-1]) nulo_y=1;
	}
	n_d++;
    }
    //    printf("n_d=%d, %d, %d\n",n_d,nulo_x,nulo_y);

    /*
     * We update the information of the DAR
     */

    if ((nulo_x==1)&&(nulo_y==1)) {

      covar=matrix(1,ma,1,ma);
      ia=ivector(1,ma);
      a_x=vector(1,ma);
      a_y=vector(1,ma);
      for (k=1;k<=ma;k++) {
	a_x[k]=1.0/k;
	a_y[k]=1.0/k;
	ia[k]=1;
      }    
      
      
      

      /*
       * We take first the linear version...
       */    
      nulo_x=0;
      nulo_y=0;
      for(j=0;j<2;j++) {
	gl_lfit(xx,dx,e_fdnx,n_d-1,a_x,ia,2,covar,&chisq,poly_serie);
	gl_lfit(xx,dy,e_fdny,n_d-1,a_y,ia,2,covar,&chisq,poly_serie);
	//    free(covar);
	/*
	 * We make another clipping taking away 1 sigma
	 * from the relation.
	 */
	n_d=0;
	for (i=0;i<nnn;i++) {
	  if ((fabs(fdnx[i]-a_x[1]-a_x[2]*fi_lambda[i])<sig_dnx)&&(fabs(fdny[i]-a_y[1]-a_y[2]*fi_lambda[i])<sig_dny)) {
	    dx[n_d]=fdnx[i];
	    dy[n_d]=fdny[i];
	    xx[n_d]=fi_lambda[i];
	    if (i>0) {
	      if (dx[n_d]!=dx[n_d-1]) nulo_x=1;
	      if (dy[n_d]!=dy[n_d-1]) nulo_y=1;
	    }
	    n_d++;
	  }
	}
      }
      //    printf("%f %f, %f %f, n_d=%d\n",a_x[1],a_x[2],a_y[1],a_y[2],n_d);


      if ((nulo_x==1)&&(nulo_y==1)) {
	gl_lfit(xx,dx,e_fdnx,n_d-1,a_x,ia,ma,covar,&chisq,poly_serie);
	gl_lfit(xx,dy,e_fdny,n_d-1,a_y,ia,ma,covar,&chisq,poly_serie);
	x = (float *)malloc(npix*sizeof(float));
	y1 = (float *)malloc(npix*sizeof(float));
	y2 = (float *)malloc(npix*sizeof(float));
	r = (float *)malloc(npix*sizeof(float));
	if (plot_all==1) {
	  cpgopen("/xterm");
	  cpgask(0);
	  cpgsch(1.6);
	  cpgsubp(1,2);
	  cpgenv(start_w,npix*delta_w+start_w,(-1)*sig_dny,sig_dny,0,0);
	  cpglab("\\gl (Amstrongs)", "\\gDy (arcsec)", "D.A.R");
	  cpgpt(nnn,fi_lambda,fdny,4);
	  cpgerrb(2,nnn,fi_lambda,fdny,e_fdny,0.2);
	  cpgerrb(4,nnn,fi_lambda,fdny,e_fdny,0.4);
	  for (i=0;i<npix;i++) {
	    x[i]=start_w+delta_w*i;
	    y1[i]=0.0;
	    y2[i]=0.0;
	    for (j=0;j<ma;j++) {
	      y1[i]+=a_y[j+1]*pow(x[i],j);
	    }
	    
	  }
	  cpgline(npix,x,y1);
	  if (dar_corrected!=0) {
	    for (j=0;j<n_groups;j++) {
	      cpgsls(j+2);
	      cpgline(dars[j].n,x,dars[j].dy);
	    }
	  }
	  cpgsls(1);
	  cpgenv(start_w,npix*delta_w+start_w,(-1)*sig_dnx,sig_dnx,0,0);
	  cpglab("\\gl (Amstrongs)", "\\gDx (arcsec)", "");
	  cpgpt(nnn,fi_lambda,fdnx,4);
	  cpgerrb(2,nnn,fi_lambda,fdnx,e_fdnx,0.2);
	  cpgerrb(4,nnn,fi_lambda,fdnx,e_fdnx,0.4);
	  for (i=0;i<npix;i++) {
	    x[i]=start_w+delta_w*i;
	    y2[i]=0.0;
	    for (j=0;j<ma;j++) {
	      y2[i]+=a_x[j+1]*pow(x[i],j);
	    }
	  }
	  cpgline(npix,x,y2);
	  if (dar_corrected!=0) {
	    for (j=0;j<n_groups;j++) {
	      cpgsls(j+2);
	      cpgline(dars[j].n,x,dars[j].dx);
	    }
	  }
	  cpgsls(1);
	  cpgsubp(1,1);
	  
	  cpgclos();
	}
	
	

	
	
	for (j=0;j<n_groups;j++) {
	  dars[j].n=npix;
	  for (i=0;i<npix;i++) {
	    dars[j].dx[i]=y2[i];
	    dars[j].dy[i]=y1[i];
	    //printf ("%d %f %f\n",i,dars[j].dx[i],dars[j].dy[i]);
	  }
	}


	free(x);
	free(r);
	free(y1);
	free(y2);

      }

      free(covar);
      free(a_x);
      free(a_y);
      free(ia);

    }

    /*

    free(xx);
    free(dx);
    free(e_dx);
    free(dy);
    free(e_dy);
    */

    
    //    free(r);

    printf("Aqui!\n");
    /*
    free(dnx);
    free(dny);
    free(fi_lambda);
    free(fdnx);
    free(fdny);
    free(fdnr);
    free(e_fdnx);
    free(e_fdny);
    free(map_zero);
    free(map_tmp);
    free(slice);
    */
    
    sprintf(interp->result,"Done");  
  } else {
    sprintf(interp->result,"Bad selection of comparison index");  
  }
  
  return TCL_OK;
}


/**********************************
 * D.A.R. Correction
 *********************************/
static int correct_dar_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int j,i,k,l;
  float *slice;
  float tmp_tr[8];
  int nx_t,ny_t;
  float dpix_t=0.2;
  /*
  if(argc < 2 ) {
    Tcl_AppendResult(interp, "plot_spectra n_map filename", NULL);
    return TCL_ERROR;
  }
  */ 
  if (dar_corrected!=1) {
    slice = (float *)malloc((nb_spec)*sizeof(float));
    for (j=0;j<npix;j++) {

      for (i=0;i<nb_spec;i++) {
	slice[i]=raw_data[j+i*npix];
      }
      //      printf("%f ",raw_data[j+100*npix]);
      correct_mono_dar(nb_spec,n_spaxels,spaxels,slice,dars,j);
      for (i=0;i<nb_spec;i++) {
	raw_data[j+i*npix]=slice[i];
      }
      //      printf("%f \n",raw_data[j+100*npix]);
      //          printf("Slice %d corrected\n",j);
    }
    
    dar_corrected=1;
    sprintf(interp->result,"Ok");  
  } else {
    sprintf(interp->result,"Already Done");  
  }

  return TCL_OK;
}


/**********************************
 * D.A.R. Theoretical Determination 
 *********************************/
static int theoretical_dar_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int j,i;
  int test=0;
  /*
  if(argc < 2 ) {
    Tcl_AppendResult(interp, "plot_spectra n_map filename", NULL);
    return TCL_ERROR;
  }
  */ 

  if (argc<1) {
    test=0;
  } else {
    test=atoi(argv[0]);
  }

  for (j=0;j<n_groups;j++) {
    dars[j].n=npix;
    dars[j].dx= (float *)malloc(npix*sizeof(float));  
    dars[j].dy= (float *)malloc(npix*sizeof(float));  
    determine_dar(dars[j],groups[j],(float)start_w,(float)delta_w,npix);     
    if (test==1) {
      for (i=0;i<npix;i++) {
	printf("%d %f %f \n",i,dars[j].dx[i],dars[j].dy[i]);
      }
    }
    
  }
  dar_corrected=-1;
  return TCL_OK;
}


/**********************************
 * SAVE SLICE ROUTINE				  
 *********************************/
static int save_slice_command(Tcl_Interp *interp, int argc, char *argv[]) {
  char text[80],units[80];
  int n_m=0;
  float *tmp_x,*tmp_y,*tmp_slice; // Array of Selection of Slices
  int *tmp_specId;
  int n_tot=0;
  int i,j,k;
  int outputtype=0;
  if(argc < 4 ) {
    Tcl_AppendResult(interp, "save_slice n_slice filename units outputtype[0=fits,1=ascii]", NULL);
    return TCL_ERROR;
  }
  n_m=atoi(argv[0]);
  strcpy(text,argv[1]);
  strcpy(units,argv[2]);
  outputtype=atoi(argv[3]);

  for (i=0;i<nb_spec;i++) {	    
    for (j=0;j<n_spaxels[i];j++) {
      n_tot++;
    }
  }
  tmp_slice = (float *)malloc((n_tot)*sizeof(float));
  tmp_x = (float *)malloc((n_tot)*sizeof(float));
  tmp_y = (float *)malloc((n_tot)*sizeof(float));
  tmp_specId = (int *)malloc((n_tot)*sizeof(int));

  k=0;
  for (i=0;i<nb_spec;i++) {	    
    for (j=0;j<n_spaxels[i];j++) {
      tmp_specId[k]=spaxels[i][j].specId;
      tmp_x[k]=spaxels[i][j].xpos;
      tmp_y[k]=spaxels[i][j].ypos;
      tmp_slice[k]=f_slice[n_m][i];
      k++;
    }
  }
  if (outputtype==0) {
    save_slice(tmp_specId,tmp_x,tmp_y,tmp_slice,n_tot,text,units);
  } else {
    save_slice_ascii(tmp_specId,tmp_x,tmp_y,tmp_slice,n_tot,text,units);
  }
  sprintf(interp->result,"1");  


  free(tmp_slice);
  free(tmp_x);
  free(tmp_y);
  free(tmp_specId);
  return TCL_OK;
}


/**********************************
 * SAVE MAP ROUTINE				  
 *********************************/
static int save_map_command(Tcl_Interp *interp, int argc, char *argv[]) {
  char text[80];
  int n_m=0;
  if(argc < 2 ) {
    Tcl_AppendResult(interp, "save_map n_map filename", NULL);
    return TCL_ERROR;
  }
  n_m=atoi(argv[0]);
  strcpy(text,argv[1]);
  if (map_created[slice_index]!=1) {
    sprintf(interp->result,"0");  
  } else {
    save_map(map_data[slice_index],nx_map[slice_index],ny_map[slice_index],text);
    sprintf(interp->result,"1");  
  }
  return TCL_OK;
}


/**********************************
 * SAVE SPEC ROUTINE				  
 *********************************/
static int save_spec_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int nargc;  
  int j,i,k; 
  int i_temp;
  float *spectra;
  float *raw_spectra;
  float *slice;
  char **tokens;
  int n_tokens;
  char wave[8];
  float lw;
  int nlw;
  char text[80];
  if(argc < 2) {
    Tcl_AppendResult(interp, "save_spec MAPFILE i_spax", NULL);
    return TCL_ERROR;
  }
  
  strcpy(text,argv[0]);
  split_text(argv[1]," ",&nargc,&tokens);
  //  printf("Number of Selected Spectra=%d\n",nargc);

  if (nargc>0) {    
    n_i_spax=nargc;
    n_sel_spec=nargc;
    
    for (j=0;j<nargc;j++) {
      i_spax[j]=atoi(tokens[j]);
    }
    /*
     * We determine the values to plot
     */
    spectra = (float *)malloc((npix)*sizeof(float));
    raw_spectra = (float *)malloc((npix*nargc)*sizeof(float));
    slice = (float *)malloc((nargc)*sizeof(float));
    for (i=0;i<npix;i++) {
      spectra[i]=0.0;
    }
    for (i=0;i<npix;i++) {
      for (k=0;k<nargc;k++) {
	spectra[i]+=raw_data[i+i_spax[k]*npix];	
	raw_spectra[i+k*npix]=raw_data[i+i_spax[k]*npix];      
	slice[k]=raw_data[i+i_spax[k]*npix];      
      }
    }
    for (i=0;i<npix;i++) {
      spectra[i]/=nargc;    
    }
    save_map(raw_spectra,npix,nargc,text);
    sprintf(interp->result,"1");  
  } else {
    sprintf(interp->result,"0");  
  }
  return TCL_OK;
}


/**********************************
 * SAVE SPEC TABLE ROUTINE				  
 *********************************/
static int save_spec_table_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int nargc;  
  int j,i,k; 
  int i_temp;
  float *spectra;
  float *raw_spectra;
  float *slice;
  float *w;
  char **tokens;
  int n_tokens;
  float lw;
  int nlw;
  char text[80],units[80];
  int flag;
  if(argc < 4) {
    Tcl_AppendResult(interp, "save_spec MAPFILE units flag i_spax", NULL);
    return TCL_ERROR;
  }
  
  strcpy(text,argv[0]);
  strcpy(units,argv[1]);
  flag=atoi(argv[2]);
  split_text(argv[3]," ",&nargc,&tokens);
  //  printf("Number of Selected Spectra=%d\n",nargc);

  if (nargc>0) {    
    n_i_spax=nargc;
    n_sel_spec=nargc;
    
    for (j=0;j<nargc;j++) {
      i_spax[j]=atoi(tokens[j]);
    }
    /*
     * We determine the values to plot
     */
    spectra = (float *)malloc((npix)*sizeof(float));
    w = (float *)malloc((npix)*sizeof(float));
    raw_spectra = (float *)malloc((npix*nargc)*sizeof(float));
    slice = (float *)malloc((nargc)*sizeof(float));
    for (i=0;i<npix;i++) {
      spectra[i]=0.0;
    }
    for (i=0;i<npix;i++) {
      w[i]=(float)start_w+((float)delta_w)*i;
      for (k=0;k<nargc;k++) {
	spectra[i]+=raw_data[i+i_spax[k]*npix];	
	raw_spectra[i+k*npix]=raw_data[i+i_spax[k]*npix];      
	slice[k]=raw_data[i+i_spax[k]*npix];      
      }
    }
    for (i=0;i<npix;i++) {
      spectra[i]/=nargc;    
    }
    if (flag==0) {
      save_spec_table(w,spectra,npix,text,units);
    } else {
      save_spec_ascii(w,spectra,npix,text,units);
    }
    //    save_map(spectra,npix,nargc,text);
    
    sprintf(interp->result,"1");  
  } else {
    sprintf(interp->result,"0");  
  }
  return TCL_OK;
}



/**********************************
 * PLOT MAP ROUTINE				  
 *********************************/
static int plot_map_command(Tcl_Interp *interp, int argc, char *argv[]) {
  char *p_names[]={"grey","rainbow","heat","iraf","aips"};
  float min;
  float max;
  int id,j,i,k,id_s; 
  int i_temp;
  int p;
  float bright,contra,sign;
  int save=0;
  int n_m=0;

  
  if(argc < 7 || *argv[1] == '-') {
    Tcl_AppendResult(interp, "plot_map min max device palette bright contra sign n_map", NULL);
    return TCL_ERROR;
  }
  min=atof(argv[0]);
  max=atof(argv[1]);
  id=atoi(argv[2]);
  bright=atof(argv[4]);
  contra=atof(argv[5]);
  sign=atof(argv[6]);
  for (j=0;j<5;j++) {
    if (strstr(p_names[j],argv[3])) p=j+1;
  }

  /*
   * Now we determine the number of spectra
   * that are passed as arguments
   */
  
  n_m=atoi(argv[7]);
  cpgslct(id);
  palette(p,0.8,0.6);
  tr_palett(nx_map[n_m]*ny_map[n_m],map_data[n_m],&tmp_data,sign,contra,bright,min,max); 
  cpgask(0);
  cpgpage();
  //image_plot(map_data[n_m],min,max,nx_map[n_m],ny_map[n_m],id,tr);
  image_plot(tmp_data,min,max,nx_map[n_m],ny_map[n_m],id,tr);
  free(tmp_data);
  return TCL_OK;
}

/*********************************
 * Subroutine to create a certain MAP				  
 *********************************/
static int create_map_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int i;
  int i0,i1,i_temp;
  float *slice;
  //


  float *map_data_temp;
  //int nx_map_temp,ny_map_temp;
  //float tr_map_temp[8];


  if(argc < 3 || *argv[1] == '-') {
    Tcl_AppendResult(interp, "create_map i1 i2 dpix", NULL);
    return TCL_ERROR;
  }
  i0=floor(atof(argv[0]));
  i1=floor(atof(argv[1]));
  dpix=atof(argv[2]);
  fflush(stdout);


  /*
   * We determine the range of spectras to ask for
   */
  if (n_map>MAX_NUM_MAPS) {
    n_map=0;    
    map_created[0]=0;
  }

  slice = (float *)malloc((nb_spec)*sizeof(float));
  for (i=0;i<nb_spec;i++) {
    slice[i]=0.0;
    for (j=i0;j<i1;j++) {
      slice[i]+=raw_data[j+i*npix];
    }
      slice[i]/=(i1-i0);
  }

  create_map(nb_spec,n_spaxels,spaxels,npts,slice,dpix,&map_data[n_map],x_min,x_max,y_min,y_max,&tr_map[n_map],&nx_map[n_map],&ny_map[n_map]);
  map_created[n_map]=1;
  sprintf(interp->result,"%d",n_map);  

  n_map++;
  return TCL_OK;
}


/*****************************************
 * Procedure to substract a certain spectra
 *****************************************/
static int div_spec_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int n1,n2;
  int j;
  if(argc < 2) {
    Tcl_AppendResult(interp, "div_spec n_spec1 n_spec2 : BAD ARGUMENTS", NULL);
    return TCL_ERROR;
  }
  n1=atoi(argv[0]);
  n2=atoi(argv[1]);
  for (j=0;j<npix;j++) {
    if (f_spec[n1][j]!=0.0) {
      f_spec[n_f_spec][j]=f_spec[n2][j]/f_spec[n1][j];
    } else {
      f_spec[n_f_spec][j]=0.0;
    }
  }
  sprintf(interp->result,"%d",n_f_spec);  
  n_f_spec++;
  if (n_f_spec>MAX_NUM_SPEC) {
    n_f_spec=0;
  }
  return TCL_OK;
}
/*****************************************
 * Procedure to substract a certain spectra
 *****************************************/
static int sub_spec_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int n1,n2;
  int j;
  if(argc < 2) {
    Tcl_AppendResult(interp, "sub_spec n_spec1 n_spec2 : BAD ARGUMENTS", NULL);
    return TCL_ERROR;
  }
  n1=atoi(argv[0]);
  n2=atoi(argv[1]);
  //printf("%d %d\n",n1,n2);
  f_spec[n_f_spec] = (float *)malloc(npix*sizeof(float));
  for (j=0;j<npix;j++) {
    //printf("%d ",j);
    f_spec[n_f_spec][j]=f_spec[n2][j]-f_spec[n1][j];
  }
  sprintf(interp->result,"%d",n_f_spec);  
  n_f_spec++;
  if (n_f_spec>MAX_NUM_SPEC) {
    n_f_spec=0;
  }
  return TCL_OK;
}

/*****************************************
 * Procedure to substract a the SKY
 *****************************************/
static int skysub_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int n1,n2;
  int i,j;
  if(argc < 1) {
    Tcl_AppendResult(interp, "sub_spec n_spec1: BAD ARGUMENTS", NULL);
    return TCL_ERROR;
  }
  n1=atoi(argv[0]);
  for (i=0;i<nb_spec;i++) {
    for (j=0;j<npix;j++) {
      raw_data[j+i*npix]=raw_data[j+i*npix]-f_spec[n1][j];
    }
  }
  return TCL_OK;
}

/*****************************************
 * Procedure for Arithmetical operations with the selected SLICEs
 * Operations (+) (-) (/) (*)
 *****************************************/
static int slicearith_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int n1,n2,n3;
  int j;
  char command[1];
  float operator;
  int op_type=0;
  if(argc < 3) {
    Tcl_AppendResult(interp, "slicearith n_spec1 command n_spec2 n3", NULL);
    return TCL_ERROR;
  }
  n1=atoi(argv[2]);
  strcpy(command,argv[1]);
  n2=atoi(argv[0]);
  //  n3=floor(atof(argv[3]));
  n3=atoi(argv[3]);
  if (n3>MAX_NUM_MAPS) n3=0;

  f_slice[n3] = (float *)malloc((nb_spec)*sizeof(float));

  //  printf("ARITH %d %s %d %d\n",n1,command,n2,n3);
  //  if (operator!=n2) op_type=1;

  //  f_slice[n3] = (float *)malloc(npix*sizeof(float));
  // Substract
  if(strcmp(command, "-") == 0) {      
    for (j=0;j<nb_spec;j++) {
      f_slice[n3][j]=f_slice[n2][j]-f_slice[n1][j];
      //  printf("%d %f %f %f\n",j,f_slice[n3][j],f_slice[n2][j],f_slice[n1][j]);
    }
  }
  // Add
  if(strcmp(command, "+") == 0) {      
    for (j=0;j<nb_spec;j++) {
      f_slice[n3][j]=f_slice[n2][j]+f_slice[n1][j];
    }
  }
  // Multiply
  if(strcmp(command, "*") == 0) {      
    for (j=0;j<nb_spec;j++) {
      f_slice[n3][j]=f_slice[n2][j]*f_slice[n1][j];
    }
  }
  // Divide
  if(strcmp(command, "/") == 0) {      
    for (j=0;j<nb_spec;j++) {
      if (f_slice[n1][j]!=0.0) { 
	f_slice[n3][j]=f_slice[n2][j]/f_slice[n1][j];
      } else {
	f_slice[n3][j]=0.0001;
      }
    }
  }
  n_i_spax=-1;
  sprintf(interp->result,"%d",n3);  
  /*
  slice_index++;
  if (slice_index>MAX_NUM_MAPS) {
    slice_index=0;
  }
  */
  return TCL_OK;
}


/*****************************************
 * Procedure for Arithmetical operations with the selected spectra
 * Operations (+) (-) (/) (*)
 *****************************************/
static int specarith_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int n1,n2;
  int j;
  char command[1];
  float operator;
  int op_type=0;
  if(argc < 3) {
    Tcl_AppendResult(interp, "specarith n_spec1 command n_spec2", NULL);
    return TCL_ERROR;
  }
  n2=atoi(argv[0]);
  strcpy(command,argv[1]);
  n1=atoi(argv[2]);
  operator=atoi(argv[2]);
  if (operator!=n2) op_type=1;
  f_spec[n_f_spec] = (float *)malloc(npix*sizeof(float));
      //      printf("%d %f %f %f\n",j,f_spec[n_f_spec][j],f_spec[n2][j],f_spec[n1][j]);
  // Substract
  if(strcmp(command, "-") == 0) {      
    for (j=0;j<npix;j++) {
      f_spec[n_f_spec][j]=f_spec[n2][j]-f_spec[n1][j];
    }
  }
  // Add
  if(strcmp(command, "+") == 0) {      
    for (j=0;j<npix;j++) {
      f_spec[n_f_spec][j]=f_spec[n2][j]+f_spec[n1][j];
    }
  }
  // Multiply
  if(strcmp(command, "*") == 0) {      
    for (j=0;j<npix;j++) {
      f_spec[n_f_spec][j]=f_spec[n2][j]*f_spec[n1][j];
    }
  }
  // Divide
  if(strcmp(command, "/") == 0) {      
    for (j=0;j<npix;j++) {
      if (f_spec[n1][j]!=0.0) { 
	f_spec[n_f_spec][j]=f_spec[n2][j]/f_spec[n1][j];
      } else {
	f_spec[n_f_spec][j]=0.0001;
      }
    }
  }
  n_i_spax=-1;
  sprintf(interp->result,"%d",n_f_spec);  
  n_f_spec++;
  if (n_f_spec>MAX_NUM_SPEC) {
    n_f_spec=0;
  }
  return TCL_OK;
}

/*****************************************
 * Procedure to create a certain new Spectrum
 *****************************************/
static int create_spec_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int i;
  if (start_n_f_spec!=0) {
    /* */
    f_spec[n_f_spec] = (float *)malloc(npix*sizeof(float));
    for (i=0;i<npix;i++) {
      f_spec[n_f_spec][i]=f_spec_now[i];
    }
    sprintf(interp->result,"%d",n_f_spec);  
    n_f_spec++;
    if (n_f_spec>MAX_NUM_SPEC) {
      n_f_spec=0;
    }
  } else {
    sprintf(interp->result,"-666");  
  }
  return TCL_OK;
}
/*****************************************
 * Procedure to load a new Spectrum
 *****************************************/
static int load_spec_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int n_spec;
  if(argc < 1) {
    Tcl_AppendResult(interp, "load_spec n_spec : BAD ARGUMENTS", NULL);
    return TCL_ERROR;
  }
  n_spec=atoi(argv[0]);
  f_spec_now=f_spec[n_spec];
  n_i_spax=-1;
  return TCL_OK;
}



/*****************************************
 * Procedure to create a certain new obj.
 *****************************************/
static int create_obj_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int j;
  int n_obj;
  //  if (argc==1) {
  //  n_obj=atoi(argv[0]);
  //} else {  
    //}
  if (que_j_spax>MAX_NUM_OBJ) {
    que_j_spax=0;
  }
  n_obj=que_j_spax;
  //  printf("NUM.OBJ=%d\n",n_obj);
  if (n_i_spax==0) {
    n_obj=-666;
  } else {
    n_j_spax[n_obj]=n_i_spax;
    for (j=0;j<n_i_spax;j++) {
      j_spax[n_obj][j]=i_spax[j];
    }
    que_j_spax++;
  }
  sprintf(interp->result,"%d",n_obj);

  return TCL_OK;
}

/*****************************************
 * Procedure to read a certain object as the actual obj.
 *****************************************/
static int load_obj_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int j;
  int n_obj;
  if(argc < 1) {
    Tcl_AppendResult(interp, "load_obj n_obj : BAD ARGUMENTS", NULL);
    return TCL_ERROR;
  }
  n_obj=atoi(argv[0]);
  if (n_obj>MAX_NUM_OBJ) {
    Tcl_AppendResult(interp, "n_obj>MAX_NUM_OBJ : ERROR", NULL);
    return TCL_ERROR;
  }
  if (n_j_spax[n_obj]==0) {
    Tcl_AppendResult(interp, "No Spaxels in this object : ERROR", NULL);
    return TCL_ERROR;
  }
  n_i_spax=n_j_spax[n_obj];
  for (j=0;j<n_i_spax;j++) {
    i_spax[j]=j_spax[n_obj][j];
  }
  sprintf(interp->result,"%d",n_i_spax);

  return TCL_OK;
}


/*************************************
 * Mark a certain region with an arrow
 *
 ***********************************/
static int mark_range_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int nargc;  
  float x1,y1,x2,y2;
  int j;
  int dev_id,colorindex,width,style;
  char text[5];
  if(argc < 9 ) {
    Tcl_SetResult(interp, "plot_line dev_id colorindex lweight lstyle text x1 y1 x2 y2: Argument Error", TCL_STATIC);
    return TCL_ERROR;
  };  
  dev_id=atoi(argv[0]);
  colorindex=atoi(argv[1]);
  width=atoi(argv[2]);
  style=atoi(argv[3]);
  strcpy(text,argv[4]);
  x1=atof(argv[5]);
  y1=atof(argv[6]);
  x2=atof(argv[7]);
  y2=atof(argv[8]);
  cpgslct(dev_id);
  cpgsci(colorindex);
 //  cpgslw(width);
  cpgsls(style);
  cpgsch(width);
  mark_range(x1,y1,x2,y2,text);
  cpgsch(1.0);
  cpgsls(1);
  cpgsci(1);
  cpgslw(1);
  return TCL_OK;

}


/**********************************
 * Routine to determine the nearest SPAX 
 * to a certain X,Y coordinates
 **********************************/
static int nearest_spax_command(Tcl_Interp *interp, int argc, char *argv[]) {
  float x,y;
  float x_c,y_c;
  float dist=100000.0,dist_temp;
  int i,j,spax_id;
  /*
  if(argc < 2 || *argv[1] == '-') {
    Tcl_AppendResult(interp, "nearest_spax X Y:ERROR", NULL);
    return TCL_ERROR;
  }
  */
  x=atof(argv[0]);
  y=atof(argv[1]);
  spax_id=0;
  for (i=0;i<nb_spec;i++) {	    
    for (j=0;j<n_spaxels[i];j++) {
      x_c=spaxels[i][j].xpos;
      y_c=spaxels[i][j].ypos;
      dist_temp=sqrt(pow(x_c-x,2)+pow(y_c-y,2));
      if (dist_temp<dist) {
	dist=dist_temp;
	spax_id=i;
      }
    }  
  }
  sprintf(interp->result,"%d",spax_id);
  return TCL_OK;
}


/**********************************
 * routine to save the selected spectra
 **********************************/
static int save_spectra_sel_command(Tcl_Interp *interp, int argc, char *argv[]) {
  char **tokens;
  int n_tokens,j; 
  //printf("argc=%d\n",argc);
  if(argc < 1 ) {
    n_i_spax=0;
  } else {
    //printf("'%s'\n",argv[0]);
    split_text(argv[0]," ",&n_tokens,&tokens);
    if (n_tokens>0) {
      n_i_spax=n_tokens;
      for (j=0;j<n_tokens;j++) {
	i_spax[j]=atoi(tokens[j]);
	//	printf("i_spax=%d\n",i_spax[j]);
      }  
    }
  }
  return TCL_OK;
}


/**********************************
 * routine to load the number selected spectra
 **********************************/
static int load_n_spectra_sel_command(Tcl_Interp *interp, int argc, char *argv[]) {
  sprintf(interp->result,"%d",n_i_spax); 
  return TCL_OK;
}


/**********************************
 * routine to load the selected spectra
 * from C-Memory
 **********************************/
static int load_spectra_sel_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int j;
  int n_sel;

  if(argc < 1) {
    Tcl_AppendResult(interp, "load_sepectra_sel n_sel", NULL);
    return TCL_ERROR;
  }
  n_sel=atoi(argv[0]);

  if (n_i_spax>0) {
    sprintf(interp->result,"%d",i_spax[n_sel]); 
  } else {
    sprintf(interp->result,"-666");
  }
  return TCL_OK;
}

/*********************************
 * Subroutine that plots the Spectra
 * in the Spectra inspector
 *********************************/
static int plot_spectra_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int nargc;  
  char *p_names[]={"grey","rainbow","heat","iraf","aips"};
  float min;
  float max;
  int id,j,i,k,id_s; 
  int i_temp;
  float *spectra;
  float *raw_spectra;
  float *slice;
  int p;
  float bright,contra,sign;
  int save=0;
  char **tokens;
  int n_tokens;
  char wave[8];
  float lw;
  int nlw;
  float local_min,local_max;
  int flag=0;
  
  if(argc < 7 || *argv[1] == '-') {
    Tcl_AppendResult(interp, "plot_spectra min max device device_2 palette bright contra sign i_spax", NULL);
    return TCL_ERROR;
  }
  min=atof(argv[0]);
  max=atof(argv[1]);
  id=atoi(argv[2]);
  id_s=atoi(argv[3]);

  bright=atof(argv[5]);
  contra=atof(argv[6]);
  sign=atof(argv[7]);
  flag=atof(argv[8]);
  for (j=0;j<5;j++) {
    if (strstr(p_names[j],argv[4])) p=j+1;
  }

  /*
   * Now we determine the number of spectra
   * that are passed as arguments
   */


  split_text(argv[8]," ",&nargc,&tokens);

  if (nargc>0) {
    if (n_sel_spec!=nargc) pintados[id]=0;


    n_i_spax=nargc;
    n_sel_spec=nargc;
    
    for (j=0;j<nargc;j++) {
      i_spax[j]=atoi(tokens[j]);
    }
    if (i_spax[0]!=old_spax_id[id]) pintados[id]=0;
    i_spax[0]==old_spax_id[id];
    /*
     * We determine the values to plot
     */
    spectra = (float *)malloc((npix)*sizeof(float));
    raw_spectra = (float *)malloc((npix*nargc)*sizeof(float));
    slice = (float *)malloc((nargc)*sizeof(float));
    for (i=0;i<npix;i++) {
      spectra[i]=0.0;
    }
    for (i=0;i<npix;i++) {
      for (k=0;k<nargc;k++) {
	spectra[i]+=raw_data[i+i_spax[k]*npix];	
	raw_spectra[i+k*npix]=raw_data[i+i_spax[k]*npix];      
	slice[k]=raw_data[i+i_spax[k]*npix];      
      }
    }
    for (i=0;i<npix;i++) {
      spectra[i]/=nargc;    
    }

    if (id!=id_s) {
      cpgslct(id);
      cpgask(0);
      
      if (old_p[id]!=p)  pintados[id]=0;
      
      
      if (pintados[id]<2) {
	cpgvstd();
	cpgenv(1.0+npix_w1,npix_w2+1.0,1.0,nargc+0.1,0,-1);     
	//	cpgenv(1.0,npix+1.0,1.0,nargc+0.1,0,-1);    
	cpgsch(1.7);
	for (j=0;j<6;j++) {
	  lw=start_w+((npix_w2-npix_w1)*delta_w)*j/5+delta_w*npix_w1;      
	  sprintf(wave,"%d",(int)lw);
	  cpgptxt((((float)npix)/5)*j+(float)npix_w1,(-1)*(nargc/20),0.0,0.5,wave);
	}
	old_p[id]=p;
	palette(p,0.8,0.6);
      } 
      pintados[id]++;
      if (pintados[id]>3) pintados[id]=3; 
      
      /*      
      local_min=min;
      local_max=min+(max-min)/bright;
      local_max=local_min+(local_max-local_min)/contra;
      */
      local_min=min;
      local_max=max;
      tr_palett(npix*nargc,raw_spectra,&tmp_data,sign,contra,bright,min,max); 
      cpgimag(tmp_data,npix,nargc,1,npix,1,nargc,min,max,tr);
      //      free(tmp_data);
    }

    /*
    cpgpage();
    image_plot(raw_spectra,min,max,npix,nargc,id,tr);
    */

    if ((pintados[id]<2)||(old_min[id_s]!=min)||(old_max[id_s]!=max)) {
      cpgslct(id_s);
      cpgask(0);
      cpgpage();
      //      spec_plot(spectra,min,max,npix,start_w,delta_w);
      spec_plot_range(spectra,min,max,npix_w1,npix_w2,start_w,delta_w);
    }


    /*
     *
     * We save the plotted spectrum in the current n_f_spec
     *
     */
    f_spec_now=spectra;
    start_n_f_spec=1;
    old_min[id_s]=min;
    old_max[id_s]=max;


  }
  return TCL_OK;
}


/*********************************
 * Subroutine that plots the Spectra
 * from the memory
 *********************************/
static int plot_spectra_mem_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int nargc;  
  char *p_names[]={"grey","rainbow","heat","iraf","aips"};
  float min;
  float max;
  int id,j,i,k,id_s; 
  int i_temp;
  float *spectra;
  float *raw_spectra;
  float *slice;
  int p;
  float bright,contra,sign;
  int save=0;
  char **tokens;
  int n_tokens;
  char wave[8];
  float lw;
  int nlw;
  float local_min,local_max;
  
  if(argc < 6 || *argv[1] == '-') {
    Tcl_AppendResult(interp, "plot_spectra min max device device2 palette bright contra sign", NULL);
    return TCL_ERROR;
  }
  min=atof(argv[0]);
  max=atof(argv[1]);
  id=atoi(argv[2]);
  id_s=atoi(argv[3]);

  bright=atof(argv[5]);
  contra=atof(argv[6]);
  sign=atof(argv[7]);
  for (j=0;j<5;j++) {
    if (strstr(p_names[j],argv[4])) p=j+1;
  }

  cpgslct(id);
  palette(p,0.8,0.6);
  cpgask(0);
  
  //  cpgvstd(); 
  cpgenv(1.0,npix+1.0,1.0,1.1,0,-1);    
  old_p[id]=p;
  palette(p,0.8,0.6);
  
  /*
  local_min=min;
  local_max=min+(max-min)/bright;
  local_max=local_min+(local_max-local_min)/contra;
  */
  local_min=min;
  local_max=max;
  tr_palett(npix,f_spec_now,&tmp_data,sign,contra,bright,min,max); 
  cpgimag(tmp_data,npix,1,1,npix,1,1.1,min,max,tr);

  cpgsch(1.7);
  for (j=0;j<6;j++) {
    lw=start_w+(npix*delta_w)*j/5;      
    sprintf(wave,"%d",(int)lw);
    cpgptxt((((float)npix)/5)*j,0.99,0.0,0.5,wave);
  }
  
 

  //  cpgpage();
  //image_plot(f_spec_now,min,max,npix,1,id,tr);
  cpgslct(id_s);
  cpgask(0);
  cpgpage();
  spec_plot(f_spec_now,min,max,npix,start_w,delta_w);
  return TCL_OK;
}



/*********************************
 * Subroutine that plots the Spaxels
 * in the Spaxels inspector
 *********************************/
static int plot_spaxels_command(Tcl_Interp *interp, int argc, char *argv[]) {
  char *p_names[]={"grey","rainbow","heat","iraf","aips"};
  float min;
  float max;
  float old_max,old_min;
  int id,j,i,k; 
  int i0,i1,i_temp;
  float *slice;
  GROUP grupo;
  int color_index,n_colors;
  int nc=240;
  float x_c,y_c;
  int p;
  float bright,contra,sign;
  int save=0;
  int fill=1;
  int text_flag=0;
  float temp_float[200];
  char text[5];
  int new_img=0;
  float tr_tmp[]={0.0,1.0,0.0,0.0,0.0,1.0};  
  float d, vpx1, vpx2, vpy1, vpy2;
  float *tmp_slice;
  float levels[100];
  float *tmp_levels;

  float real_min,real_max;
  //  int read_mem=0;

  if(argc < 5 || *argv[1] == '-') {
    Tcl_AppendResult(interp, "plot_spaxels min max device i1 i2 palette bright contra sign save fill text_flag ", NULL);
    return TCL_ERROR;
  }
  min=atof(argv[0]);
  max=atof(argv[1]);
  id=atoi(argv[2]);
  i0=floor(atof(argv[3]));
  i1=floor(atof(argv[4]));
  //  save=atoi(argv[9]);
  save=0;
  fill=atoi(argv[10]);
  text_flag=atoi(argv[11]);
  if (argc==13) {
    new_img=atoi(argv[12]);
  }

  old_max=max;
  old_min=min;


  fflush(stdout);
  if (i1<i0) {
    i_temp=i1;
    i1=i0;
    i0=i_temp;
  }

  bright=atof(argv[6]);
  contra=atof(argv[7]);
  sign=atof(argv[8]);
  for (j=0;j<5;j++) {
    if (strstr(p_names[j],argv[5])) p=j+1;
  }

  if (bright==0) bright=0.01;
  if (contra==0) bright=0.01;


  /*
   * TEXT_FLAG>15 Handeling with saved data
   */

  if (text_flag<15) {
    
    /*
     * We determine the range of spectras to ask for
     */
    slice = (float *)malloc((nb_spec)*sizeof(float));
    for (i=0;i<nb_spec;i++) {
      slice[i]=0.0;
      for (j=i0;j<i1;j++) {
	slice[i]+=raw_data[j+i*npix];
	//	printf("%f ",raw_data[j+i*npix]);
      }
      slice[i]/=(i1-i0);
      //printf(" slice= %f\n",slice[i]);
      //      f_slice_now[i]=slice[i];  
      //f_slice[slice_index][i]=slice[i];
    }    
    /*
     * We save the data for future
     */
  } else {
    text_flag=text_flag-20;
    save=0;
    slice_index=i0;
    slice = (float *)malloc((nb_spec)*sizeof(float));
    for (i=0;i<nb_spec;i++) {
      slice[i]=f_slice[slice_index][i];
      f_slice_now[i]=f_slice[slice_index][i];
    }
    //    printf("Values= %d %d %d\n",slice_index,i0,text_flag);
  }

  if ((text_flag>3)||(text_flag==-1)||(text_flag==-2)) {    
    n_map=slice_index;
    if (i0_slice!=i0) {
      create_map(nb_spec,n_spaxels,spaxels,npts,slice,dpix,&map_data[n_map],x_min,x_max,y_min,y_max,&tr_map[n_map],&nx_map[n_map],&ny_map[n_map]);
      map_created[n_map]=1;
      i0_slice=i0;
    }
  }


  /*
   * We plot in the desired Screen
   */

  if (spax_painted==0) {
    spax_painted=1;
  }

  //  printf("%f %f %f %f\n",x_min,x_max,y_min,y_max);

  if (new_img==0) {
    cpgslct(id);
    cpgask(0);
    if (pintados[id]<2) {
      cpgenv(x_max+0.2,x_min-0.2,y_min-0.2,y_max+0.2,1,-2);
      //max=min+(max-min)/bright;
      cpgsvp(0,1.0,0.0,1.0);
      cpgswin(x_max+0.2,x_min-0.2,y_min-0.2,y_max+0.2);
      old_p[id]=p;
      old_text_flag[id]=text_flag;
    } else {
      //max=min+(max-min)/bright;
      if ((old_p[id]!=p)||(old_text_flag[id]!=text_flag)) {
	cpgenv(x_max+0.2,x_min-0.2,y_min-0.2,y_max+0.2,1,-2);
	cpgpage();
	palette(p,0.8,0.6);
	//color_palett(p,0.8,0.6);
	pintados[id]=0;
      }
      cpgsvp(0,1.0,0.0,1.0);
      cpgswin(x_max+0.2,x_min-0.2,y_min-0.2,y_max+0.2);

    } 


    pintados[id]++;
    if (pintados[id]>3) pintados[id]=3; 
  }

  /*
   * In case of a Postscript!
   */
  if (new_img==2) {
    if (text_flag!=-2) {
      cpgsvp(0.1,0.8,0.1,0.9);
    } else {
      cpgsvp(0.1,0.8,0.1,0.9);
    }
    cpgswin(x_max+0.2,x_min-0.2,y_min-0.2,y_max+0.2);

    cpgsci(1);
    cpgbox("IBCTSVN", (x_max-x_min)/4, 5, "IBCTSVN", (y_max-y_min)/4, 5);
    cpglab("", "E", "N");
  }




  /***********************
   * with text_flag>3 we plot maps
   ***********************/
  if (text_flag>3) {    

    n_map=slice_index;
    if (i0_slice!=i0) {
      map_created[n_map]=1;
      i0_slice=i0;
    }
    tr_tmp[0]=x_min-0.5+0.2;
    tr_tmp[1]=(0.5+x_max-x_min+0.2)/nx_map[n_map];
    tr_tmp[2]=0;
    tr_tmp[3]=y_min-0.5+0.2;
    tr_tmp[4]=0;
    tr_tmp[5]=(0.5+y_max-y_min+0.2)/ny_map[n_map];
    //max=min+(max-min)/contra;
    palette(p,0.8,0.6);
    if ((nx_map[n_map]==0)||(ny_map[n_map]==0)) {
	create_map(nb_spec,n_spaxels,spaxels,npts,slice,dpix,&map_data[n_map],x_min,x_max,y_min,y_max,&tr_map[n_map],&nx_map[n_map],&ny_map[n_map]);
    }
    tr_palett(nx_map[n_map]*ny_map[n_map],map_data[n_map],&tmp_data,sign,contra,bright,min,max); 
//    printf("(%d,%d),(%d,%d)",1,nx_map[n_map],1,ny_map[n_map]);
    cpgimag(tmp_data,nx_map[n_map],ny_map[n_map],1,nx_map[n_map],1,ny_map[n_map],min,max,tr_tmp);
    cpgbox("bc",0.0,0,"bc",0.0,0); 
    if (new_img==2) {
      //      cpgwedg("RI",1.0,3.0,datamin,datamax,"flux");
      cpgwedg("RI",1.0,3.0,min,max,"flux");
      cpgsch(1.0);
    }

  } else {
    

    tr_palett(nb_spec,slice,&tmp_slice,sign,contra,bright,min,max); 

    if (text_flag!=-2) {
      
      color_palett(p,0.8,0.6);
      for (i=0;i<nb_spec;i++) {	    
	//n_colors=nc*contra;	   	    
	n_colors=nc;	   	    
	color_index=16+floor((tmp_slice[i]-min)/(max-min)*(n_colors-1));
	if (color_index>255) color_index=255;
	if (color_index<17) color_index=17;
	cpgsci(color_index);    
	for (j=0;j<n_spaxels[i];j++) {
	  x_c=spaxels[i][j].xpos;
	  y_c=spaxels[i][j].ypos;
	  grupo=groups[spaxels[i][j].group-1];
	  plot_spaxel(color_index,x_c,y_c,grupo,fill,0);
	}  
      }
    }
    
    if ((text_flag==1)||(text_flag==2)) {    
      for (i=0;i<nb_spec;i++) {	    
	for (j=0;j<n_spaxels[i];j++) {
	  x_c=spaxels[i][j].xpos;
	  y_c=spaxels[i][j].ypos;
	  grupo=groups[spaxels[i][j].group-1];
	  cpgslw(2.0);
	  plot_spaxel(1,x_c,y_c,grupo,2,0);
	  cpgslw(1.0);
	  plot_spaxel(0,x_c,y_c,grupo,2,0);
	  cpgsch(0.6);
	  if (text_flag==2) {
	    cpgsci(1);    
	    sprintf(text,"%d",i);
	    cpgptxt(x_c,y_c,0.0,0.5,text);
	  }
	  cpgsch(1.1);
	}
      }  
    }
    cpgsci(1);    

    //    printf("Done\n");
    if ((text_flag==-1)||(text_flag==-2)) { 
      n_map=slice_index;
      if (i0_slice!=i0) {
	map_created[n_map]=1;
	i0_slice=i0;
      }   
    tr_tmp[0]=x_min-0.5+0.2;
    tr_tmp[1]=(0.5+x_max-x_min+0.2)/nx_map[n_map];
    tr_tmp[2]=0;
    tr_tmp[3]=y_min-0.5+0.2;
    tr_tmp[4]=0;
    tr_tmp[5]=(0.5+y_max-y_min+0.2)/ny_map[n_map];
/*
      tr_tmp[0]=x_min-0.5;
      tr_tmp[1]=(0.5+x_max-x_min)/nx_map[n_map];
      tr_tmp[2]=0;
      tr_tmp[3]=y_min-0.5;
      tr_tmp[4]=0;
      tr_tmp[5]=(0.5+y_max-y_min)/ny_map[n_map];
*/
      for (i=0;i<n_contours;i++) {	    
		temp_float[i]=min+(max-min)/n_contours*i;
      }
      cpgslw(2);
      //      cpgsci(contours_color);   
      cpgsci(1);   
      cpgsls(5);    
      cpgcont(map_data[n_map],nx_map[n_map],ny_map[n_map],1,nx_map[n_map],1,ny_map[n_map],temp_float,n_contours,tr_tmp);
      cpgslw(1);
      cpgsls(1);    
    }




      /*
       * We plot the selected spaxels
       */
      for (k=0;k<n_i_spax;k++) {
	i=i_spax[k];
	if ((i>=0)&&(i<nb_spec)) {
	  for (j=0;j<n_spaxels[i];j++) {
	    x_c=spaxels[i][j].xpos;
	    y_c=spaxels[i][j].ypos;
	    grupo=groups[spaxels[i][j].group-1];
	    cpgslw(1.0);
	    plot_spaxel(0,x_c,y_c,grupo,3,0);
	    plot_spaxel(1,x_c,y_c,grupo,2,0);
	    cpgsch(0.6);
	    
	  }
	}
      }
    
    cpgsci(1);    





    /*
     * We plot the border levels!
     */
    if (text_flag!=-2) {
    if (new_img==2) {

      real_min=30000;
      real_max=-30000;

      for (i=0;i<nb_spec;i++) {	    
	if (tmp_slice[i]>real_max) real_max=tmp_slice[i];
	if (tmp_slice[i]<real_min) real_min=tmp_slice[i];
      }


      //n_colors=nc*contra;	   	    
      n_colors=nc;	   	    
      cpgsch(0.9);
      cpgsvp(0.85,0.9,0.1,0.9);
      cpgswin(0.0, 1.0, real_min, (1.0)*real_max);
      cpgbox("I", 1.0, 5, "IBCTSVN", floor(25*(max-min)/100), 5);
      cpglab("", "", "Flux");

      for (i=0;i<nb_spec;i++) {	    
	//n_colors=nc*contra;	   	    
	n_colors=nc;	   	    
	color_index=16+floor((tmp_slice[i]-min)/(max-min)*(n_colors-1));
	if (color_index>255) color_index=255;
	if (color_index<17) color_index=17;
	cpgsci(color_index);    
	cpgsfs(1);
	//	cpgrect(0.01,0.99,tmp_slice[i],tmp_slice[i]+0.1);
	cpgrect(0.01,0.99,slice[i],slice[i]+0.1);
      }

      /*
      for (i=0;i<100;i++) {	    
	levels[i]=min+((max-min)/100.0)*i;
      }
      tr_palett(100,levels,&tmp_levels,sign,contra,bright,min,max); 
      for (i=0;i<100;i++) {	    
	color_index=16+floor((tmp_levels[i]-min)/(max-min)*(n_colors-1));
	cpgsci(color_index);    
	cpgsfs(1);
	cpgrect(0.01,0.99,1.1*i*(max-min)/100.+min,1.1*(i+1)*(max-min)/100+min);
      }
      */    

      cpgsch(1.1);
    }
    }

  }




  if (text_flag==5) {
    /*
     * We plot all the spaxels
     */
    for (i=0;i<nb_spec;i++) {	    
      for (j=0;j<n_spaxels[i];j++) {
	x_c=spaxels[i][j].xpos;
	y_c=spaxels[i][j].ypos;
	grupo=groups[spaxels[i][j].group-1];
	cpgslw(1.0);
	//	plot_spaxel(0,x_c,y_c,grupo,3,0);
	plot_spaxel(1,x_c,y_c,grupo,2,0);
	cpgsch(0.6);
	
      }
    }
  }
  
  cpgsci(1);    


  //  printf("save=%d\n",save);

  free(slice);

  //  printf("Plot out=%f %f %d %d\n",min,max,slice_index,save);  
  sprintf(interp->result,"%f %f %d",min,max,slice_index);  
  if (save==1) {
    i_slices[slice_index][0]=i0;
    i_slices[slice_index][1]=i1;
    slice_index++;
  }
  if (slice_index>MAX_NUM_MAPS) slice_index=0;


  return TCL_OK;
}



/*********************************
 * Subroutine to create an slice
 *********************************/
static int create_slice_command(Tcl_Interp *interp, int argc, char *argv[]) {
  char *p_names[]={"grey","rainbow","heat","iraf","aips"};
  float min;
  float max;
  float old_max,old_min;
  int id,j,i,k; 
  int i0,i1,i_temp;
  float *slice;
  GROUP grupo;
  int color_index,n_colors;
  int nc=240;
  float x_c,y_c;
  int p;
  float bright,contra,sign;
  int save=0;
  int fill=1;
  int text_flag=0;
  float temp_float[200];
  char text[5];
  int new_img=0;
  float tr_tmp[]={0.0,1.0,0.0,0.0,0.0,1.0};  
  float d, vpx1, vpx2, vpy1, vpy2;

  if(argc < 3) {
    Tcl_AppendResult(interp, "create_slice i1 i2 slice_index", NULL);
    return TCL_ERROR;
  }
  
  i0=floor(atof(argv[0]));
  i1=floor(atof(argv[1]));
  slice_index=floor(atof(argv[2]));
  
  /*
  i0=atoi(argv[0]);
  i1=atoi(argv[1]);
  slice_index=atoi(argv[2]);
  */
  if (slice_index>MAX_NUM_MAPS) slice_index=0;

  if (i1<i0) {
    i_temp=i1;
    i1=i0;
    i0=i_temp;
  }
  if (i1==i0) i1=i0+1;
  /*
   * We determine the range of spectras to ask for
   */
  slice = (float *)malloc((nb_spec)*sizeof(float));
  for (i=0;i<nb_spec;i++) {
    slice[i]=0.0;
    f_slice_now[i]=0.0;  
    f_slice[slice_index][i]=0.0;
    for (j=i0;j<i1;j++) {
      slice[i]+=raw_data[j+i*npix];
      f_slice_now[i]+=raw_data[j+i*npix];
      f_slice[slice_index][i]+=raw_data[j+i*npix];
    }
    slice[i]/=(i1-i0);
    f_slice_now[i]/=(i1-i0);
    f_slice[slice_index][i]/=(i1-i0);
    //    printf("%d,Value(%d)=%f,%f\n",slice_index,i,f_slice_now[i],f_slice[slice_index][i]);
  }

  //  printf("Create_slice %d %d %d",i0,i1,slice_index);
  
  /*
   * We save the data for future
   */


  free(slice);

  i_slices[slice_index][0]=i0;
  i_slices[slice_index][1]=i1;
  sprintf(interp->result,"%d",slice_index);

  //  slice_index++;
  //if (slice_index>MAX_NUM_MAPS) slice_index=0;


  
  return TCL_OK;
}


/********************************************************************
 * This subroutine plot a line:
 * The basic paramters are:
 * dev_id colorindex lweight lstyle X_points Y_points
 ********************************************************************/
static int plot_line_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int nargc;  
  float *x,*y;
  int j;
  int dev_id,colorindex,width,style;
  nargc=2*floor(argc/2);
  if(argc != nargc) {
    Tcl_SetResult(interp, "plot_line dev_id colorindex lweight lstyle X_points Y_points: Argument Error", TCL_STATIC);
    return TCL_ERROR;
  };  
  dev_id=atoi(argv[0]);
  colorindex=atoi(argv[1]);
  //  printf("Color=%d\n",colorindex);
  width=atoi(argv[2]);
  style=atoi(argv[3]);
  nargc=(argc-4)/2;
  fflush(stdout);
  x = (float *)malloc((nargc)*sizeof(float));
  y = (float *)malloc((nargc)*sizeof(float));
  for (j=0;j<nargc;j++) {
    x[j]=atof(argv[2*j+4]);
    y[j]=atof(argv[2*j+1+4]);
  }
  cpgslct(dev_id);
  cpgsci(colorindex);
  cpgslw(width);
  cpgsls(style);
  cpgline(nargc,x,y);
  cpgsls(1);
  cpgsci(1);
  cpgslw(1);
  free(x);
  free(y);
  return TCL_OK;
}

/*********************************************************************
 * Function that draws a messsage in a certain window
 * 
 *********************************************************************/
static int message_command(Tcl_Interp *interp, int argc, char *argv[]) {
  display_message(atoi(argv[0]),argv[1]);
  //  sprintf(interp->result,"He pintado en la ventana %d",atoi(argv[0]));
  return TCL_OK;
}

/*********************************************************************
 * Function that close a device
 *********************************************************************/

static int close_device_command(Tcl_Interp *interp, int argc, char *argv[]) {
  close_device(atoi(argv[0]));
  return TCL_OK;
}



/*********************************************************************
 * Function that stats the start_server
 *********************************************************************/

static int start_server_command(Tcl_Interp *interp, int argc, char *argv[]) {  
  int alive=0;
  pid_t child;
  
  alive=ask_alive();
  //  printf("Alive=%d",alive);
  if (alive==1) {
    printf("Starting the server...\n");
    server_started=1;
    if ((child=fork())==-1) {    
    } else if (child == 0 ) {
      server();
    }
  } else {
    printf("The server was already running...\n");
  }
 
  return TCL_OK;
}
/*******************************************************
 * Stop the SERVER
 *******************************************************/

static int stop_server_command(Tcl_Interp *interp, int argc, char *argv[]) {  
  int *flag;
  int tmp_address;
  int mem_key,n_bytes;
  flag = (int *)malloc(15*sizeof(int));
  ask_delete_shm();
  flag[0]=666;
  mem_key=3;
  n_bytes=15;
  load_mem_int(flag,mem_key,n_bytes,&tmp_address);
  return TCL_OK;
}

/*******************************************************
 * Clean the SERVER
 *******************************************************/

static int clean_server_command(Tcl_Interp *interp, int argc, char *argv[]) {  
  int *flag;
  int tmp_address;
  int mem_key,n_bytes;
  flag = (int *)malloc(15*sizeof(int));
  ask_delete_shm();
  return TCL_OK;
}
/*******************************************************
 * Load a new e3d file in the server.
 *******************************************************/
static int save_file_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int i,j;
  char text[80];
  E3D_file e3d_tmp;
  SPECTRUM signal,noise;
  SPAXEL spax;

  if(argc < 1 ) {
    Tcl_AppendResult(interp, "save_file filename", NULL);
    return TCL_ERROR;
  }
  strcpy(text,argv[0]);
  printf("Saving file %s...\n",text);
  //  e3d_tmp=e3d_image;
  create_E3D_frame(&e3d_tmp,text,npix,(double)start_w,(double)delta_w,FLOAT,"save",NULL);
  for (i=0;i<nb_spec;i++) {    
    //    printf("i=%d\n",i);
    init_new_E3D_spec(&e3d_tmp,&signal,npix,start_w);
    for (j=0;j<signal.npts;j++) {
      WR_spec(&signal,j,raw_data[j+i*npix]); 
    }
    put_E3D_spec(&e3d_tmp,&signal,NULL,i+1);
    /*
     *
     */
    for (j=0;j<n_spaxels[i];j++) {
      spax.specId=spaxels[i][j].specId;
      spax.group=spaxels[i][j].group;
      spax.xpos=spaxels[i][j].xpos;
      spax.ypos=spaxels[i][j].ypos;
      put_E3D_spaxels(&e3d_tmp,i+1,1,&spax);    
    }
  }
  e3d_tmp.ngroups = e3d_image.ngroups;
  //  frame->groups = (GROUP *)malloc(1*sizeof(GROUP));
  //frame->groups[0]=grupo;
  e3d_tmp.groups=e3d_image.groups;
  close_E3D_frame(&e3d_tmp);

  return TCL_OK;
}


/*******************************************************
 * Load a new e3d file in the server.
 *******************************************************/
static int load_file_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int i,j;
  printf("loading file...\n");


  for (i=0;i<MAX_NUM_MAPS;i++) {
    //int map_created[MAX_NUM_MAPS];
    map_created[i]=0;
  }

  if (server_started==1) {
    printf("Using the SHM\n");
    if (strcmp(argv[0],"SHM")!=0) {
      ask_load_e3d(argv[0]); // In other case the file is already in the SHM
    }
    printf("ok\n");
    printf("reading from SHM...\n");
    ask_e3d_info(&e3d_image,&n_spaxels,&spaxels,&index_start,&npts,&groups);
    start_w=e3d_image.common_parameters[0];
    end_w=e3d_image.common_parameters[1];
    npix=e3d_image.common_parameters[2];
    delta_w=(end_w-start_w)/npix;
    nb_spec=e3d_image.nbspec;
    n_groups=e3d_image.ngroups;
    i_spax = (int *)malloc((nb_spec+1)*sizeof(int));
    raw_data = (float *)malloc((nb_spec+1)*npix*sizeof(float));
    for (j=0;j<MAX_NUM_OBJ;j++) {
      j_spax[j] = (int *)malloc((nb_spec+1)*sizeof(int));
      n_j_spax[j]=0;
    }
    ask_raw_data(&raw_data,nb_spec,npix,delta_n);
  } else {
    printf("Reading directly the FILE\n");
    load_e3d(argv[0],&e3d_image,&n_spaxels, &spaxels, &index_start, &npts, &raw_data, &raw_noise);
    groups=e3d_image.groups;
    start_w=e3d_image.common_parameters[0];
    end_w=e3d_image.common_parameters[1];
    npix=e3d_image.common_parameters[2];
    delta_w=(end_w-start_w)/npix;
    nb_spec=e3d_image.nbspec;
    n_groups=e3d_image.ngroups;
    i_spax = (int *)malloc((nb_spec+1)*sizeof(int));
    for (j=0;j<MAX_NUM_OBJ;j++) {
      j_spax[j] = (int *)malloc((nb_spec+1)*sizeof(int));
      n_j_spax[j]=0;
    }
  }
     
  datamin=3000000.0;
  datamax=-3000000.0;
  for (j=0;j<npix*nb_spec;j++) {
    if (datamin>raw_data[j]) 
      datamin=raw_data[j];
    if (datamax<raw_data[j]) 
      datamax=raw_data[j];
  }	      	 
  printf("ok\n");
  printf("Determining the spatial range\n");
  x_min=10000;
  y_min=10000;
  x_max=-10000;
  y_max=-10000;
  
  for (i=0;i<nb_spec;i++) {	 
    i_spax[i]=i;
    for (j=0;j<n_spaxels[i];j++) {
      if (x_min>spaxels[i][j].xpos) x_min=spaxels[i][j].xpos;
      if (x_max<spaxels[i][j].xpos) x_max=spaxels[i][j].xpos;
      if (y_min>spaxels[i][j].ypos) y_min=spaxels[i][j].ypos;
      if (y_max<spaxels[i][j].ypos) y_max=spaxels[i][j].ypos;
    }
  }


  /*
   * Cleaning the previous objects selection
   */

  for (j=0;j<MAX_NUM_OBJ;j++) {
    n_j_spax[j]=0;
  }

  /*
   * DAR
   */
  if (loaded==1) {
    free(dars);
  }
  dars = (struct DAR *)malloc(n_groups*sizeof(struct DAR));  

  loaded=1;
  spax_painted=0;

  /*
   * Cleaning variables... a lot to include!!!! (16.05.03)
   */ 
  for (i=0;i<n_pintados;i++) {
    pintados[i]=0;
  }


  f_slice_now = (float *)malloc((nb_spec)*sizeof(float));
  for (i=0;i<MAX_NUM_MAPS;i++) {
    f_slice[i] = (float *)malloc((nb_spec)*sizeof(float));
  }


  npix_w1=0;
  npix_w2=npix;

  return TCL_OK;
}

/*******************************************************
 * Draw Staked Spectra Image
 * The parameters to pass are:
 * 
 *******************************************************/
static int draw_raw_command(Tcl_Interp *interp, int argc, char *argv[]) {
  char *p_names[]={"grey","rainbow","heat","iraf","aips"};
  float min;
  float max;
  int id; 
  int p;
  float contra; 
  float bright; 
  float sign;
  int result;
  int *naxes;
  int j,i;
  float *out;
  int clean=0;
  char wave[8];
  float lw;
  int nlw;
  float local_min,local_max;

  if(argc < 3 || *argv[1] == '-') {
    Tcl_AppendResult(interp, "use: Command min max device clean palette bright contra sign", NULL);
    return TCL_ERROR;
  }

  min=atof(argv[0]);
  max=atof(argv[1]);
  id=atoi(argv[2]);
  clean=atoi(argv[3]);
  if (argc>4) {  
    bright=atof(argv[5]);
    contra=atof(argv[6]);
    sign=atof(argv[7]);
    for (j=0;j<5;j++) {
      if (strstr(p_names[j],argv[4])) p=j+1;
    }
  } else {
    bright=0.5;
    contra=0.7;
    p=2;
  }



  out = (float *)malloc(2*sizeof(float));
  if (min==0.0) min=datamin;
  if (max==0.0) max=datamax;  
  cpgslct(id);
  cpgask(0);

  if (old_p[id]!=p) pintados[id]=0;

  if (pintados[id]<2) {
    cpgvstd(); 
    cpgsch(1.2);
    cpgenv(1.0+npix_w1,npix_w2+1.0,1.0,nb_spec+1.0,0,-1);    
    for (j=0;j<6;j++) {
      lw=start_w+npix_w1*delta_w+((npix_w2-npix_w1)*delta_w)*j/5;      
      sprintf(wave,"%d",(int)lw);
      cpgptxt((((float)(npix_w2-npix_w1))/5)*j+(float)npix_w1,(-1)*(nb_spec/20),0.0,0.5,wave);
    }
    old_p[id]=p;
  } 
  cpgsch(1.4);
  pintados[id]++;
  if (pintados[id]>3) pintados[id]=3; 
  /*
  local_min=min;
  local_max=min+(max-min)/bright;
  local_max=local_min+(local_max-local_min)/contra;
  */
  local_min=min;
  local_max=max;
  tr_palett(npix*nb_spec,raw_data,&tmp_data,sign,contra,bright,min,max); 
  cpgimag(tmp_data,npix,nb_spec,1+npix_w1,npix_w2,1,nb_spec,min,max,tr);
   
  sprintf(interp->result,"%d %d %f %f",npix,nb_spec,min,max);
  return TCL_OK;
}






/**************************************************************
 * To Change the Palette
 **************************************************************/
static int recolor_image_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int p;
  char *p_names[]={"grey","rainbow","heat","iraf","aips"};
  int j;
  int dev_id;
  float bright,contra,sign;
  char commands[80];

  if(argc < 2) {
    Tcl_SetResult(interp, "recolor_image: Wrong number of arguments.", TCL_STATIC);
    return TCL_ERROR;
  };  

  dev_id=atoi(argv[1]);
  bright=atof(argv[2]);
  contra=atof(argv[3]);
  sign=atof(argv[4]);

  for (j=0;j<5;j++) {
    if (strstr(p_names[j],argv[0])) p=j+1;
  }
  sprintf(commands,"%d %f %f %f %d",p,bright,contra,sign,dev_id);
  cpgslct(dev_id);
  palette(p,0.8,0.6);

    return TCL_OK;
}

/**************************************************************
 * Draw Staked via Server
 **************************************************************/
static int bad_draw_raw_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int dev_id;
  char commands[80];
  if(argc < 1) {
    Tcl_SetResult(interp, "draw_raw DEV_ID, wrong number of ARG", TCL_STATIC);
    return TCL_ERROR;
  };  

  dev_id=atoi(argv[0]);
  cpgslct(dev_id);
  sprintf(commands,"%d",dev_id);
  printf("********START DRAW*******\n");

  dev_id=cpgopen("/xwin");
  cpgslct(dev_id);
  ask_draw_raw(commands);
  cpgclos();

  printf("********END DRAW*******\n");
  return TCL_OK;
}


/**************************************************************
 * Ask for the Intensity in a certain point
 **************************************************************/
static int intensity_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int x;
  int y;
  int nx;
  int ny;
  float intensity;
  if(argc < 4) {
    Tcl_SetResult(interp, "intensity x y nx ny , wrong number of ARG", TCL_STATIC);
    return TCL_ERROR;
  };  

  x=floor(atof(argv[0]));
  y=floor(atof(argv[1]));
  nx=atoi(argv[2]);
  ny=atoi(argv[3]);
  
  if ((x>=0)&&(x<npix)&&(y>=0)&&(y<nb_spec)) {
    intensity=raw_data[x+y*npix];
  } else {
    intensity=0.0;
  }
  sprintf(interp->result,"%f",intensity);
  return TCL_OK;
}


/**************************************************************
 * Open a Device via the Server
 **************************************************************/
static int open_device_command(Tcl_Interp *interp, int argc, char *argv[]) {
  int dev_id;
  if(argc < 1) {
    Tcl_SetResult(interp, "OPEN_DEVICE DEVICE, wrong number of ARG", TCL_STATIC);
    return TCL_ERROR;
  };  
  dev_id=open_device(interp,argv[0]);
  sprintf(interp->result,"%d",dev_id);
  return TCL_OK;
}

/*************************************************
 * Asking for Basic E3D Parameters
 *************************************************/

static int ask_e3d_info_command(Tcl_Interp *interp, int argc, char *argv[]) {
  sprintf(interp->result,"%d %d %f %f %f %d %f %f",npix,nb_spec,start_w,end_w,delta_w,n_groups,datamin,datamax);
  return TCL_OK;
}

/*************************************************
 * Small function to determine the maxmin 
 * for the Bright and Constrast determination
 ************************************************/
static int bc_command(Tcl_Interp *interp, int argc, char *argv[]) {
  float x,y;
  if(argc < 1) {
    Tcl_SetResult(interp, "bc x, wrong number of ARG", TCL_STATIC);
    return TCL_ERROR;
  };  

  x=atof(argv[0]);
  y=Maximun(0,Minimun(1,x));

  sprintf(interp->result,"%f",y);
  return TCL_OK;
}






