/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  2002 AIP, Potsdam, Germany
! IDENT        pmas2Euro3D.c
! LANGUAGE     C
! AUTHOR       S.F.Sanchez
! KEYWORDS     
! PURPOSE      Facility to transform INTEGRAL reduced data to Euro3D data format.
! COMMENT      No GROUP information included. No header data properly copied
! VERSION      0.1  2002-Dec-17 : Creation, SF.
------------------------------------------------------------------------------*/

#include <IFU_io.h>

#include "stats.h"

/*-----------------------------------------------------------------------------
!
!.blk            Transform the INTEGRAL reduced data to Euro3D data: No GROUP info included.
!
!.prog                             pmas2Euro3D()
!
!.purp         Facility to transform INTEGRAL reduced data to Euro3D data format.
!
-----------------------------------------------------------------------------*/

#define NB_SPEC 256
#define NPIX 1024




int set_pmas_group(E3D_file *frame, GROUP grupo)
{
         frame->ngroups = 1;
         frame->groups = (GROUP *)malloc(1*sizeof(GROUP));
	 frame->groups[0]=grupo;
}





main(int argc, char **argv)
{




  FILE *fichero;
  int count_fit=0;
  int *spax_id,*type_id;
  float *spax_x,*spax_y;
  float temp_float;
  char text[80];

  char *temp_text;

  int type_save=-1;
  int nueva_cuenta=0;

  float g_angle=0;

  /*
    GROUPS
  */
  GROUP grupo, *grupos;
  int n_grupos;
  
  /*
    SPAXELS
  */
  SPAXEL spax, *spaxels;


  
	E3D_file e3d_image;
	SPECTRUM signal,noise;
	SLICE s_signal;
	IMAGE2D image;
	char **argval, **arglabel;

	int nbal;

	short s_temp[10];
	int i_temp[10];
	float f_temp[10];
	double d_temp[10];
	char str_temp[80];


	//double *data;
	float *data;

	/*
	  All the images has an initial BITPIX.
	  It will be stored in this initial BITPIX,
	  but the data will be internally managed as DOUBLE
	  not to reduce the precision on none of them.
	*/
	short bitpix; // Variable that stores the initial BITPIX value.
	




	/* Euro3D variables */
	int specId, i,j,k, npix=NPIX, nb_spec, status, *nol;
	float start=0.0;
	float step=1.0;
	short sval;
	long lval;
	float fval, *x,*y;
	double dval;
	//	float fval;

	/* INTEGRAL image variables */

	int i_p,j_p, npix_p[2];
	double start_p[2],step_p[2];
	short sval_p;
	long lval_p;
	float fval_p;
	double dval_p;


	double rotang;

	double airmass;
	double parang;
	double pressure;
	double temperature;

	
	float size_x=1.0;
	float size_y=1.0;	
	char shape[20];

	/* General variables */

	char input_filename[80], output_filename[80], author[80], origin[80];
	char position_file[80];
	char ref[80],date[80],date_obs[80],object[80],observer[80],telescope[80];
	float equinox;
	int error=0;

	start_p[0]=1; start_p[1]=1;
	step_p[0]=1; step_p[1]=1;

	//	npix[0]=1024;
	

	/* Read a INTEGRAL file header */

	

	set_arglist("-if|inputfile none -of|outputfile outputfile -pf SB1.dat -au|author sanchez -or|origin AIP -ref|reference void -nb_spec 1 -type 1 -rotang 0");
	printf("INTEGRAL to Euro3D:\n\n");
	init_session(argv,argc,&arglabel,&argval);

	set_control_level(WARNING);
	
	for (i=0; i<9; i++) {
	  if ((strstr(arglabel[i],"-if"))||(strstr(arglabel[i],"-inputfile"))) {
	    strcpy(input_filename,argval[i]);
	  }
	  if (strstr(arglabel[i],"-pf")) {
	    strcpy(position_file,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-of"))||(strstr(arglabel[i],"-outfile"))) {
	    strcpy(output_filename,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-au"))||(strstr(arglabel[i],"-author"))) {
	    strcpy(author,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-or"))||(strstr(arglabel[i],"-origin"))) {
	    strcpy(origin,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-ref"))||(strstr(arglabel[i],"-reference"))) {
	    strcpy(ref,argval[i]);
	  }
	  if (strstr(arglabel[i],"-type")) {
	    type_save=atoi(argval[i]);
	  }
	  if (strstr(arglabel[i],"-nb_spec")) {
	    nb_spec=atoi(argval[i]);
	  }
	  if (strstr(arglabel[i],"-rotang")) {
	    rotang=(double)atof(argval[i]);
	  }
	}


	/*
	 * We read the position table
	 */

	type_id = (int *)malloc((nb_spec)*sizeof(int));  	
	spax_id = (int *)malloc((nb_spec)*sizeof(int));  	
	spax_x = (float *)malloc((nb_spec)*sizeof(float));  	
	spax_y = (float *)malloc((nb_spec)*sizeof(float));  	

	printf("Opening the position table file\n");
	if ((fichero=fopen(position_file,"r"))==NULL) {
	  printf("Error opening file: %s\n",position_file);
	} else {
	  
	  fscanf(fichero, "%s", &str_temp);
	  strcpy(shape,str_temp);
	  fscanf(fichero, "%f", &size_x);
	  fscanf(fichero, "%f", &size_y);
	  fscanf(fichero, "%f", &g_angle);

	  printf("%s, %f %f\n",str_temp,size_x,size_y);

	  j=0;
	  count_fit=0;
	  while( fscanf(fichero, "%f", &temp_float) != EOF){
	    
	    if (j>3) {
	      j=0;
	      printf("%d, %f %f %d\n",spax_id[count_fit],spax_x[count_fit],spax_y[count_fit],type_id[count_fit]);
	      count_fit++;
	    }
	    
	    if(j==0) {
	      spax_id[count_fit]=floor(temp_float);
	    }
	    if(j==1) {
	      spax_x[count_fit]=temp_float;
	    }
	    if(j==2) {
		spax_y[count_fit]=temp_float;
	    }
	    if(j==3) {
		type_id[count_fit]=floor(temp_float);
	    }
	    j++;
	  } 	 

	}

	//	printf("NB_SPEC=%d, %d\n",count_fit,spax_id[count_fit]);

	if (count_fit!=nb_spec) {
	  printf("Warning, values dues not match!!!!\n NB_SPEC=%d, Counted in PF=%d\n",nb_spec,count_fit);
	}
	//	nb_spec=count_fit;

	
	printf("Ok\n");	


	/*
	  We open the file to read the headers
	*/

	printf("Opening the file %s\n",input_filename);
	fflush(stdout);
	open_frame(&image,input_filename,"I");
	printf("Ok\n");
	fflush(stdout);

	/*
	  We read some of the header information
	*/

	printf("Reading Header information\n");
	fflush(stdout);


        fflush(stdout);
        if(!RD_desc(&image,"BITPIX",SHORT,1,s_temp)) {
          printf("No BITPIX definied, error\n");
          exit_session(0);
          return(0);
        }
        bitpix=s_temp[0];


	printf("Paso");
	fflush(stdout);

       if(!RD_desc(&image,"CRVAL1",DOUBLE,1,d_temp)) {
          printf("No CRVAL0 definied, error\n");
          exit_session(0);
          return(0);
        } else {
          start= (float)d_temp[0];
        }

        printf("Start=%g\n",start);

        if(!RD_desc(&image,"CD1_1",DOUBLE,1,d_temp)) {
          printf("No CRDELT0 definied, error\n");
          exit_session(0);
          return(0);

        } else {
        step= (float) d_temp[0];
        }



        if(!RD_desc(&image,"CDELT1",DOUBLE,1,d_temp)) {
          printf("No CRDELT1 definied, error\n");
          exit_session(0);
          return(0);

        } else {
        step=d_temp[0];
        }

        printf("Step=%g\n",step);

	if(!RD_desc(&image,"NAXIS1",INT,1,i_temp)) {
	  printf("No NAXIS1 definied, error\n");
	  exit_session(0);
	  return(0);
	}
	npix_p[0]=i_temp[0];

	if(!RD_desc(&image,"NAXIS2",INT,1,i_temp)) {
	  printf("No NAXIS2 definied, error\n");
	  exit_session(0);
	  return(0);
	}
	npix_p[1]=i_temp[0];

	if(!RD_desc(&image,"DATE",CHAR,80,str_temp)) {
	  printf("No DATE definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(date,str_temp);

	if(!RD_desc(&image,"DATE-OBS",CHAR,80,str_temp)) {
	  printf("No DATE-OBS definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(date_obs,str_temp);

	if(!RD_desc(&image,"HIERARCH CAHA TEL POS SET EQUINOX",FLOAT,1,f_temp)) {
	  printf("No EQUINOX definied, error\n");
	  exit_session(0);
	  return(0);
	}
	equinox=f_temp[0];

	if(!RD_desc(&image,"OBJECT",CHAR,80,str_temp)) {
	  printf("No OBJECT definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(object,str_temp);

	if(!RD_desc(&image,"OBSERVER",CHAR,80,str_temp)) {
	  printf("No OBSERVER definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(observer,str_temp);

	if(!RD_desc(&image,"TELESCOP",CHAR,80,str_temp)) {
	  printf("No TELESCOPE definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(telescope,str_temp);


	if(!RD_desc(&image,"AIRMASS",DOUBLE,1,d_temp)) {
	  printf("No AIRMASS definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  airmass=d_temp[0];
	}

	if(!RD_desc(&image,"HIERARCH CAHA GEN AMBI PRES",DOUBLE,1,d_temp)) {
	  printf("No PRESSURE definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  pressure=d_temp[0];
	}

	if(!RD_desc(&image,"HIERARCH CAHA GEN AMBI TEMP",DOUBLE,1,d_temp)) {
	  printf("No TEMPERATURE definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  temperature=d_temp[0];
	}

	if(!RD_desc(&image,"PRES",DOUBLE,1,d_temp)) {
	  printf("No PRES definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  pressure=d_temp[0];
	}

	if(!RD_desc(&image,"TEMP",DOUBLE,1,d_temp)) {
	  printf("No TEMP defined, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  temperature=d_temp[0];
	}


	if(!RD_desc(&image,"PARANGLE",DOUBLE,1,d_temp)) {
	  printf("No PARANGLE definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  parang=d_temp[0];
	}

/*
	if(!RD_desc(&image,"ROTSKYPA",DOUBLE,1,d_temp)) {
	  printf("No ROTSKYPA definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  rotang=d_temp[0];
	}
	parang=parang-rotang;
*/
	printf("ROT=%g\n",rotang);


	printf("Ok\n");
	fflush(stdout);

	printf("Reading INTEGRAL image data\n");
	fflush(stdout);
	/*
	  We read the data from the image.
	*/
	printf("[nx,ny]=%d,%d\n",npix_p[0],npix_p[1]);

	//data = (double *)malloc((npix_p[0]*npix_p[1])*sizeof(double));  
	data = (float *)malloc((npix_p[0]*npix_p[1])*sizeof(float));  
	for (j=0;j<image.ny;j++) {
	  for (i=0;i<image.nx;i++) {
	    dval = RD_frame(&image,i,j);
	    //fval = (1e18)*dval;
	    data[i+j*image.nx] = (1.0)*dval;
//	      data[i+j*image.nx] = (float)
//	    printf("%f %g\n",data[i+j*image.nx],dval);
	  }
	}
	printf("Ok\n");
	fflush(stdout);
	close_frame(&image);



	/*
	  Creating the single INTEGRAL GROUP
	*/

	//	size_x=2.35;
	//size_y=2.35;
	printf("group1 = %s ",shape);
	printf("%f %f \n",size_x,size_y);


	grupo.groupId=1;
	grupo.size1=1.0*size_x; 
	grupo.size2=1.0*size_y;
	grupo.shape=shape[0];
	grupo.angle=g_angle;
	grupo.poswav=(float)start;
	grupo.airmass=(float)airmass;
	grupo.parang=(float)parang;
	grupo.pressure=(float)pressure;
	grupo.temperature=(float)temperature;


	/*
	  Creating the spatial structure of the INTEGRAL data
	  NOTE: By now the relative positions of the fibers
	  are arbitrary (?), they are so called instrumental
	  We assume an square distribution...
	*/



	i=1;
	k=1;
	//	nb_spec=npix_p[1];
	nb_spec=count_fit+1;
	nol = (int *)malloc(nb_spec*sizeof(int));  
	x = (float *)malloc(nb_spec*sizeof(float));  
	y = (float *)malloc(nb_spec*sizeof(float));  
	for (j=0;j<nb_spec;j++) {
	  nol[j]=spax_id[j];
	  x[j]=spax_x[j];
	  y[j]=spax_y[j];
	  //	  printf("[%d]=%f,%f\n",j,spax_x[j],spax_y[j]);
	  i++;
	  if (i>sqrt(nb_spec)) {
	    i=1;
	    k++;
	  }
	}


	npix_p[1]=nb_spec;
	/*
	  We create now the new Euro3D image and same the data.
	*/
	printf("Opening the Euro3D image\n");
	fflush(stdout);
	create_E3D_frame(&e3d_image,output_filename,npix_p[0],start,step,FLOAT,"test",NULL);
	printf("Ok\n");	

	


//	set_ID_and_coordinates(&e3d_image,"XPOS","YPOS",nb_spec,nol,x,y);	
//	set_ID_and_coordinates(&e3d_image,nb_spec,nol,x,y);	
	printf("Writing into created Euro3D file ...");
	fflush(stdout);
	
	printf("\n NPIX_P=%d, NCUENTA=%d\n",npix_p[1],nueva_cuenta);

	
	for (specId=1;specId<=npix_p[1];specId++) {
//	    printf("specId=%d,type=%d,%d,%d\n",specId,type_save,type_id[specId-1],nueva_cuenta);
	  if ((type_save==-1)||(type_save==type_id[specId-1])) {

	    nueva_cuenta++;
	    init_new_E3D_spec(&e3d_image,&signal,npix_p[0],start); 
	    /*
	      SPAXELS
	    */
	    spax.specId=nueva_cuenta;
	    spax.group=1;
	    spax.xpos=x[specId-1]*cos(rotang*.01745327)-y[specId-1]*sin(rotang*.01745327);
	    spax.ypos=y[specId-1]*cos(rotang*.01745327)+x[specId-1]*sin(rotang*.01745327);


	    for (j=0;j<signal.npts;j++) {
	      
		WR_spec(&signal,j,(double)data[j+(specId-1)*npix_p[0]]);
		WR_spec(&signal,j,data[j+(specId-1)*npix_p[0]]);

	    }
	    
	    put_E3D_spec(&e3d_image,&signal,NULL,nueva_cuenta);
	    put_E3D_spaxels(&e3d_image,nueva_cuenta,1,&spax);
	  }
	}
	printf("N_COUNT=%d, Ok\n",nueva_cuenta);
	/*
	  Writting the GROUPS information 
	*/
	printf("****We assume HIERARCH CAHA ADA POSANG to be the paralactic angle*********\n");
	printf("Writting the GROUPS information\n");
	
	
	set_pmas_group(&e3d_image,grupo);

	printf("NGROUPS=%d\n",e3d_image.ngroups);
	


	printf("Saving created Euro3D file ...");
	fflush(stdout);



	close_E3D_frame(&e3d_image);

	printf("Ok\n");

	/*
	  Reading the saved data on the output file...
	*/


	printf("Checking the saved image: %s\n",output_filename);
	fflush(stdout);
	open_E3D_frame(&e3d_image,output_filename,"I");
	printf("Ok\n");

	get_spectra_ID(&e3d_image,nol);
	printf("Reading Euro3D values spectrum by spectrum and Spaxels...");
	fflush(stdout);
	npix_p[1]=nueva_cuenta;
	
	for (specId=1;specId<=npix_p[1];specId++) {
	  
		get_E3D_spec(&e3d_image,&signal,NULL,nol[specId-1]); 
		for (j=0;j<signal.npts;j++) {
		  if (RD_spec(&signal,j)!=data[j+(specId-1)*npix_p[0]])
		    error=1;
		}
		
		
		status=get_E3D_spaxels(&e3d_image,specId,&spaxels);
		if (spaxels[0].specId!=specId) error=2;
		if (spaxels[0].group!=1) error=3;
		if (spaxels[0].xpos!=x[specId-1]) error=4;
		if (spaxels[0].ypos!=y[specId-1]) error=5;

	}
	if (error==0) {
	  printf("Ok\n");
	} else {
	  printf("\n***** THE EURO3D FILES DOES NOT MATCH THE ORIGINAL FILE *******\n");
	  printf("ERROR=%d\n",error);
	  printf("******\n");
	}

	/* Testing the groups */

	printf("NBSPEC=%d\n",e3d_image.nbspec);

	printf("NGROUPS=%d\n",e3d_image.ngroups);
	printf("TYPE=%c\n",e3d_image.groups[0].shape);
	printf("SIZE1=%f\n",	e3d_image.groups[0].size1); 
	printf("SIZE2=%f\n",	e3d_image.groups[0].size2); 
	printf("airmass=%f\n",	e3d_image.groups[0].airmass); 

	printf("closing previous datacube ...\n");
	fflush(stdout);
	close_E3D_frame(&e3d_image);

	free(data);
	exit_session(0);
	return(0);

	
}



