/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  2002 AIP, Potsdam, Germany
! IDENT        pmas2Euro3D.c
! LANGUAGE     C
! AUTHOR       S.F.Sanchez
! KEYWORDS     
! PURPOSE      Facility to Visualize Euro3D data
! COMMENT      1st prototype
! VERSION      0.1  2002-Dec-17 : Creation, SF.
------------------------------------------------------------------------------*/

#include <stdio.h> //For Standard I/O
#include <stdlib.h> //For Functions like ATOI
#include <ctype.h> //For Type check
#include <string.h> //For String manipulation
#include <math.h> //For Math functions
#include <IFU_io.h> //For Lyon I/O Library
#include <data_io.h> //For Lyon I/O data

/*
 To use PGPLOT
 */

#include <cpgplot.h> // PGPLOT


//#include <ncarg/ngmath.h>

//#include "stats.h"



/*-----------------------------------------------------------------------------
!
!.blk          Reads an Euro3D data file and plot a raw frame
!
!.prog                             VEuro3D()
!
!.purp         Facility to Visualize Euro3D data
!
-----------------------------------------------------------------------------*/

#define NB_SPEC 256
#define NPIX 1024

void main(int argc, char **argv);
void imageplot(float* data,float datamin, float datamax, int l_naxes[2],int id, char *title);
void specplot(float* data, float datamin, float datamax, int npix, float start_w, float delta_w);
void setvp(void);
float minimun(float a, float b);
float maximun(float a, float b);
void palett(int type, float contra, float bright);
void fiddle(int l_naxes[2], char* ch, int* real_x, int* real_y, int old_x, int old_y);

int id1,id2,id3,id4;
int id_w;
int p=2;
float contra=0.8;
float bright=0.4;
float sign=1.0;
int mode=0;


int set_pmas_group(E3D_file *frame, GROUP grupo)
{
         frame->ngroups = 1;
         frame->groups = (GROUP *)malloc(1*sizeof(GROUP));
	 frame->groups[0]=grupo;
}



int get_group(E3D_file *frame, GROUP *grupo, int j)
{
  //  printf("%d %d %d\n",frame->ngroups,j,frame->ngroups);
  if ((frame->ngroups!=0)&&(j<=frame->ngroups)) {
	 grupo->groupId=frame->groups[j].groupId;
	 grupo->shape=frame->groups[j].shape;
	 grupo->size1=frame->groups[j].size1;
	 grupo->size2=frame->groups[j].size2;
	 grupo->angle=frame->groups[j].angle;
	 grupo->poswav=frame->groups[j].poswav;
	 grupo->parang=frame->groups[j].parang;
	 grupo->pressure=frame->groups[j].pressure;
	 grupo->temperature=frame->groups[j].temperature;
  } else {
    	grupo->groupId=1;
	grupo->shape='S';
	grupo->size1=50; //miliArcseconds?
	grupo->size2=50; //miliArcseconds??
	grupo->angle=0;
	grupo->poswav=0.0;
	grupo->airmass=1.0;
	grupo->parang=0.0;
	grupo->pressure=700;
	grupo->temperature=30;
  }
  return(0);
}


void plot_spaxels(int color_index,float x_c, float y_c, GROUP group) {
  //  float x_c,y_c;
  int j,i;
  float angle;
  float size1,size2;
  char shape;

//  size1=(float)group.size1/100.0;
//  size2=(float)group.size2/100.0;

 size1=(float)group.size1;
  size2=(float)group.size2;

  if (size1==0.0) size1=0.5;

    printf("%f, %f, %f,%f\n",x_c,y_c,size1,size2);
  angle=((float)group.angle)/180*3.14159;

  cpgsci(color_index);
  shape=toupper(group.shape);
  //printf("%d %d\n",shape,group.shape);
  if (shape==1075052544) {
    shape=83;
  }
  switch(shape) {
  case(83): {
    if (angle==0.0) {
      cpgrect(x_c-size1/2,x_c+size1/2,y_c-size1/2,y_c+size1/2);
    } else {
      float xp[4],yp[4];
      float x[4],y[4];
      xp[0]=-size1; yp[0]=-size1;
      xp[1]=size1; yp[1]=-size1;
      xp[2]=size1; yp[2]=size1;
      xp[3]=-size1; yp[3]=size1;
      for (i=0;i<4;i++) {
	x[i]=x_c+xp[i]*cos(angle)-yp[i]*sin(angle);
	y[i]=y_c+xp[i]*sin(angle)+yp[i]*cos(angle);
      }
      cpgpoly(4,x,y);
    }
    break;
  }
  case('R'): {      
      if (angle==0.0) {
	cpgrect(x_c-size1/2,x_c+size1/2,y_c-size2/2,y_c+size2/2);
      } else {
	float xp[4],yp[4];
	float x[4],y[4];
	xp[0]=-size1; yp[0]=-size2;
	xp[1]=size1; yp[1]=-size2;
	xp[2]=size1; yp[2]=size2;
	xp[3]=-size1; yp[3]=size2;
	for (i=0;i<4;i++) {
	  x[i]=x_c+xp[i]*cos(angle)-yp[i]*sin(angle);
	  y[i]=y_c+xp[i]*sin(angle)+yp[i]*cos(angle);
	}
	cpgpoly(4,x,y);
      }
      break;
  }
  case('C'): {
      cpgcirc(x_c,y_c,size1);
      break;
  }
  default: {
    //      cpgrect(x_c-size1/2,x_c+size1/2,y_c-size1/2,y_c+size1/2);
          cpgcirc(x_c,y_c,size1/2);
    break;
  }
  }
  
  
  
    //    cpgrect(x_c-size1/2,x_c+size1/2,y_c-size1/2,y_c+size1/2);
}




void main(int argc, char **argv)
{
  int window_size;
  float window_aspect;

  int n_colors,nc=200,color_index;
  float x_c,y_c;
  float size1=0.5,size2;


  GROUP group, *groups, fake_group;
  GROUP grupo;
  int n_groups;

  SPAXEL *spax, **spaxels;  
  int *n_spaxels;

  float x_min,y_min,x_max,y_max;

  
	E3D_file e3d_image;
	SPECTRUM signal,noise;
	SPECTRUM *spectra;
	SLICE s_signal;
	IMAGE2D image;
	char **argval, **arglabel;
	int nbal;

	short s_temp[10];
	int i_temp[10];
	float f_temp[10];
	float d_temp[10];
	char str_temp[80];
	char c_temp[10];

	float *raw_data;
	float *raw_noise;
	float *tmp_data;
	float *raw_spec;
	float *false_data;



	
	/*
	  All the images has an initial BITPIX.
	  It will be stored in this initial BITPIX,
	  but the data will be internally managed as FLOAT
	  not to reduce the precision on none of them.
	*/
	short bitpix; // Variable that stores the initial BITPIX value.
	char euro3d;

	/* Euro3D variables */
	int specId, i,j,k, npix, nb_spec, in_nb_spec,status, *nol, nfib;
	float start, step;
	short sval;
	long lval;
	float fval, *x,*y;
	float dval;
	char *format;
	/* General variables */
	char input_filename[80], output_filename[80], author[80], origin[80];
	char ref[80],date[80],date_obs[80],object[80],observer[80],telescope[80];
	float equinox;
	int error=0;
	float min,max,mean,sigma,min_i,max_i;
	int naxes[2],daxes[2];
	int npix_int;
	double start_ww,end_ww;
	float start_w, end_w, delta_w;
	
	/* PGPLOT needed varibles */
	char answer_now;
	char answer[10];    
	int answer_len = sizeof(answer);
	int real_x,real_y,old_x,old_y;

	//	npix[0]=1024;
	

	/* Read a PMAS file header */

	

	/*
	 * Data of the new file!
	 */

	int count_fit=0;
	int *spax_id,*type_id;
	float *spax_x,*spax_y;
	float temp_float;
	char text[80];

	float *new_raw_data;
	float *new_raw_noise;
	int *nn_suma;
	int final_nb_spec;
	int j_nb_spec;

	GROUP new_grupo;
	GROUP *new_grupos;
	int n_new_groups;
  
	SPAXEL *new_spax, **new_spaxels;  
	int *n_new_spaxels;
	float new_size1,new_size2;

	E3D_file new_e3d_image;
	char position_file[80];
	float rotang;
	char shape[20];	
	float size_x=1.0;
	float size_y=1.0;
	FILE *fichero;
	int type_save=-1;
	float g_angle=0;
	int nueva_cuenta=0;
	SPAXEL sg_spax;
	float dist;
	float x_now,y_now;
	int n_suma;

	set_arglist("-if|inputfile none -of|outputfile outputfile -pf SB1.dat -au|author sanchez -or|origin AIP -ref|reference void -nb_spec 1 -type 1 -rotang 0");
	printf("INTEGRAL to Euro3D:\n\n");
	init_session(argv,argc,&arglabel,&argval);

	set_control_level(WARNING);
	
	for (i=0; i<9; i++) {
	  if ((strstr(arglabel[i],"-if"))||(strstr(arglabel[i],"-inputfile"))) {
	    strcpy(input_filename,argval[i]);
	  }
	  if (strstr(arglabel[i],"-pf")) {
	    strcpy(position_file,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-of"))||(strstr(arglabel[i],"-outfile"))) {
	    strcpy(output_filename,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-au"))||(strstr(arglabel[i],"-author"))) {
	    strcpy(author,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-or"))||(strstr(arglabel[i],"-origin"))) {
	    strcpy(origin,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-ref"))||(strstr(arglabel[i],"-reference"))) {
	    strcpy(ref,argval[i]);
	  }
	  if (strstr(arglabel[i],"-type")) {
	    type_save=atoi(argval[i]);
	  }
	  if (strstr(arglabel[i],"-nb_spec")) {
	    nb_spec=atoi(argval[i]);
	  }
	  if (strstr(arglabel[i],"-rotang")) {
	    rotang=(double)atof(argval[i]);
	  }
	}

	/*
	  checking the format of the file
	*/
	format = file_format(argval[0]);
	//	printf("format %s\n",format[0]);
	if ((format[0]!=FITS_B_FORMAT)&&(format[1]!=TBL_TYPE)) {
	  printf("The file does not seem to conform the Euro3D data format\n");	  	  
	}


	/*
	  Reading the data on the output file...
	*/
	printf("Opening the image: %s\n",input_filename);
	fflush(stdout);
	open_E3D_frame(&e3d_image,input_filename,"I");
	printf("Ok\n");
	in_nb_spec=e3d_image.nbspec;
	printf("nb_spec=%d\n",in_nb_spec);

	printf("Printing GROUPS information\n");
	printf("NGROUPS=%d\n",e3d_image.ngroups);
	for (j=0;j<e3d_image.ngroups;j++) {
	  //	  printf("TYPE=%s\n",e3d_image.groups[j].shape);
	  printf("SIZE1=%f\n",	e3d_image.groups[j].size1); 
	  printf("SIZE2=%f\n",	e3d_image.groups[j].size2); 
	  printf("airmass=%f\n",	e3d_image.groups[j].airmass); 
	}

	printf("Reading the Header of the file %s\n",input_filename);
	//	fflush(stdout);

	
	if(!RD_desc(&e3d_image,"EURO3D",CHAR,10,s_temp)) {
	   printf("No EURO3D definied, error\n");	  
	   exit_session(0);
	   return(0);
	 }
	euro3d=s_temp[0];
	printf("Euro3D = %s\n",euro3d);
	
	/*
	if(!RD_desc(&e3d_image,"NAXIS2",INT,1,i_temp)) {
	  printf("No NAXIS2 definied, error\n");	  
	  exit_session(0);
	  return(0);
	}		
	nb_spec=i_temp[0];
	*/
	if ((nfib!=0)||(nb_spec==0)) {
	  in_nb_spec=nfib;
	  if (in_nb_spec==0) {
	    in_nb_spec=256;
	  }
	  printf("IN nb_spec forced to %d\n",in_nb_spec);
	}
	

	nol = (int *)malloc(in_nb_spec*sizeof(int));  
	x = (float *)malloc(in_nb_spec*sizeof(float));  
	y = (float *)malloc(in_nb_spec*sizeof(float));  
	
	spaxels = (SPAXEL *)malloc(in_nb_spec*sizeof(SPAXEL));
	n_spaxels = (int *)malloc(in_nb_spec*sizeof(int));  

	printf("Ok\n");
	fflush(stdout);

	printf("Reading common parameters\n");
	get_common_param(&e3d_image,&npix_int,&start_ww,&end_ww);	
	start_w=(float)start_ww;
	end_w=(float)end_ww;
	printf("%d,%f,%f\n",npix_int,start_w,end_w);

	delta_w=(end_w-start_w)/npix_int;

	get_spectra_ID(&e3d_image,nol);
	printf("Reading Euro3D values spectrum by spectrum ...");
	fflush(stdout);	
	min=3000000;
	max=-3000000;
	naxes[1]=in_nb_spec;
	spectra = (SPECTRUM *)malloc(in_nb_spec*sizeof(SPECTRUM));  
	x_min=10000;
	y_min=10000;
	x_max=-10000;
	y_max=-10000;
	for (specId=1;specId<=in_nb_spec;specId++) {	 
	  /*
	    We get the spaxels information!!!
	  */
	  n_spaxels[specId]=get_E3D_spaxels(&e3d_image,specId,&spaxels[specId]);
	  
	  for (j=0;j<n_spaxels[specId];j++) {
	    if (x_min>spaxels[specId][j].xpos) x_min=spaxels[specId][j].xpos;
	    if (x_max<spaxels[specId][j].xpos) x_max=spaxels[specId][j].xpos;
	    if (y_min>spaxels[specId][j].ypos) y_min=spaxels[specId][j].ypos;
	    if (y_max<spaxels[specId][j].ypos) y_max=spaxels[specId][j].ypos;

	    //	    printf("Spaxel %d of Spec %d, (%f,%f), grup=%d\n",j,specId,spaxels[specId][j].xpos,spaxels[specId][j].xpos,spaxels[specId][j].group);
 
	  }
	  

	  /*
	    We get the spectra information.
	  */
	  //signal=e3d_image.signal[nol[specId-1]];
	  get_E3D_spec(&e3d_image,&signal,NULL,nol[specId-1]); 
	  spectra[specId-1]=signal;
	  if (specId==1) {
	    npix=signal.npts;
	    naxes[0]=npix;
	    raw_data = (float *)malloc((npix*in_nb_spec)*sizeof(float));  
	    raw_noise = (float *)malloc((npix*in_nb_spec)*sizeof(float));  
	    if (npix_int!=npix) {
	      printf("There is some error in the determination of the number of pixels\n");
	      printf("npix=%d npix_int=%d\n",npix,npix_int);
	    }
	  }
	  for (j=0;j<signal.npts;j++) {
	    raw_data[j+(specId-1)*npix]=RD_spec(&signal,j);
	    raw_noise[j+(specId-1)*npix]=RD_spec(&signal,j);
	    //	    printf("%f,%f\n",raw_data[j+(specId-1)*npix],RD_spec(&signal,j));
	    if (min>raw_data[j+(specId-1)*npix]) 
	      min=raw_data[j+(specId-1)*npix];
	    if (max<raw_data[j+(specId-1)*npix]) 
	      max=raw_data[j+(specId-1)*npix];
	  }		
	}
	if (min_i!=0.0) 
	  min=min_i;
	if (max_i!=0.0) 
	  max=max_i;



	printf("Ok\n");
	printf("closing previous datacube ...\n");
	fflush(stdout);
	close_E3D_frame(&e3d_image);


/*
 * Reading the new position table!
 */

	type_id = (int *)malloc((nb_spec)*sizeof(int));  	
	spax_id = (int *)malloc((nb_spec)*sizeof(int));  	
	spax_x = (float *)malloc((nb_spec)*sizeof(float));  	
	spax_y = (float *)malloc((nb_spec)*sizeof(float));  	

	printf("Opening the position table file\n");
	if ((fichero=fopen(position_file,"r"))==NULL) {
	  printf("Error opening file: %s\n",position_file);
	} else {
	  
	  fscanf(fichero, "%s", &str_temp);
	  strcpy(shape,str_temp);
	  fscanf(fichero, "%f", &size_x);
	  fscanf(fichero, "%f", &size_y);
	  fscanf(fichero, "%f", &g_angle);

	  printf("%s, %f %f\n",str_temp,size_x,size_y);

	  j=0;
	  count_fit=0;
	  while( fscanf(fichero, "%f", &temp_float) != EOF) {	       		
	    
	    if (j>3) {
	      j=0;
	      count_fit++;
	    }
	    
	    if(j==0) {
	      spax_id[count_fit]=floor(temp_float);
	    }
	    if(j==1) {
	      spax_x[count_fit]=temp_float;
	    }
	    if(j==2) {
		spax_y[count_fit]=temp_float;
	    }
	    if(j==3) {
		type_id[count_fit]=floor(temp_float);
	    }
	    j++;
	  }
	}

	printf("Position Table readed\n");

	/*
	 * We create the new data
	 */

	new_raw_data = (float *)malloc((npix*nb_spec)*sizeof(float));  
	new_raw_noise = (float *)malloc((npix*nb_spec)*sizeof(float));  
	
	nn_suma = (int *)malloc((nb_spec)*sizeof(int));  
	for (i=0;i<npix;i++) {
	    for (j=0;j<nb_spec;j++) {
		new_raw_data[i+npix*j]=0;
		new_raw_noise[i+npix*j]=0;
	    }
	}

	final_nb_spec=0;
	for (j=0;j<nb_spec;j++) {
//	j=0;    
//	while(j<nb_spec) {
//		new_raw_data[i+npix*j]=0;
	    n_suma=0;
	    for (k=0;k<in_nb_spec;k++) {
		x_now=spaxels[k+1][0].xpos;
		y_now=spaxels[k+1][0].ypos;
		dist=sqrt(pow(spax_x[j]-x_now,2)+pow(spax_y[j]-y_now,2));
		if (dist<size_x) { 
//		    printf("LINE= %d %f %f %d %f %f %d %f %f \n",j,x_now,y_now,k,spax_x[j],spax_y[j],n_suma,dist,size_x);
//		    printf("LINE= %d %d %d\n",j,i,npix,nb_spec,final_nb_spec);
		    for (i=0;i<npix;i++) {
			new_raw_data[i+npix*j]=new_raw_data[i+npix*j]+raw_data[i+npix*k];
		    }
		    n_suma++;
		}
	    }
	    for (i=0;i<npix;i++) {
		if (n_suma>0) {
		    new_raw_data[i+npix*j]=new_raw_data[i+npix*j]/n_suma;
		    new_raw_noise[i+npix*j]=sqrt(abs(new_raw_data[i+npix*j]));
		    nn_suma[j]=1;
		    final_nb_spec++;
		} else {
		    new_raw_data[i+npix*j]=0.0;
		    new_raw_noise[i+npix*j]=0.0;
		    nn_suma[j]=1;
		}
	    }
//	    j++;	    
	}

	printf("New RAW image created\n");

	/*
	 * We create the new group
	 */
	printf("group1 = %s ",shape);
	printf("%f %f \n",size_x,size_y);
	new_grupo.groupId=1;
	new_grupo.size1=1.0*size_x; 
	new_grupo.size2=1.0*size_y;
	new_grupo.shape=shape[0];
	new_grupo.angle=g_angle;
	new_grupo.poswav=(float) e3d_image.groups[0].poswav;
	new_grupo.airmass=(float) e3d_image.groups[0].airmass;
	new_grupo.parang=(float) e3d_image.groups[0].parang;
	new_grupo.pressure=(float) e3d_image.groups[0].pressure;
	new_grupo.temperature=(float) e3d_image.groups[0].temperature;

	i=1;
	k=1;
	//	nb_spec=npix_p[1];
	nb_spec=count_fit+1;
	nol = (int *)malloc(nb_spec*sizeof(int));  
	x = (float *)malloc(nb_spec*sizeof(float));  
	y = (float *)malloc(nb_spec*sizeof(float));  
	for (j=0;j<nb_spec;j++) {
	  nol[j]=spax_id[j];
	  x[j]=spax_x[j];
	  y[j]=spax_y[j];
	  //	  printf("[%d]=%f,%f\n",j,spax_x[j],spax_y[j]);
	  i++;
	  if (i>sqrt(nb_spec)) {
	    i=1;
	    k++;
	  }
	}

	start=start_w;
	step=delta_w;
	printf("Opening the Euro3D image\n");
	fflush(stdout);
	create_E3D_frame(&new_e3d_image,output_filename,npix_int,start,step,FLOAT,"test",NULL);
	printf("Ok\n");	

	printf("Writing into created Euro3D file ...");
	fflush(stdout);

	j_nb_spec=0;
	for (specId=1;specId<=nb_spec;specId++) {
	  if ((type_save==-1)||(type_save==type_id[specId-1])) {
	    //	    printf("type=%d,%d\n",type_save,type_id[specId-1]);
//	      if (nn_suma[specId-1]==1) {
		  j_nb_spec++;
		  nueva_cuenta++;
		  init_new_E3D_spec(&new_e3d_image,&signal,npix_int,start); 
		  /*
		    SPAXELS
		  */
		  sg_spax.specId=nueva_cuenta;
		  sg_spax.group=1;
		  sg_spax.xpos=x[specId-1]*cos(rotang*.01745327)-y[specId-1]*sin(rotang*.01745327);
		  sg_spax.ypos=y[specId-1]*cos(rotang*.01745327)+x[specId-1]*sin(rotang*.01745327);


		  for (j=0;j<signal.npts;j++) {	      
		      WR_spec(&signal,j,(double)new_raw_data[j+(specId-1)*npix_int]);
		      WR_spec(&signal,j,new_raw_data[j+(specId-1)*npix_int]);
		      
		  }
	    
		  put_E3D_spec(&new_e3d_image,&signal,NULL,nueva_cuenta);
		  put_E3D_spaxels(&new_e3d_image,nueva_cuenta,1,&sg_spax);
	      }
//	  }
	}
	printf("N_COUNT=%d, Ok\n",nueva_cuenta);
	/*	  
		 Writting the GROUPS information 
	*/
	printf("Writting the GROUPS information\n");

        new_e3d_image.ngroups = 1;
        new_e3d_image.groups = (GROUP *)malloc(1*sizeof(GROUP));
	new_e3d_image.groups[0]=new_grupo;	
	
//	set_pmas_group(&new_e3d_image,new_grupo);

	printf("NGROUPS=%d\n",new_e3d_image.ngroups);
	


	printf("Saving created Euro3D file ...");
	fflush(stdout);



	close_E3D_frame(&new_e3d_image);

	printf("Ok\n");


	free(raw_data);
	exit_session(0);
	return(0);	
}

/*
 Subroutine that plots a spectrum
*/

void specplot(float* data, float datamin, float datamax, int npix, float start_w, float delta_w) {
  float *x,*y;
  int i,j;

  if (start_w==0.0)
    start_w=1.0;
  if (delta_w==0.0)
    delta_w=1.0;

  x = (float *)malloc(npix*sizeof(float));  
  y = (float *)malloc(npix*sizeof(float));  
  for (i=0;i<npix;i++) {
    x[i]=(float)start_w+(float)delta_w*i;
    y[i]=data[i];
    //    printf("%f,%f,%f,%f\n",start_w,delta_w,x[i],y[i]);
  }
  
  cpgpage();	
  cpgenv(x[0],x[npix-1],datamin,datamax,0,0);
  cpglab("\\gLambda", "Flux", "Spectra");	  
  cpgsls(1);
  cpgpt(npix,x,y,1);
  cpgline(npix,x,y);
  
}


/*
 Subroutine that plot the image.
*/
void imageplot(float* data, float datamin, float datamax, int l_naxes[2], int id, char *title) {
  float tr[]={0.0,1.0,0.0,0.0,0.0,1.0};
  /*
   * We select a certain device
   */
  cpgslct(id);
  cpgpage();
  setvp();
  cpgwnad(0.0,1.0+l_naxes[0],0.0,1.0+l_naxes[1]);
  /* Defines the original palette */
  palett(p,sign*contra,bright);
  /* Plot the image */
  cpgimag(data,l_naxes[0],l_naxes[1],1,l_naxes[0],1,l_naxes[1],datamin,datamax,tr);
  cpgmtxt("t",1.0,0.0,0.0,title);
  cpgsch(0.6);
  cpgbox("bcntsi",0.0,0,"bcntsiv",0.0,0);
  cpgmtxt("b",3.0,1.0,1.0,"pixel number");
  /* Draws the Scale */
  cpgwedg("BI",4.0,5.0,datamin,datamax,"pixel value");
  cpgsch(1.0);
}

void setvp() {
  float d, vpx1, vpx2, vpy1, vpy2;
  cpgsvp(0.0,1.0,0.0,1.0);
  cpgqvp(1,&vpx1,&vpx2,&vpy1,&vpy2);
  d=minimun(vpx2-vpx1,vpy2-vpy1)/40.0;
  vpx1=vpx1+5.0*d;
  vpx2=vpx2-2.0*d;
  vpy1=vpy1+8.0*d;
  vpy2=vpy2-2.0*d;
  cpgvsiz(vpx1,vpx2,vpy1,vpy2);
  return;
}



float minimun(float a, float b) {
  float c;
  if (a<b) {
    c=a;
  } else {
    c=b;
  }
  return c;
}

float maximun(float a, float b) {
  float c;
  if (a>b) {
    c=a;
  } else {
    c=b;
  }
  return c;
}

/*
 * This subrutine changes the palette.
 * It is very useful, since it has the colour ranges.
 */

void palett(int type, float contra, float bright){
  
  float GL[]={0.0, 1.0};
  float GR[]={0.0, 1.0};
  float GG[]={0.0, 1.0};
  float GB[]={0.0, 1.0};
  
  float RL[]={-0.5, 0.0, 0.17, 0.33, 0.50, 0.67, 0.83, 1.0, 1.7};
  float RR[]={ 0.0, 0.0,  0.0,  0.0,  0.6,  1.0,  1.0, 1.0, 1.0};
  float RG[]={ 0.0, 0.0,  0.0,  1.0,  1.0,  1.0,  0.6, 0.0, 1.0};
  float RB[]={ 0.0, 0.3,  0.8,  1.0,  0.3,  0.0,  0.0, 0.0, 1.0};
  
  float HL[]={0.0, 0.2, 0.4, 0.6, 1.0};
  float HR[]={0.0, 0.5, 1.0, 1.0, 1.0};
  float HG[]={0.0, 0.0, 0.5, 1.0, 1.0};
  float HB[]={0.0, 0.0, 0.0, 0.3, 1.0};
  
  float WL[]={0.0, 0.5, 0.5, 0.7, 0.7, 0.85, 0.85, 0.95, 0.95, 1.0};
  float WR[]={0.0, 1.0, 0.0, 0.0, 0.3,  0.8,  0.3,  1.0,  1.0, 1.0};
  float WG[]={0.0, 0.5, 0.4, 1.0, 0.0,  0.0,  0.2,  0.7,  1.0, 1.0};
  float WB[]={0.0, 0.0, 0.0, 0.0, 0.4,  1.0,  0.0,  0.0, 0.95, 1.0};
  
  float AL[]={0.0, 0.1, 0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.5,
     0.5, 0.6, 0.6, 0.7, 0.7, 0.8, 0.8, 0.9, 0.9, 1.0};
  float AR[]={0.0, 0.0, 0.3, 0.3, 0.5, 0.5, 0.0, 0.0, 0.0, 0.0,
	      0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
  float AG[]={0.0, 0.0, 0.3, 0.3, 0.0, 0.0, 0.0, 0.0, 0.8, 0.8,
	      0.6, 0.6, 1.0, 1.0, 1.0, 1.0, 0.8, 0.8, 0.0, 0.0};
  float AB[]={0.0, 0.0, 0.3, 0.3, 0.7, 0.7, 0.7, 0.7, 0.9, 0.9,
	      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

  switch(type) {
  case (1): {
    /* Grey */
    cpgctab(GL, GR, GG, GB, 2, contra, bright);
    break;
  }
  case (2): {
    /* Rainbow */
    cpgctab(RL, RR, RG, RB, 9, contra, bright);
    break;
  }
  case (3): {
    /* Heat */
    cpgctab(HL, HR, HG, HB, 5, contra, bright);
    break;
  }
  case (4): {
    /* Weird IRAF */
    cpgctab(WL, WR, WG, WB, 10, contra, bright);
    break;
  }
  case (5): {
    /* AIPS */
    cpgctab(AL, AR, AG, AB, 20, contra, bright);
    break;
  }
  default: {
    cpgctab(GL, GR, GG, GB, 2, contra, bright);
    break;
  }
  }
  
}


void fiddle(int l_naxes[2], char* ch, int* real_x, int* real_y, int old_x, int old_y) {
  int ier;
  //,pgcurs;
  float x,y;
  float x1,y1,x2,y2,b1,b2,c1,c2;
  
//  int real_x,real_y;
//  char ch[10];

//  float *xx,*yy;
  int fuera=0;

  /*
  p=2;
  contra=0.8;
  bright=0.4;
  */
  x=0.5;
  y=1.0;
  sign=1;
  cpgqwin(&x1,&x2,&y1,&y2);
  b1=0.0;
  b2=1.0;
  c1=0.0;
  c2=1.0;
  cpgswin(b1,b2,c1,c2);



  //  ier=cpgcurs(&x,&y,ch);
  while((toupper(ch[0])!='Q')&&(fuera==0)) {

    if(ier=cpgband(mode,0,(float)(old_x/l_naxes[0]),(float)(old_y/l_naxes[1]),&x,&y,ch)){
      *real_x=(int) (l_naxes[0]*x);
      *real_y=(int) (l_naxes[1]*y);
      
      if (*real_x<0) *real_x=0;
      if (*real_x>l_naxes[0]) *real_x=l_naxes[0];
      if (*real_y<0) *real_y=0;
      if (*real_y>l_naxes[1]) *real_y=l_naxes[1];
      

      switch(toupper(ch[0])) {
      case('Z'): {
	fuera=1;
	break;
      }
      case('W'): {
	fuera=1;
	break;
      }
      case('O'): {
	fuera=1;
	break;
      }
      case('R'): {
	fuera=1;
	break;
      }
      case('S'): {
	fuera=1;
	break;
      }
      case('V'): {
	fuera=1;
	break;
      }
      case('M'): {
	fuera=1;
	break;
      }
      case('L'): {
	fuera=1;
	break;
      }
      case('D'): {
	fuera=1;
	break;
      }
      case('B'): {
	fuera=1;
	break;
      }
      case('N'): {
	fuera=1;
	break;
      }
      case('E'): {
	fuera=1;
	break;
      }
      case('C'): {
	fuera=1;
	break;
      }
      case('G'): {
	bright= maximun(b1,minimun(b2,x));
	contra= maximun(c1,minimun(c2,y));
	palett(p,sign*contra,bright);
	break;
      }
      case('I'): {
	fuera=1;
	break;
      }
      case('Q'): {
	cpgswin(x1,x2,y1,y2);
	break;
      }
      case('F'): {
	bright= maximun(b1,minimun(b2,x));
	contra= maximun(c1,minimun(c2,y));
	fuera=1;
	break;
      }
      case(';'): {
	contra=1.0;
	y=1.0;
	bright=0.5;
	x=0.5;
	break;
      }
      case('U'): {
	printf("c=%f,b=%f\n",contra,bright);
	break;
      }
      case('-'): {
	sign=-sign;
	break;
      }
      case('1'): {
	p=1;
	break;
      }
      case('2'): {
	p=2;
	break;
      }
      case('3'): {
	p=3;
	break;
      }
      case('4'): {
	p=4;
	break;
      }
      case('5'): {
	p=5;
	break;
      }
      case('P'): {
	fuera=1;
	break;
      }
      }
      palett(p,sign*contra,bright);

    }
//    ier=cpgcurs(&x,&y,ch);
  }
}

/*
 * This function determine the values over the Fourier serie
 * considering angles in Degrees
 */




