/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  2004 AIP, Potsdam, Germany
! IDENT        flames2Euro3D.c
! LANGUAGE     C
! AUTHOR       S.F.Sanchez
! KEYWORDS     
! PURPOSE      Facility to transform FLAMES reduced data to Euro3D data format.
! COMMENT      
! VERSION      0.1  2004-Mar-15 : Creation, SF.
------------------------------------------------------------------------------*/

#include <IFU_io.h>

#include "stats.h"

/*-----------------------------------------------------------------------------
!
!.blk            Transform the INTEGRAL reduced data to Euro3D data: No GROUP info included.
!
!.prog                             flames2Euro3D()
!
!.purp         Facility to transform INTEGRAL reduced data to Euro3D data format.
!
-----------------------------------------------------------------------------*/

#define NB_SPEC 256
#define NPIX 1024




int set_pmas_group(E3D_file *frame, GROUP grupo)
{
         frame->ngroups = 1;
         frame->groups = (GROUP *)malloc(1*sizeof(GROUP));
	 frame->groups[0]=grupo;
}



int set_flames_group(E3D_file *frame, GROUP grupo, int n_groups, float *spax_angle)
{
    int j;
    frame->ngroups = n_groups+1;
    frame->groups = (GROUP *)malloc((n_groups+1)*sizeof(GROUP));
    for (j=0;j<=n_groups;j++) {
	grupo.angle=spax_angle[j]*180/3.141592654;
	frame->groups[j]=grupo;

    }
}



int set_single_flames_group(E3D_file *frame, GROUP grupo, int n_groups, float *spax_angle)
{
    int j;
    frame->ngroups = 1;
    frame->groups = (GROUP *)malloc((n_groups+1)*sizeof(GROUP));
    grupo.angle=spax_angle[n_groups]*180/3.141592654;
    frame->groups[0]=grupo;
}





main(int argc, char **argv)
{

    float  x_pos[]={0,5,5,6,6,5,5,4,4,4,4,3,3,3,3,2,2,1,1,2,2};
    float  y_pos[]={0,4,3,3,2,2,1,1,2,3,4,4,3,2,1,1,2,2,3,3,4};


  FILE *fichero;
  int count_fit=0;
  int *spax_id,*type_id,*def_spax,*group_id,button,which_button;
  float ra,dec,orient,xind,yind;
  int nind;
  float *spax_x,*spax_y,*spax_angle;
  float mean_x,mean_y;
  float temp_float;
  double temp_double;
  char text[80];

  char *temp_text;

  int type_save=-1;
  int nueva_cuenta=0;

  /*
    GROUPS
  */
  GROUP grupo, *grupos;
  int n_groups,group_now,group_last;

  /*
    SPAXELS
  */
  SPAXEL spax, *spaxels;

  
  TABLE table; 
  int colID;
  E3D_file e3d_image;
  SPECTRUM signal,noise;
  SLICE s_signal;
  IMAGE2D image;
  char **argval, **arglabel;
  
  int nbal;
  
  short s_temp[10];
  int i_temp[10];
  float f_temp[10];
  double d_temp[10];
	char str_temp[80];
	
	
	//double *data;
	float *data;

	/*
	  All the images has an initial BITPIX.
	  It will be stored in this initial BITPIX,
	  but the data will be internally managed as DOUBLE
	  not to reduce the precision on none of them.
	*/
	short bitpix; // Variable that stores the initial BITPIX value.
	




	/* Euro3D variables */
	int specId, i,j,k, npix=NPIX, nb_spec, status, *nol, n_cont;
	float start, step;
	short sval;
	long lval;
	float fval, *x,*y;
	double dval;
	//	float fval;

	/* INTEGRAL image variables */

	int i_p,j_p, npix_p[2];
	double start_p[2],step_p[2];
	short sval_p;
	long lval_p;
	float fval_p;
	double dval_p;


	double rotang;

	double airmass;
	double parang;
	double pressure;
	double temperature;

	int bundle;
	float size;


	/* General variables */

	char input_filename[80], output_filename[80], author[80], origin[80];
	char position_file[80];
	char ref[80],date[80],date_obs[80],object[80],observer[80],telescope[80];
	float equinox;
	int error=0;
	int delete=2;

	start_p[0]=1; start_p[1]=1;
	step_p[0]=1; step_p[1]=1;

	//	npix[0]=1024;
	

	/* Read a INTEGRAL file header */

	

	set_arglist("-if|inputfile none -of|outputfile -size 0.52 -button -1");
	printf("FLAMES to Euro3D:\n\n");
	init_session(argv,argc,&arglabel,&argval);

	set_control_level(WARNING);

	get_argval(0,"%s",input_filename);
	get_argval(0,"%s",position_file);
	get_argval(1,"%s",output_filename);
	get_argval(2,"%f",&size);
	get_argval(3,"%d",&which_button);
	
	

	




	/*
	  We open the file to read the headers
	*/

	printf("Opening the data file %s\n",input_filename);
	fflush(stdout);
	open_frame(&image,input_filename,"IO");
	printf("Ok\n");
	fflush(stdout);


	/*
	  We read some of the header information
	*/

	printf("Reading Header information\n");
	fflush(stdout);

	if(!RD_desc(&image,"CRVAL2",DOUBLE,1,d_temp)) {
	  printf("No CRVAL2 definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  start= (float)d_temp[0]*10;
	}

	if(!RD_desc(&image,"CDELT2",DOUBLE,1,d_temp)) {
	  printf("No CRDELT1 definied, error\n");
	  exit_session(0);
	  return(0);
	  
	} else {
	step=d_temp[0]*10;
	}

	if(!RD_desc(&image,"DATE",CHAR,80,str_temp)) {
	  printf("No DATE definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(date,str_temp);

	if(!RD_desc(&image,"DATE-OBS",CHAR,80,str_temp)) {
	  printf("No DATE-OBS definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(date_obs,str_temp);

	if(!RD_desc(&image,"EQUINOX",FLOAT,1,f_temp)) {
	  printf("No EQUINOX definied, error\n");
	  exit_session(0);
	  return(0);
	}
	equinox=f_temp[0];

/*
	if(!RD_desc(&image,"OBJECT",CHAR,80,str_temp)) {
	  printf("No OBJECT definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(object,str_temp);


	if(!RD_desc(&image,"OBSERVER",CHAR,80,str_temp)) {
	  printf("No OBSERVER definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(observer,str_temp);

	if(!RD_desc(&image,"TELESCOP",CHAR,80,str_temp)) {
	  printf("No TELESCOPE definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(telescope,str_temp);
*/

	if(!RD_desc(&image,"HIERARCH ESO TEL AIRM END",DOUBLE,1,d_temp)) {
	  printf("No AIRMASS definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  airmass=d_temp[0];
	}

	if(!RD_desc(&image,"HIERARCH ESO TEL AMBI PRES END",DOUBLE,1,d_temp)) {
	  printf("No PRESSURE definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  pressure=d_temp[0];
	}

	if(!RD_desc(&image,"HIERARCH ESO TEL AMBI TEMP",DOUBLE,1,d_temp)) {
	  printf("No TEMPERATURE definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  temperature=d_temp[0];
	}


	if(!RD_desc(&image,"HIERARCH ESO TEL PARANG END",DOUBLE,1,d_temp)) {
	  printf("No PARANGLE definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  parang=d_temp[0];
	}

	if(!RD_desc(&image,"HIERARCH ESO ADA ABSROT END",DOUBLE,1,d_temp)) {
	  printf("No ROTSKYPA definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  rotang=d_temp[0];
	}
	parang=parang-rotang;

	//	printf("pres=%g\n",pressure);


	printf("Ok\n");
	fflush(stdout);

	printf("Reading INTEGRAL image data\n");
	fflush(stdout);
	/*
	  We read the data from the image.
	*/
	printf("[nx,ny]=%d,%d\n",image.nx,image.ny);

	data = (float *)malloc((image.nx*image.ny)*sizeof(float));  
	for (i=0;i<image.nx;i++) {		
	    for (j=0;j<image.ny;j++) {
		dval = RD_frame(&image,i,j);
		data[j+i*image.ny] = (1.0)*dval;
//		printf("data(%d,%d)=%f,%f\n",i,j,dval,data[j+i*image.ny]);
	    }
	}
	printf("Ok\n");
	fflush(stdout);


	mean_x=0;
	mean_y=0;

	type_id = (int *)malloc((image.ny)*sizeof(int));  	
	spax_id = (int *)malloc((image.ny)*sizeof(int));  	
	def_spax = (int *)malloc((image.ny)*sizeof(int));  	
	spax_x = (float *)malloc((image.ny)*sizeof(float));  	
	spax_y = (float *)malloc((image.ny)*sizeof(float));  	
	spax_angle = (float *)malloc((image.ny)*sizeof(float));  	
	group_id = (float *)malloc((image.ny)*sizeof(float));  	

	close_frame(&image);

	strcat(position_file,"[3]");
	printf("POSITION_FILE='%s'\n",position_file);
	open_table(&table,strcat(input_filename,"[3]"),"I");
	n_groups=0;	
	n_cont=0;
	j=0;	
	do {
	    colID=get_col_ref(&table,"NSPEC");
	    RD_tbl(&table,j,colID,&k);
	    def_spax[k]=0;
	    colID=get_col_ref(&table,"RA");
	    RD_tbl(&table,j,colID,&temp_double);
	    ra=(float)temp_double;
	    colID=get_col_ref(&table,"DEC");
	    RD_tbl(&table,j,colID,&temp_double);
	    dec=(float)temp_double;

	    colID=get_col_ref(&table,"XIND");
	    RD_tbl(&table,j,colID,&i);
	    xind=(float)i;
	    xind=xind*size*2*1.02;
	    colID=get_col_ref(&table,"YIND");
	    RD_tbl(&table,j,colID,&i);
	    yind=(float)i;
	    yind=yind*size*2*1.02;

/*
	    colID=get_col_ref(&table,"NIND");
	    RD_tbl(&table,j,colID,&i);
	    nind=i;
	    if (nind>20) {
		nind=0;
	    }
	    xind=-x_pos[nind]*size*2*1.02;
	    yind=y_pos[nind]*size*2*1.02;
*/
//	    printf("nind=%d,%f,%f\n",nind,xind,yind);

	    colID=get_col_ref(&table,"ORIENT");
	    RD_tbl(&table,j,colID,&temp_double);
	    orient=(float)temp_double;	   
	    colID=get_col_ref(&table,"button");
	    RD_tbl(&table,j,colID,&i);
	    button=i;
	    if ((button>0)&&(button<65535)) {
		if (n_cont==0) {
		    group_now=button;
		} else {
		    if (group_now!=button) {
			group_now=button;
			n_groups++;
		    }
		}

		group_id[j]=n_groups+1;
		spax_angle[n_groups]=0.01745*((315-orient));	
		def_spax[j]=1;


		spax_x[j]=ra*3600+(xind*cos(spax_angle[n_groups])-yind*sin(spax_angle[n_groups]));//*cos(dec*0.01745);
//		spax_x[j]=ra*3600+xind*cos(spax_angle[n_groups])-yind*sin(spax_angle[n_groups]);
		spax_y[j]=dec*3600+yind*cos(spax_angle[n_groups])+xind*sin(spax_angle[n_groups]);



/*
		spax_x[j]=ra*3600*0.01745+yind*cos(spax_angle[j])+xind*sin(spax_angle[j]);
		spax_y[j]=dec*3600*0.01745+xind*cos(spax_angle[j])-yind*sin(spax_angle[j]);
*/
		spax_id[j]=k-1;	
//		printf("GROUP= %d, %f, %f, B=%d\n",n_groups,orient,spax_angle[n_groups],button);
//		printf("SPAX= %d, %d %f,%f %f,%f,%f,%f B=%d\n",j,spax_id[j],ra,dec,spax_x[j],spax_y[j],xind,yind,button);
		mean_x+=spax_x[j];
		mean_y+=spax_y[j];		    
		n_cont++;
	    } else {
		spax_id[j]=-1;
	    }
	    j++;
	} while (k!=0);
	close(&table);
	nb_spec=j-1;


	if ((which_button<1)||(which_button>(n_groups+1))) {
	    printf("Wrong button selection: %d [0,%d]\n",which_button,n_groups);
	    which_button=-1;
	}

	/*
	 * We recenter the data
	 */
	mean_x/=n_cont;
	mean_y/=n_cont;

	for (j=0;j<=nb_spec;j++) {
	    spax_x[j]=spax_x[j]-mean_x;
	    spax_y[j]=spax_y[j]-mean_y;
	}

	printf("NB_SPEC=%d, %d\n",nb_spec,image.ny);

	printf("Ok\n");	


	/*
	  Creating the single INTEGRAL GROUP
	*/

/*
	if (bundle==1) size=0.45/2;
	if (bundle==2) size=0.90/2;
	if (bundle==3) size=2.70/2;
*/
	grupo.groupId=1;
	grupo.shape='R';
	grupo.size1=size; 
	grupo.size2=size;
	grupo.angle=0;
	grupo.poswav=(float)start;
	grupo.airmass=(float)airmass;
	grupo.parang=(float)parang;
	grupo.pressure=(float)pressure;
	grupo.temperature=(float)temperature;

	i=1;
	k=1;
	nol = (int *)malloc(nb_spec*sizeof(int));  
	x = (float *)malloc(nb_spec*sizeof(float));  
	y = (float *)malloc(nb_spec*sizeof(float));  
	for (j=0;j<nb_spec;j++) {
	    nol[j]=spax_id[j];
	    x[j]=spax_x[j];
	    y[j]=spax_y[j];
	    i++;
	    if (i>sqrt(nb_spec)) {
		i=1;
		k++;
	    }
	}


	npix_p[0]=image.ny;
	npix_p[1]=nb_spec;
	/*
	  We create now the new Euro3D image and same the data.
	*/
	printf("Opening the Euro3D image\n");
	fflush(stdout);
	create_E3D_frame(&e3d_image,output_filename,npix_p[0],start,step,FLOAT,"test",NULL);
	printf("Ok\n");	

	printf("Writing into created Euro3D file ...");
	fflush(stdout);
	
	for (specId=1;specId<=npix_p[1];specId++) {
	    if (spax_id[specId-1]>0) {
		if (which_button==-1) {
		    nueva_cuenta++;
		    init_new_E3D_spec(&e3d_image,&signal,npix_p[0],start); 
		    /*
		      SPAXELS
		    */
		    spax.specId=nueva_cuenta;
		    spax.group=group_id[specId-1];
		    spax.xpos=x[specId-1]*cos(rotang*.01745327)-y[specId-1]*sin(rotang*.01745327);
		    spax.ypos=y[specId-1]*cos(rotang*.01745327)+x[specId-1]*sin(rotang*.01745327);
		    for (j=0;j<signal.npts;j++) {
			
			WR_spec(&signal,j,(double)data[j+spax_id[specId-1]*npix_p[0]]);
			WR_spec(&signal,j,data[j+spax_id[specId-1]*npix_p[0]]);
		    }		    
		    put_E3D_spec(&e3d_image,&signal,NULL,nueva_cuenta);
		    put_E3D_spaxels(&e3d_image,nueva_cuenta,1,&spax);
		} else {
		    if (which_button==group_id[specId-1]) {
			nueva_cuenta++;
			init_new_E3D_spec(&e3d_image,&signal,npix_p[0],start); 
		    /*
		      SPAXELS
		    */
			spax.specId=nueva_cuenta;
			spax.group=1;
			spax.xpos=x[specId-1]*cos(rotang*.01745327)-y[specId-1]*sin(rotang*.01745327);
			spax.ypos=y[specId-1]*cos(rotang*.01745327)+x[specId-1]*sin(rotang*.01745327);
			for (j=0;j<signal.npts;j++) {
			    
			    WR_spec(&signal,j,(double)data[j+spax_id[specId-1]*npix_p[0]]);
			    WR_spec(&signal,j,data[j+spax_id[specId-1]*npix_p[0]]);
			}		    
			put_E3D_spec(&e3d_image,&signal,NULL,nueva_cuenta);
			put_E3D_spaxels(&e3d_image,nueva_cuenta,1,&spax);
			
		    }
		}
	    }
	}

	printf("N_COUNT=%d, Ok\n",nueva_cuenta);
	/*
	  Writting the GROUPS information 
	*/
	printf("****We assume HIERARCH CAHA ADA POSANG to be the paralactic angle*********\n");
	printf("Writting the GROUPS information\n");
	
//	set_pmas_group(&e3d_image,grupo);
	if (which_button==-1) {
	    set_flames_group(&e3d_image,grupo,n_groups,spax_angle);
	} else {
	    set_single_flames_group(&e3d_image,grupo,which_button-1,spax_angle);
	}
	//e3d_image.ngroups=1;
	
	//        e3d_image.groups = (GROUP *)malloc(1*sizeof(GROUP));
	//        e3d_image.groups[0]=grupo;  




	//	grupos=(GROUP *)malloc(1*sizeof(GROUP));  
	//grupos[0]=grupo;
	//	put_E3D_groups(&e3d_image,1,&grupos);
	//e3d_image.groups=grupos;

	//free(grupos);

	printf("NGROUPS=%d\n",e3d_image.ngroups);
	//printf("TYPE=%c\n",e3d_image.groups[0].shape);
	
	/*
	printf("SIZE1=%d\n",	e3d_image.groups[0].size1); 
	printf("SIZE2=%d\n",	e3d_image.groups[0].size2); 
	printf("airmass=%f\n",	e3d_image.groups[0].airmass); 
	*/

	printf("Saving created Euro3D file ...");
	fflush(stdout);



	/*
	  Writting HEADER information
	*/
	
	/*
	WR_desc(&e3d_image,"AUTHOR",CHAR,80,observer);
	WR_desc(&e3d_image,"DATE",CHAR,80,date);
	WR_desc(&e3d_image,"DATE-OBS",CHAR,80,date_obs);
	f_temp[0]=equinox;
	WR_desc(&e3d_image,"EPOCH",FLOAT,1,f_temp);
	WR_desc(&e3d_image,"EQUINOX",FLOAT,1,f_temp);

	*/

	close_E3D_frame(&e3d_image);

	printf("Ok\n");

	/*
	  Reading the saved data on the output file...
	*/


	printf("Checking the saved image: %s\n",output_filename);
	fflush(stdout);
	open_E3D_frame(&e3d_image,output_filename,"I");
	printf("Ok\n");

	/*
	printf("Testing the reading of the HEADER\n");
	i_temp[0]=0;
	if(!RD_desc(&e3d_image,"NAXIS2",INT,1,i_temp)) {
	  printf("No NAXIS2 definied, error\n");	  
	  exit_session(0);
	  return(0);
	}	
	nb_spec=0;
	nb_spec=i_temp[0];
	if (nb_spec==npix_p[1]) {
	  printf("OK %d,%d\n",nb_spec,npix_p[1]);
	} else {
	  printf("Header not correctly readed...\n");
	}
	*/

	get_spectra_ID(&e3d_image,nol);
	printf("Reading Euro3D values spectrum by spectrum and Spaxels...");
	fflush(stdout);
	npix_p[1]=nueva_cuenta;
	
	for (specId=1;specId<=npix_p[1];specId++) {
	  
		get_E3D_spec(&e3d_image,&signal,NULL,nol[specId-1]); 
		for (j=0;j<signal.npts;j++) {
		  if (RD_spec(&signal,j)!=data[j+(specId-1)*npix_p[0]])
		    error=1;
		}
		
		
		status=get_E3D_spaxels(&e3d_image,specId,&spaxels);
		if (spaxels[0].specId!=specId) error=2;
		if (spaxels[0].group!=1) error=3;
		if (spaxels[0].xpos!=x[specId-1]) error=4;
		if (spaxels[0].ypos!=y[specId-1]) error=5;
		//		printf("status=%d\n",status);

	}
	if (error==0) {
	  printf("Ok\n");
	} else {
	  printf("\n***** THE EURO3D FILES DOES NOT MATCH THE ORIGINAL FILE *******\n");
	  printf("ERROR=%d\n",error);
	  printf("******\n");
	}

	/* Testing the groups */

	printf("NBSPEC=%d\n",e3d_image.nbspec);

	printf("NGROUPS=%d\n",e3d_image.ngroups);
	//	e3d_image.groups[0].shape=3;
	printf("TYPE=%d\n",e3d_image.groups[0].shape);
	printf("SIZE1=%f\n",	e3d_image.groups[0].size1); 
	printf("SIZE2=%f\n",	e3d_image.groups[0].size2); 
	printf("airmass=%f\n",	e3d_image.groups[0].airmass); 
	/*
	for (j=0;j<e3d_image.ngroups;j++) {
	  printf("GROUP %d INFO\n 
%s\n",
	e3d_image.groups[j].groupId,
	e3d_image.groups[j].shape); 
	  
	  printf("%d, %d, %d, %4.2f,  %4.2f,  %4.2f,  %4.2f,  %4.2f\n",

	e3d_image.groups[j].angle,
	e3d_image.groups[j].size2, 
	e3d_image.groups[j].poswav,
	e3d_image.groups[j].airmass,
	e3d_image.groups[j].parang,
	e3d_image.groups[j].pressure,
		 e3d_image.groups[j].temperature);
	  

	}

	*/

	/*
	n_grupos=npix_p[1];
	printf("n_grupos=%d\n",n_grupos);
	for (specId=1;specId<=npix_p[1];specId++) {
	  status=get_E3D_groups(&e3d_image,specId,grupos);
	  printf("status=%d\n",status);
	}
	*/

	printf("closing previous datacube ...\n");
	fflush(stdout);
	close_E3D_frame(&e3d_image);

	free(data);
	exit_session(0);
	return(0);

	
}



