/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  2002 AIP, Potsdam, Germany
! IDENT        pmas2Euro3D.c
! LANGUAGE     C
! AUTHOR       S.F.Sanchez
! KEYWORDS     
! PURPOSE      Facility to transform PMAS reduced data to Euro3D data format.
! COMMENT      No GROUP information included. No header data properly copied
! VERSION      0.1  2002-Dec-17 : Creation, SF.
------------------------------------------------------------------------------*/

#include <IFU_io.h>

#include "stats.h"

/*-----------------------------------------------------------------------------
!
!.blk            Transform the PMAS reduced data to Euro3D data: No GROUP info included.
!
!.prog                             pmas2Euro3D()
!
!.purp         Facility to transform PMAS reduced data to Euro3D data format.
!
-----------------------------------------------------------------------------*/

#define NB_SPEC 256
#define NPIX 1024

main(int argc, char **argv)
{

  /*
    GROUPS
  */
  GROUP grupo;
  GROUP *grupos;
  int n_grupos;
  

  
	E3D_file e3d_image;
	SPECTRUM signal,noise;
	SLICE s_signal;
	IMAGE2D image;
	char **argval, **arglabel;
	int nbal;

	short s_temp[10];
	int i_temp[10];
	float f_temp[10];
	double d_temp[10];
	char str_temp[80];


	double *data;

	/*
	  All the images has an initial BITPIX.
	  It will be stored in this initial BITPIX,
	  but the data will be internally managed as DOUBLE
	  not to reduce the precision on none of them.
	*/
	short bitpix; // Variable that stores the initial BITPIX value.
	




	/* Euro3D variables */
	int specId, i,j,k, npix=NPIX, nb_spec, status, *nol;
	double start, step;
	short sval;
	long lval;
	float fval, *x,*y;
	double dval;

	/* PMAS image variables */

	int i_p,j_p, npix_p[2];
	double start_p[2],step_p[2];
	short sval_p;
	long lval_p;
	float fval_p;
	double dval_p;

	double airmass;
	double parang;
	double pressure;
	double temperature;



	/* General variables */

	char input_filename[80], output_filename[80], author[80], origin[80];
	char ref[80],date[80],date_obs[80],object[80],observer[80],telescope[80];
	float equinox;
	int error=0;

	start_p[0]=1; start_p[1]=1;
	step_p[0]=1; step_p[1]=1;

	//	npix[0]=1024;
	

	/* Read a PMAS file header */

	

	set_arglist("-if|inputfile none -of|outputfile outputfile -au|author sanchez -or|origin AIP -ref|reference void");
	printf("PMAS to Euro3D:\n\n");
	init_session(argv,argc,&arglabel,&argval);

	set_control_level(WARNING);
	
	for (i=0; i<5; i++) {
	  if ((strstr(arglabel[i],"-if"))||(strstr(arglabel[i],"-inputfile"))) {
	    strcpy(input_filename,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-of"))||(strstr(arglabel[i],"-outfile"))) {
	    strcpy(output_filename,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-au"))||(strstr(arglabel[i],"-author"))) {
	    strcpy(author,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-or"))||(strstr(arglabel[i],"-origin"))) {
	    strcpy(origin,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-ref"))||(strstr(arglabel[i],"-reference"))) {
	    strcpy(ref,argval[i]);
	  }
	}


	/*
	  We open the file to read the headers
	*/

	printf("Opening the file %s\n",input_filename);
	fflush(stdout);
	open_frame(&image,input_filename,"I");
	printf("Ok\n");
	fflush(stdout);

	/*
	  We read some of the header information
	*/

	printf("Reading Header information\n");
	fflush(stdout);
	if(!RD_desc(&image,"BITPIX",SHORT,1,s_temp)) {
	  printf("No BITPIX definied, error\n");	  
	  exit_session(0);
	  return(0);
	}
	bitpix=s_temp[0];

	if(!RD_desc(&image,"CRVAL0",DOUBLE,1,d_temp)) {
	  printf("No CRVAL0 definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  start=d_temp[0];
	}

	if(!RD_desc(&image,"CRVAL1",DOUBLE,1,d_temp)) {
	  printf("No CRVAL1 definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  start=d_temp[0];
	}


	if(!RD_desc(&image,"CDELT0",DOUBLE,1,d_temp)) {
	  printf("No CRDELT0 definied, error\n");
	  exit_session(0);
	  return(0);
	  
	} else {
	step=d_temp[0];
	}

	if(!RD_desc(&image,"CDELT1",DOUBLE,1,d_temp)) {
	  printf("No CRDELT1 definied, error\n");
	  exit_session(0);
	  return(0);
	  
	} else {
	step=d_temp[0];
	}


	if(!RD_desc(&image,"NAXIS1",INT,1,i_temp)) {
	  printf("No NAXIS1 definied, error\n");
	  exit_session(0);
	  return(0);
	}
	npix_p[0]=i_temp[0];

	if(!RD_desc(&image,"NAXIS2",INT,1,i_temp)) {
	  printf("No NAXIS2 definied, error\n");
	  exit_session(0);
	  return(0);
	}
	npix_p[1]=i_temp[0];

	if(!RD_desc(&image,"DATE",CHAR,80,str_temp)) {
	  printf("No DATE definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(date,str_temp);

	if(!RD_desc(&image,"DATE-OBS",CHAR,80,str_temp)) {
	  printf("No DATE-OBS definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(date_obs,str_temp);

	if(!RD_desc(&image,"HIERARCH CAHA TEL POS SET EQUINOX",FLOAT,1,f_temp)) {
	  printf("No EQUINOX definied, error\n");
	  exit_session(0);
	  return(0);
	}
	equinox=f_temp[0];

	if(!RD_desc(&image,"OBJECT",CHAR,80,str_temp)) {
	  printf("No OBJECT definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(object,str_temp);

	if(!RD_desc(&image,"OBSERVER",CHAR,80,str_temp)) {
	  printf("No OBSERVER definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(observer,str_temp);

	if(!RD_desc(&image,"TELESCOP",CHAR,80,str_temp)) {
	  printf("No TELESCOPE definied, error\n");
	  exit_session(0);
	  return(0);
	}
	strcpy(telescope,str_temp);


	if(!RD_desc(&image,"AIRMASS",DOUBLE,1,d_temp)) {
	  printf("No AIRMASS definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  airmass=d_temp[0];
	}

	if(!RD_desc(&image,"HIERARCH CAHA GEN AMBI PRES",DOUBLE,1,d_temp)) {
	  printf("No PRESSURE definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  pressure=d_temp[0];
	}

	if(!RD_desc(&image,"HIERARCH CAHA GEN AMBI TEMP",DOUBLE,1,d_temp)) {
	  printf("No TEMPERATURE definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  temperature=d_temp[0];
	}


	if(!RD_desc(&image,"HIERARCH CAHA ADA POSANG",DOUBLE,1,d_temp)) {
	  printf("No PARALACTIC definied, error\n");
	  exit_session(0);
	  return(0);
	} else {
	  parang=d_temp[0];
	}

	//	printf("pres=%g\n",pressure);


	printf("Ok\n");
	fflush(stdout);

	printf("Reading PMAS image data\n");
	fflush(stdout);
	/*
	  We read the data from the image.
	*/

	data = (double *)malloc((npix_p[0]*npix_p[1])*sizeof(double));  
	for (j=0;j<image.ny;j++) {
	  for (i=0;i<image.nx;i++) {
	    dval = (double)RD_frame(&image,i,j);
	    data[i+j*image.nx] = dval;	    
	  }
	}
	printf("Ok\n");
	fflush(stdout);
	close_frame(&image);

	/*
	  Creating the single PMAS GROUP
	*/
	grupo.groupId=1;
	grupo.shape='S';
	grupo.size1=0.5; //Arcseconds?
	grupo.angle=0.0;
	grupo.size2=0.5; //Arcseconds??
	grupo.poswav=start;
	grupo.airmass=airmass;
	grupo.parang=parang;
	grupo.pressure=pressure;
	grupo.temperature=temperature;

	/*
	  Creating the spatial structure of the PMAS data
	  NOTE: By now the relative positions of the fibers
	  are arbitrary (?), they are so called instrumental
	  We assume an square distribution...
	*/

	i=1;
	k=1;
	nb_spec=npix_p[1];
	nol = (int *)malloc(nb_spec*sizeof(int));  
	x = (float *)malloc(nb_spec*sizeof(float));  
	y = (float *)malloc(nb_spec*sizeof(float));  
	for (j=0;j<nb_spec;j++) {
	  nol[j]=j+1;
	  x[j]=i;
	  y[j]=k;
	  i++;
	  if (i>sqrt(nb_spec)) {
	    i=1;
	    k++;
	  }
	}



	/*
	  We create now the new Euro3D image and same the data.
	*/
	printf("Opening the Euro3D image\n");
	fflush(stdout);
	create_E3D_frame(&e3d_image,output_filename,npix_p[0],start,step,FLOAT,"test",NULL);
	printf("Ok\n");	

	


//	set_ID_and_coordinates(&e3d_image,"XPOS","YPOS",nb_spec,nol,x,y);	
	set_ID_and_coordinates(&e3d_image,nb_spec,nol,x,y);	
	printf("Writing into created Euro3D file ...");
	fflush(stdout);

	for (specId=1;specId<=npix_p[1];specId++) {
		init_new_E3D_spec(&e3d_image,&signal,npix_p[0],start); 
		for (j=0;j<signal.npts;j++) {
		  
		  switch(bitpix) {
		  case (8): {
		    WR_spec(&signal,j,(short)data[j+(specId-1)*npix_p[0]]);
		    break;
		  }
		  case (16): {
		    WR_spec(&signal,j,(short)data[j+(specId-1)*npix_p[0]]);
		    break;
		  }
		  case (32): {
		    WR_spec(&signal,j,(long)data[j+(specId-1)*npix_p[0]]);
		    break;
		  }
		  case (-32): {
		    WR_spec(&signal,j,(float)data[j+(specId-1)*npix_p[0]]);
		    break;
		  }
 		  case (-64): {
	 	    WR_spec(&signal,j,(double)data[j+(specId-1)*npix_p[0]]);
		    break;
		  }
		    
		  }
		  //  WR_spec(&noise,j,0.0);
		  //		  WR_spec(&signal,j,(float)j*specId);
		}
				put_E3D_spec(&e3d_image,&signal,NULL,specId);
		//put_E3D_row(&e3d_image,&signal,NULL,specId);
	}
	printf("Ok\n");
	/*
	  Writting the GROUPS information 
	*/
	printf("****We assume HIERARCH CAHA ADA POSANG to be the paralactic angle*********\n");
	printf("Writting the GROUPS information\n");
	put_E3D_groups(&e3d_image,1,&grupo);
	

	printf("Saving created Euro3D file ...");
	fflush(stdout);



	/*
	  Writting HEADER information
	*/
	
	WR_desc(&e3d_image,"AUTHOR",CHAR,80,observer);
	WR_desc(&e3d_image,"DATE",CHAR,80,date);
	WR_desc(&e3d_image,"DATE-OBS",CHAR,80,date_obs);
	f_temp[0]=equinox;
	WR_desc(&e3d_image,"EPOCH",FLOAT,1,f_temp);
	WR_desc(&e3d_image,"EQUINOX",FLOAT,1,f_temp);

	

	close_E3D_frame(&e3d_image);

	printf("Ok\n");

	/*
	  Reading the saved data on the output file...
	*/


	printf("Checking the saved image: %s\n",output_filename);
	fflush(stdout);
	open_E3D_frame(&e3d_image,output_filename,"I");
	printf("Ok\n");

	printf("Testing the reading of the HEADER\n");
	i_temp[0]=0;
	if(!RD_desc(&e3d_image,"NAXIS2",INT,1,i_temp)) {
	  printf("No NAXIS2 definied, error\n");	  
	  exit_session(0);
	  return(0);
	}	
	nb_spec=0;
	nb_spec=i_temp[0];
	if (nb_spec==npix_p[1]) {
	  printf("OK %d,%d\n",nb_spec,npix_p[1]);
	} else {
	  printf("Header not correctly readed...\n");
	}


	get_spectra_ID(&e3d_image,nol);
	printf("Reading Euro3D values spectrum by spectrum ...");
	fflush(stdout);
	
	for (specId=1;specId<=npix_p[1];specId++) {
	  
		get_E3D_spec(&e3d_image,&signal,NULL,nol[specId-1]); 
		for (j=0;j<signal.npts;j++) {
		  if (RD_spec(&signal,j)!=data[j+(specId-1)*npix_p[0]])
		    error=1;
		}
		
		
	}
	if (error==0) {
	  printf("Ok\n");
	} else {
	  printf("***** THE EURO3D FILES DOES NOT MATCH THE ORIGINAL FILE *******\n");
	}

	/* Testing the groups */
	n_grupos=0;
	get_E3D_groups(&e3d_image,&n_grupos,&grupos);
	printf("n_grupos=%d\n",n_grupos);
	for (j=0;j<n_grupos+1;j++) {
	  printf("%d, %s, %4.2f, %5.2f, %4.2f, %10.2f, %5.3f, %5.2f, %6.2f, %4.2f\n",
		 grupos[j].groupId,
		 grupos[j].shape,
		 grupos[j].size1,
		 grupos[j].angle,
		 grupos[j].size2,
		 grupos[j].poswav,
		 grupos[j].airmass,
		 grupos[j].parang,
		 grupos[j].pressure,
		 grupos[j].temperature);
	}

	printf("closing previous datacube ...\n");
	fflush(stdout);
	close_E3D_frame(&e3d_image);

	free(data);
	exit_session(0);
	return(0);

	
}

