/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  1993 Observatoire de Lyon - St Genis Laval (France)
! IDENT        check_table_io.c
! LANGUAGE     C
! AUTHOR       A. Rousset
! KEYWORDS     
! PURPOSE      Facility to check interfaces with Midas 
! COMMENT      
! VERSION      4.0  1993-May-12 : Creation, AR
-----------------------------------------------------------------------------*/

#include <IFU_io.h>

/*-----------------------------------------------------------------------------
!
!.blk               Checking of the interface with Midas sessions 
!
!.prog                             check_table_io()
!
!.purp      		    Checks each table i/O routines
!
-----------------------------------------------------------------------------*/
#define NBROW 1000
#define NBCOL 5

int
main(int argc, char **argv)
{
	int nocol_short, nocol_long, nocol_float, nocol_double, nocol_char;
	char **argval, **arglabel;
	int i, nbrow = NBROW, nbcol=NBCOL;
	short sval, s_colbuf[NBROW];
	long lval, l_colbuf[NBROW];
	float fval, f_colbuf[NBROW];
	double dval, d_colbuf[NBROW];
	char text[20];
	char ident[20];
	char Rtext[20];
	char c_colbuf[NBROW*20];
	char input_file[80],out_file[80];
	float *x,*y;
	FILE *fichero;
	int n_rows;
	TABLE table;

	int colID_x,colID_y,colID_start,colID_end,colID_no;
	float start,end;
	int no;
	
	

						/*  init_session() checking */	


	printf("IOLIB environment routines :\n\n");
	fflush(stdout);

	set_arglist("-if|inputfile none -of|outputfile -n_rows none");
	init_session(argv,argc,&arglabel,&argval);
/* 	set_control_level(WARNING); */



	for (i=0; i<3; i++) {
	  if ((strstr(arglabel[i],"-if"))||(strstr(arglabel[i],"-inputfile"))) {
	    strcpy(input_file,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-of"))||(strstr(arglabel[i],"-outfile"))) {
	    strcpy(out_file,argval[i]);
	  }
	  if (strstr(arglabel[i],"-n_rows")) {
	    //	    n_rows=floor(atof(argval[i]));
	    n_rows=atoi(argval[i]);
	  }
	}

	printf("NRoWs=%d\n",n_rows);
	

        x = (float *)malloc((n_rows)*sizeof(float));
        y = (float *)malloc((n_rows)*sizeof(float));



	fflush(stdout);
	printf("Opening table: %s\n",input_file);
	open_table(&table,input_file,"I");
	printf("Ok\n");
	fflush(stdout);


	colID_x=get_col_ref(&table,"A");
	colID_y=get_col_ref(&table,"D");
	colID_start=get_col_ref(&table,"START");
	colID_end=get_col_ref(&table,"END");
	colID_no=get_col_ref(&table,"NO");

	for (i=0; i<n_rows; i++) {
		RD_tbl(&table,i,colID_x,&x[i]);
		RD_tbl(&table,i,colID_y,&y[i]);
		RD_tbl(&table,i,colID_start,&start);
		RD_tbl(&table,i,colID_end,&end);
		RD_tbl(&table,i,colID_no,&no);
		x[i]=(-1)*x[i];
		printf("%d %f %f 1\n",no,x[i],y[i]);
	}
	printf("Ok\n");

        close_table(&table);
	exit_session(0);
	return(0);
}
