/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  2002 AIP, Potsdam, Germany
! IDENT        pmas2Euro3D.c
! LANGUAGE     C
! AUTHOR       S.F.Sanchez
! KEYWORDS     
! PURPOSE      Facility to Visualize Euro3D data
! COMMENT      1st prototype
! VERSION      0.1  2002-Dec-17 : Creation, SF.
------------------------------------------------------------------------------*/

#include <stdio.h> //For Standard I/O
#include <stdlib.h> //For Functions like ATOI
#include <ctype.h> //For Type check
#include <string.h> //For String manipulation
#include <math.h> //For Math functions
#include <IFU_io.h> //For Lyon I/O Library
#include <data_io.h> //For Lyon I/O data

/*
 To use PGPLOT
 */

#include <cpgplot.h> // PGPLOT


//#include "stats.h"



/*-----------------------------------------------------------------------------
!
!.blk          Reads an Euro3D data file and plot a raw frame
!
!.prog                             VEuro3D()
!
!.purp         Facility to Visualize Euro3D data
!
-----------------------------------------------------------------------------*/

#define NB_SPEC 256
#define NPIX 1024

void main(int argc, char **argv);
void imageplot(float* data,float datamin, float datamax, int l_naxes[2],int id, char *title);
void specplot(float* data, float datamin, float datamax, int npix, double start_w, double delta_w);
void setvp(void);
float minimun(float a, float b);
float maximun(float a, float b);
void palett(int type, float contra, float bright);
void fiddle(int l_naxes[2], char* ch, int* real_x, int* real_y, int old_x, int old_y);

int id1,id2,id3,id4;
int id_w;
int p=2;
float contra=0.8;
float bright=0.4;
float sign=1.0;
int mode=0;




int get_group(E3D_file *frame, GROUP *grupo, int j)
{
  //  printf("%d %d %d\n",frame->ngroups,j,frame->ngroups);
  if ((frame->ngroups!=0)&&(j<=frame->ngroups)) {
	 grupo->groupId=frame->groups[j].groupId;
	 grupo->shape=frame->groups[j].shape;
	 grupo->size1=frame->groups[j].size1;
	 grupo->size2=frame->groups[j].size2;
	 grupo->angle=frame->groups[j].angle;
	 grupo->poswav=frame->groups[j].poswav;
	 grupo->parang=frame->groups[j].parang;
	 grupo->pressure=frame->groups[j].pressure;
	 grupo->temperature=frame->groups[j].temperature;
  } else {
    	grupo->groupId=1;
	grupo->shape='S';
	grupo->size1=50; //miliArcseconds?
	grupo->size2=50; //miliArcseconds??
	grupo->angle=0;
	grupo->poswav=0.0;
	grupo->airmass=1.0;
	grupo->parang=0.0;
	grupo->pressure=700;
	grupo->temperature=30;
  }
  return(0);
}


void plot_spaxels(int color_index,float x_c, float y_c, GROUP group) {
  //  float x_c,y_c;
  int j,i;
  float angle;
  float size1,size2;
  int shape;

  size1=(float)group.size1/100.0;
  size2=(float)group.size2/100.0;

  if (size1==0.0) size1=0.5;

  //  printf("%f, %f, %f,%f\n",x_c,y_c,size1,size2);
  angle=((float)group.angle)/180*3.14159;

  cpgsci(color_index);
  shape=toupper(group.shape);
  //printf("%d %d\n",shape,group.shape);
  if (shape==1075052544) {
    shape=83;
  }
  switch(shape) {
  case(83): {
    if (angle==0.0) {
      cpgrect(x_c-size1/2,x_c+size1/2,y_c-size1/2,y_c+size1/2);
    } else {
      float xp[4],yp[4];
      float x[4],y[4];
      xp[0]=-size1; yp[0]=-size1;
      xp[1]=size1; yp[1]=-size1;
      xp[2]=size1; yp[2]=size1;
      xp[3]=-size1; yp[3]=size1;
      for (i=0;i<4;i++) {
	x[i]=x_c+xp[i]*cos(angle)-yp[i]*sin(angle);
	y[i]=y_c+xp[i]*sin(angle)+yp[i]*cos(angle);
      }
      cpgpoly(4,x,y);
    }
    break;
  }
  case('R'): {      
      if (angle==0.0) {
	cpgrect(x_c-size1/2,x_c+size1/2,y_c-size2/2,y_c+size2/2);
      } else {
	float xp[4],yp[4];
	float x[4],y[4];
	xp[0]=-size1; yp[0]=-size2;
	xp[1]=size1; yp[1]=-size2;
	xp[2]=size1; yp[2]=size2;
	xp[3]=-size1; yp[3]=size2;
	for (i=0;i<4;i++) {
	  x[i]=x_c+xp[i]*cos(angle)-yp[i]*sin(angle);
	  y[i]=y_c+xp[i]*sin(angle)+yp[i]*cos(angle);
	}
	cpgpoly(4,x,y);
      }
      break;
  }
  case('C'): {
      cpgcirc(x_c,y_c,size1);
      break;
  }
  default: {
    //      cpgrect(x_c-size1/2,x_c+size1/2,y_c-size1/2,y_c+size1/2);
          cpgcirc(x_c,y_c,size1/2);
    break;
  }
  }
  
  
  
    //    cpgrect(x_c-size1/2,x_c+size1/2,y_c-size1/2,y_c+size1/2);
}




void main(int argc, char **argv)
{
  int window_size;
  float window_aspect;

  int n_colors,nc=200,color_index;
  float x_c,y_c;
  float size1=0.5,size2;


  GROUP group, *groups, fake_group;
  GROUP grupo;
  int n_groups;

  SPAXEL *spax, **spaxels;  
  int *n_spaxels;

  float x_min,y_min,x_max,y_max;

  
	E3D_file e3d_image;
	SPECTRUM signal,noise;
	SPECTRUM *spectra;
	SLICE s_signal;
	IMAGE2D image;
	char **argval, **arglabel;
	int nbal;

	short s_temp[10];
	int i_temp[10];
	float f_temp[10];
	double d_temp[10];
	char str_temp[80];
	char c_temp[10];

	float *raw_data;
	float *raw_spec;
	float *false_data;
	
	/*
	  All the images has an initial BITPIX.
	  It will be stored in this initial BITPIX,
	  but the data will be internally managed as DOUBLE
	  not to reduce the precision on none of them.
	*/
	short bitpix; // Variable that stores the initial BITPIX value.
	char euro3d;

	/* Euro3D variables */
	int specId, i,j,k, npix, nb_spec, status, *nol, nfib;
	double start, step;
	short sval;
	long lval;
	float fval, *x,*y;
	double dval;
	char *format;
	/* General variables */
	char input_filename[80], output_filename[80], author[80], origin[80];
	char ref[80],date[80],date_obs[80],object[80],observer[80],telescope[80];
	float equinox;
	int error=0;
	float min,max,mean,sigma,min_i,max_i;
	int naxes[2],daxes[2];
	int npix_int;
	double start_w, end_w, delta_w;
	
	/* PGPLOT needed varibles */
	char answer_now;
	char answer[10];    
	int answer_len = sizeof(answer);
	int real_x,real_y,old_x,old_y;

	//	npix[0]=1024;
	

	/* Read a PMAS file header */

	

	set_arglist("-if|inputfile none -nfib|nfibers 0 -npalette 2 -min 0 -max 0");
	printf("Euro3D visualization tool, V0.0:\n\n");
	init_session(argv,argc,&arglabel,&argval);

	set_control_level(WARNING);

	nfib=0;
	for (i=0; i<5; i++) {
	  if ((strstr(arglabel[i],"-if"))||(strstr(arglabel[i],"-inputfile"))) {
	    strcpy(input_filename,argval[i]);
	  }
	  if ((strstr(arglabel[i],"-nfib"))||(strstr(arglabel[i],"-nfibers"))) {
	    nfib=atoi(argval[i]);
	  }
	  if (strstr(arglabel[i],"-npalette")) {
	    p=atoi(argval[i]);
	    if (p>5)
	      p=1;
	    if (p<1)
	      p=5;

	  }
	  if (strstr(arglabel[i],"-min")) {
	    min_i=atof(argval[i]);
	  }
	  if (strstr(arglabel[i],"-max")) {
	    max_i=atof(argval[i]);
	  }

	  /*
	  if (strstr(arglabel[i],"-size1")) {
	    size1=atof(argval[i]);
	  }
	  */
	}
	
	/*
	  checking the format of the file
	*/
	format = file_format(argval[0]);
	//	printf("format %s\n",format[0]);
	if ((format[0]!=FITS_B_FORMAT)&&(format[1]!=TBL_TYPE)) {
	  printf("The file does not seem to conform the Euro3D data format\n");	  	  
	}


	/*
	  Reading the data on the output file...
	*/
	printf("Opening the image: %s\n",input_filename);
	fflush(stdout);
	open_E3D_frame(&e3d_image,input_filename,"I");
	printf("Ok\n");
	nb_spec=e3d_image.nbspec;

	printf("Printing GROUPS information\n");
	printf("NGROUPS=%d\n",e3d_image.ngroups);
	for (j=0;j<e3d_image.ngroups;j++) {
	  printf("TYPE=%s\n",e3d_image.groups[j].shape);
	  printf("SIZE1=%d\n",	e3d_image.groups[j].size1); 
	  printf("SIZE2=%d\n",	e3d_image.groups[j].size2); 
	  printf("airmass=%f\n",	e3d_image.groups[j].airmass); 
	}

	printf("Reading the Header of the file %s\n",input_filename);
	//	fflush(stdout);

	
	if(!RD_desc(&image,"EURO3D",CHAR,10,s_temp)) {
	   printf("No EURO3D definied, error\n");	  
	   exit_session(0);
	   return(0);
	 }
	euro3d=s_temp[0];
	printf("Euro3D = %s\n",euro3d);
	
	/*
	if(!RD_desc(&e3d_image,"NAXIS2",INT,1,i_temp)) {
	  printf("No NAXIS2 definied, error\n");	  
	  exit_session(0);
	  return(0);
	}		
	nb_spec=i_temp[0];
	*/
	if ((nfib!=0)||(nb_spec==0)) {
	  nb_spec=nfib;
	  if (nb_spec==0) {
	    nb_spec=256;
	  }
	  printf("nb_spec forced to %d\n",nb_spec);
	}
	

	nol = (int *)malloc(nb_spec*sizeof(int));  
	x = (float *)malloc(nb_spec*sizeof(float));  
	y = (float *)malloc(nb_spec*sizeof(float));  
	
	spaxels = (SPAXEL *)malloc(nb_spec*sizeof(SPAXEL));
	n_spaxels = (int *)malloc(nb_spec*sizeof(int));  

	printf("Ok\n");
	fflush(stdout);

	printf("Reading common parameters\n");
	get_common_param(&e3d_image,&npix_int,&start_w,&end_w);	
	printf("%d,%f,%f\n",npix_int,start_w,end_w);
	delta_w=(end_w-start_w)/npix_int;

	get_spectra_ID(&e3d_image,nol);
	printf("Reading Euro3D values spectrum by spectrum ...");
	fflush(stdout);	
	min=3000000;
	max=-3000000;
	naxes[1]=nb_spec;
	spectra = (SPECTRUM *)malloc(nb_spec*sizeof(SPECTRUM));  
	x_min=10000;
	y_min=10000;
	x_max=-10000;
	y_max=-10000;
	for (specId=1;specId<=nb_spec;specId++) {	 
	  /*
	    We get the spaxels information!!!
	  */
	  n_spaxels[specId]=get_E3D_spaxels(&e3d_image,specId,&spaxels[specId]);
	  
	  for (j=0;j<n_spaxels[specId];j++) {
	    if (x_min>spaxels[specId][j].xpos) x_min=spaxels[specId][j].xpos;
	    if (x_max<spaxels[specId][j].xpos) x_max=spaxels[specId][j].xpos;
	    if (y_min>spaxels[specId][j].ypos) y_min=spaxels[specId][j].ypos;
	    if (y_max<spaxels[specId][j].ypos) y_max=spaxels[specId][j].ypos;

	    //	    printf("Spaxel %d of Spec %d, (%f,%f), grup=%d\n",j,specId,spaxels[specId][j].xpos,spaxels[specId][j].xpos,spaxels[specId][j].group);
 
	  }
	  

	  /*
	    We get the spectra information.
	  */
	  //signal=e3d_image.signal[nol[specId-1]];
	  get_E3D_spec(&e3d_image,&signal,NULL,nol[specId-1]); 
	  spectra[specId-1]=signal;
	  if (specId==1) {
	    npix=signal.npts;
	    naxes[0]=npix;
	    raw_data = (float *)malloc((npix*nb_spec)*sizeof(float));  
	    if (npix_int!=npix) {
	      printf("There is some error in the determination of the number of pixels\n");
	      printf("npix=%d!=%d\n",npix,npix_int);
	    }
	  }
	  for (j=0;j<signal.npts;j++) {
	    raw_data[j+(specId-1)*npix]=RD_spec(&signal,j);
	    if (min>raw_data[j+(specId-1)*npix]) 
	      min=raw_data[j+(specId-1)*npix];
	    if (max<raw_data[j+(specId-1)*npix]) 
	      max=raw_data[j+(specId-1)*npix];
	  }		
	}
	if (min_i!=0.0) 
	  min=min_i;
	if (max_i!=0.0) 
	  max=max_i;



	printf("Ok\n");
	printf("closing previous datacube ...\n");
	fflush(stdout);
	close_E3D_frame(&e3d_image);


	answer_now=' ';
	while((toupper(answer_now)!='Q')) {
	  answer_now=getc(stdin);
	  
	}
	exit(0);

	/*
	  Now we need to plot the data!
	*/
	//	printf("dato=%f\n",e3d_image.signal[0].npix);

	/*
	 * We open the devices we are going to use.
	 */
	id1=cpgopen("/xwin");
	printf("F=%f\n",(float)nb_spec/(float)npix_int);
	window_size=3*floor((float)nb_spec/1024);
	if (window_size>10) window_size=10;
	window_aspect=0.7*(float)nb_spec/(float)npix_int;
	//	if (window_aspect<0.5) window_aspect=0.5;
	//	if (window_aspect>1.0) {
	  //window_size=floor((float)window_size/(0.5*window_aspect));
	//  window_aspect=1.0;
	//}
	if (((float)window_size*window_aspect>15)) {
	  window_aspect=(float)window_size/15;
	}
	printf("WINDOW=%d,%f\n",window_size,window_aspect);
	cpgpap(window_size,window_aspect);
	cpgask(0);
	cpgsubp(1,1);
	cpgpanl(1,1);		   
	imageplot(raw_data,min,max,naxes,id1,"Euro3D raw data");	
	
	printf("Options:\n");
	printf("Press 'Q' to quit\n");
	printf("Press 'R' to read the intensity in a point\n");
	printf("Press 'P' to change the palette\n");
	printf("Press 'F' to change the bright and contrast and reaload the image\n");
	printf("Press 'G' to change the bright and contrast (Only in PseudoColor Computers)\n");
	printf("Press 'S' to plot a Spectrum\n");
	printf("Press 'M' to plot a Monochromatic Image\n");
	printf("Press 'N' to plot a Monochromatic Image\n");
		
	answer_now=' ';
	while((toupper(answer_now)!='Q')) {
	  fiddle(naxes, &answer_now,&real_x,&real_y, old_x, old_y);
	  switch(toupper(answer_now)) {
	  case('R'): {
	    if ((real_x<npix)&&(real_x>0)&&(real_y<nb_spec)&&(real_y>0)) {
	      printf("I(%d,%d)=%f\n",real_x,real_y,raw_data[real_x+real_y*npix]);
	    } else {
	      printf("Out of borders\n");
	    }
	    break;
	  }
	  case('P'): {
	    p++;
	    if (p>5) {
	      p=1;
	    }
	    color_palett(p,sign*contra,bright,nc);
	    palett(p,sign*contra,bright);
	    imageplot(raw_data,min,max,naxes,id1,"Euro3D raw data");	
	    break;
	  }
	  case('F'): {
	    color_palett(p,sign*contra,bright,nc);
	    palett(p,sign*contra,bright);
	    imageplot(raw_data,min,max,naxes,id1,"Euro3D raw data");	
	    cpgmove((float)old_x/naxes[0],(float)old_y/naxes[1]);
	    break;
	  }
	    

	case('S'): {
	  if(!id2) {
	    id2=cpgopen("/xterm");
	    cpgask(0);
	  } else {
	    cpgslct(id2);
	  }
	  if ((real_y<nb_spec)&&(real_y>0)) {
	    raw_spec = (float *)malloc(npix*sizeof(float));  
	    for (j=0;j<spectra[real_y].npts;j++) {
	      raw_spec[j]=RD_spec(&spectra[real_y],j);
	      //	      printf ("%d,%f\n",j,raw_spec[j]);
	    }
	    specplot(raw_spec, min, max, npix, start_w, delta_w);
	    free(raw_spec);
	  } else {
	    printf("Out of borders\n");
	  }
	  


	  cpgslct(id1);
	  break;
	}


	case('M'): {
	  if(!id3) {
	    id3=cpgopen("/xwin");
	    cpgpap(5,1);
	    cpgask(0);
	  } else {
	    cpgslct(id3);
	  }
	  cpgenv(x_min-1.0,x_max+1.0,y_min-1.0,y_max+1.0,0,0);
	  cpglab("X", "Y", "test");
	  color_palett(p,sign*contra,bright,nc);
	  for (specId=0;specId<nb_spec;specId++) {	    
	    n_colors=nc*contra;	   	    
	    color_index=16+floor((raw_data[real_x+specId*npix]-min)/(max-min)*(n_colors-1));
	    cpgsci(color_index);

	    //	    spax=spaxels[specId];
	    for (j=0;j<n_spaxels[specId];j++) {
	      x_c=spaxels[specId][j].xpos;
	      y_c=spaxels[specId][j].ypos;
	      get_group(&e3d_image,&grupo,spaxels[specId][j].group-1);	      
	      plot_spaxels(color_index,x_c,y_c,grupo);
	    }

	      /*
	    for (j=0;j<n_spaxels[specId];j++) {
	      x_c=spaxels[specId][j].xpos;
	      y_c=spaxels[specId][j].ypos;
	      cpgrect(x_c-size1/2,x_c+size1/2,y_c-size1/2,y_c+size1/2);
	    }
	      */
	  }
	  cpgslct(id1);
	  break;

	}

	case('N'): {
	  if(!id4) {
	    id4=cpgopen("/CPS");
	    cpgpap(5,1);
	    cpgask(0);
	  } else {
	    cpgslct(id4);
	  }
	  cpgenv(x_min-1.0,x_max+1.0,y_min-1.0,y_max+1.0,0,0);
	  cpglab("X", "Y", "test");
	  color_palett(p,sign*contra,bright,nc);
	  for (specId=0;specId<nb_spec;specId++) {	    
	    n_colors=nc*contra;	   	    
	    color_index=16+floor((raw_data[real_x+specId*npix]-min)/(max-min)*(n_colors-1));
	    cpgsci(color_index);

	    //	    spax=spaxels[specId];
	    for (j=0;j<n_spaxels[specId];j++) {
	      x_c=spaxels[specId][j].xpos;
	      y_c=spaxels[specId][j].ypos;
	      get_group(&e3d_image,&grupo,spaxels[specId][j].group-1);	      
	      plot_spaxels(color_index,x_c,y_c,grupo);
	    }

	      /*
	    for (j=0;j<n_spaxels[specId];j++) {
	      x_c=spaxels[specId][j].xpos;
	      y_c=spaxels[specId][j].ypos;
	      cpgrect(x_c-size1/2,x_c+size1/2,y_c-size1/2,y_c+size1/2);
	    }
	      */
	  }
	  cpgslct(id1);
	  break;

	}

	case('L'): {
	  if(!id3) {
	    id3=cpgopen("/xwin");
	    cpgpap(5,1);
	    cpgask(0);
	  } else {
	    cpgslct(id3);
	  }
	  cpgenv(x_min-1.0,x_max+1.0,y_min-1.0,y_max+1.0,0,0);
	  cpglab("X", "Y", "test");
	  color_palett(p,sign*contra,bright,nc);
	  for (i=0;i<npix;i++) {
	    for (specId=0;specId<nb_spec;specId++) {	    
	      n_colors=nc*contra;	   	    
	      color_index=16+floor((raw_data[i+specId*npix]-min)/(max-min)*(n_colors-1));
	      cpgsci(color_index);
	    for (j=0;j<n_spaxels[specId];j++) {
	      x_c=spaxels[specId][j].xpos;
	      y_c=spaxels[specId][j].ypos;
	      get_group(&e3d_image,&grupo,spaxels[specId][j].group-1);	      
	      plot_spaxels(color_index,x_c,y_c,grupo);
	    }
	    /*
	      for (j=0;j<n_spaxels[specId];j++) {
		x_c=spaxels[specId][j].xpos;
		y_c=spaxels[specId][j].ypos;
		cpgrect(x_c-size1/2,x_c+size1/2,y_c-size1/2,y_c+size1/2);
		//Here should be the GROUPs stuff, actually only rectangles are plotted!
	      }
	    */
	      //	      printf("ok\n");
	    }
	  }
	  cpgslct(id1);
	  break;
	}
	  }


	  old_x=real_x;
	  old_y=real_y;
	  }

	
	cpgend();	
	free(raw_data);
	exit_session(0);
	return(0);	
}

/*
 Subroutine that plots a spectrum
*/

void specplot(float* data, float datamin, float datamax, int npix, double start_w, double delta_w) {
  float *x,*y;
  int i,j;

  if (start_w==0.0)
    start_w=1.0;
  if (delta_w==0.0)
    delta_w=1.0;

  x = (float *)malloc(npix*sizeof(float));  
  y = (float *)malloc(npix*sizeof(float));  
  for (i=0;i<npix;i++) {
    x[i]=(float)start_w+(float)delta_w*i;
    y[i]=data[i];
    //    printf("%f,%f,%f,%f\n",start_w,delta_w,x[i],y[i]);
  }
  
  cpgpage();	
  cpgenv(x[0],x[npix-1],datamin,datamax,0,0);
  cpglab("\\gLambda", "Flux", "Spectra");	  
  cpgsls(1);
  cpgpt(npix,x,y,1);
  cpgline(npix,x,y);
  
}


/*
 Subroutine that plot the image.
*/
void imageplot(float* data, float datamin, float datamax, int l_naxes[2], int id, char *title) {
  float tr[]={0.0,1.0,0.0,0.0,0.0,1.0};
  /*
   * We select a certain device
   */
  cpgslct(id);
  cpgpage();
  setvp();
  cpgwnad(0.0,1.0+l_naxes[0],0.0,1.0+l_naxes[1]);
  /* Defines the original palette */
  palett(p,sign*contra,bright);
  /* Plot the image */
  cpgimag(data,l_naxes[0],l_naxes[1],1,l_naxes[0],1,l_naxes[1],datamin,datamax,tr);
  cpgmtxt("t",1.0,0.0,0.0,title);
  cpgsch(0.6);
  cpgbox("bcntsi",0.0,0,"bcntsiv",0.0,0);
  cpgmtxt("b",3.0,1.0,1.0,"pixel number");
  /* Draws the Scale */
  cpgwedg("BI",4.0,5.0,datamin,datamax,"pixel value");
  cpgsch(1.0);
}

void setvp() {
  float d, vpx1, vpx2, vpy1, vpy2;
  cpgsvp(0.0,1.0,0.0,1.0);
  cpgqvp(1,&vpx1,&vpx2,&vpy1,&vpy2);
  d=minimun(vpx2-vpx1,vpy2-vpy1)/40.0;
  vpx1=vpx1+5.0*d;
  vpx2=vpx2-2.0*d;
  vpy1=vpy1+8.0*d;
  vpy2=vpy2-2.0*d;
  cpgvsiz(vpx1,vpx2,vpy1,vpy2);
  return;
}



float minimun(float a, float b) {
  float c;
  if (a<b) {
    c=a;
  } else {
    c=b;
  }
  return c;
}

float maximun(float a, float b) {
  float c;
  if (a>b) {
    c=a;
  } else {
    c=b;
  }
  return c;
}

/*
 * This subrutine changes the palette.
 * It is very useful, since it has the colour ranges.
 */

void palett(int type, float contra, float bright){
  
  float GL[]={0.0, 1.0};
  float GR[]={0.0, 1.0};
  float GG[]={0.0, 1.0};
  float GB[]={0.0, 1.0};
  
  float RL[]={-0.5, 0.0, 0.17, 0.33, 0.50, 0.67, 0.83, 1.0, 1.7};
  float RR[]={ 0.0, 0.0,  0.0,  0.0,  0.6,  1.0,  1.0, 1.0, 1.0};
  float RG[]={ 0.0, 0.0,  0.0,  1.0,  1.0,  1.0,  0.6, 0.0, 1.0};
  float RB[]={ 0.0, 0.3,  0.8,  1.0,  0.3,  0.0,  0.0, 0.0, 1.0};
  
  float HL[]={0.0, 0.2, 0.4, 0.6, 1.0};
  float HR[]={0.0, 0.5, 1.0, 1.0, 1.0};
  float HG[]={0.0, 0.0, 0.5, 1.0, 1.0};
  float HB[]={0.0, 0.0, 0.0, 0.3, 1.0};
  
  float WL[]={0.0, 0.5, 0.5, 0.7, 0.7, 0.85, 0.85, 0.95, 0.95, 1.0};
  float WR[]={0.0, 1.0, 0.0, 0.0, 0.3,  0.8,  0.3,  1.0,  1.0, 1.0};
  float WG[]={0.0, 0.5, 0.4, 1.0, 0.0,  0.0,  0.2,  0.7,  1.0, 1.0};
  float WB[]={0.0, 0.0, 0.0, 0.0, 0.4,  1.0,  0.0,  0.0, 0.95, 1.0};
  
  float AL[]={0.0, 0.1, 0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.5,
     0.5, 0.6, 0.6, 0.7, 0.7, 0.8, 0.8, 0.9, 0.9, 1.0};
  float AR[]={0.0, 0.0, 0.3, 0.3, 0.5, 0.5, 0.0, 0.0, 0.0, 0.0,
	      0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
  float AG[]={0.0, 0.0, 0.3, 0.3, 0.0, 0.0, 0.0, 0.0, 0.8, 0.8,
	      0.6, 0.6, 1.0, 1.0, 1.0, 1.0, 0.8, 0.8, 0.0, 0.0};
  float AB[]={0.0, 0.0, 0.3, 0.3, 0.7, 0.7, 0.7, 0.7, 0.9, 0.9,
	      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

  switch(type) {
  case (1): {
    /* Grey */
    cpgctab(GL, GR, GG, GB, 2, contra, bright);
    break;
  }
  case (2): {
    /* Rainbow */
    cpgctab(RL, RR, RG, RB, 9, contra, bright);
    break;
  }
  case (3): {
    /* Heat */
    cpgctab(HL, HR, HG, HB, 5, contra, bright);
    break;
  }
  case (4): {
    /* Weird IRAF */
    cpgctab(WL, WR, WG, WB, 10, contra, bright);
    break;
  }
  case (5): {
    /* AIPS */
    cpgctab(AL, AR, AG, AB, 20, contra, bright);
    break;
  }
  default: {
    cpgctab(GL, GR, GG, GB, 2, contra, bright);
    break;
  }
  }
  
}


void fiddle(int l_naxes[2], char* ch, int* real_x, int* real_y, int old_x, int old_y) {
  int ier;
  //,pgcurs;
  float x,y;
  float x1,y1,x2,y2,b1,b2,c1,c2;
  
//  int real_x,real_y;
//  char ch[10];

//  float *xx,*yy;
  int fuera=0;

  /*
  p=2;
  contra=0.8;
  bright=0.4;
  */
  x=0.5;
  y=1.0;
  sign=1;
  cpgqwin(&x1,&x2,&y1,&y2);
  b1=0.0;
  b2=1.0;
  c1=0.0;
  c2=1.0;
  cpgswin(b1,b2,c1,c2);



  //  ier=cpgcurs(&x,&y,ch);
  while((toupper(ch[0])!='Q')&&(fuera==0)) {

    if(ier=cpgband(mode,0,(float)(old_x/l_naxes[0]),(float)(old_y/l_naxes[1]),&x,&y,ch)){
      *real_x=(int) (l_naxes[0]*x);
      *real_y=(int) (l_naxes[1]*y);
      
      if (*real_x<0) *real_x=0;
      if (*real_x>l_naxes[0]) *real_x=l_naxes[0];
      if (*real_y<0) *real_y=0;
      if (*real_y>l_naxes[1]) *real_y=l_naxes[1];
      

      switch(toupper(ch[0])) {
      case('Z'): {
	fuera=1;
	break;
      }
      case('W'): {
	fuera=1;
	break;
      }
      case('O'): {
	fuera=1;
	break;
      }
      case('R'): {
	fuera=1;
	break;
      }
      case('S'): {
	fuera=1;
	break;
      }
      case('V'): {
	fuera=1;
	break;
      }
      case('M'): {
	fuera=1;
	break;
      }
      case('L'): {
	fuera=1;
	break;
      }
      case('D'): {
	fuera=1;
	break;
      }
      case('B'): {
	fuera=1;
	break;
      }
      case('N'): {
	fuera=1;
	break;
      }
      case('E'): {
	fuera=1;
	break;
      }
      case('C'): {
	fuera=1;
	break;
      }
      case('G'): {
	bright= maximun(b1,minimun(b2,x));
	contra= maximun(c1,minimun(c2,y));
	palett(p,sign*contra,bright);
	break;
      }
      case('I'): {
	fuera=1;
	break;
      }
      case('Q'): {
	cpgswin(x1,x2,y1,y2);
	break;
      }
      case('F'): {
	bright= maximun(b1,minimun(b2,x));
	contra= maximun(c1,minimun(c2,y));
	fuera=1;
	break;
      }
      case(';'): {
	contra=1.0;
	y=1.0;
	bright=0.5;
	x=0.5;
	break;
      }
      case('U'): {
	printf("c=%f,b=%f\n",contra,bright);
	break;
      }
      case('-'): {
	sign=-sign;
	break;
      }
      case('1'): {
	p=1;
	break;
      }
      case('2'): {
	p=2;
	break;
      }
      case('3'): {
	p=3;
	break;
      }
      case('4'): {
	p=4;
	break;
      }
      case('5'): {
	p=5;
	break;
      }
      case('P'): {
	fuera=1;
	break;
      }
      }
      palett(p,sign*contra,bright);

    }
//    ier=cpgcurs(&x,&y,ch);
  }
}

/*
 * This function determine the values over the Fourier serie
 * considering angles in Degrees
 */




