#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include <tk.h>

#include "tkpgplot.h"
#include "cpgplot.h"



static int create_window(ClientData data, Tcl_Interp *interp, int argc, char *argv[]);
static int Demo_AppInit(Tcl_Interp *interp);
static void display_message(int device_id, char *text);
int open_device(Tcl_Interp *interp, char *device);
static close_device(int device_id);
int new_window(Tcl_Interp *interp, char *caller, char *cmd, char *device);


/**********************************************************************
 * Different funcions associated with the TK_Commands
 **********************************************************************/
static int window_instance_command(ClientData data, Tcl_Interp *interp,
			       int argc, char *argv[]);
static int message_command(Tcl_Interp *interp, int argc, char *argv[]); 
static int server_command(Tcl_Interp *interp, int argc, char *argv[]); 

/*.......................................................................
 * After presenting a warning if the first argument is not the name
 * of the demo Tcl script, main() simply calls the standard Tk_Main()
 * to initialize Tcl/Tk and the demo package.
 * Input:
 *  argc     int    The number of command line arguments.
 *  argv    char*[] The array of command-line argument strings.
 * Output:
 *  return   int    0 - OK.
 *                  1 - Error.
 */
int main(int argc, char *argv[])
{
  char *usage = "Usage: tk_test tk_test.tcl [tk-options].\n";
/*
 * Check whether the first argument names a valid pgtkdemo
 * script file.
 */
  if(argc < 2 || *argv[1] == '-') {
    fprintf(stderr, usage);
    return 1;
  };
/*
 * Start the application.
 */
  Tk_Main(argc, argv, Demo_AppInit);
  return 0;
}


/*.......................................................................
 * This dummy fortran main allows pgtkdemo to be linked with the
 * f2c-compiled pgplot library.
 */
int MAIN__(void)
{
}

/*.......................................................................
 * This is the application initialization file that is called by Tk_Main().
 */
static int Demo_AppInit(Tcl_Interp *interp)
{
/*
 * Create the standard Tcl and Tk packages, plus the TkPgplot package.
 */
  if(Tcl_Init(interp)    == TCL_ERROR ||
     Tk_Init(interp)     == TCL_ERROR ||
     Tkpgplot_Init(interp) == TCL_ERROR)
    return 1;
/*
 * Create the TCL command used to initialization the demo.
 */
  Tcl_CreateCommand(interp, "create_window", create_window,
		    (ClientData) Tk_MainWindow(interp), (Tcl_CmdDeleteProc *) NULL);
  return 0;
}

/*.......................................................................
 * This function provides the TCL command that creates a pgdemo
 * manipulation command. This opens the two given PGPLOT widgets to
 * PGPLOT, establishes a cursor handler and records the state of the
 * demo in a dynamically allocated container.
 *
 * Input:
 *  data      ClientData    The main window cast to ClientData.
 *  interp    Tcl_Interp *  The TCL intrepreter of the demo.
 *  argc             int    The number of command arguments.
 *  argv            char ** The array of 'argc' command arguments.
 *                          argv[0] = "create_window"
 *                          argv[1] = The name to give the new command.
 *                          argv[2] = The name of the image widget.
 *                          argv[3] = The name of the slice widget.
 * Output:
 *  return           int    TCL_OK    - Success.
 *                          TCL_ERROR - Failure.
 */
static int create_window(ClientData data, Tcl_Interp *interp, int argc,
			 char *argv[])
{
  int dev_id;
  //  Pgdemo *demo;      /* The new widget instance object */
/*
 * Check that the right number of arguments was provided.
 */
  if(argc != 3) {
    Tcl_AppendResult(interp,
	     argv[0], ": Wrong number of arguments - should be \'",
	     argv[0], " new_command_name image_widget\'", NULL);
    return TCL_ERROR;
  };
/*
 * Allocate a context object for the command.
 */

  dev_id=new_window(interp, argv[0], argv[1], argv[2]);
  if(!dev_id)
    return TCL_ERROR;
  return TCL_OK;
}

/********************************************************************
 * Creates a new device
 ********************************************************************/

int open_device(Tcl_Interp *interp, char *device) {
  int dev_id;
  
  if (!(dev_id = cpgopen(device))) {
    Tcl_AppendResult(interp, "Unable to open widgets: ", device, NULL);
    return close_device(dev_id);
  };
  return dev_id;
}


/****************************************************
 * Close the device
 ****************************************************/

static close_device(int device_id) {
  cpgslct(device_id);
  cpgclos();
  return NULL;
}



/*.......................................................................
 * Display a "Please wait" message in the slice window.
 *
 * Input:
 *  demo     Pgdemo *   The demo instance object.
 */
static void display_message(int device_id, char *text)
{
/*
 * Clear the slice plot and replace it with instructional text.
 */
  cpgslct(device_id);
  cpgask(0);
  cpgpage();
  cpgsch(3.0f);
  cpgsvp(0.0, 1.0, 0.0, 1.0);
  cpgswin(0.0, 1.0, 0.0, 1.0);
  cpgmtxt("T", -2.0, 0.5, 0.5, text);

}


int new_window(Tcl_Interp *interp, char *caller, char *cmd, char *image_device) {
  int dev_id;
 
  if ((dev_id=open_device(interp, image_device))<=0) {
    Tcl_AppendResult(interp, "Unable to open widgets: ", image_device, NULL);
  }

  cpgslct(dev_id);

  Tcl_CreateCommand(interp, cmd, window_instance_command,NULL,NULL);
  /*
   * Return the command name.
   */
  Tcl_AppendResult(interp, cmd, NULL);

  return dev_id;
}

static int window_instance_command(ClientData data, Tcl_Interp *interp, int argc, char *argv[]) {

  char *command;

/*
 * We must have at least one command argument.
 */
  if(argc < 2) {
    Tcl_SetResult(interp, "Wrong number of arguments.", TCL_STATIC);
    return TCL_ERROR;
  };
  /*
   * Get the command-name argument.
   */
  command = argv[1];
  if(strcmp(command, "message") == 0)
    return message_command(interp, argc - 2, argv + 2);
  else if(strcmp(command, "server") == 0)
    return server_command(interp, argc - 2, argv + 2);

  //return pgdemo_save_command(demo, interp, argc - 2, argv + 2);
/*
 * Unknown command name.
 */
  Tcl_AppendResult(interp, argv[0], ": Unknown demo command \"",
		   argv[1], "\"", NULL);
  return TCL_ERROR;
}

/*********************************************************************
 * Function that draws a messsage in a certain window
 * 
 *********************************************************************/
static int message_command(Tcl_Interp *interp, int argc, char *argv[]) {
  display_message(atoi(argv[0]),argv[1]);
  //  sprintf(interp->result,"He pintado en la ventana %d",atoi(argv[0]));
  return(0);
}

/*********************************************************************
 *
 *********************************************************************/

static int server_command(Tcl_Interp *interp, int argc, char *argv[]) {



}
