#!/disks/nova13/jfalcon/Programs/Euro3D/e3d-1.2/user/bin/tk_e3d
#
# CHANGE '/home/sanchez/code/v3d/user/bin/' 
# by the current V3D BINARY PATH
#

#set server "/work2/ssa/code/lyon/IFU_C_iolibs-6.0/euro3d/exec/shm_server"

set root "/usr/local/src/v3d-1.0d/"


#################################################
# Procedure to fit the last mean spectra to
# a sigle line plus continnum
#
################################################
proc stats {list} {
    set mean 0
    set stddev 0
    set sum 0
    set n 0
    foreach element $list {
	set sum [expr $sum+$element]
	incr n
    }
    if {$n>0} {
	set mean [expr $sum/$n]
	if {$n>1} {
	    set sum 0
	    foreach element $list {
		set sum [expr $sum+($element-$mean)*($element-$mean)]
	    }
	    set stddev [expr $sum/($n-1)]
	} else {
	    set stddev 0
	}
    } else {
	set mean 0 
	set stddev 0 
    }
    set list_tmp $list
    lsort -real $list_tmp
    set n_med [expr (int([llength $list_tmp]/2)-1)]
    set median [lindex $list_tmp $n_med]
    

    set out {}
    lappend out $mean
    lappend out $stddev
    lappend out $median
    return $out
}

proc abs {w} {
    if {$w<0} {
	set w [expr (-1)*$w]
    }
    return $w
}

proc clean { } {
    global ax1 ax2 amax amin abright acontra asign acolor_map max min bright contra sign color_map out_min_max tmp_j n_slice nb_spec slice_active
    for {set j 0} {$j<$nb_spec} {incr j 1} {
	set ax1($j) 0
	set ax2($j) 1
	set amax($j) $max 
	set amin($j) $min 
	set abright($j) $bright 
	set acontra($j) $contra 
	set asign($j) $sign 
	set acolor_map($j) $color_map 
    }
    set current_obj -1
}

proc clean_spec_list {} {
    global spec_list
    for {set j 0} {$j<10} {incr j 1} {
	$spec_list delete 1
    }    
}

proc clean_obj_list {} {
    global obj_list
    for {set j 0} {$j<10} {incr j 1} {
	$obj_list delete 1
    }    
}

proc fit_single_line {} {
    global min max color_map bright contra sign dev_id3
    set guess [euro3d guess_single_line]
    set n_max_iter 20
    set i_iter 0
    set chisq_min 1.0
    set chisq 10.0
    while {$i_iter<$n_max_iter} {
	set Ig [lindex $guess 0]
	set Lg [lindex $guess 1]
	set Sg [lindex $guess 2]
	set Cg [lindex $guess 3]
	set dIg [expr $Ig*0.5]
	set dLg [expr $Lg*0.001]
	set dSg [expr $Sg*0.5]
	set dCg [expr $Cg*0.5]
	puts "N=$i_iter,GUESS=$guess"
	set guess [euro3d fit_single_line $min $max $dev_id3 $color_map $bright $contra $sign $Ig $dIg 1 $Lg $dLg 1 $Sg $dSg 1 $Cg $dCg 1 $chisq_min -1]
	incr i_iter 1	
	set old_chisq $chisq
	set old_Ig $Ig
	set old_Lg $Lg
	set old_Sg $Sg
	set old_Cg $Cg

	set chisq [lindex $guess 4]
	if {$chisq<$chisq_min} {
	    set i_iter 200
	}
	if {$old_chisq<$chisq} {
	    set i_iter 200
	}
    }
    set guess [euro3d fit_single_line $min $max $dev_id3 $color_map $bright $contra $sign $Ig $dIg 1 $Lg $dLg 1 $Sg $dSg 1 $Cg $dCg 1 $chisq_min 0]
    set Ig [lindex $guess 0]
    set Lg [lindex $guess 1]
    set Sg [lindex $guess 2]
    set Cg [lindex $guess 3]
    set dIg [abs [expr $Ig-$old_Ig]]
    set dLg [abs [expr $Lg-$old_Lg]]
    set dSg [abs [expr $Sg-$old_Sg]]
    set dCg [abs [expr $Cg-$old_Cg]]

    set Flux [expr 2.5066*$Sg*$Ig]
    set FWHM [expr 2.345*$Sg]
    if {$Cg>0} {
	set EW [expr $Flux/$Cg]
    } else {
	set EW 1000
    }
    puts " I_gauss=$Ig+-$dIg\n Cent. Wavelength=$Lg+-$dLg\n Sigma=$Sg+-$dSg\n Continuum=$Cg+-$dCg\n Chisq=$chisq\n\n Flux=$Flux FWHM=$FWHM EW=$EW"
    

    set text "Flux=$Flux W=$Lg FWHM=$FWHM EW=$EW"

#    euro3d tcl_pgptxt [expr 1.1*$Lg] [expr 0.9*$max] 1.0 2 $text 1.5 1 1.8
#    euro3d tcl_pgptxt 0.5 0.5 0.0 2 $text 1.5 1 1.8
    euro3d tcl_pgptxt 1.5 1.05 0.0 2 $text 1.5 1 1.8
#    euro3d tcl_pgptxt 0.5 0.5 0.0 2 "test" 1.5 1 1.8
    euro3d clean_device $dev_id3
    return $guess
}


proc vel_map {} {
    global nb_spec selected_spectra type_spec_rep dev_id3
    set local_type_spec_rep $type_spec_rep
    set type_spec_rep 4
    spec_env clean_device $dev_id3

    set Flux {}
    set Wavelength {} 
    set FWHM {}
    set EW {}
    set Continuum {}
    for {set j 0} {$j<$nb_spec} {incr j 1} {
#    for {set j 0} {$j<20} {incr j 1} {
    #}

	set selected_spectra {}
	lappend selected_spectra $j
	spax_env save_spectra_sel $selected_spectra
	plot_spectra_sel
	set guess [fit_single_line]
	set Ig [lindex $guess 0]
	set Lg [lindex $guess 1]
	set Sg [lindex $guess 2]
	set Cg [lindex $guess 3]
	set Flux_now [expr 2.5066*$Sg*$Ig]
	set FWHM_now [expr 2.345*$Sg]
	if {$Cg>0} {
	    set EW_now [expr $Flux_now/$Cg]
	} else {
	    set EW_now 1000
	}


	lappend Flux $Flux_now
	lappend FWHM $FWHM_now
	lappend EW $EW_now
	lappend Wavelength $Lg
	lappend Continuum $Cg
    }
    feed_slice $Flux

    set out_stat [stats $Wavelength]
    set mean_vel [lindex $out_stat 0]
    set stddev_vel [lindex $out_stat 1]
    set median_vel [lindex $out_stat 2]
#    puts "out_Stat=$out_stat"
    puts "Average Wavelength=$mean_vel+-$stddev_vel, Median=$median_vel"
    set Velocity {}
    foreach w $Wavelength {
#	set vel [expr (($w-$mean_vel)/$mean_vel)*300000]
	set vel [expr (($w-$median_vel)/$median_vel)*300000]
	lappend Velocity $vel
    }
    set Dispersion {}
    foreach fwhm $FWHM {
	set vel [expr ($fwhm/$median_vel)*300000]
	lappend Dispersion $vel
    }
    feed_slice $Velocity
    feed_slice $Dispersion
#    feed_slice $Wavelength
#    feed_slice $FWHM
    feed_slice $Continuum


    set type_spec_rep $local_type_spec_rep
}

proc plot_all_spectra {} {
    global nb_spec selected_spectra type_spec_rep dev_id3
    set local_type_spec_rep $type_spec_rep
    set type_spec_rep 4
    spec_env clean_device $dev_id3
    for {set j 0} {$j<$nb_spec} {incr j 1} {
	set selected_spectra {}
	lappend selected_spectra $j
	spax_env save_spectra_sel $selected_spectra
	plot_spectra_sel
    }
    set type_spec_rep $local_type_spec_rep
}

#
# Procedure to feed the last slice with the data included in a LIST
# named feed, of maximun length nb_spec
#
proc feed_slice { feed } {
    global ax1 ax2 amax amin abright acontra asign acolor_map max min bright contra sign color_map out_min_max tmp_j n_slice nb_spec slice_active dev_id3 text_flag fill

#    plot_spaxel 1 3 0 -1  $min $max $color_map $bright $contra $sign
#    set n_slice_now [expr $n_slice-1]

    set n_slice_now [expr $n_slice+1]



#    set n_slice_now $n_slice
#    set feed {}
#    for {set j 0} {$j<$nb_spec} {incr j} {
#	lappend feed $j
#    }
    euro3d feed_slice $n_slice_now $feed
    set ax1($n_slice_now) $n_slice_now
    set ax2($n_slice_now) $n_slice_now
    set amax($n_slice_now) $max 
    set amin($n_slice_now) $min 
    set abright($n_slice_now) $bright 
    set acontra($n_slice_now) $contra 
    set asign($n_slice_now) $sign 
    set acolor_map($n_slice_now) $color_map 

    set tmp_flag [expr $text_flag+20]

    plot_spaxel $ax1($n_slice_now) $ax2($n_slice_now) 0 $n_slice_now $amin($n_slice_now) $amax($n_slice_now) $acolor_map($n_slice_now) $abright($n_slice_now) $acontra($n_slice_now) $asign($n_slice_now)


#    incr n_slice 2

#    incr n_slice 1
#    if {$n_slice>7} {
#	set n_slice 0
#    }

}

 proc write_output_e3d_file {w} {
#    file delete /tmp/output.e3d
#    file delete /tmp/output_e3d.fits
    set Fid [open /tmp/output.e3d {RDWR CREAT} 0777]
#    set Fid [open "/tmp/output.e3d"]
#    set Fid [open "output.e3d"]
    puts $Fid "$w"
    close $Fid
 }

##################################################
# Procedure to comunicate with external program
# It looks for the file "/tmp/input.e3d"
# if it is readable, then it executes it
##################################################

# every --
#   Cheap rescheduler.  (c) Jeffrey Hobbs
#
# every::schedule <time> cmd;	# cmd is a one arg (cmd as list)
#	schedules $cmd to be run every <time> 1000ths of a sec
#	IOW, [::every::schedule 1000 "puts hello"] prints hello every sec
# every::cancel pattern
#	cancels cmd matching the glob pattern
# every::info ?pattern?
#	returns info about commands in pairs of "time cmd time cmd ..."
#
namespace eval ::every {}
proc ::every::schedule {time cmd} {
    if {![string is integer -strict $time]} {
	return -code error "usage: [lindex [::info level 0] 0] time command"
    }
    # A time was given, so schedule a command to run every $time msecs
    variable ID
    if {[string compare {} $cmd]} {
	set ID($cmd) [list $time [after $time [list ::every::_do $cmd]]]
    }
}

proc ::every::_do {cmd} {
    variable ID
    if {[::info exists ID($cmd)]} {
	uplevel \#0 $cmd
	set time [lindex $ID($cmd) 0]
	set ID($cmd) [list $time [after $time [list ::every::_do $cmd]]]
    }
}

proc ::every::cancel {pattern} {
    variable ID
    foreach i [array names ID $pattern] {
	after cancel [lindex $ID($i) 1]
	unset ID($i)
    }
}

proc ::every::info {{pattern *}} {
    variable ID
    set result {}
    foreach i [array names ID $pattern] {
	lappend result [lindex $ID($i) 0] [lindex $ID($i) 1]
    }
    return $result
}

proc source_e3d {} {
    if {[file exist "/tmp/input.e3d"]} {
	source "/tmp/input.e3d"
	file delete "/tmp/input.e3d"
    }
}

proc plot_slice { slice_index } {
    global min max color_map bright contra sign
    set selected_spectra {}
    spax_env save_spectra_sel
    plot_spaxel $slice_index $slice_index 0 -1 $min $max $color_map $bright $contra $sign

}


####################################################
# This procedure creates SLICE Arithmetic
####################################################
proc create_slice_arithmetic { w } {
    global x1 x2 w1 w2 dpix n_map sa_i1 sa_i2 sa_i3

#
# Creates the Pannel
#
    toplevel $w -class dialog
    wm withdraw $w
    wm title $w "Slice Arithmetic"
    wm iconname $w Dialog


#
# Create the top and bottom frames.
#

    frame $w.top -borderwidth 2 
    frame $w.bottom -borderwidth 2 
    frame $w.bottom.right1 -borderwidth 2 
    frame $w.bottom.right2 -borderwidth 2 
    pack $w.top -side top -fill both 
    pack $w.bottom -side top -fill both -expand true

    label $w.top.text -width 40 -relief flat
    pack $w.top.text -side left

    $w.top.text configure -text "Select two Monocromatic Cuts and an Output";	

    #
    # Wavelength cut
    #
    frame $w.w1 -width 30 -borderwidth 2 
    pack $w.w1 -side top -fill y
    label $w.w1.text -width 12 -text "1st Cut:"
    pack $w.w1.text -side left
    entry $w.w1.entry -relief sunken -bd 2 -width 12 -textvariable sa_i1    
    pack $w.w1.entry -side left


    frame $w.w2 -width 30 -borderwidth 2 
    pack $w.w2 -side top -fill y
    label $w.w2.text -width 12 -text "2nd Cut:"
    pack $w.w2.text -side left
    entry $w.w2.entry -relief sunken -bd 2 -width 12 -textvariable sa_i2    
    pack $w.w2.entry -side left

    frame $w.w3 -width 30 -borderwidth 2 
    pack $w.w3 -side top -fill y
    label $w.w3.text -width 12 -text "Output:"
    pack $w.w3.text -side left
    entry $w.w3.entry -relief sunken -bd 2 -width 12 -textvariable sa_i3    
    pack $w.w3.entry -side left


    frame $w.create -width 30 -border 2
    pack $w.create -side top -fill y

    menubutton $w.create.arith -text Arithm -menu $w.create.arith.menu -relief raised
    set m [menu $w.create.arith.menu -tearoff 1 ]
    $m add command -label "Substract" -command { 
	global sa_i1 sa_i2
	set tmp [euro3d slicearith $sa_i1 - $sa_i2 $sa_i3]	
	puts stdout "$sa_i1 $sa_i2 $sa_i3 $tmp"
	plot_slice $sa_i3
    }
    $m add command -label "Divide" -command { 
	global sa_i1 sa_i2
	euro3d slicearith $sa_i1 / $sa_i2 $sa_i3
	plot_slice $sa_i3
    }
    $m add command -label "Add" -command { 
	global sa_i1 sa_i2
	euro3d slicearith $sa_i1 + $sa_i2 $sa_i3
	plot_slice $sa_i3
    }
    $m add command -label "Multiply" -command { 
	global sa_i1 sa_i2
	euro3d slicearith $sa_i1 * $sa_i2 $sa_i3
	plot_slice $sa_i3
    }

    pack $w.create.arith -side left


#    button $w.create.button -text "Create Map" -command {
#	global n_map dev_id2
#	set n_map [euro3d create_map $x1 $x2 $dpix]
#	.map.top.text configure -text "Map $n_map created";	
#	spax_env plot_map 
#    spax_env plot_map $min $max $dev_id2 $color_map $bright $contra $sign $n_map
#    }


    button $w.create.cancel -text Cancel -command "wm withdraw $w" 
    pack $w.create.cancel -side right   


}





####################################################
# This procedure creates the interpolation
# configuration panel
####################################################
proc create_map_definer { w } {
    global x1 x2 w1 w2 dpix n_map grid_func grid_opt

#
# Creates the Pannel
#
    toplevel $w -class dialog
    wm withdraw $w
    wm title $w "Interpolation Definer"
    wm iconname $w Dialog


#
# Create the top and bottom frames.
#

    frame $w.title -width 30 -border 2
    pack $w.title -side top -fill y
    label $w.title.text -width 30 -text "INTERPOLATION"
    pack $w.title.text -side top
    frame $w.option -width 30 -border 2
    pack $w.option -side top -fill y
    label $w.option.text -width 30 -text "---"
    pack $w.option.text -side top


    menubutton $w.grid_func -text FUNCTION -menu $w.grid_func.menu -relief raised
    set menu_grid [menu $w.grid_func.menu -tearoff 1 ]
    $menu_grid add command -label "CSA" -command { 
	global grid_func
	set grid_func 1
	.map.option.text configure -text "Cubic Spline Selected"	
    }
    $menu_grid add command -label "Delaunay" -command { 
	global grid_func
	set grid_func 2
	.map.option.text configure -text "Linear Delaunay Selected"	
    }
    $menu_grid add command -label "NN" -command { 
	global grid_func
	set grid_func 3
	.map.option.text configure -text "Natural Neighbours Selected"	
    }
    $menu_grid add command -label "NN IDW" -command { 
	global grid_func
	set grid_func 4
	.map.option.text configure -text "KNN Inv. Distance Weight Selected"	
    }
    $menu_grid add command -label "NNL" -command { 
	global grid_func 
	set grid_func 5
	.map.option.text configure -text "3NN Linear Weight Selected"	
    }

    pack $w.grid_func -side top -fill y

    frame $w.grid_opt -width 30 -border 2
    pack $w.grid_opt -side top -fill y
    label $w.grid_opt.text -width 12 -text "Grid Option:"
    pack $w.grid_opt.text -side left
    entry $w.grid_opt.entry -relief sunken -bd 2 -width 12 -textvariable grid_opt    
    pack $w.grid_opt.entry -side left

    frame $w.dpix -width 30 -border 2
    pack $w.dpix -side top -fill y
    label $w.dpix.text -width 12 -text "Pix Size:"
    pack $w.dpix.text -side left
    entry $w.dpix.entry -relief sunken -bd 2 -width 12 -textvariable dpix    
    pack $w.dpix.entry -side left

    frame $w.create -width 30 -border 2
    pack $w.create -side top -fill y
    button $w.create.button -text "Set Parameter" -command {
	global grid_func grid_opt dpix
#	set n_map [euro3d create_map $x1 $x2 $dpix]
	euro3d set_grid $grid_func $grid_opt $dpix
	.map.option.text configure -text "Parameters Selected";	
    }
    pack $w.create.button -side left
    button $w.create.cancel -text Close -relief flat -underline 0 -command "wm withdraw $w" 
    pack $w.create.cancel -side right   



}


####################################################
# This procedure creates the spaxel selection 
# configuration
####################################################
proc create_spax_sel_definer { w } {
    global several radius

#
# Creates the Pannel
#
    toplevel $w -class dialog
    wm withdraw $w
    wm title $w "Spaxel Selection Definer"
    wm iconname $w Dialog


#
# Create the top and bottom frames.
#

    frame $w.title -width 30 -border 2
    pack $w.title -side top -fill y
    label $w.title.text -width 30 -text "Kind of Selection"
    pack $w.title.text -side top
    frame $w.option -width 30 -border 2
    pack $w.option -side top -fill y
    label $w.option.text -width 30 -text "---"
    pack $w.option.text -side top


    menubutton $w.grid_func -text OPTIONS -menu $w.grid_func.menu -relief raised
    set menu_grid [menu $w.grid_func.menu -tearoff 1 ]
    $menu_grid add command -label "Single" -command { 
	global several
	set several 0
	.map.option.text configure -text "Single Spaxels Selection"	
    }
    $menu_grid add command -label "Circular" -command { 
	global several
	set several 1
	.map.option.text configure -text "Circular Spaxels Selection"	
    }


    pack $w.grid_func -side top -fill y

    frame $w.grid_opt -width 30 -border 2
    pack $w.grid_opt -side top -fill y
    label $w.grid_opt.text -width 12 -text "Radius:"
    pack $w.grid_opt.text -side left
    entry $w.grid_opt.entry -relief sunken -bd 2 -width 12 -textvariable radius
    pack $w.grid_opt.entry -side left

    frame $w.create -width 30 -border 2
    pack $w.create -side top -fill y
    button $w.create.button -text "Set Parameters" -command "$w.option.text configure -text \"Parameters Selected\";"	
    pack $w.create.button -side left
    button $w.create.cancel -text Close -command "wm withdraw $w" 
    pack $w.create.cancel -side right   



}






########################################################
# Procedure to PIck an specects from the list
########################################################
proc select_spec { w y } {
    global flag_arith flag_ord arith_index spec_id spec_list n_spec
    
    if {$n_spec>0} {

	$w select set anchor [$w nearest $y]
	set j [$w nearest $y]
	.spec.top.text configure -text "Selected Spectrum $j"; 
	if {$flag_arith==0} {
	    load_spec $j
	}
	if {$flag_arith==1} {	
	    incr flag_ord
	    lappend arith_index $j
	    if {$flag_ord>2} {
		set flag_ord 0
		set flag_arith 0
		set i1 [lindex $arith_index 0]
		set i2 [lindex $arith_index 1]
		set i3 [spec_env specarith $i1 - $i2]
		load_spec $i3
		$spec_list delete $i3
		$spec_list insert $i3 "Sub $i2 $i1"
	    }
	}
	if {$flag_arith==2} {	
	    incr flag_ord
	    lappend arith_index $j
	    if {$flag_ord>2} {
		set flag_ord 0
		set flag_arith 0
		set i1 [lindex $arith_index 0]
		set i2 [lindex $arith_index 1]
		set i3 [spec_env specarith $i1 / $i2]
		load_spec $i3
		$spec_list delete $i3
		$spec_list insert $i3 "Div $i2 $i1"
	    }
	}
	if {$flag_arith==3} {	
	    incr flag_ord
	    lappend arith_index $j
	    if {$flag_ord>2} {
		set flag_ord 0
		set flag_arith 0
		set i1 [lindex $arith_index 0]
		set i2 [lindex $arith_index 1]
		set i3 [spec_env specarith $i1 + $i2]
		load_spec $i3
		$spec_list delete $i3
		$spec_list insert $i3 "Sum $i2 $i1"
	    }
	}
	if {$flag_arith==4} {	
	    incr flag_ord
	    lappend arith_index $j
	    if {$flag_ord>2} {
		set flag_ord 0
		set flag_arith 0
		set i1 [lindex $arith_index 0]
		set i2 [lindex $arith_index 1]
		set i3 [spec_env specarith $i1 * $i2]
		load_spec $i3
		$spec_list delete $i3
		$spec_list insert $i3 "Pro $i2 $i1"
	    }
	}
	
	if {$flag_arith==5} {	
	    lappend arith_index $j
	    set flag_ord 0
	    set flag_arith 0
	    spec_env skysub $j
	}
    } else {
	.spec.top.text configure -text "No Spectra on the list"; 
    }

}

########################################################
# Procedure to recover a certain SPECECT
########################################################
proc load_spec { n_spec } {
    global min max dev_id3 dev_id4 color_map bright contra sign type_spec_rep_mem list_spec_mem
    if {$type_spec_rep_mem==1} {
	set existe [lsearch $list_spec_mem $n_spec]
	if {$existe==-1} {
	    lappend list_spec_mem $n_spec
	}
	set i 0
	foreach n_spec_now $list_spec_mem {
	    spec_env load_spec $n_spec_now
	    spec_env plot_spectra_mem $min $max $dev_id3 1 $color_map $bright $contra $sign $i
	    incr i
	}
    } else {
	spec_env load_spec $n_spec
	spec_env plot_spectra_mem $min $max $dev_id3 1 $color_map $bright $contra $sign
    }
#    plot_spec
}


########################################################
# Procedure to Pick an objects from the list
########################################################
proc select_obj { w y } {
    global n_spax n_flux_spax mean_flux_spax sigma_flux_spax reverse_obj current_obj
    if {$n_spax>0} {
	$w select set anchor [$w nearest $y]
	set j [$w nearest $y]
	if {$reverse_obj==1} {
	    set reverse_obj 0
	    euro3d reverse_obj $j
	}
	load_obj $j
	set current_obj $j
	set stats_spax [spax_env stats_spax]
	set n_flux_spax [lindex $stats_spax 0]
	set mean_flux_spax [lindex $stats_spax 1]
	set sigma_flux_spax [lindex $stats_spax 2]
    } else {
	.spax.top.text configure -text "No Objects created";
    }
}


########################################################
# Procedure to save a current selected object as 
# separated Euro3D file
########################################################
proc save_obj_file {} {
    global current_obj
    set type {
	{{FITs file} {.fits} FITS}
    }
    set filename [tk_getSaveFile -filetypes $type -title "Euro3D FITS File" -initialdir "."]    
    euro3d save_obj_file $current_obj $filename
}
########################################################
# Procedure to recover a certain OBJECT
########################################################
proc load_obj { n_obj } {
  global ax1 ax2 slice_active text_flag selected_spectra amin amax acolor_map abright acontra asign
    #
    # We load the OBJECT in the C-Memory
    #    
    set n_sel_temp [spax_env load_obj $n_obj]
    #
    # Now we read this information
    # 
    if {$n_sel_temp>0} {
	set selected_spectra {}
	for {set j 0 } {$j<$n_sel_temp} {incr j} {
	    lappend selected_spectra [spax_env load_spectra_sel $j]
	} 
	set old_text_flag $text_flag
#	if {$text_flag<4} {
#	    set text_flag 3
#	}
	plot_spaxel $ax1($slice_active) $ax2($slice_active) 1 $slice_active $amin($slice_active) $amax($slice_active) $acolor_map($slice_active) $abright($slice_active) $acontra($slice_active) $asign($slice_active)
	set text_flag $old_text_flag
	plot_spectra_sel
	.spax.top.text configure -text "Obj. $n_obj loaded";
    } else {
	.spax.top.text configure -text "No Spaxels in this obj.";
    }
}

####################################################
# Procedure to create a listBox
####################################################

proc ScrolledListBox { parent text args } {
    frame $parent -borderwidth 2
    label $parent.label -text $text
    pack $parent.label -side top
    eval {listbox $parent.list -yscrollcommand [list $parent.sy set]} $args
    scrollbar $parent.sy -orient vertical -command [list $parent.list yview]
    pack $parent.sy -side right -fill y
    pack $parent.list -side left -fill both -expand true
    return $parent.list

}


proc incr_n_plots {} {
    global n_plots plot_name plot_file
    incr n_plots
    set plot_name "euro3d_$n_plots.ps/CPS"
    set plot_file "euro3d_$n_plots.ps"
}

proc incr_n_gifs {} {
    global n_gifs plot_name plot_file
    incr n_gifs
    set plot_name "euro3d_$n_gifs.gif/GIF"
    set plot_file "euro3d_$n_gifs.gif"
}

proc incr_n_specs {} {
    global n_specs plot_name plot_file
    incr n_specs
    set plot_name "spec_$n_specs.fits"
    set plot_file "spec_$n_specs.fits"
}

proc incr_n_spec_as {} {
    global n_spec_as plot_name plot_file
    incr n_spec_as
    set plot_name "spec_$n_spec_as.txt"
    set plot_file "spec_$n_spec_as.txt"
}

proc incr_n_spec_tabs {} {
    global n_spec_tabs plot_name plot_file
    incr n_spec_tabs
    set plot_name "spec_tab_$n_spec_tabs.fits"
    set plot_file "spec_tab_$n_spec_tabs.fits"
}


####################################################
# This procedure creates the spectra inspector
#
####################################################
proc create_spectra_inspector { w title} {
    global dev_id1 naxes bright contra sign npix nb_spec min max color_map dev_id2 dev_small small_areas tmp_j ax1 ax2 dev_id4
#
# Creates the Pannel
#
    toplevel $w -class dialog
    wm withdraw $w
    wm title $w $title
    wm iconname $w Dialog


#
# Create the top and bottom frames.
#

    frame $w.top -borderwidth 2 -relief raised


    frame $w.bottom -borderwidth 2 
    frame $w.bottom.right1 -borderwidth 2 
    frame $w.bottom.right2 -borderwidth 2 
    create_info_panel $w.info_panel 2
    pack $w.top -side top -fill both
    pack $w.bottom -side top -fill both -expand true


    ScrolledListBox $w.info_panel.objects "Spectra" -width 15 -height 11 -setgrid true -selectmode single
    bind $w.info_panel.objects.list <ButtonPress-1> {select_spec %W %y}
    pack $w.info_panel.objects -side top 

    menubutton $w.top.save -text File -menu $w.top.save.menu -underline 0 
#-relief raised
    set menu_file [menu $w.top.save.menu -tearoff 1 ]

    $menu_file add command -label "PS Save" -command { 
	global min max color_map bright contra sign small_areas dev_small plot_name plot_file  type_spec_rep type_spec_save type_spec_n_buffer list_spec_mem type_spec_rep_mem
	if ($loaded!=0) {
	    incr_n_plots
	    set type {
		{{postscript file} {.ps} PS}
	    }
	    set ps_file [tk_getSaveFile -initialfile $plot_file -filetypes $type -title "Postscript File" -initialdir "."]    
	    set plot_name $ps_file/CPS
	    set dev_temp1 [spax_env open_device "$plot_name"]
	    set dev_temp2 $dev_temp1
	    set n_sel_temp [spax_env load_n_spectra_sel]
	    if {$n_sel_temp>0} {
		set selected_temp {}
		for {set j 0 } {$j<$n_sel_temp} {incr j} {
		    lappend selected_temp [spax_env load_spectra_sel $j]
		} 

		spec_env set_type_spec_rep $type_spec_rep 0 $type_spec_n_buffer
		spec_env plot_spectra $min $max $dev_temp1 2 $color_map $bright $contra $sign $selected_temp   
		spec_env set_type_spec_rep $type_spec_rep $type_spec_save $type_spec_n_buffer
	    } else {
		if {$n_sel_temp<0} {
		    if {$type_spec_rep_mem==1} {
			set i 0
			foreach n_spec_now $list_spec_mem {
			    spec_env load_spec $n_spec_now
			    spec_env plot_spectra_mem $min $max $dev_temp1 1 $color_map $bright $contra $sign $i
			    incr i
			}
		    } else {
			spec_env plot_spectra_mem $min $max $dev_temp1 1 $color_map $bright $contra $sign
		    }
		} else {
		.spax.top.text configure -text "No Spaxel Sel.";
		}
	    }
	    spax_env close_device $dev_temp1
	    .spax.top.text configure -text "File $plot_name saved";	
	}
    }



    $menu_file add command -label "GIF Save" -command { 
	global min max color_map bright contra sign small_areas dev_small plot_name plot_file type_spec_rep type_spec_save type_spec_n_buffer type_spec_rep_mem list_spec_mem
	if ($loaded!=0) {
	    incr_n_gifs
	    set type {
		{{GIF file} {.gif} GIF}
	    }
	    set ps_file [tk_getSaveFile -initialfile $plot_file -filetypes $type -title "Postscript File" -initialdir "."]    
	    set plot_name $ps_file/GIF
	    set dev_temp1 [spax_env open_device "$plot_name"]
	    set dev_temp2 $dev_temp1
	    set n_sel_temp [spax_env load_n_spectra_sel]
	    if {$n_sel_temp>0} {
		set selected_temp {}
		for {set j 0 } {$j<$n_sel_temp} {incr j} {
		    lappend selected_temp [spax_env load_spectra_sel $j]
		} 
		spec_env set_type_spec_rep $type_spec_rep 0 $type_spec_n_buffer
		spec_env plot_spectra $min $max $dev_temp1 2 $color_map $bright $contra $sign $selected_temp   
		spec_env set_type_spec_rep $type_spec_rep $type_spec_save $type_spec_n_buffer
	    } else {
		if {$n_sel_temp<0} {
		    if {$type_spec_rep_mem==1} {
			set i 0
			foreach n_spec_now $list_spec_mem {
			    spec_env load_spec $n_spec_now
			    spec_env plot_spectra_mem $min $max $dev_temp1 1 $color_map $bright $contra $sign $i
			    incr i
			}
		    } else {
			spec_env plot_spectra_mem $min $max $dev_temp1 1 $color_map $bright $contra $sign
		    }

#		    spec_env plot_spectra_mem $min $max $dev_temp1 2 $color_map $bright $contra $sign
		} else {
		.spax.top.text configure -text "No Spaxel Sel.";
		}
	    }
	    spax_env close_device $dev_temp1
	    .spax.top.text configure -text "File $plot_name saved";	
	}
    }


    $menu_file add command -label "FITs Spectral Image Save" -command { 
	global min max color_map bright contra sign small_areas dev_small plot_name plot_file
	if ($loaded!=0) {
	    set n_sel_temp [spax_env load_n_spectra_sel]
	    if {$n_sel_temp>0} {
		incr_n_specs		
		set selected_temp {}
		for {set j 0 } {$j<$n_sel_temp} {incr j} {
		    lappend selected_temp [spax_env load_spectra_sel $j]
		} 

		set type {
		    {{FITs file} {.fits} FITS}
		}
		set ps_file [tk_getSaveFile -initialfile $plot_file -filetypes $type -title "MAP FITS File" -initialdir "."]    
		set plot_name $ps_file
		spec_env save_spec $plot_name $selected_temp   
		.spax.top.text configure -text "File $plot_name saved";	
	    } else {
		.spax.top.text configure -text "No Spaxel Sel.";
	    }	    
	}
    }


    $menu_file add command -label "FITs Table Save" -command { 
	global min max color_map bright contra sign small_areas dev_small plot_name plot_file
	if ($loaded!=0) {
	    set n_sel_temp [spax_env load_n_spectra_sel]
	    if {$n_sel_temp>0} {
		incr_n_spec_tabs		
		set selected_temp {}
		for {set j 0 } {$j<$n_sel_temp} {incr j} {
		    lappend selected_temp [spax_env load_spectra_sel $j]
		} 
		set type {
		    {{FITS file} {.fits} FITS}
		}
		set ps_file [tk_getSaveFile -initialfile $plot_file -filetypes $type -title "FITS Table File" -initialdir "."]    
		set plot_name $ps_file

		spec_env save_spec_table $plot_name Flux 0 $selected_temp   
		.spax.top.text configure -text "File $plot_name saved";	
	    } else {
		.spax.top.text configure -text "No Spaxel Sel.";
	    }	    
	}
    }

    $menu_file add command -label "ASCII Table Save" -command { 
	global min max color_map bright contra sign small_areas dev_small plot_name plot_file
	if ($loaded!=0) {
	    set n_sel_temp [spax_env load_n_spectra_sel]
	    if {$n_sel_temp>0} {
		incr_n_spec_as		
		set selected_temp {}
		for {set j 0 } {$j<$n_sel_temp} {incr j} {
		    lappend selected_temp [spax_env load_spectra_sel $j]
		} 
		set type {
		    {{ASCII file} {.txt} TXT}
		}
		set ps_file [tk_getSaveFile -initialfile $plot_file -filetypes $type -title "ASCII Table File" -initialdir "."]    
		set plot_name $ps_file
		
		spec_env save_spec_table $plot_name Flux 1 $selected_temp   
		.spax.top.text configure -text "File $plot_name saved";	
	    } else {
		.spax.top.text configure -text "No Spaxel Sel.";
	    }	    
	}
    }







    menubutton $w.top.select -text Spectra -menu $w.top.select.menu -underline 0 
#-relief raised
    set m [menu $w.top.select.menu -tearoff 1 ]
    $m add command -label "Save Spectrum" -command { 
	global spec_list n_spec
	set spec_id [spax_env create_spec]
	if {$spec_id==-666} {
	    .spec.top.text configure -text "No Spectrum actually Plotted!"; 
	} else {
	    if {$increase_spec==0} {
		.spec.top.text configure -text "Spectrum $spec_id defined"; 
		$spec_list insert $spec_id "Spec $spec_id"
	    } else {
		.spec.top.text configure -text "Spectrum $spec_id redefined"; 
	    }
	}	
	incr n_spec 1
	if {$n_spec>9} {
	    set n_spec 0
	    set increase_spec 1
#	    clean_spec_list
	}
    }




    $m add checkbutton -label "Single/Multiple Plot" -command {
	global type_spec_rep_mem list_spec_mem
	set list_spec_mem {}
	if {$type_spec_rep_mem==0} {
	    set type_spec_rep_mem 1
	    .spec.top.text configure -text "Multiple Spectra Representation Mode"; 
	} else {
	    set type_spec_rep_mem 0
	    .spec.top.text configure -text "Single Spectrum Representation Mode"; 
	}
    }

    $m add command -label "Clear Multiple Selection" -command {
	global type_spec_rep_mem list_spec_mem
	set list_spec_mem {}
    }

    $m add separator


    $m add command -label "Arithmetic" 
    $m add separator


    $m add command -label "Substract" -command { 
	global flag_ord flag_arith arith_index;
	.spec.top.text configure -text "Select two spectra"; 
	set flag_ord 1
	set flag_arith 1
	set arith_index {}	    
    }
    $m add command -label "Divide" -command { 
	global flag_ord flag_arith arith_index;
	.spec.top.text configure -text "Select two spectra"; 
	set flag_ord 1
	set flag_arith 2
	set arith_index {}	    
    }
    $m add command -label "Add" -command { 
	global flag_ord flag_arith arith_index;
	.spec.top.text configure -text "Select two spectra"; 
	set flag_ord 1
	set flag_arith 3
	set arith_index {}	    
    }
    $m add command -label "Multiply" -command { 
	global flag_ord flag_arith arith_index;
	.spec.top.text configure -text "Select two spectra"; 
	set flag_ord 1
	set flag_arith 4
	set arith_index {}	    
    }
    $m add command -label "Sky Substraction" -command { 
	global flag_ord flag_arith arith_index;
	.spec.top.text configure -text "Select no spectra"; 
	set flag_ord 1
	set flag_arith 5
	set arith_index {}	    
    }




    menubutton $w.top.fitting -text Fitting -menu $w.top.fitting.menu -underline 0 
#-relief raised
    set m [menu $w.top.fitting.menu -tearoff 1 ]
    $m add command -label "Fit Single Emission Line" -command { 
	fit_single_line
    }
    $m add command -label "Full Automatic Kinematic Analysis" -command { 
	vel_map
    }


    pack $w.top.save -side left
    pack $w.top.select -side left
    pack $w.top.fitting -side left


#    tk_menuBar $w.top.menubar $w.top.menubar.save  $w.top.menubar.select  $w.top.menubar.fitting
#    focus $w.top.menubar
# -side top -fill both








    label $w.top.text -width 40 -relief flat
    pack $w.top.text -side left

    button $w.top.close -text Close -relief flat -underline 0 -command "wm withdraw $w"
    pack $w.top.close -side right
    pack $w.info_panel -side left -fill y 


    create_spec_area $w.bottom.imagearea 25 6 1  
    create_env spec_env [$w.bottom.imagearea.pgplot device]

    bind $w.bottom.imagearea.pgplot <Button-1> { set_inspectors %W %x %y }


    bind $w.bottom.imagearea.pgplot <Button-3> {
	global x1 x2 min max color_map bright contra sign spax_catch
	if {$spax_catch==1} {
	    
	    plot_spaxel $x1 $x2 0 -1  $min $max $color_map $bright $contra $sign
	}
    }


    bind $w.bottom.imagearea.pgplot <Motion> {
	set xp1 [%W world x %x]
	.spec.top.text configure -text "Wavelength: $xp1"; 
    }


    bind $w.bottom.imagearea.pgplot <B2-Motion> {
	global x1 x2 min max color_map bright contra sign spax_catch dev_id3 delta_x start_w delta_w w1 w2 first_spec type_spec_rep type_spec_save type_spec_n_buffer
	set xp1 [%W world x %x]
	set xp1 [expr ($xp1-$start_w)/$delta_w]	
	set xp2 [expr $xp1+$delta_x]
	set yp1 [%W world y %y]
	set yp2 [expr $yp1+1]
	if {$spax_catch==1} {
#	    plot_spaxel $xp1 $xp2 0 -1  $min $max $color_map $bright $contra $sign 
	    spax_env plot_spaxels $min $max $dev_id2 $xp1 $xp2 $color_map $bright $contra $sign 1 $fill $text_flag
	    set w1 [expr ($start_w+$delta_w*$xp1)]
	    set w2 [expr ($start_w+$delta_w*$xp2)]
	}
	if {$spec_catch==1} {
	    set yyp [expr $yp1+$first_spec]
	    spec_env set_type_spec_rep $type_spec_rep 0 $type_spec_n_buffer
	    spec_env plot_spectra $min $max $dev_id3 0 $color_map $bright $contra $sign $yyp
	    spec_env set_type_spec_rep $type_spec_rep $type_spec_save $type_spec_n_buffer
	}
    }

    bind $w.bottom.imagearea.pgplot <B2-ButtonRelease> {
	global x1 x2 min max color_map bright contra sign spax_catch dev_id3 delta_x start_w delta_w w1 w2 first_spec type_spec_rep type_spec_save type_spec_n_buffer
	set xp1 [%W world x %x]
	set xp1 [expr ($xp1-$start_w)/$delta_w]	
	set xp2 [expr $xp1+$delta_x]
	set yp1 [%W world y %y]
	set yp2 [expr $yp1+1]
	if {$spax_catch==1} {
	    if {$color_map=="rainbow"} {
		euro3d plot_line $dev_id3 1 1 2 [expr $start_w+$xp1*$delta_w] 0.0 [expr $start_w+$xp1*$delta_w] 10000.0
		euro3d plot_line $dev_id3 1 1 2 [expr $start_w+$xp2*$delta_w] 0.0 [expr $start_w+$xp2*$delta_w] 10000.0
	    } else {
		euro3d plot_line $dev_id3 5 1 2 [expr $start_w+$xp1*$delta_w] 0.0 [expr $start_w+$xp1*$delta_w] 10000.0
		euro3d plot_line $dev_id3 5 1 2 [expr $start_w+$xp2*$delta_w] 0.0 [expr $start_w+$xp2*$delta_w] 10000.0
	    }
	    plot_spaxel $xp1 $xp2 0 -1  $min $max $color_map $bright $contra $sign 
	}
	if {$spec_catch==1} {
	    set yyp [expr $yp1+$first_spec]
	    spec_env set_type_spec_rep $type_spec_rep 0 $type_spec_n_buffer
	    spec_env plot_spectra $min $max $dev_id3 0 $color_map $bright $contra $sign $yyp
	    spec_env set_type_spec_rep $type_spec_rep $type_spec_save $type_spec_n_buffer
	}
    }






#    create_spec_area $w.bottom.specarea 25 6 0
#    set dev_id4 [spec_env open_device [$w.bottom.specarea.pgplot device]]
}

#
# Create the Spectral Working area
#

proc create_spec_area {w xsize ysize scr } {
#
# Frame the workarea.
#
    set c "c"

    set xsize $xsize$c
    set ysize $ysize$c
    frame $w -width $xsize -height $ysize -colormap .bottom.imagearea1
    pgplot $w.pgplot -share true  -width $xsize -height $ysize -mincolors 256 -maxcolors 12000 -bg black -fg white


    scrollbar $w.yscroll -command "$w.pgplot yview" -orient vertical
    $w.pgplot configure -yscrollcommand "$w.yscroll set"
    pack $w.yscroll -side right -fill y

    if {$scr==1} {
	pack $w.pgplot -side left -fill both -expand true 
	pack $w -side top -fill both -expand true
    } else {
	pack $w.pgplot -side left -fill both -expand false 
	pack $w -side top -fill both -expand false
    }
}

proc create_menu_spectra { w window } {
    global spec_catch n_spec n_spec_lines spax_catch
    menubutton $w -text Spectra -menu $w.menu  -underline 0
    set m [menu $w.menu -tearoff 1 ]
    $m add command -label Open  -command "wm deiconify $window; raise $window"
    $m add checkbutton -label Select -command {
	global spec_catch spax_catch
	set spax_catch 0
	if {$spec_catch==0} {
	    set spec_catch 1
	    set spax_catch 0
	    .bottom.imagearea1.pgplot configure -cursor {tcross black red}
	    .spec.bottom.imagearea.pgplot configure -cursor {tcross black red}
	} else {
	    set spec_catch 0	
	    set spax_catch 1
	    .bottom.imagearea1.pgplot configure -cursor {crosshair black white}
#	    .spec.botton.imagearea.pgplot configure -cursor {crosshair black white}
	}
    }
    $m add command -label Plot  -command {
	plot_spectra
    }

}


proc plot_flux_prof_sel {} {
    global dev_id3
    set guess [euro3d plot_flux_spax $dev_id3 0 1]
    set Flux [lindex $guess 0]
    set FWHM [lindex $guess 2]
    set text "Flux Peak=$Flux FWHM=$FWHM"
    euro3d tcl_pgptxt 1.0 1.05 0.0 2 $text 1.5 1 1.8
    euro3d clean_device $dev_id3
}
################################################
# Procedure to Plot a set of Spectra in the Spectra Analysis
################################################
proc plot_spectra_sel { } {
    global dev_id3 dev_id4 min max color_map bright contra sign small_areas dev_small type_spec_rep type_spec_save type_spec_n_buffer type_spec_rep_mem list_spec_mem
    #set type_spec_n_buffer -1
    spec_env set_type_spec_rep $type_spec_rep $type_spec_save $type_spec_n_buffer
     set n_sel_temp [spax_env load_n_spectra_sel]
    if {$n_sel_temp>0} {
	set selected_temp {}
	for {set j 0 } {$j<$n_sel_temp} {incr j} {
	    lappend selected_temp [spax_env load_spectra_sel $j]
	}    
	spec_env plot_spectra $min $max $dev_id3 0 $color_map $bright $contra $sign $selected_temp 
    } else {
	if {$n_sel_temp<0} {
	    if {$type_spec_rep_mem==1} {
		set i 0
		foreach n_spec_now $list_spec_mem {
		    spec_env load_spec $n_spec_now
		    spec_env plot_spectra_mem $min $max $dev_id3 1 $color_map $bright $contra $sign $i
		    incr i
		}
	    } else {
		spec_env plot_spectra_mem $min $max $dev_id3 1 $color_map $bright $contra $sign
	    }

#	spec_env plot_spectra_mem $min $max $dev_id3 0 $color_map $bright $contra $sign
	} else {	    
	.spax.top.text configure -text "No Spaxel Sel.";
	}
    }
}



################################################
# Procedure to Plot a set of Spectra in the Spectra Analysis
################################################
proc plot_spectra {} {
	global dev_id3 dev_id4 min max color_map bright contra sign small_areas dev_small selected_spectra type_spec_rep type_spec_save type_spec_n_buffer
    spec_env set_type_spec_rep $type_spec_rep $type_spec_save $type_spec_n_buffer
    
    set existe [llength $selected_spectra]
    if {$existe>0} {
	set y_1 [lindex $selected_spectra 0]
	set y_2 [lindex $selected_spectra [expr [llength $selected_spectra]-1]]
	spec_env plot_spectra $min $max $dev_id3 0 $color_map $bright $contra $sign $selected_spectra
	set selected_spectra {}
	set j $y_1
	while {$j<=$y_2} {
	    lappend selected_spectra $j
	    incr j 1
	}	
    }
}


proc report_click {w x y} {
    global cut_pos n_cut_pos selected_spectra spax_env amin amax acolor_map abright acontra asign del_spax radius several n_flux_spax mean_flux_spax sigma_flux_spax text_flag slice_active ax1 ax2 dpix loaded
    if {$loaded==1} {
	set pg $w
	set x_ini [$pg world x $x]
	set y_ini [$pg world y $y]
	#    set dpix 0.05
	

	if {$n_cut_pos==0} {
	    set cut_pos {}
	    lappend cut_pos $x_ini
	    lappend cut_pos $y_ini		
	    $pg setcursor line $x_ini $y_ini 3
	    set selected_spectra {}
	    set n_cut_pos 1
	} else {
	    $pg setcursor norm 0.0 0.0 1
	    set n_cut_pos 0
	    set x1 $x_ini
	    set y1 $y_ini
	    set x0 [lindex $cut_pos 0]
	    set y0 [lindex $cut_pos 1]
	    if {[expr abs($x1-$x0)]<[expr 10*$dpix]} {
		set x1 $x0
	    }
	    #	puts "x=$x1 $x0 y=$y1 $y0"
	    if {($x1!=$x0)&&([expr abs($x1-$x0)]>[expr abs($y1-$y0)])} {
		if {$x1<$x0} {
		    set x0 $x_ini
		    set y0 $y_ini
		    set x1 [lindex $cut_pos 0]
		    set y1 [lindex $cut_pos 1]
		    
		}
		
		
		set dx $dpix
		set dy [expr $dpix*($y1-$y0)/($x1-$x0)]
		set n [expr int(($x1-$x0)/$dpix)]	   
		
		
		for {set j 0} {$j<$n} {incr j 1} {
		    set x_tmp [expr $x0+$dx*$j]
		    set y_tmp [expr $y0+$dy*$j]
		    set spax_id 0
		    set spax_id [spax_env nearest_spax $x_tmp $y_tmp]
		    set esta [lsearch -exact $selected_spectra $spax_id]
		    if {$esta==-1} {
			lappend selected_spectra $spax_id
		    }
		}
	    } else {
		if {$y1!=$y0} {
		    if {$y1<$y0} {
			set x0 $x_ini
			set y0 $y_ini
			set x1 [lindex $cut_pos 0]
			set y1 [lindex $cut_pos 1]
			
		    }
		    
		    set dy $dpix
		    set dx [expr $dpix*($x1-$x0)/($y1-$y0)]
		    set n [expr int(($y1-$y0)/$dpix)]	   
		    for {set j 0} {$j<$n} {incr j 1} {
			set x_tmp [expr $x0+$dx*$j]
			set y_tmp [expr $y0+$dy*$j]
			set spax_id 0
			set spax_id [spax_env nearest_spax $x_tmp $y_tmp]
			set esta [lsearch -exact $selected_spectra $spax_id]
			if {$esta==-1} {
			    lappend selected_spectra $spax_id
			}
		    }
		} else {
		    set spax_id 0
		    set spax_id [spax_env nearest_spax $x_ini $y_ini]
		    set esta [lsearch -exact $selected_spectra $spax_id]
		    if {$esta==-1} {
			lappend selected_spectra $spax_id
		    }
		}
	    }
	    
	    #	puts "$selected_spectra"
	    
	    if {[llength $selected_spectra]>0} {
		spax_env save_spectra_sel $selected_spectra
	    }
	}
	set old_text_flag $text_flag
	plot_spaxel $ax1($slice_active) $ax2($slice_active) 1 $slice_active $amin($slice_active) $amax($slice_active) $acolor_map($slice_active) $abright($slice_active) $acontra($slice_active) $asign($slice_active)
	set text_flag $old_text_flag
	set stats_spax [spax_env stats_spax]
	set n_flux_spax [lindex $stats_spax 0]
	set mean_flux_spax [lindex $stats_spax 1]
	set sigma_flux_spax [lindex $stats_spax 2]
	
	
	
    }
}

#################################################
# Procedure that reports the clicking over a certain 
# position in the Spaxels inspector
#################################################

proc report_spax_click1 {pg x y} {
  global tcl_precision loaded select_spax ax1 ax2 slice_active text_flag selected_spectra  amin amax acolor_map abright acontra asign del_spax radius several n_flux_spax mean_flux_spax sigma_flux_spax
  set tcl_precision 3
    $pg setcursor norm 0.0 0.0 1
    if ($loaded!=0) {
    set pg .spax.bottom.left.imagearea.pgplot
    set x_spax [$pg world x $x]
    set y_spax [$pg world y $y]
#    $pg setcursor line $x_spax $y_spax 2
    set spax_id 0
	if {$several==0 } {
	    set spax_id [spax_env nearest_spax $x_spax $y_spax]

	    if {$select_spax==1} {
		.spax.top.text configure -text "Select Spaxel  $spax_id";
		#
		# We check that it was not previously included
		#
		set esta [lsearch -exact $selected_spectra $spax_id]
		if {$esta>-1} {
		    #
		    # Now it does nothing!!!
		    #		puts stdout $del_spax
		    if {$del_spax==1} {
			set selected_temp {}
			for {set j 0} {$j<[llength $selected_spectra]} {incr j} {
			    if {$esta!=$j} {
				lappend selected_temp [lindex $selected_spectra $j]
			    }
			}
			set selected_spectra $selected_temp
			if {[llength $selected_spectra]>0} {
			    spax_env save_spectra_sel $selected_spectra
			} else {
			    spax_env save_spectra_sel
			}
		    }
		
		} else {
		    if {$del_spax==0} {
			lappend selected_spectra $spax_id
			spax_env save_spectra_sel $selected_spectra
		    }
		}
	    }
	} else {
	    #
	    # Selecting Several Spaxels at the same time
	    # 
	    set encircled_selection {}
	    set i 0
	    set n_spax 1
	    while {$i<$n_spax} {
		set temp_list {}
		set temp_list [spax_env encircled_spax $x_spax $y_spax $radius $i]
		set n_spax [lindex $temp_list 0]	    
		lappend encircled_selection [lindex $temp_list 1]
		incr i
	    }

#	    puts stdout "|$encircled_selection|"
	    foreach spax_id $encircled_selection {
		if {$select_spax==1} {
		    .spax.top.text configure -text "Select Spaxel  $spax_id";
		    #
		    # We check that it was not previously included
		    #
		    set esta [lsearch -exact $selected_spectra $spax_id]
		    if {$esta>-1} {
			#
			# Now it does nothing!!!
			#		puts stdout $del_spax
			if {$del_spax==1} {
			    set selected_temp {}
			    for {set j 0} {$j<[llength $selected_spectra]} {incr j} {
				if {$esta!=$j} {
				    lappend selected_temp [lindex $selected_spectra $j]
				}
			    }
			    set selected_spectra $selected_temp
			    if {[llength $selected_spectra]>0} {
				spax_env save_spectra_sel $selected_spectra
			    } else {
				spax_env save_spectra_sel
			    }
			}
		    } else {
			if {$del_spax==0} {
			    lappend selected_spectra $spax_id
			    spax_env save_spectra_sel $selected_spectra
			}
		    }
		}
	    }
	}
    
	set old_text_flag $text_flag
	#	    if {$text_flag<4} {
	#		set text_flag 3
	#	    }
	plot_spaxel $ax1($slice_active) $ax2($slice_active) 1 $slice_active $amin($slice_active) $amax($slice_active) $acolor_map($slice_active) $abright($slice_active) $acontra($slice_active) $asign($slice_active)
	set text_flag $old_text_flag
	set stats_spax [spax_env stats_spax]
	set n_flux_spax [lindex $stats_spax 0]
	set mean_flux_spax [lindex $stats_spax 1]
	set sigma_flux_spax [lindex $stats_spax 2]
	    	
    }
       
  set tcl_precision 6
   
}

#
# Procedure to delete
#
proc report_spax_click_delete {pg x y} {
  global tcl_precision loaded select_spax ax1 ax2 slice_active text_flag selected_spectra  amin amax acolor_map abright acontra asign
  set tcl_precision 3
    if ($loaded!=0) {
    set pg .spax.bottom.left.imagearea.pgplot
    set x_spax [$pg world x $x]
    set y_spax [$pg world y $y]
    set spax_id 0
    set spax_id [spax_env nearest_spax $x_spax $y_spax]
	if {$select_spax==1} {
	    .spax.top.text configure -text "Select Spaxel  $spax_id";
	    #
	    # We check that it was not previously included
	    #
	    set esta [lsearch -exact $selected_spectra $spax_id]
	    if {$esta>-1} {
		set selected_temp {}
		for {set j 0} {$j<[llength $selected_spectra]} {incr j} {
		    if {$esta!=$j} {
			lappend selected_temp [lindex $selected_spectra $j]
		    }
		}
		set selected_spectra $selected_temp
#	    } else {
#DOES NOTHING
#		lappend selected_spectra $spax_id
	    }
#	    puts stdout $selected_spectra
	    if {[llength $selected_spectra]>0} {
		spax_env save_spectra_sel $selected_spectra
	    } else {
		spax_env save_spectra_sel
	    }



	    set old_text_flag $text_flag
#	    if {$text_flag<4} {
#		set text_flag 3
#	    }
	    plot_spaxel $ax1($slice_active) $ax2($slice_active) 1 $slice_active $amin($slice_active) $amax($slice_active) $acolor_map($slice_active) $abright($slice_active) $acontra($slice_active) $asign($slice_active)
	    set text_flag $old_text_flag
	}	
    }
  set tcl_precision 6
}



#################################################
# Procedure that reports the clicking over a certain 
# position in the Spaxels inspector, with the second
# button and plot the corresponding spectrum.
#################################################

proc report_spax_motion2 {pg x y} {
    global tcl_precision loaded min max dev_id3 dev_id4 color_map bright contra sign last_spax_id flux_spax type_spec_rep type_spec_save type_spec_n_buffer x_si y_si
    set tcl_precision 3
    if ($loaded!=0) {
	set pg .spax.bottom.left.imagearea.pgplot
	set x_spax [$pg world x $x]
	set y_spax [$pg world y $y]
	set spax_id [spax_env nearest_spax $x_spax $y_spax]
	set flux_spax [spax_env flux_spax $spax_id]
#	set x_si $x_spax
#	set y_si $y_spax

	if {$spax_id!=$last_spax_id} {
	    spec_env set_type_spec_rep $type_spec_rep 0 $type_spec_n_buffer
	    spec_env plot_spectra $min $max $dev_id3 1 $color_map $bright $contra $sign $spax_id
	    spec_env set_type_spec_rep $type_spec_rep $type_spec_save $type_spec_n_buffer
	    .spax.top.text configure -text "SPAXEL=$spax_id, FLUX=$flux_spax";	
	    set last_spax_id $spax_id
	}
    }
  set tcl_precision 6
}

#
# This procedure reads the position, look for the nearest spaxel,
# and reports the flux of that Spaxel
#
proc report_spax_motion {pg x y} {
    global tcl_precision loaded min max dev_id3 dev_id4 color_map bright contra sign last_spax_id flux_spax x_si y_si
    set tcl_precision 3
    if ($loaded!=0) {
	set pg .spax.bottom.left.imagearea.pgplot
	set x_spax [$pg world x $x]
	set y_spax [$pg world y $y]
	set spax_id [spax_env nearest_spax $x_spax $y_spax]
	set flux_spax [spax_env flux_spax $spax_id]
	set x_si $x_spax
	set y_si $y_spax

#	puts "X,Y=$x_si $y_si"

	if {$spax_id!=$last_spax_id} {
#	    spec_env plot_spectra $min $max $dev_id3 1 $color_map $bright $contra $sign $spax_id
	    .spax.top.text configure -text "SPAXEL=$spax_id, FLUX=$flux_spax";	
	    set last_spax_id $spax_id
	}
    }
  set tcl_precision 6
}



####################################################
# This procedure creates the spaxels inspector
#
####################################################
proc create_spaxels_inspector { w title} {
    global dev_id1 naxes bright contra sign npix nb_spec min max color_map dev_id2 dev_small small_areas tmp_j ax1 ax2 text_flag amin amax acolor_map abright acontra asign
#
# Creates the Pannel
#
    toplevel $w -class dialog
    wm withdraw $w
    wm title $w $title
    wm iconname $w Dialog

#
# Create the top and bottom frames.
#

    frame $w.top -borderwidth 2 -relief raised
    frame $w.bottom -borderwidth 2 
    frame $w.bottom.left -borderwidth 2 
    frame $w.bottom.right -borderwidth 2 
#    frame $w.bottom.right.top -borderwidth 2 
    frame $w.bottom.right.bottom -borderwidth 2 
    frame $w.bottom.right.bottom.panel1 -borderwidth 2 
    frame $w.bottom.right.bottom.panel2 -borderwidth 2 
    create_info_panel $w.info_panel 1
    pack $w.top -side top -fill both 
    pack $w.bottom -side top -fill both -expand true
    pack $w.bottom.left -side left -fill both -expand true
    pack $w.bottom.right -side left -fill both -expand true
#    pack $w.bottom.right.top -side top -fill both -expand true
    pack $w.bottom.right.bottom -side top -fill both -expand true
    pack $w.bottom.right.bottom.panel2 -side right -expand false
    pack $w.bottom.right.bottom.panel1 -side right -expand false

    pack $w.info_panel -side left -fill y 

#
# We add the OBJECTS list only here
#

    ScrolledListBox $w.info_panel.objects "Objects" -width 15 -height 9 -setgrid true -selectmode single
    bind $w.info_panel.objects.list <ButtonPress-1> {select_obj %W %y}
    pack $w.info_panel.objects -side top 


    button $w.top.close -text Close -relief flat -underline 0 -command "wm withdraw $w"
    pack $w.top.close -side right

    menubutton $w.top.save -text File -menu $w.top.save.menu -underline 0
    set menu_file [menu $w.top.save.menu -tearoff 1 ]

    $menu_file add command -label "Import MAP" -command { 
	set type {
	    {{fits file} {.fits} FITS}
	    {{fits file} {.3d} FITS}
	    {{fits file} {.cube} FITS}
	}
	import_map [tk_getOpenFile -filetypes $type -title "FITS Map Load File" -initialdir "."]
	
    }
    $menu_file add separator
    
    
    $menu_file add command -label "Map Save" -command { 
	global slice_active loaded
	set local_slice $slice_active
	incr local_slice 1
	set map_name "map_$local_slice.fits"
	if ($loaded!=0) {
	    set res [spax_env save_map $local_slice $map_name]
	    if {$res!=0} {
		.spax.top.text configure -text "$map_name saved";	
	    } else {
		.spax.top.text configure -text "No Map created";	
	    }
	}
    }
    $menu_file add command -label "Slice Save" -command { 
	global slice_active loaded
	set local_slice $slice_active
	incr local_slice 1
	set slice_name "slice_$local_slice.fits"
	if ($loaded!=0) {
#	    set res [spax_env save_slice $slice_active $slice_name Flux 0]
	    set res [spax_env save_slice $local_slice $slice_name Flux 0]
		.spax.top.text configure -text "$slice_name saved";	
	}
    }
    $menu_file add command -label "Slice Save Ascii" -command { 
	global slice_active loaded
	set local_slice $slice_active
	incr local_slice 1
	set slice_name "slice_$local_slice.txt"
	if ($loaded!=0) {
#	    set res [spax_env save_slice $slice_active $slice_name Flux 1]
	    set res [spax_env save_slice $local_slice $slice_name Flux 1]
		.spax.top.text configure -text "$slice_name saved";	
	}
    }
    $menu_file add command -label "PS Save" -command { 
	global blink_index start_blink ax1 ax2 amax amin abright acontra asign acolor_map slice_active plot_name plot_file loaded fill text_flag
	if ($loaded!=0) {
	    incr_n_plots
	    set type {
		{{postscript file} {.ps} PS}
	    }
	    set ps_file [tk_getSaveFile -initialfile $plot_file -filetypes $type -title "Postscript File" -initialdir "."]    
	    set plot_name $ps_file/CPS

	    set dev_temp [spax_env open_device "$plot_name"]
#	    set dev_temp [spax_env open_device "/xs"]
	    if {$ax1($slice_active)!=$ax2($slice_active)} {
		spax_env plot_spaxels $amin($slice_active) $amax($slice_active) $dev_temp $ax1($slice_active) $ax2($slice_active) $acolor_map($slice_active) $abright($slice_active) $acontra($slice_active) $asign($slice_active) 1 $fill $text_flag 2
	    } else {
	    set tmp_flag [expr $text_flag+20]
	    spax_env plot_spaxels $amin($slice_active) $amax($slice_active) $dev_temp $ax1($slice_active) $ax2($slice_active) $acolor_map($slice_active) $abright($slice_active) $acontra($slice_active) $asign($slice_active) 1 $fill $tmp_flag 2
	    }
	    spax_env close_device $dev_temp
	    .spax.top.text configure -text "File $plot_name saved";	
	}
    }


    $menu_file add command -label "GIF Save" -command { 
	global blink_index start_blink ax1 ax2 amax amin abright acontra asign acolor_map slice_active plot_name plot_file loaded fill text_flag
	if ($loaded!=0) {
	    incr_n_gifs
	    set type {
		{{GIF file} {.gif} GIF}
	    }
	    set ps_file [tk_getSaveFile -initialfile $plot_file -filetypes $type -title "GIF File" -initialdir "."]    
	    set plot_name $ps_file/GIF

	    set dev_temp [spax_env open_device "$plot_name"]

	    if {$ax1($slice_active)!=$ax2($slice_active)} {
		spax_env plot_spaxels $amin($slice_active) $amax($slice_active) $dev_temp $ax1($slice_active) $ax2($slice_active) $acolor_map($slice_active) $abright($slice_active) $acontra($slice_active) $asign($slice_active) 1 $fill $text_flag 2
	    } else {
	    set tmp_flag [expr $text_flag+20]
	    spax_env plot_spaxels $amin($slice_active) $amax($slice_active) $dev_temp $ax1($slice_active) $ax2($slice_active) $acolor_map($slice_active) $abright($slice_active) $acontra($slice_active) $asign($slice_active) 1 $fill $tmp_flag 2
	    }
#	    spax_env plot_spaxels $amin($slice_active) $amax($slice_active) $dev_temp $ax1($slice_active) $ax2($slice_active) $acolor_map($slice_active) $abright($slice_active) $acontra($slice_active) $asign($slice_active) 1 $fill $text_flag 2
	    spax_env close_device $dev_temp
	    .spax.top.text configure -text "File $plot_name saved";	
	}
    }


    $menu_file add command -label "Save Object" -command { 
	save_obj_file
    }

    pack $w.top.save -side left






    menubutton $w.top.shape -text Shape -menu $w.top.shape.menu -underline 0
    set m [menu $w.top.shape.menu -tearoff 1 ]
    $m add command -label Fill -command { global text_flag; set text_flag 0; .spax.top.text configure -text "Fill Shape"; }
    $m add command -label Outline -command { global text_flag; set text_flag 1;  .spax.top.text configure -text "Outline Shape"; }
    $m add command -label Spaxel.Id -command { global text_flag; set text_flag 2;  .spax.top.text configure -text "Spaxel Id Shape"; }
    $m add command -label Map -command { global text_flag; set text_flag 4;  .spax.top.text configure -text "Map"; }
    $m add command -label OverContour -command { global text_flag; set text_flag -1;  .spax.top.text configure -text "Over Plot Contour"; }
    $m add command -label Contour -command { global text_flag; set text_flag -2;  .spax.top.text configure -text "Only Contour"; }
    $m add command -label "Map+Spax Shape" -command { global text_flag; set text_flag 5;  .spax.top.text configure -text "Map+Spax Shape"; }
    pack $w.top.shape -side left


    menubutton $w.top.select -text Select -menu $w.top.select.menu -underline 0
    set m [menu $w.top.select.menu -tearoff 1 ]
#    $m add  checkbutton -label Start  -command {
#	global select_spax
#	if {$select_spax==0} {
#	    set select_spax 1
#	} else {
#	    set select_spax 0
#	}
#    }
    $m add command -label Clear -command { 
	global ax1 ax2 slice_active text_flag selected_spectra amin amax acolor_map abright acontra asign
	set selected_spectra {}
	spax_env save_spectra_sel
	plot_spaxel $ax1($slice_active) $ax2($slice_active) 1 $slice_active $amin($slice_active) $amax($slice_active) $acolor_map($slice_active) $abright($slice_active) $acontra($slice_active) $asign($slice_active)
    }
    $m add command -label "Plot Spectra " -command { 
	plot_spectra_sel
    }
    $m add command -label "Plot Flux Profile " -command { 
	plot_flux_prof_sel
    }

    $m add separator

    $m add command -label "Create Object" -command { 
	global obj_list n_spax increase_spax current_obj
	set obj_id [spax_env create_obj]
	if {$obj_id==-666} {
	    .spax.top.text configure -text "No Spaxels actually selected!"; 
	} else {
	    if {$increase_spax==0 } {
		.spax.top.text configure -text "Object $obj_id defined"; 
		$obj_list insert $obj_id "Obj $obj_id"
	    } else {
		.spax.top.text configure -text "Object $obj_id redefined";
	    }
	}
	set current_obj $n_spax
	incr n_spax 1
	if {$n_spax>9} {
	    set n_spax 0
	    set increase_spax 1
 #	    clean_obj_list
	}

    }


    $m add command -label "Reverse Object" -command { 
	global reverse_obj 
	set reverse_obj 1
	.spax.top.text configure -text "Select an object to reverse"; 
    }

    pack $w.top.select -side left


    menubutton $w.top.tools -text Tools -menu $w.top.tools.menu -underline 0
    set m [menu $w.top.tools.menu -tearoff 1 ]

    $m add command -label "Blink" -command { 


	global blink_index start_blink n_blink ax1 ax2 blink_delay amax amin abright acontra asign acolor_map slice_active plot_name plot_file loaded fill text_flag
	set paso 0
	if {$start_blink==2} {
	    every::cancel blink
	    .spax.top.text configure -text "Stop Blinking"; 
	    set blink_index {}	    
	    set n_blink 0
	    set start_blink 0
	    set paso 1
	}

	if {$start_blink==1} {
	    set start_blink 2	   
	    .spax.top.text configure -text "Start Blinking"; 
	    every::schedule 1000 blink
	}


	if {($start_blink==0)&&($paso==0)} {
	    .spax.top.text configure -text "Select the Slices to Blink"; 
	    set blink_index {}	    
	    set n_blink 0
	    set start_blink 1
	}




    }
#    pack $w.top.blink -side left



    create_slice_arithmetic .sa

    $m add command -label "Arithmetic" -command { 
	wm deiconify .sa
	raise .sa
    }
    pack $w.top.tools -side left    
#    pack $w.top.sa -side left
    
#    pack $w.top.save_map -side left

#    pack $w.top.save_gif -side left
    label $w.top.text -width 40 -relief flat
    pack $w.top.text -side left






#    create_spax_area $w.bottom.left.imagearea 12 13  
    create_spax_area $w.bottom.left.imagearea 16 16
    create_env spax_env [$w.bottom.left.imagearea.pgplot device]
#    create_spax_area $w.bottom.right.top.imagearea 8 8
#    set dev_id4 [ $w.bottom.right.top.imagearea.pgplot device]



    

#
# OLD
#
#    bind $w.bottom.left.imagearea.pgplot <Button-1> {report_spax_click1 %W %x %y}
    bind $w.bottom.left.imagearea.pgplot <B1-Motion> {report_spax_click1 %W %x %y}
    bind $w <KeyPress-d> {
	global del_spax
	set del_spax 1
    }
    bind $w <KeyRelease-d> {
	global del_spax
	set del_spax 0
    }

    bind $w <KeyPress-s> {
	global pseudoslit_sel
	if {$pseudoslit_sel==0} {
	    set pseudoslit_sel 1
	    .spax.top.text configure -text "Pseudo-Slit Selection";
	} else {
	    set pseudoslit_sel 0
	    .spax.top.text configure -text "Spaxel to Spaxel Selection";
	}
    }


    bind $w.bottom.left.imagearea.pgplot <Button-1> {
	global pseudoslit_sel
	if {$pseudoslit_sel==1} {
	    report_click %W %x %y
	}
    }

    bind $w <KeyPress-v> {
	plot_flux_prof_sel
    }


    bind $w.bottom.left.imagearea.pgplot <B2-Motion> {report_spax_motion2 %W %x %y}
    bind $w.bottom.left.imagearea.pgplot <Motion> {report_spax_motion %W %x %y}
    bind $w.bottom.left.imagearea.pgplot <Button-3> {plot_spectra_sel}
    $w.bottom.left.imagearea.pgplot configure -cursor {tcross yellow green}


    set dev_small {}
    set small_areas {}
    set k 1
    for {set j 0} {$j<8} {incr j 1} {
	set ax1($j) 0
	set ax2($j) 1
	if {$j>3} {
	    set k 2
	}
	create_spax_area $w.bottom.right.bottom.panel$k.smallarea$j 4 4
	$w.bottom.right.bottom.panel$k.smallarea$j configure -borderwidth 2 
	set dev_tmp [$w.bottom.right.bottom.panel$k.smallarea$j.pgplot device]
	set small_tmp "$w.bottom.right.bottom.panel$k.smallarea$j"
	lappend dev_small $dev_tmp
	lappend small_areas $small_tmp
	set tmp_j $j
	bind $small_tmp.pgplot <Button-1> "global blink_index n_blink start_blink; if (\$start_blink==1) { lappend blink_index $j;  .spax.top.text configure -text \"Select [expr $j+1]\"; incr n_blink; }"
#	bind $small_tmp.pgplot <Button-2> "global start_blink; set start_blink 0"
	bind $small_tmp.pgplot <Button-3> "global ax1 ax2 tmp_j spax_catch spec_catch amax amin abright acontra asign acolor_map ; if {\$spax_catch==1} { plot_spaxel \$ax1($j) \$ax2($j) 1 $j \$amin($j) \$amax($j) \$acolor_map($j) \$abright($j) \$acontra($j) \$asign($j);}"

    }
}


proc create_menu_spaxels { w window } {
    global spax_catch n_slice n_lines spec_catch  
    menubutton $w -text Spaxels -menu $w.menu  -underline 0
    set m [menu $w.menu -tearoff 1 ]
    $m add command -label Open  -command "wm deiconify $window; raise $window"
    $m add checkbutton -label Select -command {
	global spax_catch spec_catch
	set spec_catch 0 
	if {$spax_catch==0} {
	    set spax_catch 1
	    set spec_catch 0
	    .bottom.imagearea1.pgplot configure -cursor {tcross yellow red}
	} else {
	    set spax_catch 0
	    .bottom.imagearea1.pgplot configure -cursor {crosshair black white}
	}
    }
    $m add command -label Plot  -command {
	global x1 x2 min max color_map bright contra sign
	plot_spaxel $x1 $x2 0 -1 $min $max $color_map $bright $contra $sign
    }



}


#
#
#
proc plot_spaxel { x1 x2 change_slice old_slice tmin tmax tcolor_map tbright tcontra tsign } {
    global dev_id2 small_areas dev_small ax1 ax2 n_slice fill text_flag slice_active w1 w2 start_w delta_w dev_id1 nb_spec amax amin abright acontra asign acolor_map max min bright contra sign color_map out_min_max


    set w1 [expr ($start_w+$delta_w*$x1)]
    set w2 [expr ($start_w+$delta_w*$x2)]

#    set out_min_max 0
#    set out_min_max [spax_env plot_spaxels $tmin $tmax $dev_id2 $x1 $x2 $tcolor_map $tbright $tcontra $tsign 1 $fill 20]

    if {$x1==$x2} { 
	incr text_flag 20
	set n_slice [expr int($x1-1)]
    }

    set out_min_max [spax_env plot_spaxels $tmin $tmax $dev_id2 $x1 $x2 $tcolor_map $tbright $tcontra $tsign 1 $fill $text_flag]



    set smin [lindex $out_min_max 0]
    set smax [lindex $out_min_max 1]
    # We plot in the small region...
    if {$change_slice==0} {
	set nn_slice [expr int($n_slice)]
    } else {
	set nn_slice [expr int($old_slice)]
    }
    set slice_active [expr int($nn_slice)]
    foreach area $small_areas {
	$area configure -bg grey
    }
    set dev_tmp [lindex $dev_small $nn_slice]
    set area_tmp [lindex $small_areas $nn_slice]
    $area_tmp configure -bg red
    if {$change_slice==0} {
	set dev_id_tmp [spax_env open_device $dev_tmp]
	#    puts stdout "$tcolor_map"
	if {$x1!=$x2} { 
#	    spax_env plot_spaxels $smin $smax $dev_id_tmp $x1 $x2 $tcolor_map $tbright $tcontra $tsign 0 1 0 0   
	    spax_env plot_spaxels $smin $smax $dev_id_tmp $x1 $x2 $tcolor_map $tbright $tcontra $tsign 0 $fill $text_flag 0   
	} else {
	    spax_env plot_spaxels $smin $smax $dev_id_tmp $x1 $x2 $tcolor_map $tbright $tcontra $tsign 0 $fill $text_flag 0   
#	    spax_env plot_spaxels $smin $smax $dev_id_tmp $x1 $x2 $tcolor_map $tbright $tcontra $tsign 0 1 0 20
	}
	spax_env clean_device $dev_id_tmp
	spax_env close_device $dev_id_tmp
    }
    if {$change_slice==0} {
	set ax1($nn_slice) $x1
	set ax2($nn_slice) $x2
	incr n_slice 1
	if {$n_slice>7} {
	    set n_slice 0
	}
	#
	# We create the Slice
	#
	if {$x1!=$x2} {
	    set tmp_n_slice [spax_env create_slice $x1 $x2 $n_slice $text_flag]
	}
	set n_lines 0
	recolor_image $tcolor_map 0
    }



    euro3d plot_line $dev_id1 1 3 1 $x1 0.0 $x1 $nb_spec.0    
    euro3d plot_line $dev_id1 1 3 1 $x2 0.0 $x2 $nb_spec.0    
    set nnn_slice [expr ($nn_slice+1)]
    euro3d mark_range $dev_id1 1 1.5 1 "Sp.$nnn_slice" $x1 [expr (($nb_spec/20)*$nn_slice+1.0)] $x2 [expr (($nb_spec/20)*$nn_slice+1.0)] 

#    .bottom.imagearea1 create line 0 100 0 100

    set max $tmax 
    set min $tmin
    set bright $tbright 
    set contra $tcontra 
    set sign $tsign 
    set color_map $tcolor_map 
    set amax($nn_slice) $tmax
    set amin($nn_slice) $tmin
    set abright($nn_slice) $tbright
    set acontra($nn_slice) $tcontra
    set asign($nn_slice) $tsign
    set acolor_map($nn_slice) $tcolor_map


    if {$text_flag>14} {
	incr text_flag -20
#	puts stdout "FIN"
    }


#    set 

}




#
# Procedure to create the Menu related with the color Maps
#
proc create_menu_colormap { w } {
    global change_bc
menubutton $w -text Scale -menu $w.menu -underline 0
set m [menu $w.menu -tearoff 1 ]
$m add cascade -label ColorMap -menu $m.colormap
set m_c [menu $m.colormap -tearoff 0]
$m_c add command -label grey -command { recolor_image grey 0 }
$m_c add command -label rainbow -command { recolor_image rainbow 0 }
$m_c add command -label heat -command { recolor_image heat 0 }
$m_c add command -label iraf -command { recolor_image iraf 0 }
$m_c add command -label aips -command { recolor_image aips 0 }
#$m add separator

$m add checkbutton -label Invert -command {
    global sign
    set sign [expr (-1)*$sign]
    if {$loaded!=0} {
	recolor_image $color_map 0
    }
}

$m add checkbutton -label "Bright/Cont." -command {
    if {$change_bc==0} {
	set change_bc 1
    } else {
	set change_bc 0
    }
}

}

proc open_device {} {
    euro3d open_device [.bottom.imagearea1.pgplot device]
    puts stdout [.bottom.imagearea1.pgplot id]
}

proc recolor_image { colormap clean } {
    global dev_id1 naxes bright contra sign npix nb_spec min max color_map loaded
    set color_map $colormap
    euro3d recolor_image $colormap $dev_id1 $bright $contra $sign


    if {$loaded!=0} {

	if [.bottom.imagearea1.pgplot cget -share] {
#	    puts "Clean=$clean"
	    set naxes [euro3d draw_raw $min $max $dev_id1 $clean $colormap $bright $contra $sign ]
 


	    set npix [lindex $naxes 0]
	    set nb_spec [lindex $naxes 1]

	    set tam_x [expr [lindex $naxes 0]*0.7]
	    set tam_y [expr [lindex $naxes 1]*1.2]
	    if {$tam_x>400} {
		set tam_x 400
	    }
	    if {$tam_x<200} {
		set tam_x 200
	    }
	    if {$tam_y>400} {
		set tam_y 400
	    }
	    if {$tam_y<200} {
		set tam_y 200
	    }

#	    .bottom.imagearea1.pgplot configure -width $tam_x
#	    .bottom.imagearea1.pgplot configure -height $tam_y
	}
#	    incr loaded 1
	    set loaded 1
	    
    }
    

}


proc create_option_menu {w label cmd name_list} {
#
# Create a frame to enclose the menu.
#
    frame $w
#
# Create the option-menu label.
#
    label $w.label -text $label
#
# Get the name of the variable this is to be used to trace menu-value
# changes.
#
    set var global$w.menu
    global $var
#
# Create the option menu.
    eval tk_optionMenu $w.menu $var $name_list
    trace variable $var w $cmd 
#
# Set the width of the menu button to be the maxmimum of all
# menu options. This removes the need for dynamic resizing.
#
    set maxwidth 0
    foreach name $name_list {
	set length [string length $name]
	if [ expr $length > $maxwidth ] {
	    set maxwidth $length
	}
    }
    $w.menu configure -width $maxwidth
#
# Place the label to the left of the menu button.
#
    pack $w.label $w.menu -side left
}


proc repaint_raw { which x } {
    global loaded color_map text_flag ax1 ax2 slice_active  min max color_map bright contra sign 

#
# $which define w
#

#    puts stdout "$x $which"
    if {$loaded!=0} {
	if {$which==0} {
	    recolor_image $color_map 0
	}
	if {$which==1} {
	    set old_text_flag $text_flag
#	    if {$text_flag<4} {
#		set text_flag 3
#	    }
	    plot_spaxel $ax1($slice_active) $ax2($slice_active) 1 $slice_active $min $max $color_map $bright $contra $sign
	    set text_flag $old_text_flag
	}
	if {$which==2} {
		if {$loaded!=0} {
		    plot_spectra_sel
		}
	}
    }
}


#
# Command entry pannel
#

proc create_command_entry { w } {
    frame $w.frame -relief raised -bd 1 -width 80 
    pack $w.frame -side left -fill y
    label $w.frame.label -width 12 -text "Command:"
    entry $w.frame.command_entry -relief sunken -bd 2 -width 100 -textvariable new_command  
    pack $w.frame.label -side left
    pack $w.frame.command_entry -side left
    bind $w.frame.command_entry <Return> {
	after 1 $new_command
	set new_command ""
#	Eval $new_command    
#	exec -- $new_command    
#	set out [$new_command]    
#	set fid [open "input.e3d" RDWR 0777]	
#	puts $fid $new_command
#	close $fid
#	file mo
    }
}

proc create_info_panel { w which } {
    global min max colormap loaded bright contra sign x1 x2 w1 w2 start_w delta_w text_flag ax1 ax2 slice_active color_map dev_id1 nb_spec first_spec last_spec nb_spec delta_spec last_spax_id flux_spax x_si y_si
    frame $w -relief raised -bd 1 -width 30 
    pack $w -side top -fill y
    #
    # Max Min
    #    
    frame $w.top -width 30 -borderwidth 2 
    pack $w.top -side top -fill y
    frame $w.bottom -width 30 -borderwidth 2 
    pack $w.bottom -side top -fill y
    label $w.bottom.min -width 12 -text "Min:"
    pack $w.bottom.min -side left
    entry $w.bottom.min_e -relief sunken -bd 2 -width 12 -textvariable min    
    pack $w.bottom.min_e -side left
    label $w.top.max -width 12 -text "Max:"
    pack $w.top.max -side left
    entry $w.top.max_e -relief sunken -bd 2 -width 12 -textvariable max        
    pack $w.top.max_e -side left
    if {$which==0} {
	bind $w.top.max_e <Return> {
	    if {$loaded!=0} {
		recolor_image $color_map 0
	    }
	}
    }
    if {$which==2} {
	bind $w.top.max_e <Return> {
	    if {$loaded!=0} {
		plot_spectra_sel
	    }
	}
    }
    if {$which==1} {
	bind $w.top.max_e <Return> {
	    if {$loaded!=0} {
		set old_text_flag $text_flag
#		if {$text_flag<4} {
#		    set text_flag 3
#		}
		plot_spaxel $ax1($slice_active) $ax2($slice_active) 1 $slice_active $min $max $color_map $bright $contra $sign
		set text_flag $old_text_flag
	    }
	}
    }
    if {$which==0} {
	bind $w.bottom.min_e <Return> {
	    if {$loaded!=0} {
		recolor_image $color_map 0
	    }
	}
    }
    if {$which==2} {
	bind $w.bottom.min_e <Return> {
	    if {$loaded!=0} {
		plot_spectra_sel
	    }
	}
    }
    if {$which==1} {
	bind $w.bottom.min_e <Return> {
	    if {$loaded!=0} {
		set old_text_flag $text_flag
#		if {$text_flag<4} {
#		set text_flag 3
#		}
		plot_spaxel $ax1($slice_active) $ax2($slice_active) 1 $slice_active $min $max $color_map $bright $contra $sign
		set text_flag $old_text_flag
	    }
	}
    }


    #
    # Bright/Contrast
    #    

    frame $w.bright -width 30 -borderwidth 2 
    pack $w.bright -side top -fill y
    label $w.bright.text -width 12 -text "Bright:"
    pack $w.bright.text -side left
    entry $w.bright.entry -relief sunken -bd 2 -width 12 -textvariable bright    
    pack $w.bright.entry -side left
    if {$which==0} {
	bind $w.bright.entry <Return> {
	    if {$loaded!=0} {
		recolor_image $color_map 0
	    }
	}
    }
    if {$which==2} {
	bind $w.bright.entry <Return> {
	    if {$loaded!=0} {
		plot_spectra_sel
	    }
	}
    }
    if {$which==1} {
	bind $w.bright.entry <Return> {
	    if {$loaded!=0} {
		set old_text_flag $text_flag
#		if {$text_flag<4} {
#		set text_flag 3
#		}
		plot_spaxel $ax1($slice_active) $ax2($slice_active) 1 $slice_active $min $max $color_map $bright $contra $sign
		set text_flag $old_text_flag
	    }
	}
    }

    frame $w.bright_scale -width 30
    pack $w.bright_scale -side top -fill y
    scale $w.bright_scale.scale -from 0.01 -to 0.99 -resolution 0.01 -length 150 -variable bright -orient horizontal -command "repaint_raw $which" -showvalue false
    pack $w.bright_scale.scale -side top

    frame $w.contra -width 30 -borderwidth 2 
    pack $w.contra -side top -fill y
    label $w.contra.text -width 12 -text "Contra:"
    pack $w.contra.text -side left
    entry $w.contra.entry -relief sunken -bd 2 -width 12 -textvariable contra    
    pack $w.contra.entry -side left
    if {$which==0} {
	bind $w.contra.entry <Return> {
	    if {$loaded!=0} {
		recolor_image $color_map 0
	    }
	}
    }
    if {$which==2} {
	bind $w.contra.entry <Return> {
	    if {$loaded!=0} {
		plot_spectra_sel
	    }
	}
    }
    if {$which==1} {
	bind $w.contra.entry <Return> {
	    if {$loaded!=0} {
		set old_text_flag $text_flag
#		if {$text_flag<4} {
#		set text_flag 3
#		}
		plot_spaxel $ax1($slice_active) $ax2($slice_active) 1 $slice_active $min $max $color_map $bright $contra $sign
		set text_flag $old_text_flag
	    }
	}
    }
    frame $w.contra_scale -width 30
    pack $w.contra_scale -side top -fill y
    scale $w.contra_scale.scale -from 0.01 -to 0.99 -resolution 0.01 -length 150 -variable contra -orient horizontal -command "repaint_raw $which" -showvalue false
    pack $w.contra_scale.scale -side top


    #
    # Wavelength cut
    #
    frame $w.w1 -width 30 -borderwidth 2 
    pack $w.w1 -side top -fill y
    label $w.w1.text -width 12 -text "W1:"
    pack $w.w1.text -side left
    entry $w.w1.entry -relief sunken -bd 2 -width 12 -textvariable w1    
    pack $w.w1.entry -side left
    bind $w.w1.entry <Return> {
	if {$loaded!=0} {
	    set temp_x1 [expr int(($w1-$start_w)/$delta_w)]
	    if {$x1!=$temp_x1} {
		set x1 $temp_x1
		plot_spaxel $x1 $x2 0 -1  $min $max $color_map $bright $contra $sign
		set w1 [expr ($start_w+$delta_w*$x1)]
#	    set w2 [expr ($start_w+$delta_w*$xp2)]
	    }
	}
    }

    frame $w.w2 -width 30 -borderwidth 2 
    pack $w.w2 -side top -fill y
    label $w.w2.text -width 12 -text "W2:"
    pack $w.w2.text -side left
    entry $w.w2.entry -relief sunken -bd 2 -width 12 -textvariable w2    
    pack $w.w2.entry -side left
    bind $w.w2.entry <Return> {
	if {$loaded!=0} {
	    set temp_x2 [expr int(($w2-$start_w)/$delta_w)]
	    if {$x2!=$temp_x2} {
		set x2 $temp_x2
		plot_spaxel $x1 $x2 0 -1  $min $max $color_map $bright $contra $sign
#		set w1 [expr ($start_w+$delta_w*$x1)]
	    set w2 [expr ($start_w+$delta_w*$x2)]
	    }
	}
    }

    if {$which==1} {
	frame $w.spax -width 30 -borderwidth 2 
	pack $w.spax -side top -fill y
	label $w.spax.text -width 12 -text "SPAX.ID:"
	pack $w.spax.text -side left
	entry $w.spax.entry -relief sunken -bd 2 -width 12 -textvariable last_spax_id    
	pack $w.spax.entry -side left
	frame $w.flux -width 30 -borderwidth 2 
	pack $w.flux -side top -fill y
	label $w.flux.text -width 12 -text "FLUX:"
	pack $w.flux.text -side left
	entry $w.flux.entry -relief sunken -bd 2 -width 12 -textvariable flux_spax    
#x_si
#
	pack $w.flux.entry -side left

	frame $w.x -width 30 -borderwidth 2 
	pack $w.x -side top -fill y
	label $w.x.text -width 12 -text "X:"
	pack $w.x.text -side left
	entry $w.x.entry -relief sunken -bd 2 -width 12 -textvariable x_si    
	pack $w.x.entry -side left

	frame $w.y -width 30 -borderwidth 2 
	pack $w.y -side top -fill y
	label $w.y.text -width 12 -text "Y:"
	pack $w.y.text -side left
	entry $w.y.entry -relief sunken -bd 2 -width 12 -textvariable y_si
	pack $w.y.entry -side left



	frame $w.n_flux_spax -width 30 -borderwidth 2 
	pack $w.n_flux_spax -side top -fill y
	label $w.n_flux_spax.text -width 12 -text "N.SPAXELS:"
	pack $w.n_flux_spax.text -side left
	entry $w.n_flux_spax.entry -relief sunken -bd 2 -width 12 -textvariable n_flux_spax
	pack $w.n_flux_spax.entry -side left

	frame $w.mean_flux_spax -width 30 -borderwidth 2 
	pack $w.mean_flux_spax -side top -fill y
	label $w.mean_flux_spax.text -width 12 -text "MEAN:"
	pack $w.mean_flux_spax.text -side left
	entry $w.mean_flux_spax.entry -relief sunken -bd 2 -width 12 -textvariable mean_flux_spax
	pack $w.mean_flux_spax.entry -side left

	frame $w.sigma_flux_spax -width 30 -borderwidth 2 
	pack $w.sigma_flux_spax -side top -fill y
	label $w.sigma_flux_spax.text -width 12 -text "SIGMA:"
	pack $w.sigma_flux_spax.text -side left
	entry $w.sigma_flux_spax.entry -relief sunken -bd 2 -width 12 -textvariable sigma_flux_spax
	pack $w.sigma_flux_spax.entry -side left


    }

    frame $w.w3 -width 30 -borderwidth 2 
    pack $w.w3 -side top -fill y
    if {$which==0} {
	button $w.w3.zoom -text Zoom -command {	
#	    puts "$x1 $x2 $w1 $w2 $dev_id1"
#	    set w1 
#	    set w2 [expr ($start_w+$delta_w*$xp2)]
#	    euro3d zoom_raw $x1 $x2 $dev_id1
	    euro3d zoom_raw [expr (($w1-$start_w)/$delta_w)] [expr (($w2-$start_w)/$delta_w)] $dev_id1
	    if {$loaded!=0} {
		recolor_image $color_map 0
	    }
	}	
	pack $w.w3.zoom -side left
    }
    if {$which==2} {
	button $w.w3.zoom -text Zoom -command {	
#	    euro3d zoom_raw $x1 $x2 $dev_id3
	    euro3d zoom_raw [expr (($w1-$start_w)/$delta_w)] [expr (($w2-$start_w)/$delta_w)] $dev_id3
	    if {$loaded!=0} {
		plot_spectra_sel
	    }
	}	
	pack $w.w3.zoom -side left
    }


    if {$which==0} {
	button $w.w3.rel -text Release -command {	
	    global max_n nb_spec delta_spec first_spec last_spec
	    set first_spec 0
	    set delta_spec 256
	    if {$delta_spec>$nb_spec} {
		set delta_spec $nb_spec
	    }
	    set last_spec [expr $first_spec+$delta_spec]
	    set max_n [expr $nb_spec-$delta_spec]
	    if {$max_n<0} {
		set max_n 0
	    }
	    .info_panel.fl_scale.scale configure -to $max_n 
	    euro3d set_first_last $first_spec $last_spec

	    euro3d release_raw $dev_id1
	    if {$loaded!=0} {
		recolor_image $color_map 0
	    }
	}	
	pack $w.w3.rel -side right
    }
    if {$which==2} {
	button $w.w3.rel -text Release -command {	
	    euro3d release_raw $dev_id1
	    if {$loaded!=0} {
	    plot_spectra_sel
	    }
	}	
	pack $w.w3.rel -side right

    }
    


    if {$which==0} {
	global nb_spec last_spec first_spec color_map delta_spec
	frame $w.fl -width 30 -borderwidth 2 
	pack $w.fl -side top -fill y
	label $w.fl.text -width 30 -text "Range of Spectra plotted"
	pack $w.fl.text -side top
	label $w.fl.text1 -width 6 -text "First:"
	pack $w.fl.text1 -side left
	entry $w.fl.entry1 -relief sunken -bd 2 -width 6 -textvariable first_spec    
	pack $w.fl.entry1 -side left
	label $w.fl.text2 -width 6 -text "Range:"
	pack $w.fl.text2 -side left
	entry $w.fl.entry2 -relief sunken -bd 2 -width 6 -textvariable delta_spec    
	pack $w.fl.entry2 -side left
	bind $w.fl.entry1 <Return> { fl_scale_pro 0 }
#{
#	    global loaded first_spec last_spec color_map delta_spec
#	    set last_spec [expr $first_spec+$delta_spec]
#	    if {$loaded!=0} {
#		euro3d set_first_last $first_spec $last_spec
#		recolor_image $color_map 0
#	    }
#	}
	bind $w.fl.entry2 <Return> { 
	    set max_n [expr $nb_spec-$delta_spec]
	    if {$max_n<0} {
		set max_n 0
	    }
	    .info_panel.fl_scale.scale configure -to $max_n 
	    fl_scale_pro 1 
	}
#{
#	    global loaded first_spec last_spec color_map delta_spec
#	    set last_spec [expr $first_spec+$delta_spec]
#	    if {$loaded!=0} {
#		euro3d set_first_last $first_spec $last_spec
#		recolor_image $color_map 0
#	    }
#	}
	
	set max_n [expr $nb_spec-$delta_spec]
	if {$max_n<0} {
	    set max_n 0
	}

	frame $w.fl_scale -width 30
	pack $w.fl_scale -side top -fill y
	scale $w.fl_scale.scale -from 0 -to $max_n -resolution 1 -length 150 -variable first_spec -orient horizontal -showvalue false -com fl_scale_pro
	pack $w.fl_scale.scale -side top
    }
}

proc fl_scale_pro { w } {
    global first_spec last_spec nb_spec color_map delta_spec
    set last_spec [expr $first_spec+$delta_spec]
#    set last_spec [expr $first_spec+256];
    if {$last_spec>$nb_spec} {
	set last_spec $nb_spec
    }
    euro3d set_first_last $first_spec $last_spec
    recolor_image $color_map $w
} 


proc create_prompt_dialog {w title msg} {
#
# Create the toplevel dialog window withdrawn.
#
    toplevel $w -class dialog
    wm withdraw $w
    wm title $w $title
    wm iconname $w Dialog
#
# Create the top and bottom frames.
#
    frame $w.top -relief raised -bd 1
    pack $w.top -side top -fill both -expand 1
    frame $w.bot -relief raised -bd 1
    pack $w.bot -side bottom -fill both -expand 1
#
# Create a label and an entry widget in the top frame.
#
    message $w.top.msg -justify left -width 8c -anchor w -text $msg
    entry $w.top.entry -relief sunken -bd 2 -width 30
    pack $w.top.msg $w.top.entry -side top -anchor w
#
# Create three buttons in the bottom frame.
#
    button $w.bot.ok -text OK
    button $w.bot.cancel -text Cancel -command "wm withdraw $w"
    button $w.bot.help -text Help -state disabled
    pack $w.bot.ok $w.bot.cancel $w.bot.help -side left -expand 1 -pady 2m -padx 2m
#
# Arrange for carriage-return to invoke the OK key.
#
    bind $w <Return> "$w.bot.ok invoke"
}

#
# Dialog for exporting the RSS and the position table
#

proc export_rss_dialog {w} {
#
# Create the toplevel dialog window withdrawn.
#
    toplevel $w -class dialog
    wm withdraw $w
    wm title $w "Export Row Staked Spectra"
    wm iconname $w Dialog
#
# Create the top and bottom frames.
#
    frame $w.top -relief raised -bd 1
    pack $w.top -side top -fill both -expand 1
    frame $w.bot -relief raised -bd 1
    pack $w.bot -side bottom -fill both -expand 1
#
# Create a label and an entry widget in the top frame.
#
    message $w.top.msg -justify left -width 8c -anchor w -text "RSS Fits file:"
    entry $w.top.entry -relief sunken -bd 2 -width 30 
    pack $w.top.msg $w.top.entry -side top -anchor w

    message $w.top.msg2 -justify left -width 8c -anchor w -text "Position Table File:"
    entry $w.top.entry2 -relief sunken -bd 2 -width 30 
    pack $w.top.msg2 $w.top.entry2 -side top -anchor w
#
# Create three buttons in the bottom frame.
#
    button $w.bot.ok -text OK 
    button $w.bot.cancel -text Cancel -command "wm withdraw $w"
    button $w.bot.help -text Help -state disabled
    pack $w.bot.ok $w.bot.cancel $w.bot.help -side left -expand 1 -pady 2m -padx 2m
#
# Arrange for carriage-return to invoke the OK key.
#
    bind $w <Return> "$w.bot.ok invoke"
}

proc create_export_rss_dialog {w} {
    export_rss_dialog $w
    $w.bot.ok configure -command "wm withdraw $w; update; export_rss $w; recolor_image grey 0;"
}

proc export_rss {w} {
    set fitsfilename [$w.top.entry get]    
    set positiontable_file [$w.top.entry2 get]    
#    puts stdout "1=$fitsfilename 2=$positiontable_file"

    if {$fitsfilename==""} {
	set fitsfilename "rss_default.fits"
    }
    if {$positiontable_file==""} {
	set positiontable_file "pt_default.txt"
    }
    euro3d export_rss $fitsfilename $positiontable_file;
}


proc create_import_rss_dialog {w} {
    export_rss_dialog $w
    $w.bot.ok configure -command "wm withdraw $w; update; import_rss $w; recolor_image grey 0;"
}

proc import_rss {w} {
    global loaded dev_id1 npix nb_spec min max start_w end_w delta_w n_groups w1 w2 with_shm first_spec last_spec

    set fitsfilename [$w.top.entry get]    
    set positiontable_file [$w.top.entry2 get]    
#    puts stdout "1=$fitsfilename 2=$positiontable_file"

    if {$fitsfilename==""} {
	set fitsfilename "rss_default.fits"
    }
    if {$positiontable_file==""} {
	set positiontable_file "pt_default.txt"
    }

    set exist_file [file exist $fitsfilename] 
    if {$exist_file} {
	euro3d import_rss $fitsfilename $positiontable_file;
	set data [euro3d ask_e3d_info]
	set npix [lindex $data 0]
	set nb_spec [lindex $data 1]    
	set start_w [lindex $data 2]    
	set end_w [lindex $data 3]
	set delta_w [lindex $data 4]
	set n_groups [lindex $data 5]
	set min [lindex $data 6]
	set max [lindex $data 7]
	set first_spec [lindex $data 8]
	set last_spec [lindex $data 9]
	
	set max_n [expr $nb_spec-256]
	if {$max_n<0} {
	    set max_n 0
	}
	.info_panel.fl_scale.scale configure -to $max_n 
    #	puts stdout "MAX_N=$max_n"
    
	write_output_e3d_file $data
	
	set w1 [expr ($start_w+$delta_w*0.0)]
	set w2 [expr ($start_w+$delta_w*1.0)]
	
	set tam_x [expr $npix*0.7]
	set tam_y [expr $nb_spec*1.2]
	if {$tam_x>400} {
	    set tam_x 400
	}
	if {$tam_x<200} {
	    set tam_x 200
	}
	if {$tam_y>400} {
	    set tam_y 400
	}
	if {$tam_y<200} {
	    set tam_y 200
	}
	
	set loaded 1
    }
}



proc new_import_rss {fitsfilename positiontable_file} {
    global loaded dev_id1 npix nb_spec min max start_w end_w delta_w n_groups w1 w2 with_shm first_spec last_spec

#    set fitsfilename [$w.top.entry get]    
#    set positiontable_file [$w.top.entry2 get]    
#    puts stdout "1=$fitsfilename 2=$positiontable_file"

#    if {$fitsfilename==""} {
#	set fitsfilename "rss_default.fits"
#    }
#    if {$positiontable_file==""} {
#	set positiontable_file "pt_default.txt"
#    }

    set exist_file [file exist $fitsfilename] 
    if {$exist_file} {
	euro3d import_rss $fitsfilename $positiontable_file;
	set data [euro3d ask_e3d_info]
	set npix [lindex $data 0]
	set nb_spec [lindex $data 1]    
	set start_w [lindex $data 2]    
	set end_w [lindex $data 3]
	set delta_w [lindex $data 4]
	set n_groups [lindex $data 5]
	set min [lindex $data 6]
	set max [lindex $data 7]
	set first_spec [lindex $data 8]
	set last_spec [lindex $data 9]
	
	set max_n [expr $nb_spec-256]
	if {$max_n<0} {
	    set max_n 0
	}
	.info_panel.fl_scale.scale configure -to $max_n 
    #	puts stdout "MAX_N=$max_n"
    
	write_output_e3d_file $data
	
	set w1 [expr ($start_w+$delta_w*0.0)]
	set w2 [expr ($start_w+$delta_w*1.0)]
	
	set tam_x [expr $npix*0.7]
	set tam_y [expr $nb_spec*1.2]
	if {$tam_x>400} {
	    set tam_x 400
	}
	if {$tam_x<200} {
	    set tam_x 200
	}
	if {$tam_y>400} {
	    set tam_y 400
	}
	if {$tam_y<200} {
	    set tam_y 200
	}
	
	set loaded 1
    }
}


proc create_export_cube_dialog {w} {
    create_prompt_dialog $w "Save a data Cube" "Enter File Name"
    $w.bot.ok configure -command "wm withdraw $w; update; export_cube $w; recolor_image grey 0;"
}

proc export_cube {w} {
    set fitsfilename [$w.top.entry get]    
#    set positiontable_file [$w.top.entry2 get]    
#    puts stdout "1=$fitsfilename 2=$positiontable_file"

    if {$fitsfilename==""} {
	set fitsfilename "cube_default.fits"
    }

    euro3d export_cube $fitsfilename 
}


proc create_import_cube_dialog {w} {
    create_prompt_dialog $w "Load a Cube File" "Enter File Name"
    $w.bot.ok configure -command "wm withdraw $w; update; import_cube $w; recolor_image grey 0;"
}


proc import_cube {w} {
    global loaded dev_id1 npix nb_spec min max start_w end_w delta_w n_groups w1 w2 with_shm first_spec last_spec

    set fitsfilename [$w.top.entry get]    
#    set positiontable_file [$w.top.entry2 get]    
#    puts stdout "1=$fitsfilename 2=$positiontable_file"

    set exist_file [file exist $fitsfilename] 
    if {$exist_file} {
	euro3d import_cube $fitsfilename 
	set data [euro3d ask_e3d_info]
	set npix [lindex $data 0]
	set nb_spec [lindex $data 1]    
	set start_w [lindex $data 2]    
	set end_w [lindex $data 3]
	set delta_w [lindex $data 4]
	set n_groups [lindex $data 5]
	set min [lindex $data 6]
	set max [lindex $data 7]
	set first_spec [lindex $data 8]
	set last_spec [lindex $data 9]
	
	set max_n [expr $nb_spec-256]
	if {$max_n<0} {
	    set max_n 0
	}
	.info_panel.fl_scale.scale configure -to $max_n 
    #	puts stdout "MAX_N=$max_n"
    
	write_output_e3d_file $data
	
	set w1 [expr ($start_w+$delta_w*0.0)]
	set w2 [expr ($start_w+$delta_w*1.0)]
	
	set tam_x [expr $npix*0.7]
	set tam_y [expr $nb_spec*1.2]
	if {$tam_x>400} {
	    set tam_x 400
	}
	if {$tam_x<200} {
	    set tam_x 200
	}
	if {$tam_y>400} {
	    set tam_y 400
	}
	if {$tam_y<200} {
	    set tam_y 200
	}
	
	set loaded 1
    }
}


proc new_import_cube {fitsfilename} {
    global loaded dev_id1 npix nb_spec min max start_w end_w delta_w n_groups w1 w2 with_shm first_spec last_spec

#    set fitsfilename [$w.top.entry get]    
#    set positiontable_file [$w.top.entry2 get]    
#    puts stdout "1=$fitsfilename 2=$positiontable_file"

    set exist_file [file exist $fitsfilename] 
    if {$exist_file} {
	euro3d import_cube $fitsfilename 
	set data [euro3d ask_e3d_info]
	set npix [lindex $data 0]
	set nb_spec [lindex $data 1]    
	set start_w [lindex $data 2]    
	set end_w [lindex $data 3]
	set delta_w [lindex $data 4]
	set n_groups [lindex $data 5]
	set min [lindex $data 6]
	set max [lindex $data 7]
	set first_spec [lindex $data 8]
	set last_spec [lindex $data 9]
	
	set max_n [expr $nb_spec-256]
	if {$max_n<0} {
	    set max_n 0
	}
	.info_panel.fl_scale.scale configure -to $max_n 
    #	puts stdout "MAX_N=$max_n"
    
	write_output_e3d_file $data
	
	set w1 [expr ($start_w+$delta_w*0.0)]
	set w2 [expr ($start_w+$delta_w*1.0)]
	
	set tam_x [expr $npix*0.7]
	set tam_y [expr $nb_spec*1.2]
	if {$tam_x>400} {
	    set tam_x 400
	}
	if {$tam_x<200} {
	    set tam_x 200
	}
	if {$tam_y>400} {
	    set tam_y 400
	}
	if {$tam_y<200} {
	    set tam_y 200
	}
	
	set loaded 1
    }
}


proc import_map {fitsfilename} {
    global loaded dev_id1 npix nb_spec min max start_w end_w delta_w n_groups w1 w2 with_shm first_spec last_spec

#    set fitsfilename [$w.top.entry get]    
#    set positiontable_file [$w.top.entry2 get]    
#    puts stdout "1=$fitsfilename 2=$positiontable_file"

    set exist_file [file exist $fitsfilename] 
    if {$exist_file} {
	euro3d import_map $fitsfilename 
	set data [euro3d ask_e3d_info]
	set npix [lindex $data 0]
	set nb_spec [lindex $data 1]    
	set start_w [lindex $data 2]    
	set end_w [lindex $data 3]
	set delta_w [lindex $data 4]
	set n_groups [lindex $data 5]
	set min [lindex $data 6]
	set max [lindex $data 7]
	set first_spec [lindex $data 8]
	set last_spec [lindex $data 9]
	
	set max_n [expr $nb_spec-256]
	if {$max_n<0} {
	    set max_n 0
	}
	.info_panel.fl_scale.scale configure -to $max_n 
    #	puts stdout "MAX_N=$max_n"
    
	write_output_e3d_file $data
	
	set w1 [expr ($start_w+$delta_w*0.0)]
	set w2 [expr ($start_w+$delta_w*1.0)]
	
	set tam_x [expr $npix*0.7]
	set tam_y [expr $nb_spec*1.2]
	if {$tam_x>400} {
	    set tam_x 400
	}
	if {$tam_x<200} {
	    set tam_x 200
	}
	if {$tam_y>400} {
	    set tam_y 400
	}
	if {$tam_y<200} {
	    set tam_y 200
	}
	
	set loaded 1
    }
}


proc import_spectra {fitsfilename} {
    global loaded dev_id1 npix nb_spec min max start_w end_w delta_w n_groups w1 w2 with_shm first_spec last_spec

#    set fitsfilename [$w.top.entry get]    
#    set positiontable_file [$w.top.entry2 get]    
#    puts stdout "1=$fitsfilename 2=$positiontable_file"

    set exist_file [file exist $fitsfilename] 
    if {$exist_file} {
	euro3d import_spectra $fitsfilename 
	set data [euro3d ask_e3d_info]
	set npix [lindex $data 0]
	set nb_spec [lindex $data 1]    
	set start_w [lindex $data 2]    
	set end_w [lindex $data 3]
	set delta_w [lindex $data 4]
	set n_groups [lindex $data 5]
	set min [lindex $data 6]
	set max [lindex $data 7]
	set first_spec [lindex $data 8]
	set last_spec [lindex $data 9]
	
	set max_n [expr $nb_spec-256]
	if {$max_n<0} {
	    set max_n 0
	}
	.info_panel.fl_scale.scale configure -to $max_n 
    #	puts stdout "MAX_N=$max_n"
    
	write_output_e3d_file $data
	
	set w1 [expr ($start_w+$delta_w*0.0)]
	set w2 [expr ($start_w+$delta_w*1.0)]
	
	set tam_x [expr $npix*0.7]
	set tam_y [expr $nb_spec*1.2]
	if {$tam_x>400} {
	    set tam_x 400
	}
	if {$tam_x<200} {
	    set tam_x 200
	}
	if {$tam_y>400} {
	    set tam_y 400
	}
	if {$tam_y<200} {
	    set tam_y 200
	}
	
	set loaded 1
    }
}



proc create_load_dialog {w} {
    create_prompt_dialog $w "Load a file" "Enter File Name"
    $w.bot.ok configure -command "wm withdraw $w; update; load_file $w; recolor_image grey 0;"
}


proc create_save_dialog {w} {
    create_prompt_dialog $w "Save a file" "Enter File Name"
    $w.bot.ok configure -command "wm withdraw $w;update;save_file $w; recolor_image grey 0;"
}

proc save_file {w} {
    euro3d save_file [$w.top.entry get]    
}



proc load_e3d {w} {
    global loaded dev_id1 npix nb_spec min max start_w end_w delta_w n_groups w1 w2 with_shm first_spec last_spec
    if {$with_shm==1} {
	euro3d clean_server
    } 
   set exist_file [file exist $w] 
    #;puts "existe=$exist_file"
    if {$exist_file==1} {
	euro3d load_file $w
	set data [euro3d ask_e3d_info]
	set npix [lindex $data 0]
	set nb_spec [lindex $data 1]    
	set start_w [lindex $data 2]    
	set end_w [lindex $data 3]
	set delta_w [lindex $data 4]
	set n_groups [lindex $data 5]
	set min [lindex $data 6]
	set max [lindex $data 7]
	set first_spec [lindex $data 8]
	set last_spec [lindex $data 9]
	
	set max_n [expr $nb_spec-256]
	if {$max_n<0} {
	    set max_n 0
	}
        .info_panel.fl_scale.scale configure -to $max_n 
#	puts stdout "MAX_N=$max_n"

	write_output_e3d_file $data
	
	set w1 [expr ($start_w+$delta_w*0.0)]
	set w2 [expr ($start_w+$delta_w*1.0)]
	
	set tam_x [expr $npix*0.7]
	set tam_y [expr $nb_spec*1.2]
	if {$tam_x>400} {
	    set tam_x 400
	}
	if {$tam_x<200} {
	    set tam_x 200
	}
	if {$tam_y>400} {
	    set tam_y 400
	}
	if {$tam_y<200} {
	    set tam_y 200
	}
	#    puts stdout "TAM=$tam_x $tam_y"
#	.bottom.imagearea1.pgplot configure -width $tam_x
#	.bottom.imagearea1.pgplot configure -height $tam_y	
    set loaded 1
    } else {
	.top.panel.text configure -text "We cannot find the file";	
    }
    clean
}



proc load_file {w} {
    global loaded dev_id1 npix nb_spec min max start_w end_w delta_w n_groups w1 w2 with_shm
    set filename [$w.top.entry get]    
#    puts stdout "PASO!!!!!!!!!!!!!!!!!!"
#    puts stdout "FILE=$filename $exist_file"
    if {$loaded!=0} {
	    if {$with_shm==1} {
		euro3d clean_server
	    }
    }
    load_e3d $filename

}


########################################################################
# This procedures are used to catch the output from the server
########################################################################
proc exit_all {} {
    global with_shm
    if {$with_shm==1} {
	euro3d stop_server
    }
    exit
}

proc clean_server {} {
    euro3d clean_server
}



#-----------------------------------------------------------------------
# Draw the currently selected image function.
#-----------------------------------------------------------------------
proc start_server {args} {
    global server with_shm
#    upvar #0 global.function.menu mode_menu
#
# Display a busy-cursor.
#
    . configure -cursor {watch}
    .bottom.imagearea1.pgplot configure -cursor {}
    update
#
# Display the new function.
#

#    [euro3d start_server]
#    exec $server > e3d.log &
    if {$with_shm==1} {
	euro3d start_server
    }
#    open_device
#    set salida [euro3d message [.bottom.imagearea1.pgplot id] "E3D server started"]
#    puts stdout $salida



#    euro3d2 function $mode_menu
#    puts stdout $mode_menu
#
# Reset the cursor.

    . configure -cursor {}
    .bottom.imagearea1.pgplot configure -cursor {crosshair black white}
    update
#
# Arm the cursor of the image window for the selection of a slice.
#
#    prepare_for_slice
}


proc create_spax_area {w xsize ysize} {
#
# Frame the workarea.
#
    set c "c"
    set xsize $xsize$c
    set ysize $ysize$c
    frame $w -width $xsize -height $ysize -borderwidth 2 -colormap .bottom.imagearea1
    pgplot $w.pgplot -share true  -width $xsize -height $ysize -mincolors 256 -maxcolors 256 -bg black -fg white
    pack $w.pgplot -side left -fill both -expand true 
    pack $w -side top -fill both -expand true  
}



proc create_image_area {w} {
#
# Frame the workarea.
#

  frame $w -width 20c -height 10c -colormap new -visual default 




#-visual grey
#-colormap monochrome
#-colormap 8
#Colormap heat
#.grey -visual "greyscale"
#
# Create the PGPLOT image window.
#

#  canvas $w.c -width 20c -heigh 10c
#  pack $w.c -side left -fill both -expand true
#  $w.c create text 50 50 -text "Hello" -fill red

  pgplot $w.pgplot -share true  -width 20c -height 10c -mincolors 256 -maxcolors 12000 -bg black -fg white






#  pgplot $w.pgplot -share true  -width 20c -height 10c -bd 3 -bg black -fg white
#
# Create horizontal and vertical scroll-bars and have them
# call the pgplot xview and yview scroll commands to scroll the
# image within the window.
#

#  scrollbar $w.xscroll -command "$w.pgplot xview" -orient horizontal
#  scrollbar $w.yscroll -command "$w.pgplot yview" -orient vertical
#
# Tell the PGPLOT widget how to update the scrollbar sliders.
#
#  $w.pgplot configure -xscrollcommand "$w.xscroll set"
#  $w.pgplot configure -yscrollcommand "$w.yscroll set"
#
# Position the PGPLOT widget and the scrollbars.
#
#  pack $w.xscroll -side bottom -fill x
#  pack $w.yscroll -side right -fill y
  pack $w.pgplot -side left -fill both -expand true
#
# Bind motion events to the world coordinate x and y label widgets.
#
  bind $w.pgplot <Motion> {report_motion %W %x %y}
  bind $w.pgplot <B1-Motion> {change_brco %W %x %y}
  bind $w.pgplot <Button-1> {set_inspectors %W %x %y}
  bind $w.pgplot <Button-3> {
	global x1 x2 spax_catch spec_catch
      if {$spax_catch==1} {	  
	  plot_spaxel $x1 $x2 0 -1  $min $max $color_map $bright $contra $sign
      }
      if {$spec_catch==1} { 
	  plot_spectra
      }
  }

    bind $w.pgplot <B2-Motion> {
	global x1 x2 min max color_map bright contra sign spax_catch dev_id3 delta_x dev_id2 fill text_flag w1 w2 start_w delta_w first_spec type_spec_rep type_spec_save type_spec_n_buffer
	set xp1 [%W world x %x]
	set xp2 [expr $xp1+$delta_x]
	set yp1 [%W world y %y]
	set yp2 [expr $yp1+1]
	if {$spax_catch==1} {
	    spax_env plot_spaxels $min $max $dev_id2 $xp1 $xp2 $color_map $bright $contra $sign 1 $fill $text_flag
	    set w1 [expr ($start_w+$delta_w*$xp1)]
	    set w2 [expr ($start_w+$delta_w*$xp2)]
	}
	if {$spec_catch==1} {
	    set yyp [expr $yp1+$first_spec]
	    spec_env set_type_spec_rep $type_spec_rep 0 $type_spec_n_buffer
	    spec_env plot_spectra $min $max $dev_id3 0 $color_map $bright $contra $sign $yyp
	    spec_env set_type_spec_rep $type_spec_rep $type_spec_save $type_spec_n_buffer
	}
    }

    bind $w.pgplot <B2-ButtonRelease> {
	global x1 x2 min max color_map bright contra sign spax_catch dev_id3 delta_x dev_id2 fill text_flag w1 w2 start_w delta_w
	set xp1 [%W world x %x]
	set xp2 [expr $xp1+$delta_x]
	set yp1 [%W world y %y]
	set yp2 [expr $yp1+1]
	if {$spax_catch==1} {
	    if {$color_map=="rainbow"} {
		euro3d plot_line $dev_id3 1 1 2 [expr $start_w+$xp1*$delta_w] 0.0 [expr $start_w+$xp1*$delta_w] 10000.0
		euro3d plot_line $dev_id3 1 1 2 [expr $start_w+$xp2*$delta_w] 0.0 [expr $start_w+$xp2*$delta_w] 10000.0
	    } else {
		euro3d plot_line $dev_id3 5 1 2 [expr $start_w+$xp1*$delta_w] 0.0 [expr $start_w+$xp1*$delta_w] 10000.0
		euro3d plot_line $dev_id3 5 1 2 [expr $start_w+$xp2*$delta_w] 0.0 [expr $start_w+$xp2*$delta_w] 10000.0
	    }
	    plot_spaxel $xp1 $xp2 0 -1  $min $max $color_map $bright $contra $sign 
	}
	if {$spec_catch==1} {
	    set yyp [expr $yp1+$first_spec]
	    spec_env plot_spectra $min $max $dev_id3 0 $color_map $bright $contra $sign $yyp
	}
    }
  pack $w -side top -fill both -expand true
}

#-----------------------------------------------------------------------
# Create the area that contains the slice PGPLOT window.
#
# Input:
#  w            The name to give the frame widget that encloses the area.
#-----------------------------------------------------------------------
proc create_slice_area {w} {
#
# Frame the workarea.
#
  frame $w -width 11c -height 6c
#
# Create the PGPLOT slice window.
#
  pgplot $w.pgplot -share true  -width 10c -height 5c -maxcolors 2 -bd 2 -bg black -fg white
#
# Position the PGPLOT widget.
#
  pack $w.pgplot -side left -fill both -expand true
#
# Arrange for the plot to be redrawn whenever the widget is resized.
#
#  bind $w.pgplot <Configure> {euro3d redraw_slice}
}


#
# Procedure to create a drageable line
# 

proc drag_horz_line { w x } {
    global tcl_precision loaded xp yp npix nb_spec change_bc color_map bright contra x_map y_map
    set points { $x 0 $x 256 } 
    $w create line $points -tag line -joinstyle round -smooth true

}


#-----------------------------------------------------------------------
# This procedure is called whenever cursor motion is detected in the
# the image widget. It displays the world coordinates of the cursor
# in previously created label widgets.
#
# Input:
#  pg     The image pgplot widget.
#  x y    The X-window coordinates of the cursor.
#-----------------------------------------------------------------------



proc report_motion {pg x y} {
  global tcl_precision loaded xp yp npix nb_spec change_bc color_map bright contra x_map y_map start_w delta_w loaded x1 first_spec delta_spec x_si y_si
    
    if {$loaded==1} {
	set tcl_precision 3
	set pg .bottom.imagearea1.pgplot
	set x_map $x
	set y_map $y
	
	set xp [$pg world x $x]
	set yp [$pg world y $y]
	set tmp_w [expr $xp*$delta_w+$start_w]
	set tmp_spec floor([expr $yp*$delta_spec+$first_spec])
	.top.panel.x configure -text "$tmp_w"
	.top.panel.y configure -text "$yp"
	if ($loaded!=0) {
	    .top.panel.intensity configure -text "[euro3d intensity $xp $yp $npix $nb_spec]"
	} else {
	    .top.panel.intensity configure -text "NONE"
	}
	set tcl_precision 6
    }
    }

proc change_brco {pg x y} {
  global dev_id1 tcl_precision loaded xp yp npix nb_spec change_bc color_map bright contra
    set tcl_precision 2
    set pg .bottom.imagearea1.pgplot
    set xp [$pg world x $x]
    set yp [$pg world y $y]
    #
    # Procedure to change the contrast and the brightness
    # 
#    puts stdout "Paso\n"
    if {$loaded==1} {
	set xx [expr $xp/$npix]
	set yy [expr $yp/$nb_spec]
	
	if {$change_bc==1} {
	    set contra [euro3d bc $xx]
	    set bright [euro3d bc $yy]
	    if {$loaded!=0} {
		recolor_image $color_map 0
	    }
	}
	set tcl_precision 6
    }
}

#############################################
# Procedure that will draw a line if the 
# variable spax_catch=1 when clicking the Button-1
#############################################

proc set_inspectors {pg x y} {
  global dev_id1 tcl_precision loaded xp yp npix nb_spec change_bc color_map bright contra spax_catch n_lines x1 x2 n_spec_lines y1 y2 spec_catch selected_spectra start_w delta_w dev_id3 color_map first_spec w1 w2
    set tcl_precision 3
#    set pg .bottom.imagearea1.pgplot
    set xp [$pg world x $x]
    set yp [$pg world y $y]
#    puts "$pg $x $xp $y $xp"
    if {$pg==".spec.bottom.imagearea.pgplot"} {
	set xp [expr ($xp-$start_w)/$delta_w]	
    }


    #
    # Procedure to change the contrast and the brightness
    # 
#    puts stdout "Paso\n"

    if {$spax_catch==1} {
	if {$spec_catch==1} {
	    set spax_catch 0
	    set spec_catch 0
	}
    }

    if {$spax_catch==1} {
	if ($n_lines>1) {
	    set n_lines 0
	    recolor_image $color_map 0
	}
	if ($n_lines==0) {
	    set x1 $xp
	    set x2 [expr $xp+1]
	}
	if ($n_lines==1) {
	    set x2 $xp
	    if {$x2==$x1} {
	    set x2 [expr $xp+1]
	    }
	}

	set w1 [expr ($start_w+$delta_w*$x1)]
	set w2 [expr ($start_w+$delta_w*$x2)]
#	puts "$w1 $w2";

	euro3d plot_line $dev_id1 1 3 1 $xp 0.0 $xp $nb_spec.0
	if {$color_map=="rainbow"} {
	    euro3d plot_line $dev_id3 1 1 2 [expr $start_w+$xp*$delta_w] 0.0 [expr $start_w+$xp*$delta_w] 10000.0
	} else {
	    euro3d plot_line $dev_id3 5 1 2 [expr $start_w+$xp*$delta_w] 0.0 [expr $start_w+$xp*$delta_w] 10000.0
	}
	incr n_lines
    }

    if {$spec_catch==1} {
	if ($n_spec_lines>1) {
	    set n_spec_lines 0
	    recolor_image $color_map 0	    
	    set selected_spectra {}
	}
	if ($n_spec_lines==0) {
	    set y1 [expr int($yp)+$first_spec]
	    set selected_spectra {}
	    lappend selected_spectra $y1
	}
	if ($n_spec_lines==1) {
	    set selected_spectra {}
	    set y2 [expr int($yp)+$first_spec]
	    if {$y2<$y1} {
		set y_temp $y2
		set y2 $y1
		set y1 $y_temp
	    }
	    set y_1 [expr int($y1)]
	    set y_2 [expr int($y2)]
	    set j $y_1
	    #puts "$y_1 $y_2"
	    while {$j<=$y_2} {
		lappend selected_spectra $j
		incr j 1
	    }

	}
	euro3d plot_line $dev_id1 2 3 1 0.0 $yp $npix $yp
	incr n_spec_lines
    }

  set tcl_precision 6
}

proc blink {} {
    global blink_index start_blink n_blink ax1 ax2 blink_delay amax amin abright acontra asign acolor_map slice_active plot_name plot_file loaded fill text_flag
    foreach i $blink_index {
#	puts $blink_index
#	puts "i=$i"
	plot_spaxel $ax1($i) $ax2($i) 1 $i $amin($i) $amax($i) $acolor_map($i) $abright($i) $acontra($i) $asign($i)
	.spax.top.text configure -text "Blink $i";
	after $blink_delay
    }
}


#######################################################################
# MAIN
# Screen Set-UP
#######################################################################

wm title . "E3D: Euro3D Visualization Tool. v. 1.2" 

#.wm configure -expand true

#RAW_DATA variables
set first_spec 0
set delta_spec 256
set last_spec [expr $first_spec+$delta_spec]
set nb_spec 256

# ARITHMETIC FLAGS
set flag_ord 0
set flag_arith 0
set arith_index {}	    


# MAPs variables
set dpix 0.2
set grid_func 1
set grid_opt 0.0

#set p 2;
set contra 0.65
set bright 0.65
set sign 1.0
set min 0.0
set max 0.0
set color_map "grey"
set change_bc 0
set spax_catch 1
set n_lines 0

set spec_catch 0
set n_spec_lines 0
set n_spec 0
set increase_spec 0
set n_spax 0
set increase_spax 0


set x_pos 0
set y_pos 0

set n_plots 0
set n_gifs 0
set n_specs 0
set n_spec_as 0
set n_spec_tabs 0
set plot_name ""
set plot_file ""
#
# spaxel variables
# 
# w1 & w2 defines the wavelength range of the actual cut!!!
#
set x1 0
set x2 1
set delta_x 5
set w1 0 
set w2 1
set spax_ins 0
set n_slice 0
set start_blink 0
set n_blink 0
set blink_delay 500
set fill 1 
set text_flag 0
set select_spax 1
set ax1(0) 0
set ax2(0) 1
set abright(0) $bright
set acontra(0) $contra
set asign(0) $sign
set acolor_map(0) $color_map
set amin(0) $min
set amax(0) $max
set slice_active 0
set last_spax_id -1

set del_spax 0
set pseudoslit_sel 0
#
# spectra variables
#

set y1 0
set y2 1
set selected_spectra {}


frame .top -borderwidth 2 -relief raised
frame .bottom -borderwidth 2 
frame .bottom_entry -borderwidth 2 

create_command_entry .bottom_entry


create_info_panel .info_panel 0
#    entry $w.w1.entry -relief sunken -bd 2 -width 12 -textvariable sa_i1    
#    pack $w.w1.entry -side left

create_load_dialog .load
create_save_dialog .save
create_export_rss_dialog .export_rss
create_export_cube_dialog .export_cube
create_import_rss_dialog .import_rss
create_import_cube_dialog .import_cube


button .top.shm -text SHM -command {
    global with_shm
    if {$with_shm==0} {
	euro3d start_server
	set with_shm 1;
	.top.panel.text configure -text "SHM activated";	
    } else {
	euro3d stop_server
	set with_shm 0;
	.top.panel.text configure -text "SHM deactivated";	
    }
}

button .top.quit -text Quit -command exit_all -relief flat -underline 0

#
# FILE MENU
#
menubutton .top.file -text File -menu .top.file.menu -underline 0
set menu_file [menu .top.file.menu -tearoff 1 ]
$menu_file add command -label "Load" -command { 
#    wm deiconify .load
#    raise .load

    set type {
	{{fits file} {.fits} FITS}
    }
    load_e3d [tk_getOpenFile -filetypes $type -title "Euro3D Load File" -initialdir "."]
    recolor_image grey 0
}

$menu_file add command -label "Save" -command { 
    set type {
	{{fits file} {.fits} FITS}
    }
    euro3d save_file [tk_getSaveFile -filetypes $type -title "Euro3D Save File" -initialdir "."]    
#    wm deiconify .save
#    raise .save
}
$menu_file add separator

$menu_file add command -label "Import RSS" -command { 
    global root
    set type {
	{{fits file} {.fits} FITS}
	{{fits file} {.ex} FITS}
    }
    set fitsfilename [tk_getOpenFile -filetypes $type -title "Row Stacked Spectra Fits Load File" -initialdir "."]
    set type {
	{{ascii file} {.txt} ASCII}
	{{ascii file} {.dat} ASCII}
    }
    set pt_dir $root/data
#    puts $pt_dir
    set pt_filename [tk_getOpenFile -filetypes $type -title "Position Table Name" -initialdir $pt_dir]
    new_import_rss $fitsfilename $pt_filename
    recolor_image grey 0

#    wm deiconify .import_rss
#    raise .import_rss
}

$menu_file add command -label "Import CUBE" -command { 
#    wm deiconify .import_cube
#    raise .import_cube
    set type {
	{{fits file} {.fits} FITS}
	{{fits file} {.3d} FITS}
	{{fits file} {.cube} FITS}
    }
    new_import_cube [tk_getOpenFile -filetypes $type -title "FITS Cube Load File" -initialdir "."]

}
$menu_file add separator
$menu_file add command -label "Export RSS" -command { 
    global loaded root
    if ($loaded==1) {
#	wm deiconify .export_rss
#	raise .export_rss
#    global root
    set type {
	{{fits file} {.fits} FITS}
	{{fits file} {.ex} FITS}
    }
    set fitsfilename [tk_getSaveFile -filetypes $type -title "Row Stacked Spectra Fits Save File" -initialdir "."]
    set type {
	{{ascii file} {.txt} ASCII}
	{{ascii file} {.dat} ASCII}
    }
    set pt_dir $root/data
#    puts $pt_dir
    set pt_filename [tk_getSaveFile -filetypes $type -title "Position Table Name" -initialdir $pt_dir]
    euro3d export_rss $fitsfilename $pt_filename
    recolor_image grey 0
    }
}

$menu_file add command -label "Export CUBE" -command { 
    global loaded
    if ($loaded==1) {
	euro3d export_cube [tk_getSaveFile -filetypes $type -title "FITS Cube Save File" -initialdir "."]    

    }
}


$menu_file add separator

$menu_file add command -label "Import Slit Spectra" -command { 
    set type {
	{{fits file} {.fits} FITS}
	{{fits file} {.3d} FITS}
	{{fits file} {.cube} FITS}
    }
    import_spectra [tk_getOpenFile -filetypes $type -title "FITS Slit Load File" -initialdir "."]
}

$menu_file add command -label "Save Slit Spectra" -command { 
    global loaded
    if ($loaded==1) {
	euro3d save_raw [tk_getSaveFile -filetypes $type -title "FITS Spectra Save File" -initialdir "."]    

    }
}

$menu_file add command -label "Save Spectra (wavelength cut)" -command { 
    global loaded
    if ($loaded==1) {
	euro3d save_cut [tk_getSaveFile -filetypes $type -title "FITS Spectra Save File" -initialdir "."]    

    }
}

$menu_file add separator

$menu_file add command -label "Quit" -command { 
    exit_all
}

#button .top.load -text Load -command {
#}





button .top.draw -text Draw -command {
    set id [.bottom.imagearea1.pgplot id]
    euro3d draw_raw 500. 0. $id
} 


#
# INFO PANEL
#
frame .top.panel -width 10 -borderwidth 2  -relief flat -bd 1 -width 80 
label .top.panel.text -width 20 
label .top.panel.x_lab -width 2 -text "W:"
label .top.panel.x -width 10 
label .top.panel.y_lab -width 7 -text "SPAXEL:"
label .top.panel.y -width 10
label .top.panel.intensity_lab -width 5 -text "FLUX:"
label .top.panel.intensity -width 10

pack .top.panel.text -side left
pack .top.panel.x_lab -side left
pack .top.panel.x -side left
pack .top.panel.y_lab -side left
pack .top.panel.y -side left
pack .top.panel.intensity_lab -side left
pack .top.panel.intensity -side left







create_image_area .bottom.imagearea1

create_env euro3d [.bottom.imagearea1.pgplot device]
set dev_id1 [.bottom.imagearea1.pgplot id]





#create_env euro3d "/XWIN"
#set dev_id1 1

set loaded 0


#create_option_menu .top.colors "Select a color table:" recolor_image {
# grey rainbow heat iraf aips
#}


pack .top -side top -fill both
pack .bottom -side top -fill both -expand true
pack .bottom_entry -side top -fill x
pack .info_panel -side left -fill y 
#pack .top.load -side left
pack .top.file -side left

#pack .top.draw -side left



#create_menu_colormap .top.colormenu

create_spaxels_inspector .spax "Spaxel Inspector"
set dev_id2 [.spax.bottom.left.imagearea.pgplot id]
set obj_list .spax.info_panel.objects.list

#.spax.info_panel.objects.list insert end "test"



create_spectra_inspector .spec "Spectra Inspector"
set dev_id3 [.spec.bottom.imagearea.pgplot id]
set spec_list .spec.info_panel.objects.list


create_menu_spaxels .top.spax .spax

create_menu_spectra .top.spec .spec

#

#pack .top.colormenu -side left 
pack .top.spax -side left
pack .top.spec -side left


#
# Configuration MENU 
#
menubutton .top.config -text Configuration -menu .top.config.menu -underline 0
set menu_config [menu .top.config.menu -tearoff 1 ]
$menu_config add cascade -label ColorMap -menu $menu_config.colormap
set menu_config_out [menu $menu_config.colormap -tearoff 0]
$menu_config_out add command -label grey -command { recolor_image grey 0 }
$menu_config_out add command -label rainbow -command { recolor_image rainbow 0 }
$menu_config_out add command -label heat -command { recolor_image heat 0 }
$menu_config_out add command -label iraf -command { recolor_image iraf 0 }
$menu_config_out add command -label aips -command { recolor_image aips 0 }

$menu_config add cascade -label "Spectral Representation" -menu $menu_config.spec_rep
set menu_config_spec [menu $menu_config.spec_rep -tearoff 0]
$menu_config_spec add command -label "Image/Plot Mean" -command { set type_spec_rep 0; spax_env clean_device $dev_id3; plot_spectra_sel }
$menu_config_spec add command -label "Image" -command { set type_spec_rep 1; spax_env clean_device $dev_id3; plot_spectra_sel }
$menu_config_spec add command -label "Image/Plot All" -command { set type_spec_rep 2; spax_env clean_device $dev_id3; plot_spectra_sel }
$menu_config_spec add command -label "Plot All" -command { set type_spec_rep 3; spax_env clean_device $dev_id3; plot_spectra_sel }
$menu_config_spec add command -label "Plot Mean" -command { set type_spec_rep 4; spax_env clean_device $dev_id3;plot_spectra_sel }



create_map_definer .map
$menu_config add command -label "Interpolation" -command { 
    wm deiconify .map
    raise .map
}
create_spax_sel_definer .spax_sel
$menu_config add command -label "Spaxel Selection" -command { 
    wm deiconify .spax_sel
    raise .spax_sel
}
pack .top.config -side left

#
# DAR Correction Menu
#
menubutton .top.eff -text "DAR Tools" -menu .top.eff.menu -underline 0
set menu_eff [menu .top.eff.menu -tearoff 1 ]
$menu_eff add command -label "Th. Det. DAR" -command { 
    global dar_det
    .top.panel.text configure -text "Calculating"	
    euro3d theoretical_dar 
    .top.panel.text configure -text "Done"	
    set dar_det 1
}

$menu_eff add command -label "PM Det. DAR" -command { 
    global dar_det
   .top.panel.text configure -text "Calculating"	
    euro3d theoretical_dar
    set ref_pix [expr $npix/2];
    set delta_pix [expr $npix/100];
    if {$delta_pix<1} {
	set delta_pix 1
    }
    puts stdout "$ref_pix $delta_pix"
    euro3d pm_dar $ref_pix 50 0.02 1
   .top.panel.text configure -text "Done"	
    set dar_der 1
}

$menu_eff add command -label "Peak Det. DAR" -command { 
    global dar_det
   .top.panel.text configure -text "Calculating"	
    euro3d theoretical_dar
    set ref_pix [expr $npix/2];
    set delta_pix [expr $npix/50];
    if {$delta_pix<1} {
	set delta_pix 1
    }
    puts stdout "$ref_pix $delta_pix"
    euro3d peak_dar $ref_pix $delta_pix 0.02 1
   .top.panel.text configure -text "Done"	
    set dar_det 1
}

$menu_eff add command -label "Simple Det. DAR" -command { 
    global dar_det
   .top.panel.text configure -text "Calculating"	
    euro3d theoretical_dar
    set ref_pix [expr $npix/2];
    set delta_pix [expr $npix/50];
    if {$delta_pix<1} {
	set delta_pix 1
    }
    puts stdout "$ref_pix $delta_pix"
    euro3d simple_dar $ref_pix $delta_pix 0.02 1
   .top.panel.text configure -text "Done"	
    set dar_det 1
}

$menu_eff add command -label "Emp. Det. DAR" -command { 
    global dar_det
   .top.panel.text configure -text "Calculating"	
    euro3d theoretical_dar
    set ref_pix [expr $npix/2];
    set delta_pix [expr $npix/12];
    if {$delta_pix<1} {
	set delta_pix 1
    }
    puts stdout "$ref_pix $delta_pix"
    euro3d empirical_dar $ref_pix $delta_pix 0.05 1
   .top.panel.text configure -text "Done"	
    set dar_det 1
}

$menu_eff add separator

$menu_eff add command -label "Correct DAR" -command { 
    global dar_det
    if {$dar_det==1} {
	.top.panel.text configure -text "Correcting"
	puts stdout "Please Wait..."
	set out [euro3d correct_dar]
	.top.panel.text configure -text $out
	puts stdout $out
    } else {
	.top.panel.text configure -text "DAR still not determined"
    }
}


pack .top.quit -side right
pack .top.eff -side left

#
# SHM deactivated. Not working propertly
#
#pack .top.shm -side right
pack .top.panel -side left -fill none






pack .bottom.imagearea1 -side top -fill both -expand true





#wm withdraw .loco


#set this value to 1 if you want to use the SHM
set with_shm 0 

set dar_det 0
set sa_i1 0
set sa_i2 0
set sa_i3 0


set radius 1
set several 0
set flux_spax 0.0
set n_flux_spax 0
set mean_flux_spax 0.0
set sigma_flux_spax 0.0

#
# Spectral Buffer does not work propertly. 
# set type_spec_save 0, for not to save.
set type_spec_rep 0
set type_spec_save 0 
set type_spec_n_buffer -1
# 0=Single, 1=Several
set type_spec_rep_mem 0
set list_spec_mem {}


set reverse_obj 0
set current_obj -1
set x_si 0
set y_si 0

#event add <<EXISTE>> [file exist "/tmp/input.e3d"]
#
#event add <<EXISTE>> [file exist "/tmp/input.e3d"]
#bind 1 <<EXISTE>> { puts "YES"}
#external_call
file delete "/tmp/input.e3d"
every::schedule 100 source_e3d

#
#  toplevel .grey -visual "truecolor"


file delete /tmp/input.e3d
file delete /tmp/output.e3d
file delete /tmp/output_e3d.txt



set cut_pos {}
set n_cut_pos 0

start_server 



#
