#!/work2/ssa/code/lyon/e3d-1.2/user/bin/tk_e3d

if {$argc<13} {
    puts "plot_map.tcl FITSFILE PS_OUT MIN MAX bright contra W0 W1 flag sign n_cont COLORMAP FLAG_2"
    puts "where:";
    puts "W0,W1 are the start and end of the wavelength cuts"
    puts "flag could be 0,1,2,3,4 for different map representations"
    puts "sign could be 0 or 1"
    puts "n_cont is the number of contours, if applicable"
    puts "colormap: grey,heat,rainbow,iraf,aips"
    puts "FLAG_2: With BOX (2) without box (0)"
    puts ""
    puts "EG: plot_map.tcl e3d_cor.fits test.ps 0 50 0.65 0.80 6000 6600 1 1 10 heat 0"
    puts ""
    puts "Edit the 1st line from the output of 'which tk_e3d'"
    exit
}
set fitsfile [lindex $argv 0]
set psfile [lindex $argv 1]
set min [lindex $argv 2]
set max [lindex $argv 3]
set bright [lindex $argv 4]
set contra [lindex $argv 5]
set w0 [lindex $argv 6]
set w1 [lindex $argv 7]
set flag_i [lindex $argv 8]
set sign [lindex $argv 9]
set n_cont [lindex $argv 10]
set colormap [lindex $argv 11]
set new_img [lindex $argv 12]
if ($sign>1) {
    set sign 1
}
if ($sign<0) {
    set sign 0
}
if (($sign!=1)&&($sign!=0)) {
    set sign 1
}
if (($new_img!=2)&&($new_img!=0)) {
    set new_img 0
}
if ($sign==0) {
    set flag $flag_i
} else {
    set flag [expr (-1)*$flag_i]
}

#set flag -1
#set flag 4

create_env euro3d "/xwin"
euro3d load_file $fitsfile
#set bright 0.72
#set contra 0.66



set data [euro3d ask_e3d_info]
set npix [lindex $data 0]
set nb_spec [lindex $data 1]
set start_w [lindex $data 2]
set end_w [lindex $data 3]
set delta_w [lindex $data 4]
euro3d recolor_image heat 1 0.65 0.70 1



#euro3d set_grid 5 0.000001 0.3
#euro3d set_grid 5 1.01 0.3
euro3d set_grid 1 0.1 0.3
set i0 [expr ($w0-$start_w)/$delta_w]
set i1 [expr ($w1-$start_w)/$delta_w]


set id 1

#set bright 0.71
#set bright 0.71
#set contra 0.60
#set colormap heat
#set colormap rainbow
#set colormap iraf
#set min 1
#set max 1700
set c_red 0
set c_blue 0
set vel_11 0 
set vel_12 200
set vel_21 -200 
set vel_22 0

#set out [euro3d plot_spaxels $min $max $id $i0 $i1 $colormap $bright $contra 1 1 1 $flag 0 1 1]
set out [euro3d plot_spaxels $min $max $id $i0 $i1 $colormap $bright $contra 1 1 1 $flag $new_img 0 $n_cont]
puts $out
#euro3d plot_scale $min $max $id $bright $contra 1 $colormap Flux 200 700 0

set id_ps [euro3d open_device "$psfile/CPS"]
set out [euro3d plot_spaxels $min $max $id_ps $i0 $i1 $colormap $bright $contra 1 1 1 $flag $new_img 1 $n_cont]
set title "Flux"
#euro3d plot_scale $min $max $id_ps $bright $contra 1 $colormap $title 200 700 1

euro3d close_device $id_ps

exec gs $psfile

exit
