struct DAR {
  int n;
  float *dx;
  float *dy;
};

struct MARK {
  int n;
  float x[300];
  float y[300];
  char txt[300];
};

struct VELOCITY_MAP {
  int n;
  float lambda;
  int *id;
  float *x;
  float *y;
  float *f;
  float *e_f;
  float *w;
  float *e_w;
  float *dw;
  float *e_dw;
  int *q;
};

int read_velocity_map(char* filename, struct VELOCITY_MAP *vel_map, float sistemic, float resolution);
int read_cont_map(char* filename, struct VELOCITY_MAP *vel_map, float width);

int basic_stats(float *data, int n, float *mean, float *sigma, int sigma_clip);
int mark_range(float x1, float y1, float x2, float y2, char* text);
int ask_alive();
int ask_slice(float **out_raw_data, int nb_spec, int index_w);
int ask_spectrum(float **out_raw_data, int specId, int npix, int index_start);
int ask_raw_data(float **out_raw_data, int nb_spec, int npix, int delta_n);
int ask_e3d_info(E3D_file *e3d_frame, int **n_spaxels, SPAXEL ***spaxels, int **index_start, int **npts, GROUP **groups);
int ask_load_e3d(char *input_filename);
int ask_delete_shm();
int load_mem_all(E3D_file e3d_image, int *n_spaxels,SPAXEL **spaxels,int *index_start, int *npts, int *address);
int server();
int load_e3d(char *filename, E3D_file *e3d_frame, int **n_spaxels, SPAXEL ***spaxels, int **index_start, int **npts, float **raw_data, float **raw_noise);
int load_e3d_groups(char *filename, int *n_groups, GROUP **groups, float *common_parameters, int *nb_spec_out, int **n_spaxels, SPAXEL ***spaxels, int **index_start, int **npts, float **raw_data_temp, float **raw_noise);
int load_e3d_only_groups(char *filename, int *n_groups, GROUP **groups, float *common_paramters, int *nb_spec_out);
int load_e3d_only_data(char *filename, int nb_spec, int npix, int *n_spaxels, SPAXEL ***spaxels, int *index_start, int *npts, float *raw_data, float *raw_noise);
float* read_spax_int(int i_spec, int nb_spec, int npix);
int read_mem_group(GROUP **group,int key, int size);
int load_mem_group(GROUP *grupo, int key, int size, int *address);
int read_mem_int(int *out_int, int key, int size);
int load_mem_int(int *raw_data, int key, int size, int* address);
int  read_mem_char(char **out_shm,int key, int size);
char load_mem_char(char *raw_data, int key, int size, int* address);
int read_mem_spaxels(SPAXEL ***out_spax, int* n_spaxels, int key, int size);
int load_mem_spaxels(SPAXEL **spaxels, int* n_spaxels, int key, int size, int* address);
int read_mem_float(float **out_float, int key, int size);
int load_mem_float(float *raw_data, int key, int size, int* address);
float* read_mem_staked_spectra(int key, int size);
int load_mem_staked_spectra(float *raw_data, int key, int size, int* address);
int load_mem_e3d(E3D_file e3d_file, int key, int *address);
int read_mem_e3d(E3D_file* e3d_out, int key);
int palette(int type, float contra, float bright);
float Minimum(float a, float b);
float Maximum(float a, float b);
int draw_staked_spectra(float min, float max,int **nnaxes, float **out);
void plot_spaxel(int color_index,float x_c, float y_c, GROUP group, int fill, int text_flag);
int split_text(char *text, char *splitter, int *n_words, char ***words);
int ask_change_palette(char *commands);
int image_plot(float *data, float datamin, float datamax, int n_x, int n_y, int dev_id, float *tr);
int ask_draw_raw(char *commands);
int ask_open_device(char *commands);
int ask_close_device(char *commands);
int ask_intensity(float *out_raw_data, int nb_spec, int index_w);
void spec_plot(float* data, float datamin, float datamax, int npix, double start_w, double delta_w);

void spec_plot_range(float* data, float datamin, float datamax, int npix_w1, int npix_w2, double start_w, double delta_w, int clean);

int create_map(int nb_spec, int *n_spaxels, SPAXEL **spaxels, int *npts, float* slice, float dpix1, float dpix2, float** map_data, float x_min, float x_max, float y_min, float y_max, float ttr[8], int *nnx, int *nny, int grid_func, float grid_opt);

int save_cube(int nb_spec, int npix_p, int *n_spaxels, SPAXEL **spaxels, float* raw_data, float dpix1, float dpix2, char *cube_filename, float x_min, float x_max, float y_min, float y_max, int grid_func, float grid_opt, double start_w, double step_w);
int save_map(float* map_data, int nx, int ny, char* filename);
int save_raw(float* map_data, int nx, int ny, char* filename, double start, double step);
int load_rss(char *data_filename, char *pt_filename, int *out_nb_spec, int *out_npix, int **out_n_spaxels, SPAXEL ***out_spaxels, int **out_index_start, int **out_npts, float **out_raw_data, float **out_raw_noise, int *out_n_groups, GROUP **out_groups, double *out_start, double *out_step, float *dpix1, float *dpix2);
int load_spectra(char *data_filename, int *out_nb_spec, int *out_npix, int **out_n_spaxels, SPAXEL ***out_spaxels, int **out_index_start, int **out_npts, float **out_raw_data, float **out_raw_noise, int *out_n_groups, GROUP **out_groups, double *out_start, double *out_step);
int load_cube(char *cube_filename, int *out_nb_spec, int *out_npix, int **out_n_spaxels, SPAXEL ***out_spaxels, int **out_index_start, int **out_npts, float **out_raw_data, float **out_raw_noise, int *out_n_groups, GROUP **out_groups, double *out_start, double *out_step, float *dpix1, float *dpix2);
int load_map(char *cube_filename, int *out_nb_spec, int *out_npix, int **out_n_spaxels, SPAXEL ***out_spaxels, int **out_index_start, int **out_npts, float **out_raw_data, float **out_raw_noise, int *out_n_groups, GROUP **out_groups, double *out_start, double *out_step);

int dar_l(float *dr, float l, float p, float t, float f, float z);
int determine_dar(struct DAR dar, GROUP group, float start, float step, int npix);
int correct_mono_dar(int nb_spec, int *n_spaxels, SPAXEL **spaxels, float* slice, struct DAR *dar_t, int  i_slice);

int save_slice(float *spaxId, float *x, float *y, float* slice_data, int n, char* filename, char* units);
int save_slice_ascii(float *spaxId, float *x, float *y, float* slice_data, int n, char* filename, char* units);
int save_PT_ascii(float *x, float *y, int *int_group, int n, GROUP *grupo, int n_groups, char* filename);
int save_spec_table(float *w, float* spec_data, int n, char* filename, char* units);
int save_spec_ascii(float *w, float* spec_data, int n, char* filename, char* units);

void color_palett(int type, double contra, double bright, int sign);

int tr_palett(int n, float *in_data, float **out_data, int sign, double contra, double bright, float min, float max, float *out_min, float *out_max);

float fit_single_line(float *data, float *noise, float datamin, float datamax, int npix_w1, int npix_w2, double start_w, double delta_w, int clean, float a[4], float d_a[4], int ia[4], float chisq_cont);

int save_dar(char* filename, struct DAR *dar, int npix, int n_groups);
int load_dar(char* filename, struct DAR *dar, int npix, int n_groups);

int save_int_map(float* map_data, int nx, int ny, char* filename, double crval1, double cdelt1, double crval2, double cdelt2);

int add_to_file(char* filename, int *argc , char *argv[]);
int write_to_file(char* filename, int *argc , char *argv[]);
int is_e3d_file(char *filename);
float cut_min_max(float data, float min, float max);
