/*
 * S.F.Sanchez, Oct 2002
 * This routine gets a solution to a generalized 
 * least square fitting. It has been 
 * taken from NR. Use with care!
 */

#include "my_math.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define SWAP(a,b) {temp=(a);(a)=(b);(b)=temp;}

void gl_covsrt(float **covar, int ma, int ia[], int mfit)
{
  int i,j,k;
  float temp;
  
  for (i=mfit+1;i<=ma;i++)
    for (j=1;j<=i;j++) covar[i][j]=covar[j][i]=0.0;
  k=mfit;
  for (j=ma;j>=1;j--) {
    if (ia[j]) {
      for (i=1;i<=ma;i++) SWAP(covar[i][k],covar[i][j])
      for (i=1;i<=ma;i++) SWAP(covar[k][i],covar[j][i])
      k--;
    }
  }
}

void gl_gaussj(float **a, int n, float **b, int m)
{
  int *indxc,*indxr,*ipiv;
  int i,icol,irow,j,k,l,ll;
  float big,dum,pivinv,temp;
  
  indxc=ivector(1,n);
  indxr=ivector(1,n);
  ipiv=ivector(1,n);
  for (j=1;j<=n;j++) ipiv[j]=0;
  for (i=1;i<=n;i++) {
    big=0.0;
    for (j=1;j<=n;j++) 
      if (ipiv[j] != 1) 
        for (k=1;k<=n;k++) {
          if (ipiv[k]==0) {
            if (fabs(a[j][k])>=big) {
              big=fabs(a[j][k]);
              irow=j;
              icol=k;
            }
          }
        }
    ++(ipiv[icol]);
    
    if(irow!=icol) {
      for (l=1;l<=n;l++) SWAP(a[irow][l],a[icol][l])
      for (l=1;l<=m;l++) SWAP(b[irow][l],b[icol][l])
    }
    indxr[i]=irow;
    indxc[i]=icol;
    if (a[icol][icol]==0.0) {
      printf("gausj error: Singular Matrix");
      return;
    }
    pivinv=1.0/a[icol][icol];
    a[icol][icol]=1.0;
    for (l=1;l<=n;l++) a[icol][l] *= pivinv;
    for (l=1;l<=m;l++) b[icol][l] *= pivinv;

    for (ll=1;ll<=n;ll++)
      if (ll != icol) {
        dum=a[ll][icol];
        a[ll][icol]=0;
        for(l=1;l<=n;l++) a[ll][l] -= a[icol][l]*dum;
        for(l=1;l<=m;l++) b[ll][l] -= b[icol][l]*dum;
      }
  }

  for (l=n;l>=1;l--) {
    if (indxr[l] != indxc[l])
      for (k=1;k<=n;k++)
        SWAP(a[k][indxr[l]],a[k][indxc[l]]);
  }

  free_ivector(ipiv,1,n);
  free_ivector(indxr,1,n);
  free_ivector(indxc,1,n);

}

/*
 * This subrutine determines the CHISQ of
 * the comparison of two set of data.
 */
float gl_chisq_det( float y0[], float y1[], float sig[], int nini, int ndat)
{
  int j;
  float chisq;

  chisq=0.0;
  for (j=nini;j<ndat;j++) {
    if (sig[j]==0.0) sig[j]=sqrt(fabs(y0[j]));
    if (sig[j]==0.0) sig[j]=1.0;

    chisq+=pow(y1[j]-y0[j],2)/pow(sig[j],2);
  }
  return chisq;
}

/*
 * This tool is prepared to fit profiles,
 * and therefore it eliminates the 1st points
 */
void gl_fit( float x[], float y[], float sig[], int nini, int ndat, float a[], 
          float s_a[], float d_a[], int ia[], int ma, float *chisq, 
          float chisq_con, void (*funcs)(float, float[], float*))
{
  int n_max=1000;
  int i,j,k,kk;
  float fn;
  float *y1,*ey1;
  float chisq1,chisq2,chisq3,chisq_temp;
  float d_ch,dd_ch;
  float new_chisq;
  float *a_error;
  int nfree;

  new_chisq=0;
  y1 = (float *)malloc((ndat)*sizeof(float));    
  ey1 = (float *)malloc((ndat)*sizeof(float));    
  a_error = (float *)malloc((ma)*sizeof(float));    
  fn=1.0;
  nfree=(ndat-nini-ma-1);
  j=nini;
  while (j<ndat) {
    if ((y[j]==0.0)&&(sig[j]==0.0)) {
      ndat=j-1;
      break;
    }

    if (sig[j]==0.0) {
      sig[j]=0.5*sqrt(fabs(y[j]));     
    }
    j++;
  }

  for (j=0;j<ma;j++) {
    if (ia[j]==1) {
      if (a[j]<0) a[j]=-a[j];
      if (fabs(d_a[j])<0.001) d_a[j]=-d_a[j]*10.0;
    }
  }
  

  for (j=nini;j<ndat;j++) {
    (*funcs)(x[j],a,&y1[j]);
  }
  chisq_temp=gl_chisq_det(y,y1,sig,nini,ndat);
  *chisq=chisq_temp/nfree;
  
  k=1;

  while ((k<n_max)&&(*chisq>chisq_con)) {
    for (j=0;j<ma;j++) {
      if ((a[j]<0)&&(ia[j]==1)) a[j]=-a[j];
    }
    for (i=0;i<ma;i++) {
      if (ia[i]==1) {
        for (j=nini;j<ndat;j++) {
          (*funcs)(x[j],a,&y1[j]);
        }
        chisq1=gl_chisq_det(y,y1,sig,nini,ndat);
        chisq1/=nfree;
        fn=0.;
        kk=0;
        do {
          if (kk==2) {
            d_a[i]=-1.2*d_a[i];
            kk=0;
          }        
          
          if (fabs(d_a[i])<0.001) d_a[i]=-d_a[i]*5.0;
          
          a[i]+=d_a[i];
          for (j=nini;j<ndat;j++) {
            (*funcs)(x[j],a,&y1[j]);
          }
          chisq2=gl_chisq_det(y,y1,sig,nini,ndat);                            
          chisq2/=nfree;
          if (d_a[i]==0.0) d_a[i]=a[i]/1000;
          kk+=1;
        } while (chisq2==chisq1);
        if (chisq1<chisq2) {
          d_a[i]=-d_a[i];
          a[i]+=d_a[i];
          chisq_temp=chisq1;
          chisq1=chisq2;
          chisq2=chisq_temp;
        } 
        fn+=1.0;
        a[i]+=d_a[i];
        for (j=nini;j<ndat;j++) {
          (*funcs)(x[j],a,&y1[j]);
        }
        chisq3=gl_chisq_det(y,y1,sig,nini,ndat);
        chisq3/=nfree;
        if (chisq3<chisq2) {
          chisq1=chisq2;
          chisq2=chisq3;
        }
        d_ch=chisq3-chisq2;
        dd_ch=chisq3-3*chisq2+chisq1;
        if (d_ch==0.0) d_ch=1.0;
        if (dd_ch==0.0) dd_ch=1.0;
      
        if ((1.0+(chisq1-chisq2)/d_ch)!=0.0) {
          d_a[i]=d_a[i]*(1.0/(1.0+(chisq1-chisq2)/d_ch)+0.5);
        }
        a[i]-=d_a[i];
        s_a[i]=d_a[i]*sqrt(fabs(2/((ndat-nini-ma-1)*dd_ch)));
        d_a[i]=d_a[i]*fn/3;
        if (d_a[i]==0.0) d_a[i]=a[i]/1000.0;
      }
      k++;     
      *chisq=chisq3;    
    }
  }

  /*
   * We plot the results!
   */

  /*
   * Now we determine the 1 sigma error as the
   * error when the X^2 is increased by 1
   */
  chisq1=*chisq;
  for (j=0; j<ma;j++) {
    a_error[j]=a[j];
  }
 
  for (i=0;i<ma;i++) {
    if (ia[i]==1) {
      d_a[i]=-d_a[i];
      if (d_a[i]==0.0) d_a[i]=a[i]/5.0;
      kk=0;
      do {
        a[i]+=d_a[i];
        for (j=nini;j<ndat;j++) {
          (*funcs)(x[j],a,&y1[j]);
        }
        chisq2=gl_chisq_det(y,y1,sig,nini,ndat);
        chisq2=chisq2/(ndat-nini-ma-1);
        kk++;
      } while ((chisq2<(chisq1+2.0))&&(kk<100));
      s_a[i]=fabs(a[i]-a_error[i]);
    }
  }

  for (j=0; j<ma;j++) {
    a[j]=a_error[j];
  } 

  for (i=0;i<ma;i++) {
    if (d_a[i]==0.0) d_a[i]=a[i]/10;
  }
}

/*
 * Gaussing Function to be fit with GL_FIT
 */
void gl_fit_gauss(float x, float a[0], float *y)
{
  float flux;

  if (a[2]!=0.0) {
    flux=a[0]*exp((-0.5)*pow(((x-a[1])/(a[2])),2));
  } else {
    if (x==a[1]) { 
      flux=a[0];
    } else {
      flux=0;
    }
  }
  flux=flux+a[3];

  *y=flux;
}

/*
 * This rutine performs a fit of the data x,y to a certain function funcs
 * givin an initial set of parameters "a" and initial variations "d_a"
 * all to be fitted or not, which is controled with ia=1
 * until a convergence criteria is reached: chisq_con.
 */
void gl_lfit( float x[], float y[], float sig[], int ndat, float a[], 
           int ia[], int ma, float **covar, float *chisq, void (*funcs)(float, float[], int))
{
  int i,j,k,l,m,mfit=0;
  float ym,wt,sum,sig2i;
  double **beta,*afunc;
  beta=matrix(1,ma,1,1);
  afunc=vector(1,ma);
  
  for (j=1;j<=ma;j++) 
    if (ia[j]) mfit++;
  if (mfit==0) {
    printf("Error: gl_lfit, no parameters to fit\n");
    return;
  }

  for (j=1;j<=mfit;j++) {
    for (k=1;k<=mfit;k++) {
      covar[j][k]=0.0;
    }
    beta[j][1]=0.0;
  }

  for (i=1;i<=ndat;i++) {
    (*funcs)(x[i],(float *)afunc,ma);
    ym=y[i];
    if(mfit<ma) {
      for(j=1;j<=ma;j++) 
        if (!ia[j]) ym-= a[j]*afunc[j];      
    }
    
    sig2i=1.0/sqrt(fabs(sig[i]));

    for (j=0,l=1;l<=ma;l++) {
      if (ia[l]) {
        wt=afunc[l]*sig2i;
        for (j++,k=0,m=1;m<=l;m++)
          if (ia[m]) covar[j][++k] += wt*afunc[m];
        beta[j][1] += ym*wt;
      }
    }
  }
  for (j=2;j<=mfit;j++) 
    for (k=1;k<j;k++)
      covar[k][j]=covar[j][k];
  gl_gaussj(covar,mfit,(float **)beta,1);
  for(j=0,l=1;l<=ma;l++)
    if (ia[l]) a[l]=beta[++j][1];
  *chisq=0.0;
  for(i=1;i<=ndat;i++) {
    (*funcs)(x[i],(float *)afunc,ma);
    for (sum=0.0,j=1;j<=ma;j++) sum += a[j]*afunc[j];
    *chisq += sqrt(fabs((y[i]-sum)/sig[i]));
  }

  gl_covsrt(covar,ma,ia,mfit);
  //free_vector(afunc,1,ma);
  //free_matrix(beta,1,ma,1,1);
}
