/*
 * Algorithm to convolve two images using the FFT 
 * TESTs
 */

#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "my_math.h"
#include "fft2d.h"

void cdft2d(int, int, int, double **, double *, int *, double *);
void index_xy(int x, int y, int n_x, int *index);
void xy_index(int *x, int *y, int n_x, int index);
void complmultipl(double *ar1, double *ar2, unsigned long ntot);
void complmultipl_cor(double *ar1, double *ar2, unsigned long ntot);

void fft_mirror(double *image, int nx, int ny);

int my_crosscor(double *image_input, int nx_image_input, int ny_image_input, double *psf, int nx_psf, int ny_psf) {
  double **fftpsf;
  double **fftwork;
  double *local_psf;
  int d_x,d_y,j,i,k;
  int ix,iy,ixp,iyp;
  int *ip;
  int n;
  double *w;  


  
  double *image;
  int nx_image,ny_image;
  


  /*
   * (1) We look for the minimun power of 2 that excess the  
   * image size.
   * 
   * (2) We create a fake image, padded with 0, of the size
   * of this power of 2, with the real data in the middle.
   *
   * (3) We correlate this fake image.
   *
   * (4) We cut the inner region to obtain the result.
   *
   */
  nx_image=min2power(nx_image_input);
  ny_image=min2power(ny_image_input);
  image=dvector(0,nx_image*ny_image-1);  
  d_x=floor((nx_image-nx_image_input)/2);
  d_y=floor((ny_image-ny_image_input)/2);
  for (i=0;i<nx_image*ny_image;i++) {
    image[i]=0.0;
    xy_index(&ix,&iy,nx_image,i);
    ixp=ix-d_x;
    iyp=iy-d_y;
    if ((ixp>=0)&&(ixp<nx_image_input)&&(iyp>=0)&&(iyp<ny_image_input)) {
      index_xy(ixp,iyp,nx_image_input,&j);
      image[i]=image_input[j];
    }
  }  
  /*
   * Now we have a power of 2 image
   */



  /*
   * We rewrite the PSF in case that it is smaller or larger
   * than the original image!
   *
   * The rest is feeding with the mean of the outer parts!!!
   */
  fftpsf=dmatrix(0,nx_image-1,0,2*ny_image-1);
  fftwork=dmatrix(0,nx_image-1,0,2*ny_image-1);
  
  n=imax(nx_image,ny_image);
  local_psf=dvector(0,nx_image*ny_image-1); //Dude??
  ip = ivector (0, 2 + (int)sqrt(n + 0.5)-1);
  w = dvector (0, n);


  if ((nx_psf>nx_image)||(ny_psf>ny_image)) {
    printf("Size of convolving image larger that size of convolved image\n");
  } 
  d_x=floor((nx_image-nx_psf)/2);
  d_y=floor((ny_image-ny_psf)/2);
  for (i=0;i<nx_image*ny_image;i++) {
    local_psf[i]=0.0;
    xy_index(&ix,&iy,nx_image,i);
    ixp=ix-d_x;
    iyp=iy-d_y;
    if ((ixp>=0)&&(ixp<nx_psf)&&(iyp>=0)&&(iyp<ny_psf)) {
      index_xy(ixp,iyp,nx_psf,&j);
      local_psf[i]=psf[j];
    }
  }  
  /*
   * We fill the work space with the data
   */
  for (j=0;j<ny_image;j++) {
    for (i=0;i<nx_image;i++) {
      index_xy(i,j,nx_image,&k);
      //      printf("%d,%d,%d\n",i,j,k);
      if (j!=0) {
	fftwork[i][2*j]=image[k];
	fftpsf[i][2*j]=local_psf[k];
      } else {
	fftwork[i][0]=image[i];
	fftpsf[i][0]=local_psf[i];
      }
      fftwork[i][2*j+1]=0.0;
      fftpsf[i][2*j+1]=0.0;      
    }
  }

  
  /*
   * Now we apply the FFT
   */

  //  printf("Ok\n");
  //  ip[0]=0;


  
  //  printf("fftwork[0][0]=%f, %f\n",fftwork[0][0],image[0]);
  //printf("fftwork[1][0]=%f\n",fftwork[1][0]);
  FFT2D(fftwork,nx_image,ny_image,1);  
  FFT2D(fftpsf,nx_image,ny_image,1);
  complmultipl(*fftwork,*fftpsf,nx_image*ny_image);
  FFT2D(fftwork,nx_image,ny_image,-1);
  


  //

  /*
   * We have to reorganize the image that has been desorganized
   */
    for (j=0;j<ny_image;j++) {
      for (i=0;i<nx_image;i++) {
	//      index_xy(i,j,nx_image,&k);
      k=i+j*nx_image;
      //      image[k]=fftwork[i][2*j]*nx_image*ny_image;
      image[k]=fftwork[i][2*j]*nx_image*ny_image;
      if (image[k]!=image[k]) image[k]=0.0;
      //printf("INTER=%d %d %d %f %f\n",k,i,j,image[k],fftwork[i][2*j]);
    }
  }
    //    scanf("%lf",tmp);

    fft_mirror(image,nx_image,ny_image);
    
    /*
     * Now we cut the image
     */
    d_x=floor((nx_image-nx_image_input)/2);
    d_y=floor((ny_image-ny_image_input)/2);
    for (i=0;i<nx_image*ny_image;i++) {
      xy_index(&ix,&iy,nx_image,i);
      ixp=ix-d_x+1;
      iyp=iy-d_y+1;
      if ((ixp>=0)&&(ixp<nx_image_input)&&(iyp>=0)&&(iyp<ny_image_input)) {
	index_xy(ixp,iyp,nx_image_input,&j);
	image_input[j]=image[i];
//	printf("END %d %d %f %f\n",i,j,image[i],image_input[j]);
      }
    }  
    
  free_dvector(image,0,nx_image*ny_image-1);     
  free_dmatrix(fftpsf,0,nx_image-1,0,2*ny_image-1);
  free_dmatrix(fftwork,0,nx_image-1,0,2*ny_image-1);  
  free_dvector(local_psf,0,nx_image*ny_image-1); 
  

  free_ivector (ip,0, 2 + (int)sqrt(n + 0.5)-1);
  free_dvector (w,0, n);
    
  return(0);

}


int my_convolve(double *image_input, int nx_image_input, int ny_image_input, double *psf, int nx_psf, int ny_psf) {
  double **fftpsf;
  double **fftwork;
  double *local_psf;
  int d_x,d_y,j,i,k;
  int ix,iy,ixp,iyp;
  int *ip;
  int n;
  double *w;  
  double *image;
  int nx_image,ny_image;

  /*
   * (1) We look for the minimun power of 2 that excess the  
   * image size.
   * 
   * (2) We create a fake image, padded with 0, of the size
   * of this power of 2, with the real data in the middle.
   *
   * (3) We convolve this fake image.
   *
   * (4) We cut the inner region to obtain the result.
   *
   */
  nx_image=min2power(nx_image_input);
  ny_image=min2power(ny_image_input);
  //    printf("Power =%d , %d, %d %d \n",nx_image,ny_image,nx_image_input,ny_image_input);
  image=dvector(0,nx_image*ny_image-1);  
  d_x=floor((nx_image-nx_image_input)/2);
  d_y=floor((ny_image-ny_image_input)/2);
  for (i=0;i<nx_image*ny_image;i++) {
    image[i]=0.0;
    xy_index(&ix,&iy,nx_image,i);
    ixp=ix-d_x;
    iyp=iy-d_y;
    if ((ixp>=0)&&(ixp<nx_image_input)&&(iyp>=0)&&(iyp<ny_image_input)) {
      index_xy(ixp,iyp,nx_image_input,&j);
      image[i]=image_input[j];
      //printf("%d %d %f %f\n",i,j,image[i],image_input[j]);
    }
  }  
  /*
   * Now we have a power of 2 image
   */



  /*
   * We rewrite the PSF in case that it is smaller or larger
   * than the original image!
   *
   * The rest is feeding with the mean of the outer parts!!!
   */
  fftpsf=dmatrix(0,nx_image-1,0,2*ny_image-1);
  fftwork=dmatrix(0,nx_image-1,0,2*ny_image-1);
  
  n=imax(nx_image,ny_image);
  local_psf=dvector(0,nx_image*ny_image-1); //Dude??
  ip = ivector (0, 2 + (int)sqrt(n + 0.5)-1);
  w = dvector (0, n);


  if ((nx_psf>nx_image)||(ny_psf>ny_image)) {
    printf("Size of convolving image larger that size of convolved image\n");
  } 
  d_x=floor((nx_image-nx_psf)/2);
  d_y=floor((ny_image-ny_psf)/2);
  for (i=0;i<nx_image*ny_image;i++) {
    local_psf[i]=0.0;
    xy_index(&ix,&iy,nx_image,i);
    ixp=ix-d_x;
    iyp=iy-d_y;
    if ((ixp>=0)&&(ixp<nx_psf)&&(iyp>=0)&&(iyp<ny_psf)) {
      index_xy(ixp,iyp,nx_psf,&j);
      local_psf[i]=psf[j];
    }
  }  
  /*
   * We fill the work space with the data
   */
  for (j=0;j<ny_image;j++) {
    for (i=0;i<nx_image;i++) {
      index_xy(i,j,nx_image,&k);
      //      printf("%d,%d,%d\n",i,j,k);
      if (j!=0) {
	fftwork[i][2*j]=image[k];
	fftpsf[i][2*j]=local_psf[k];
      } else {
	fftwork[i][0]=image[i];
	fftpsf[i][0]=local_psf[i];
      }
      fftwork[i][2*j+1]=0.0;
      fftpsf[i][2*j+1]=0.0;      
//      printf("fftwork[%d][%d]=%5.7f, %d=%5.7f\n",i,2*j,fftwork[i][2*j],k,image[k]);
//        printf("fftpsf[%d][%d]=%5.7f, %d=%5.7f\n",i,2*j,fftpsf[i][2*j],k,local_psf[k]);
    }
  }
  //  fftwork[0][0]=image[0];
  //fftpsf[0][0]=local_psf[0];
  
  /*
   * Now we apply the FFT
   */

  //  printf("Ok\n");
  //  ip[0]=0;


  
  //  printf("fftwork[0][0]=%f, %f\n",fftwork[0][0],image[0]);
  //printf("fftwork[1][0]=%f\n",fftwork[1][0]);
  FFT2D(fftwork,nx_image,ny_image,1);  
  FFT2D(fftpsf,nx_image,ny_image,1);
  complmultipl(*fftwork,*fftpsf,nx_image*ny_image);
  FFT2D(fftwork,nx_image,ny_image,-1);
  


  //

  /*
   * We have to reorganize the image that has been desorganized
   */
    for (j=0;j<ny_image;j++) {
      for (i=0;i<nx_image;i++) {
	//      index_xy(i,j,nx_image,&k);
      k=i+j*nx_image;
      //      image[k]=fftwork[i][2*j]*nx_image*ny_image;
      image[k]=fftwork[i][2*j]*nx_image*ny_image;
      if (image[k]!=image[k]) image[k]=0.0;
      //printf("INTER=%d %d %d %f %f\n",k,i,j,image[k],fftwork[i][2*j]);
    }
  }
    //    scanf("%lf",tmp);

    fft_mirror(image,nx_image,ny_image);
    
    /*
     * Now we cut the image
     */
    d_x=floor((nx_image-nx_image_input)/2);
    d_y=floor((ny_image-ny_image_input)/2);
    for (i=0;i<nx_image*ny_image;i++) {
      xy_index(&ix,&iy,nx_image,i);
      ixp=ix-d_x+1;
      iyp=iy-d_y+1;
      if ((ixp>=0)&&(ixp<nx_image_input)&&(iyp>=0)&&(iyp<ny_image_input)) {
	index_xy(ixp,iyp,nx_image_input,&j);
	image_input[j]=image[i];
//	printf("END %d %d %f %f\n",i,j,image[i],image_input[j]);
      }
    }  
    
  free_dvector(image,0,nx_image*ny_image-1);     
  free_dmatrix(fftpsf,0,nx_image-1,0,2*ny_image-1);
  free_dmatrix(fftwork,0,nx_image-1,0,2*ny_image-1);  
  free_dvector(local_psf,0,nx_image*ny_image-1); 
  

  free_ivector (ip,0, 2 + (int)sqrt(n + 0.5)-1);
  free_dvector (w,0, n);
    
    return(0);
    //    return convolved;
}


void complmultipl(double ar1[], double ar2[], unsigned long n) {

    double realpart, aimagpart;
    unsigned long i, k, j, ntot;

    ntot = 2 * n;
    for (i = 0; i< ntot; i+=2){
        k = i;
        j = i+1;
        realpart = ar1[k] * ar2[k] - ar1[j] * ar2[j];
        aimagpart = ar1[k] * ar2[j] + ar1[j] * ar2[k];
        ar1[k] = realpart;
        ar1[j] = aimagpart;
    };
}


void complmultipl_cor(double ar1[], double ar2[], unsigned long n) {

    double realpart, aimagpart;
    unsigned long i, k, j, ntot;

    ntot = 2 * n;
    for (i = 0; i< ntot; i+=2){
        k = i;
        j = i+1;
        realpart = ar1[k] * ar2[k] + ar1[j] * ar2[j];
        aimagpart = ar1[k] * ar2[j] - ar1[j] * ar2[k];
        ar1[k] = realpart;
        ar1[j] = aimagpart;
    };
}


void fft_mirror(double *image, int nx, int ny) {
  int i,j;
  int nx_med,ny_med;
  double *tmp_image;  
  tmp_image = (double *)malloc(nx*ny*sizeof(double));
  nx_med=nx/2;
  ny_med=ny/2;
  for(j=0;j<nx*ny;j++) {
    tmp_image[j]=0.0;
  }
  for (j=0;j<ny_med;j++) {
    for (i=0;i<nx_med;i++) {
      tmp_image[i+j*nx]=image[nx_med+i+(ny_med+j)*ny];
    }
  }

  for (j=0;j<ny_med;j++) {
    for (i=0;i<nx_med;i++) {
      tmp_image[nx_med+i+j*nx]=image[i+(ny_med+j)*ny];
    }
  }

  for (j=0;j<ny_med;j++) {
    for (i=0;i<nx_med;i++) {
      tmp_image[i+(ny_med+j)*nx]=image[nx_med+i+j*ny];
    }
  }

  
  for (j=0;j<ny_med;j++) {
    for (i=0;i<nx_med;i++) {
      tmp_image[nx_med+i+(ny_med+j)*nx]=image[i+j*ny];
    }
  }
  
  


  for(j=0;j<nx*ny;j++) {
    image[j]=tmp_image[j];
  }
  free(tmp_image);
  
}
