/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  2002 AIP, Potsdam, Germany
! IDENT        pmas2Euro3D.c
! LANGUAGE     C
! AUTHOR       S.F.Sanchez
! KEYWORDS     
! PURPOSE      Facility to Visualize Euro3D data
! COMMENT      1st prototype
! VERSION      0.1  2002-Dec-17 : Creation, SF.
------------------------------------------------------------------------------*/

#include <stdio.h> //For Standard I/O
#include <stdlib.h> //For Functions like ATOI
#include <ctype.h> //For Type check
#include <string.h> //For String manipulation
#include <math.h> //For Math functions
#include <IFU_io.h> //For Lyon I/O Library
#include <data_io.h> //For Lyon I/O data
#include "Euro3D.h"

/*
 To use PGPLOT
 */
#include <cpgplot.h> // PGPLOT

/*-----------------------------------------------------------------------------
!
!.blk          Reads an Euro3D data file and plot a raw frame
!
!.prog                             VEuro3D()
!
!.purp         Facility to Visualize Euro3D data
!
-----------------------------------------------------------------------------*/

#define NB_SPEC 256
#define NPIX 1024

int id1,id2,id3,id4;
int id_w;
int p=2;
float contra=0.8;
float bright=0.4;
float sign=1.0;
int mode=0;

int get_group(E3D_file *frame, GROUP *grupo, int j)
{
  if ((frame->ngroups!=0)&&(j<=frame->ngroups)) {
    grupo->groupId=frame->groups[j].groupId;
    grupo->shape=frame->groups[j].shape;
    grupo->size1=frame->groups[j].size1;
    grupo->size2=frame->groups[j].size2;
    grupo->angle=frame->groups[j].angle;
    grupo->poswav=frame->groups[j].poswav;
    grupo->parang=frame->groups[j].parang;
    grupo->pressure=frame->groups[j].pressure;
    grupo->temperature=frame->groups[j].temperature;
  } else {
    grupo->groupId=1;
    grupo->shape='S';
    grupo->size1=50; //miliArcseconds?
    grupo->size2=50; //miliArcseconds??
    grupo->angle=0;
    grupo->poswav=0.0;
    grupo->airmass=1.0;
    grupo->parang=0.0;
    grupo->pressure=700;
    grupo->temperature=30;
  }
  return 0;
}

int main(int argc, char **argv)
{
  SPAXEL **spaxels;  
  int *n_spaxels;
  float x_min,y_min,x_max,y_max;
  E3D_file e3d_image;
  SPECTRUM signal;
  SPECTRUM *spectra;
  char **argval, **arglabel;
  short s_temp[10];
  char str_temp[80];
  float *raw_data;
  float *raw_noise;
  char euro3d;
  /* Euro3D variables */
  int specId, i,j,k, npix, nb_spec, in_nb_spec, *nol, nfib;
  float start, step;
  float *x,*y;
  char *format;
  /* General variables */
  char input_filename[80], output_filename[80], author[80], origin[80];
  char ref[80];
  float min,max,min_i,max_i;
  int naxes[2];
  int npix_int;
  double start_ww,end_ww;
  float start_w, end_w, delta_w;
  /* Data of the new file! */
  int count_fit=0;
  int *spax_id,*type_id;
  float *spax_x,*spax_y;
  float temp_float;
  float *new_raw_data;
  float *new_raw_noise;
  int *nn_suma;
  int final_nb_spec;
  int j_nb_spec;
  GROUP new_grupo;
  E3D_file new_e3d_image;
  char position_file[80];
  float rotang;
  char shape[20];        
  float size_x=1.0;
  float size_y=1.0;
  FILE *fichero;
  int type_save=-1;
  float g_angle=0;
  int nueva_cuenta=0;
  SPAXEL sg_spax;
  float dist;
  float x_now,y_now;
  int n_suma;

  /* before starting, override any IFU_DEFAULT_FMT variable, *
   * within E3D we only need Euro3D                          */
  setenv("IFU_DEFAULT_FMT","Euro3D",1);

  set_arglist("-if|inputfile none -of|outputfile outputfile -pf SB1.dat -au|author sanchez -or|origin AIP -ref|reference void -nb_spec 1 -type 1 -rotang 0");
  set_version(VERSION);
  init_session(argv,argc,&arglabel,&argval);
  set_control_level(WARNING);
  
  for (i=0; i<9; i++) {
    if ((strstr(arglabel[i],"-if"))||(strstr(arglabel[i],"-inputfile"))) {
      strcpy(input_filename,argval[i]);
    }
    if (strstr(arglabel[i],"-pf")) {
      strcpy(position_file,argval[i]);
    }
    if ((strstr(arglabel[i],"-of"))||(strstr(arglabel[i],"-outfile"))) {
      strcpy(output_filename,argval[i]);
    }
    if ((strstr(arglabel[i],"-au"))||(strstr(arglabel[i],"-author"))) {
      strcpy(author,argval[i]);
    }
    if ((strstr(arglabel[i],"-or"))||(strstr(arglabel[i],"-origin"))) {
      strcpy(origin,argval[i]);
    }
    if ((strstr(arglabel[i],"-ref"))||(strstr(arglabel[i],"-reference"))) {
      strcpy(ref,argval[i]);
    }
    if (strstr(arglabel[i],"-type")) {
      type_save=atoi(argval[i]);
    }
    if (strstr(arglabel[i],"-nb_spec")) {
      nb_spec=atoi(argval[i]);
    }
    if (strstr(arglabel[i],"-rotang")) {
      rotang=(double)atof(argval[i]);
    }
  }

  /*
    checking the format of the file
  */
  format = file_format(argval[0]);
  if ((format[0]!=FITS_B_FORMAT)&&(format[1]!=T_TABLE)) {
    printf("The file does not seem to conform the Euro3D data format\n");                    
  }

  /*
    Reading the data on the output file...
  */
  printf("Opening the image: %s\n",input_filename);
  open_E3D_frame(&e3d_image,input_filename,"I");
  in_nb_spec=e3d_image.nbspec;
  printf("nb_spec=%d\n",in_nb_spec);

  printf("Printing GROUPS information\n");
  printf("NGROUPS=%d\n",e3d_image.ngroups);
  for (j=0;j<e3d_image.ngroups;j++) {
    printf("SIZE1=%f\n",   e3d_image.groups[j].size1); 
    printf("SIZE2=%f\n",   e3d_image.groups[j].size2); 
    printf("airmass=%f\n", e3d_image.groups[j].airmass); 
  }

  printf("Reading the Header of the file %s\n",input_filename);
  
  if(!RD_desc(&e3d_image,"EURO3D",CHAR,10,s_temp)) {
     printf("No EURO3D definied, error\n");          
     exit_session(0);
     return(0);
   }
  euro3d=s_temp[0];
  printf("Euro3D = %c\n",euro3d);
  
  /*
  if(!RD_desc(&e3d_image,"NAXIS2",INT,1,i_temp)) {
    printf("No NAXIS2 definied, error\n");          
    exit_session(0);
    return(0);
  }                
  nb_spec=i_temp[0];
  */
  if ((nfib!=0)||(nb_spec==0)) {
    in_nb_spec=nfib;
    if (in_nb_spec==0) {
      in_nb_spec=256;
    }
    printf("IN nb_spec forced to %d\n",in_nb_spec);
  }

  nol = (int *)malloc(in_nb_spec*sizeof(int));  
  x = (float *)malloc(in_nb_spec*sizeof(float));  
  y = (float *)malloc(in_nb_spec*sizeof(float));  
  
  spaxels = (SPAXEL **)malloc(in_nb_spec*sizeof(SPAXEL));
  n_spaxels = (int *)malloc(in_nb_spec*sizeof(int));  

  printf("Reading common parameters\n");
  get_common_param(&e3d_image,&npix_int,&start_ww,&end_ww);        
  start_w=(float)start_ww;
  end_w=(float)end_ww;
  printf("%d,%f,%f\n",npix_int,start_w,end_w);

  delta_w=(end_w-start_w)/npix_int;

  get_spectra_ID(&e3d_image,nol);
  printf("Reading Euro3D values spectrum by spectrum ...");
  fflush(stdout);        
  min=3000000;
  max=-3000000;
  naxes[1]=in_nb_spec;
  spectra = (SPECTRUM *)malloc(in_nb_spec*sizeof(SPECTRUM));  
  x_min=10000;
  y_min=10000;
  x_max=-10000;
  y_max=-10000;
  for (specId=1;specId<=in_nb_spec;specId++) {         
    /*
      We get the spaxels information!!!
    */
    n_spaxels[specId]=get_E3D_spaxels(&e3d_image,specId,&spaxels[specId]);
    for (j=0;j<n_spaxels[specId];j++) {
      if (x_min>spaxels[specId][j].xpos) x_min=spaxels[specId][j].xpos;
      if (x_max<spaxels[specId][j].xpos) x_max=spaxels[specId][j].xpos;
      if (y_min>spaxels[specId][j].ypos) y_min=spaxels[specId][j].ypos;
      if (y_max<spaxels[specId][j].ypos) y_max=spaxels[specId][j].ypos;
    }

    /*
      We get the spectra information.
    */
    get_E3D_spec(&e3d_image,&signal,NULL,nol[specId-1]); 
    spectra[specId-1]=signal;
    if (specId==1) {
      npix=signal.npts;
      naxes[0]=npix;
      raw_data = (float *)malloc((npix*in_nb_spec)*sizeof(float));  
      raw_noise = (float *)malloc((npix*in_nb_spec)*sizeof(float));  
      if (npix_int!=npix) {
        printf("There is some error in the determination of the number of pixels\n");
        printf("npix=%d npix_int=%d\n",npix,npix_int);
      }
    }
    for (j=0;j<signal.npts;j++) {
      raw_data[j+(specId-1)*npix]=RD_spec(&signal,j);
      raw_noise[j+(specId-1)*npix]=RD_spec(&signal,j);
      //            printf("%f,%f\n",raw_data[j+(specId-1)*npix],RD_spec(&signal,j));
      if (min>raw_data[j+(specId-1)*npix]) 
        min=raw_data[j+(specId-1)*npix];
      if (max<raw_data[j+(specId-1)*npix]) 
        max=raw_data[j+(specId-1)*npix];
    }                
  }
  if (min_i!=0.0) 
    min=min_i;
  if (max_i!=0.0) 
    max=max_i;

  printf("closing previous datacube ...\n");
  close_E3D_frame(&e3d_image);

  /*
   * Reading the new position table!
   */
  type_id = (int *)malloc((nb_spec)*sizeof(int));          
  spax_id = (int *)malloc((nb_spec)*sizeof(int));          
  spax_x = (float *)malloc((nb_spec)*sizeof(float));          
  spax_y = (float *)malloc((nb_spec)*sizeof(float));          

  printf("Opening the position table file\n");
  if ((fichero=fopen(position_file,"r"))==NULL) {
    printf("Error opening file: %s\n",position_file);
  } else {
    fscanf(fichero, "%s", str_temp);
    strcpy(shape,str_temp);
    fscanf(fichero, "%f", &size_x);
    fscanf(fichero, "%f", &size_y);
    fscanf(fichero, "%f", &g_angle);

    printf("%s, %f %f\n",str_temp,size_x,size_y);

    j=0;
    count_fit=0;
    while( fscanf(fichero, "%f", &temp_float) != EOF) {                               
      if (j>3) {
        j=0;
        count_fit++;
      }
      if(j==0) {
        spax_id[count_fit]=floor(temp_float);
      }
      if(j==1) {
        spax_x[count_fit]=temp_float;
      }
      if(j==2) {
          spax_y[count_fit]=temp_float;
      }
      if(j==3) {
          type_id[count_fit]=floor(temp_float);
      }
      j++;
    }
  }
  printf("Position Table readed\n");

  /*
   * We create the new data
   */
  new_raw_data = (float *)malloc((npix*nb_spec)*sizeof(float));  
  new_raw_noise = (float *)malloc((npix*nb_spec)*sizeof(float));  
  
  nn_suma = (int *)malloc((nb_spec)*sizeof(int));  
  for (i=0;i<npix;i++) {
      for (j=0;j<nb_spec;j++) {
          new_raw_data[i+npix*j]=0;
          new_raw_noise[i+npix*j]=0;
      }
  }

  final_nb_spec=0;
  for (j=0;j<nb_spec;j++) {
    n_suma=0;
    for (k=0;k<in_nb_spec;k++) {
      x_now=spaxels[k+1][0].xpos;
      y_now=spaxels[k+1][0].ypos;
      dist=sqrt(pow(spax_x[j]-x_now,2)+pow(spax_y[j]-y_now,2));
      if (dist<size_x) { 
        for (i=0;i<npix;i++) {
          new_raw_data[i+npix*j]=new_raw_data[i+npix*j]+raw_data[i+npix*k];
        }
        n_suma++;
      }
    }
    for (i=0;i<npix;i++) {
      if (n_suma>0) {
        new_raw_data[i+npix*j]=new_raw_data[i+npix*j]/n_suma;
        new_raw_noise[i+npix*j]=sqrt(abs(new_raw_data[i+npix*j]));
        nn_suma[j]=1;
        final_nb_spec++;
      } else {
        new_raw_data[i+npix*j]=0.0;
        new_raw_noise[i+npix*j]=0.0;
        nn_suma[j]=1;
      }
    }
  }

  printf("New RAW image created\n");

  /*
   * We create the new group
   */
  printf("group1 = %s ",shape);
  printf("%f %f \n",size_x,size_y);
  new_grupo.groupId=1;
  new_grupo.size1=1.0*size_x; 
  new_grupo.size2=1.0*size_y;
  new_grupo.shape=shape[0];
  new_grupo.angle=g_angle;
  new_grupo.poswav=(float) e3d_image.groups[0].poswav;
  new_grupo.airmass=(float) e3d_image.groups[0].airmass;
  new_grupo.parang=(float) e3d_image.groups[0].parang;
  new_grupo.pressure=(float) e3d_image.groups[0].pressure;
  new_grupo.temperature=(float) e3d_image.groups[0].temperature;

  i=1;
  k=1;
  nb_spec=count_fit+1;
  nol = (int *)malloc(nb_spec*sizeof(int));  
  x = (float *)malloc(nb_spec*sizeof(float));  
  y = (float *)malloc(nb_spec*sizeof(float));  
  for (j=0;j<nb_spec;j++) {
    nol[j]=spax_id[j];
    x[j]=spax_x[j];
    y[j]=spax_y[j];
    i++;
    if (i>sqrt(nb_spec)) {
      i=1;
      k++;
    }
  }

  start=start_w;
  step=delta_w;
  printf("Opening the Euro3D image\n");
  create_E3D_frame(&new_e3d_image,output_filename,npix_int,start,step,FLOAT,"test",NULL);

  printf("Writing into created Euro3D file ...\n");
  j_nb_spec=0;
  for (specId=1;specId<=nb_spec;specId++) {
    if ((type_save==-1)||(type_save==type_id[specId-1])) {
      j_nb_spec++;
      nueva_cuenta++;
      init_new_E3D_spec(&new_e3d_image,&signal,npix_int,start); 
      /* SPAXELS */
      sg_spax.specId=nueva_cuenta;
      sg_spax.group=1;
      sg_spax.xpos=x[specId-1]*cos(rotang*.01745327)-y[specId-1]*sin(rotang*.01745327);
      sg_spax.ypos=y[specId-1]*cos(rotang*.01745327)+x[specId-1]*sin(rotang*.01745327);

      for (j=0;j<signal.npts;j++) {              
          WR_spec(&signal,j,(double)new_raw_data[j+(specId-1)*npix_int]);
          WR_spec(&signal,j,new_raw_data[j+(specId-1)*npix_int]);
      }
      
      put_E3D_spec(&new_e3d_image,&signal,NULL,nueva_cuenta);
      put_E3D_spaxels(&new_e3d_image,nueva_cuenta,1,&sg_spax);
    }
  }
  printf("N_COUNT=%d, Ok\n",nueva_cuenta);
  /* Writing the GROUPS information */
  printf("Writing the GROUPS information\n");

  new_e3d_image.ngroups = 1;
  new_e3d_image.groups = (GROUP *)malloc(1*sizeof(GROUP));
  new_e3d_image.groups[0]=new_grupo;        

  printf("NGROUPS=%d\n",new_e3d_image.ngroups);
  printf("Saving created Euro3D file ...");

  close_E3D_frame(&new_e3d_image);

  free(raw_data);
  exit_session(0);
  return 0; 
}
