/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! COPYRIGHT    (c)  2002 AIP, Potsdam, Germany
! IDENT        pmas2Euro3D.c
! LANGUAGE     C
! AUTHOR       S.F.Sanchez
! KEYWORDS     
! PURPOSE      Facility to interpolate
! COMMENT      No GROUP information included. No header data properly copied
! VERSION      0.1  2002-Dec-17 : Creation, SF.
------------------------------------------------------------------------------*/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <IFU_io.h>

#include "stats.h"
#include "my_grid.h"
#include "csa.h"
#include "nn.h"
#include "nan.h"

#include <Euro3D.h>
#include <fft2d.h>
#include <my_math.h>
#include <my_convolve.h>
#include <gl_lsq.h> 
#include <stats.h>


/*-----------------------------------------------------------------------------
!
!.blk           
!
!.prog                             interpol()
!
!.purp        
!
-----------------------------------------------------------------------------*/

#define NB_SPEC 256
#define NPIX 1024

int set_pmas_group(E3D_file *frame, GROUP grupo)
{
         frame->ngroups = 1;
         frame->groups = (GROUP *)malloc(1*sizeof(GROUP));
         frame->groups[0]=grupo;
         return 0;
}

int main(int argc, char **argv)
{
  FILE *fichero;
  int count_fit=0;
  int *spax_id,*type_id;
  float *spax_x,*spax_y,*spax_flux;
  float temp_float;
  char **argval, **arglabel;
  /* Euro3D variables */
  int i,j,k, nb_spec;
  /* INTEGRAL image variables */
  double start_p[2],step_p[2];
  /* General variables */
  char input_filename[80], output_filename[80];
  char position_file[80];
  float dpix,x_min,x_max,y_min,y_max,grid_opt;
  int grid_func;
  int nx,ny,nc;
  float *xo,*yo,*data;
  PLFLT **zo;

  start_p[0]=1; start_p[1]=1;
  step_p[0]=1; step_p[1]=1;

  /* before starting, override any IFU_DEFAULT_FMT variable, *
   * within E3D we only need Euro3D                          */
  setenv("IFU_DEFAULT_FMT","Euro3D",1);

  /* Read a INTEGRAL file header */
  set_arglist("-if|inputfile none -of|outputfile out.fits -dp|dpix 0.3 -gf|grid_func 1 -go|grid_opt 0 -nc|num_col 4");
  set_version(VERSION);
  init_session(argv,argc,&arglabel,&argval);
  set_control_level(WARNING);

  get_argval(0,"%s",input_filename);
  get_argval(1,"%s",output_filename);
  get_argval(2,"%f",&dpix);
  get_argval(3,"%d",&grid_func);
  get_argval(4,"%f",&grid_opt);
  get_argval(5,"%d",&nc);
  nc=nc-1;
  /*
   * We read the position table
   */
  printf("Opening the input file\n");
  if ((fichero=fopen(input_filename,"r"))==NULL) {
    printf("Error opening file: %s\n",position_file);
  } else {
    /*
     * We count the number of lines
     */
    nb_spec=0;
    
    j=0;
    k=0;
    while( fscanf(fichero, "%f", &temp_float) != EOF){            
      if (j>nc) {
        j=0;
        nb_spec++;
      }
      j++;
      k++;
    }
    nb_spec=floor(k/(nc+1));
    j=0;
    printf("%d number of lines.\n Reading...",nb_spec);
    type_id = (int *)malloc((nb_spec)*sizeof(int));          
    spax_id = (int *)malloc((nb_spec)*sizeof(int));          
    spax_x = (float *)malloc((nb_spec)*sizeof(float));          
    spax_y = (float *)malloc((nb_spec)*sizeof(float));          
    spax_flux = (float *)malloc((nb_spec)*sizeof(float));          
    rewind(fichero);
    
    x_max=-1000000;
    x_min=1000000;
    y_max=-1000000;
    y_min=1000000;
    j=0;
    count_fit=0;
    while( fscanf(fichero, "%f", &temp_float) != EOF){
      if (j>nc) {
        j=0;
        count_fit++;
      }
      
      if(j==0) {
        spax_id[count_fit]=floor(temp_float);
      }
      if(j==1) {
        spax_x[count_fit]=temp_float;
        if (x_max<spax_x[count_fit]) x_max=spax_x[count_fit];
        if (x_min>spax_x[count_fit]) x_min=spax_x[count_fit];
      }
      if(j==2) {
        spax_y[count_fit]=temp_float;
        if (y_max<spax_y[count_fit]) y_max=spax_y[count_fit];
        if (y_min>spax_y[count_fit]) y_min=spax_y[count_fit];
      }
      if(j==3) {
        spax_flux[count_fit]=temp_float;
      }
      j++;
    }          

  }
  fclose(fichero);
  
  printf("DONE\n");        
  nx=floor((x_max-x_min)/dpix);
  ny=floor((y_max-y_min)/dpix);
  printf("%f %f %f %f %f %d %d\n",x_min,x_max,y_min,y_max,dpix,nx,ny);
  printf("Interpolating...");
  /*
   * We interpolate
   */
  printf(".");
  xo = (float *) calloc(nx,sizeof(float));    
  yo = (float *) calloc(ny,sizeof(float));    
  zo = (PLFLT **) calloc(nx,sizeof(PLFLT*));
  
  for (i = 0; i < nx; i++) {
    zo[i] = (PLFLT *) calloc(ny,sizeof(PLFLT));
  }
  for (i=0;i<nx;i++) {
    xo[i]=x_min+dpix*i;
  }
  for (j=0;j<ny;j++) {
    yo[j]=y_min+dpix*j;
  }
  my_griddata(spax_x, spax_y, spax_flux, nb_spec, xo, nx, yo, ny, zo, grid_func, grid_opt);

  data = (float *) malloc(nx*ny*sizeof(float));    
  printf(".");

  for (i=0;i<nx;i++) {
    for (j=0;j<ny;j++) {
      data[i+j*nx] = zo[i][j];          
    }
  }
  printf("DONE\n");
  printf("Saving %s file...",output_filename);
  save_int_map(data,nx,ny,output_filename,x_min,dpix,y_min,dpix);

  exit_session(0);
  return(0);
}



