/* 
   S.F.Sanchez January 2003,
   
   This program changes the palete color
   for maps representations...
*/

#include<stdio.h> //For Standard I/O
#include<stdlib.h> //For Functions like ATOI
#include<ctype.h> //For Type check
#include<string.h> //For String manipulation
#include<math.h> //For Math functions


/*
 To use PGPLOT
 */
#include<cpgplot.h>

#define MAX_SIZE 8192
/*
 Image as large as 512x512 pixels
 If the image is larger then we rebin the data,
 to match this size.
 */

/* PGPLOT definitions */
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 1
#endif

void color_palett(int type, double contra, double bright, int sign){
  int nc_ini=0,nc_end=256;
  int range,j,n_ini;
  float value;
  float light,red,green,blue;

  float GL[]={0.0, 1.0};
  float GR[]={0.0, 1.0};
  float GG[]={0.0, 1.0};
  float GB[]={0.0, 1.0};

  float iGL[]={1.0, 0.0};
  float iGR[]={1.0, 0.0};
  float iGG[]={1.0, 0.0};
  float iGB[]={1.0, 0.0};
  
  float RL[]={-0.5, 0.0, 0.17, 0.33, 0.50, 0.67, 0.83, 1.0, 1.7};
  float RR[]={ 0.0, 0.0,  0.0,  0.0,  0.6,  1.0,  1.0, 1.0, 1.0};
  float RG[]={ 0.0, 0.0,  0.0,  1.0,  1.0,  1.0,  0.6, 0.0, 1.0};
  float RB[]={ 0.0, 0.3,  0.8,  1.0,  0.3,  0.0,  0.0, 0.0, 1.0};
  
  float HL[]={0.0, 0.2, 0.4, 0.6, 1.0};
  float HR[]={0.0, 0.5, 1.0, 1.0, 1.0};
  float HG[]={0.0, 0.0, 0.5, 1.0, 1.0};
  float HB[]={0.0, 0.0, 0.0, 0.3, 1.0};
  
  float WL[]={0.0, 0.5, 0.5, 0.7, 0.7, 0.85, 0.85, 0.95, 0.95, 1.0};
  float WR[]={0.0, 1.0, 0.0, 0.0, 0.3,  0.8,  0.3,  1.0,  1.0, 1.0};
  float WG[]={0.0, 0.5, 0.4, 1.0, 0.0,  0.0,  0.2,  0.7,  1.0, 1.0};
  float WB[]={0.0, 0.0, 0.0, 0.0, 0.4,  1.0,  0.0,  0.0, 0.95, 1.0};
  
  float AL[]={0.0, 0.1, 0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.5,
              0.5, 0.6, 0.6, 0.7, 0.7, 0.8, 0.8, 0.9, 0.9, 1.0};
  float AR[]={0.0, 0.0, 0.3, 0.3, 0.5, 0.5, 0.0, 0.0, 0.0, 0.0,
              0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
  float AG[]={0.0, 0.0, 0.3, 0.3, 0.0, 0.0, 0.0, 0.0, 0.8, 0.8,
              0.6, 0.6, 1.0, 1.0, 1.0, 1.0, 0.8, 0.8, 0.0, 0.0};
  float AB[]={0.0, 0.0, 0.3, 0.3, 0.7, 0.7, 0.7, 0.7, 0.9, 0.9,
              0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

  contra=1.0;
  bright=0.0;
  cpgqcol(&nc_ini,&nc_end);
  nc_ini=16+nc_ini;
  range=nc_end-nc_ini;
  switch(type) {
  case (1): {
    /* Grey */
      if (sign>0) {
          for (j=nc_ini;j<nc_end;j++) {
              value=((float)j-nc_ini)/((float)range)/(1-0.0);
              if (value>1.0) value=1.0;
              if (value<0.0) value=0;
              n_ini=floor(value);
              light=GL[n_ini]+(value-n_ini)*(GL[n_ini+1]-GL[n_ini]);
              red=GR[n_ini]+(value-n_ini)*(GR[n_ini+1]-GR[n_ini]);
              green=GG[n_ini]+(value-n_ini)*(GG[n_ini+1]-GG[n_ini]);
              blue=GB[n_ini]+(value-n_ini)*(GB[n_ini+1]-GB[n_ini]);
              
              cpgscr(j,red,green,blue);
              //              printf("%d %4.2f %4.2f %4.2f\n",j,red,green,blue);
          }

      } else {
          for (j=nc_ini;j<nc_end;j++) {
              value=((float)j-nc_ini)/((float)range)/(1-0.0);
              if (value>1.0) value=1.0;
              if (value<0.0) value=0;
              n_ini=floor(value);
              light=iGL[n_ini]+(value-n_ini)*(iGL[n_ini+1]-GL[n_ini]);
              red=iGR[n_ini]+(value-n_ini)*(iGR[n_ini+1]-GR[n_ini]);
              green=iGG[n_ini]+(value-n_ini)*(iGG[n_ini+1]-GG[n_ini]);
              blue=iGB[n_ini]+(value-n_ini)*(iGB[n_ini+1]-GB[n_ini]);
              
              cpgscr(j,red,green,blue);
          }
      }
    break;
  }
  case (2): {
    /* Rainbow */
    for (j=nc_ini;j<nc_end;j++) {
      value=((float)j-nc_ini)/((float)range)*8/(1-0.0);
      if (value>8.0) value=8.0;
      if (value<0.0) value=0;
      n_ini=floor(value);
      light=RL[n_ini]+(value-n_ini)*(RL[n_ini+1]-RL[n_ini]);
      red=RR[n_ini]+(value-n_ini)*(RR[n_ini+1]-RR[n_ini]);
      green=RG[n_ini]+(value-n_ini)*(RG[n_ini+1]-RG[n_ini]);
      blue=RB[n_ini]+(value-n_ini)*(RB[n_ini+1]-RB[n_ini]);
      cpgscr(j,red,green,blue);
    }
    break;
  }
  case (3): {
    /* Heat */
    for (j=nc_ini;j<nc_end;j++) {
      value=((float)j-nc_ini)/((float)range)*4/(1-0.0);
      if (value>4.0) value=4.0;
      if (value<0.0) value=0;
      n_ini=floor(value);
      light=HL[n_ini]+(value-n_ini)*(HL[n_ini+1]-HL[n_ini]);
      red=HR[n_ini]+(value-n_ini)*(HR[n_ini+1]-HR[n_ini]);
      green=HG[n_ini]+(value-n_ini)*(HG[n_ini+1]-HG[n_ini]);
      blue=HB[n_ini]+(value-n_ini)*(HB[n_ini+1]-HB[n_ini]);
      cpgscr(j,red,green,blue);
    }
    break;
  }
  case (4): {
    /* Weird IRAF */
    for (j=nc_ini;j<nc_end;j++) {
      value=((float)j-nc_ini)/((float)range)*9/(1-0.0);
      if (value>9.0) value=9.0;
      if (value<0.0) value=0;
      n_ini=floor(value);
      light=WL[n_ini]+(value-n_ini)*(WL[n_ini+1]-WL[n_ini]);
      red=WR[n_ini]+(value-n_ini)*(WR[n_ini+1]-WR[n_ini]);
      green=WG[n_ini]+(value-n_ini)*(WG[n_ini+1]-WG[n_ini]);
      blue=WB[n_ini]+(value-n_ini)*(WB[n_ini+1]-WB[n_ini]);
      cpgscr(j,red,green,blue);
    }
    break;
  }
  case (5): {
    /* AIPS */
    for (j=nc_ini;j<nc_end;j++) {
      value=((float)j-nc_ini)/((float)range)*19/(1-0.0);
      if (value>19.0) value=19.0;
      if (value<0.0) value=0;
      n_ini=floor(value);
      light=AL[n_ini]+(value-n_ini)*(AL[n_ini+1]-AL[n_ini]);
      red=AR[n_ini]+(value-n_ini)*(AR[n_ini+1]-AR[n_ini]);
      green=AG[n_ini]+(value-n_ini)*(AG[n_ini+1]-AG[n_ini]);
      blue=AB[n_ini]+(value-n_ini)*(AB[n_ini+1]-AB[n_ini]);
      cpgscr(j,red,green,blue);
    }
    break;
  }
  default: {
    for (j=nc_ini;j<nc_end;j++) {
      value=((float)j-nc_ini)/((float)range)*1/(1-0.0);
      if (value>1.0) value=1.0;
      if (value<0.0) value=0;
      n_ini=floor(value);
      light=GL[n_ini]+(value-n_ini)*(GL[n_ini+1]-GL[n_ini]);
      red=GR[n_ini]+(value-n_ini)*(GR[n_ini+1]-GR[n_ini]);
      green=GG[n_ini]+(value-n_ini)*(GG[n_ini+1]-GG[n_ini]);
      blue=GB[n_ini]+(value-n_ini)*(GB[n_ini+1]-GB[n_ini]);
      cpgscr(j,red,green,blue);
    }
    break;
  }
  }
}


