/* 
   S.F.Sanchez Augost 2002,
   Some statistical functions
*/

#include<stdio.h> //For Standard I/O
#include<stdlib.h>
#include<math.h>

#include "stats.h"

int mean_loop(float *data, int n, int n_loop, int n_sigma, float *mean_out, float *sigma_out) {
    int i,j,n_temp;
    float mean_val,sigma_val;
    float *tmp_data;
    
    tmp_data = (float *)malloc((n)*sizeof(float));
    for (j=0;j<n;j++) {
        tmp_data[j]=data[j];
    }
    mean_val=mean(tmp_data,n);
    sigma_val=sigma(tmp_data,n,mean_val);
    i=0;
    while(i<n_loop){
        n_temp=0;
        for (j=0;j<n;j++) {
            if (fabs(data[j]-mean_val)<n_sigma*sigma_val) {                
                tmp_data[n_temp]=data[j];
                n_temp++;
            }
        }
        if (n_temp>3) {
            mean_val=mean(tmp_data,n_temp);
            sigma_val=sigma(tmp_data,n_temp,mean_val);
        } else {
            i=n_loop+1;
        }
        i++;
    }
    free(tmp_data);
    *mean_out=mean_val;
    *sigma_out=sigma_val;
    return(0);
}

float mean(float *data, int n) {
  int i;
  float mean_val=0.0;
  for (i=0;i<n;i++) {
    mean_val+=data[i];
  }
//  printf("i=%d,n=%d\n",i,n);
  mean_val/=n;
  return mean_val;
}

float sigma(float *data, int n, float mean_val) {
  int i=0;
  float sigma_val=0;
  for (i=0;i<n;i++) {
    sigma_val+=pow(data[i]-mean_val,2);
    //    printf("%f %f\n",data[i],mean_val);
  }
  sigma_val=sqrt(sigma_val/(n-1));
  return sigma_val;
}


float median(float *data, int n) {
  int i=0;
  int j=0;
  float temp;
  float median_val=0;
  int n_med=0;
  int n_max=n;


  if (n_max>n) n_max=n;
  /*
   * First we order the numbers from larger to smaller
   */
  for (i=0;i<n_max;i++) {
    for (j=(i+1);j<n_max;j++) {
      if (data[j]>data[i]) {
        temp=data[j];
        data[j]=data[i];
        data[i]=temp;
      }    
    }
  }

  /*
   * Now the median should be the value of
   * the point at the mean
   */

  n_med=(int) (n_max/2);
//  printf("n_med=%d\n",n_med);
  median_val=data[n_med];
  return median_val;
}





float mean_mask(float *data, int *mask, int n) {
  int i;
  int n_now=0;
  float mean_val=0;
  for (i=0;i<n;i++) {
    if ((mask[i]==0)&&(data[i]!=-666.0)) {
      mean_val+=data[i];
      n_now++;
    }
  }
  if (n_now!=0) {
    mean_val/=n_now;
  } else {
    mean_val=-666;
  }
  return mean_val;
}

float sigma_mask(float *data, int *mask, int n, float mean_val) {
  int i=0;
  int n_now=0;
  float sigma_val=0;
  for (i=0;i<n;i++) {
    if ((mask[i]==0)&&(data[i]!=-666.0)) {
      sigma_val+=(float) pow(data[i]-mean_val,2);
      n_now++;
    }
  }
  if ((n_now-1)!=0) {
    sigma_val=sqrt(sigma_val/(n_now-1));
  } else {
    n_now=-666;
  }
  return sigma_val;
}


float median_mask(float *data, int *mask, int n) {
  int i=0;
  int j=0;
  float temp;
  float median_val=0;
  int n_now=0;
  int n_max=n;

  if (n_max>n) n_max=n;
  /*
   * First we order the numbers from larger to smaller
   */
  for (i=0;i<n_max;i++) {
    if (mask[i]==0) n_now++;
    for (j=(i+1);j<n_max;j++) {
      if (data[j]>data[i]) {
        temp=data[j];
        data[j]=data[i];
        data[i]=temp;
      }    
    }
  }

  /*
   * Now the median should be the value of
   * the point at the mean
   * But for the masked it is not so easy!!
   */
  i=0;
  j=0;
  while (i<(n_now/2)) {
    if (mask[i]==0) {
      i++;
    }
    j++;
  }
  median_val=data[j];
  return median_val;
}

float background(float *data, int *mask,int n) {
  float sigma0,delta_sigma;
  int i=0,j=0,k=0;
  float mean_val,sigma_val=0;

  do {
    sigma0=sigma_val;
    mean_val=mean_mask(data,mask,n);
    sigma_val=sigma_mask(data,mask,n,mean_val);
    /*
     * We masked new points if needed!
     */
    for (i=0;i<n;i++){ 
      if (data[i]-mean_val>(2*sigma_val)) {
        mask[i]=1;
        j++;
      }
    }
    delta_sigma=(fabs(sigma0-sigma_val))/sigma_val;
    k++;
    printf("k=%d,mean=%f,s0=%f,s=%f,d=%f,n_mask=%d\n",k,mean_val,sigma0,sigma_val,delta_sigma,j);
  } while (delta_sigma>0.05);
  return mean_val;
}


float bilinear(float *data, long n_axes[2], float x, float y) {
  int i,j;
  float flux,t,u;
  /*
   * We look for the nearest points in the grid.
   */
  i=floor(x);
  j=floor(y);
  t=(x-(float)i);
  u=(y-(float)j);
  if ((i>0)&&(j>0)&&(i<(n_axes[0]-1))&&(j<(n_axes[1]-1))) {
    flux=(1-t)*(1-u)*data[i+j*n_axes[0]]+t*(1-u)*data[i+1+j*n_axes[0]]+t*u*data[i+1+(j+1)*n_axes[0]]+(1-t)*u*data[i+(j+1)*n_axes[0]];
  } else {
    flux=data[i+j*n_axes[0]];
  }
//  printf ("x=%f,y=%f,i=%d,j=%d,flux=%f,data_ij=%f,nx=%d,ny=%d\n",x,y,i,j,flux,data[i+j*n_axes[0]],n_axes[0],n_axes[1]);
//  printf ("nx=%d,ny=%d (2)\n",n_axes[0],n_axes[1]);
  return flux;
}


float datos(float *data, int n_axes[2], int x, int y) {
  float datum;
  datum=data[x+y*n_axes[0]];
  return datum;
}


