/* 
   S.F.Sanchez Augost 2002,

   Subrutine based on PGPLOT to plot an image

*/

#include<stdio.h> //For Standard I/O
#include<stdlib.h> //For Functions like ATOI
#include<ctype.h> //For Type check
#include<string.h> //For String manipulation
#include<math.h> //For Math functions

/*
 To use PGPLOT
 */

#include<cpgplot.h>

#define MAX_SIZE 8192
/*
 Image as large as 512x512 pixels
 If the image is larger then we rebin the data,
 to match this size.
 */

/* PGPLOT definitions */
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 1
#endif






/*
 * Subrutines definitions
 */
void imageplot(float* data,float datamin, float datamax, long l_naxes[2],int id, int p, float contra, float bright, float sign);
void setvp(void);
float minimun(float a, float b);
float maximun(float a, float b);
void palett(int type, float contra, float bright);
void fiddle(long l_naxes[2], char* ch, int* real_x, int* real_y);

//int id1,id2,id3,id4;
//int id_w;

/*
int p=2;
float contra=0.8;
float bright=0.4;
float sign=1.0;
*/

void imageplot(float* data,float datamin, float datamax, long l_naxes[2], int id, int p, float contra, float bright, float sign) {

  float tr[]={0.0,1.0,0.0,0.0,0.0,1.0};

  /*
  int t;
  float x[20],y[20];


  for (t=0;t<20;t++) {
    x[t]=t;
    y[t]=t*t;
  }


  */

  /* Initialize the device
  */

//  printf("You need a device with colour avilities\n");
  /* 
     if (cpgbeg(0,"?",1,1) !=1)
     exit(EXIT_FAILURE);
     cpgask(1);
  */

  /*
   * We select a certain device
   */
  cpgslct(id);
  cpgpage();
  setvp();
  cpgwnad(0.0,1.0+l_naxes[0],0.0,1.0+l_naxes[1]);
  /* Defines the original palette */
  palett(p,sign*contra,bright);
//  palett(2,0.8,0.4);
  /* Plot the image */
  cpgimag(data,l_naxes[0],l_naxes[1],1,l_naxes[0],1,l_naxes[1],datamin,datamax,tr);

  cpgmtxt("t",1.0,0.0,0.0,"Image");
  cpgsch(0.6);
  cpgbox("bcntsi",0.0,0,"bcntsiv",0.0,0);
  cpgmtxt("b",3.0,1.0,1.0,"pixel number");

  /* Draws the Scale */
  cpgwedg("BI",4.0,5.0,datamin,datamax,"pixel value");

//  cpgpt(20,x,y,9);

  cpgsch(1.0);

}

void setvp() {
  float d, vpx1, vpx2, vpy1, vpy2;
  cpgsvp(0.0,1.0,0.0,1.0);
  cpgqvp(1,&vpx1,&vpx2,&vpy1,&vpy2);
  d=minimun(vpx2-vpx1,vpy2-vpy1)/40.0;
  vpx1=vpx1+5.0*d;
  vpx2=vpx2-2.0*d;
  vpy1=vpy1+8.0*d;
  vpy2=vpy2-2.0*d;
  cpgvsiz(vpx1,vpx2,vpy1,vpy2);
  return;
}



float minimun(float a, float b) {
  float c;
  if (a<b) {
    c=a;
  } else {
    c=b;
  }
  return c;
}

float maximun(float a, float b) {
  float c;
  if (a>b) {
    c=a;
  } else {
    c=b;
  }
  return c;
}

/*
 * This subrutine changes the palette.
 * It is very useful, since it has the colour ranges.
 */

void palett(int type, float contra, float bright){
  
  float GL[]={0.0, 1.0};
  float GR[]={0.0, 1.0};
  float GG[]={0.0, 1.0};
  float GB[]={0.0, 1.0};
  
  float RL[]={-0.5, 0.0, 0.17, 0.33, 0.50, 0.67, 0.83, 1.0, 1.7};
  float RR[]={ 0.0, 0.0,  0.0,  0.0,  0.6,  1.0,  1.0, 1.0, 1.0};
  float RG[]={ 0.0, 0.0,  0.0,  1.0,  1.0,  1.0,  0.6, 0.0, 1.0};
  float RB[]={ 0.0, 0.3,  0.8,  1.0,  0.3,  0.0,  0.0, 0.0, 1.0};
  
  float HL[]={0.0, 0.2, 0.4, 0.6, 1.0};
  float HR[]={0.0, 0.5, 1.0, 1.0, 1.0};
  float HG[]={0.0, 0.0, 0.5, 1.0, 1.0};
  float HB[]={0.0, 0.0, 0.0, 0.3, 1.0};
  
  float WL[]={0.0, 0.5, 0.5, 0.7, 0.7, 0.85, 0.85, 0.95, 0.95, 1.0};
  float WR[]={0.0, 1.0, 0.0, 0.0, 0.3,  0.8,  0.3,  1.0,  1.0, 1.0};
  float WG[]={0.0, 0.5, 0.4, 1.0, 0.0,  0.0,  0.2,  0.7,  1.0, 1.0};
  float WB[]={0.0, 0.0, 0.0, 0.0, 0.4,  1.0,  0.0,  0.0, 0.95, 1.0};
  
  float AL[]={0.0, 0.1, 0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.5,
     0.5, 0.6, 0.6, 0.7, 0.7, 0.8, 0.8, 0.9, 0.9, 1.0};
  float AR[]={0.0, 0.0, 0.3, 0.3, 0.5, 0.5, 0.0, 0.0, 0.0, 0.0,
	      0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
  float AG[]={0.0, 0.0, 0.3, 0.3, 0.0, 0.0, 0.0, 0.0, 0.8, 0.8,
	      0.6, 0.6, 1.0, 1.0, 1.0, 1.0, 0.8, 0.8, 0.0, 0.0};
  float AB[]={0.0, 0.0, 0.3, 0.3, 0.7, 0.7, 0.7, 0.7, 0.9, 0.9,
	      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

  switch(type) {
  case (1): {
    /* Grey */
    cpgctab(GL, GR, GG, GB, 2, contra, bright);
    break;
  }
  case (2): {
    /* Rainbow */
    cpgctab(RL, RR, RG, RB, 9, contra, bright);
    break;
  }
  case (3): {
    /* Heat */
    cpgctab(HL, HR, HG, HB, 5, contra, bright);
    break;
  }
  case (4): {
    /* Weird IRAF */
    cpgctab(WL, WR, WG, WB, 10, contra, bright);
    break;
  }
  case (5): {
    /* AIPS */
    cpgctab(AL, AR, AG, AB, 20, contra, bright);
    break;
  }
  default: {
    cpgctab(GL, GR, GG, GB, 2, contra, bright);
    break;
  }
  }
  
}


void fiddle(long l_naxes[2], char* ch, int* real_x, int* real_y) {
  int ier;
  //,pgcurs;
  float x,y;
  float x1,y1,x2,y2,b1,b2,c1,c2;
  
//  int real_x,real_y;
//  char ch[10];

//  float *xx,*yy;
  int fuera=0;


  p=2;
  contra=0.8;
  bright=0.4;
  x=0.5;
  y=1.0;
  sign=1;
  cpgqwin(&x1,&x2,&y1,&y2);
  b1=0.0;
  b2=1.0;
  c1=0.0;
  c2=1.0;
  cpgswin(b1,b2,c1,c2);



  ier=cpgcurs(&x,&y,ch);
  while((toupper(ch[0])!='Q')&&(fuera==0)) {

    if(ier=cpgcurs(&x,&y,ch)){
      *real_x=(int) (l_naxes[0]*x);
      *real_y=(int) (l_naxes[1]*y);
      
      if (*real_x<0) *real_x=0;
      if (*real_x>l_naxes[0]) *real_x=l_naxes[0];
      if (*real_y<0) *real_y=0;
      if (*real_y>l_naxes[1]) *real_y=l_naxes[1];
      

      switch(toupper(ch[0])) {
      case('Z'): {
	fuera=1;
	break;
      }
      case('W'): {
	fuera=1;
	break;
      }
      case('O'): {
	fuera=1;
	break;
      }
      case('R'): {
	fuera=1;
	break;
      }
      case('S'): {
	fuera=1;
	break;
      }
      case('V'): {
	fuera=1;
	break;
      }
      case('M'): {
	fuera=1;
	break;
      }
      case('D'): {
	fuera=1;
	break;
      }
      case('B'): {
	fuera=1;
	break;
      }
      case('N'): {
	fuera=1;
	break;
      }
      case('E'): {
	fuera=1;
	break;
      }
      case('C'): {
	fuera=1;
	break;
      }
      case('G'): {
	fuera=1;
	break;
      }
      case('I'): {
	fuera=1;
	break;
      }
      case('Q'): {
	cpgswin(x1,x2,y1,y2);
	break;
      }
      case('F'): {
	bright= maximun(b1,minimun(b2,x));
	contra= maximun(c1,minimun(c2,y));
	break;
      }
      case(';'): {
	contra=1.0;
	y=1.0;
	bright=0.5;
	x=0.5;
	break;
      }
      case('U'): {
	printf("c=%f,b=%f\n",contra,bright);
	break;
      }
      case('-'): {
	sign=-sign;
	break;
      }
      case('1'): {
	p=1;
	break;
      }
      case('2'): {
	p=2;
	break;
      }
      case('3'): {
	p=3;
	break;
      }
      case('4'): {
	p=4;
	break;
      }
      case('5'): {
	p=5;
	break;
      }
      case('P'): {
	p++;
	if (p>5)
	  p=1;
	break;
      }
      }
      palett(p,sign*contra,bright);

    }
//    ier=cpgcurs(&x,&y,ch);
  }
}

/*
 * This function determine the values over the Fourier serie
 * considering angles in Degrees
 */
