import os, pyfits, time, numarray, TableIO, Numeric
from time import sleep
from TableIO import *
from numarray import *

# modules needed: pyfits, numarray, Numeric, TableIO

print 'Display an image in the V3D, with cuts of [min,max]:'
print '    usage: e3d.display("name",min,max)'
print 'Read the spectrum number "N" and create an array :'
print '    usage: array=e3d.rdspec(number)'
print 'Create a slice between the wavelengths index [i1,i2] and put it in an array :'
print '    usage: array=e3d.rdslice(i1,i2)'

def open_file(filename):
    sleep(1)
    try:
        file = open(filename)
    except:
        open_file(filename)
    return file

def display(name,min,max):
    _env=os.environ['PWD']
    min=str(min)
    max=str(max)
    f=open("/tmp/input.e3d", 'w')
    f.write('cd '+_env+'/ \n')
    f.write('load_e3d '+name+'\n')
    f.write('euro3d draw_raw '+min+' '+max+' 1 1 heat 0.8 0.5 1 \n') 
    f.write('recolor_image heat 0')
    f.close()
    return("done")

def rdspec(num):
    num=str(num)
    f=open("/tmp/input.e3d", 'w')
    f.write('set out_sel {} \n')
    f.write('lappend out_sel '+num+'\n')
    f.write('spec_env save_spec /tmp/output_e3d.fits $out_sel \n')
    f.close()
    fitsfile=open_file("/tmp/output_e3d.fits")    
    fitsfile.close()
    infits=pyfits.open("/tmp/output_e3d.fits")
    d=infits[0].data
    infits.close()
    f=open("/tmp/input.e3d", 'w')
    f.write('file delete /tmp/output_e3d.fits \n')  
    f.close()
    return d

def rdslice(i1,i2):
    i1=str(i1)
    i2=str(i2)
    f=open("/tmp/input.e3d", 'w')
    f.write('spax_env create_slice '+i1+' '+i2+' 0 \n')
    f.write('spax_env save_slice 0 /tmp/output_e3d.txt Flux 1 \n')
    f.close()
    fitsfile=open_file("/tmp/output_e3d.txt")    
    fitsfile.close()
    a=readTableAsArray('/tmp/output_e3d.txt','!#')
    f=open("/tmp/input.e3d", 'w')
    f.write('file delete /tmp/output_e3d.txt \n')  
    f.close()
    return a





