#!/usr/bin/perl

if ($#ARGV != 0) {
   # we want exactly one argument (the version)
   die("We need exactly one argument, the version:\n\tUsage: $0 <VERSION>\nExit");
}

open(FH,"pwd |"); $dir=<FH>; chop($dir); close(FH);
$dir =~ s,/scripts,,; # $dir: make it the installation root dir of E3D

open(FH,"<tk_e3d.tcl");
open(FHOUT,">../user/bin/tk_e3d.tcl");
$line=<FH>;
$line=<FH>;
$line=<FH>;
$line=<FH>;
print FHOUT "\#\!$dir/user/bin/tk_e3d\n";
print FHOUT "set root \"$dir\"\n";
while($line=<FH>) {
   $line =~ s,__E3D_VERSION__,$ARGV[0], ;
   print FHOUT "$line";
}
close(FHOUT);
close(FH);
system("chmod +x ../user/bin/tk_e3d.tcl");
print "tk_e3d.tcl installed OK\n";


open(FH,"<plot_map.tcl");
open(FHOUT,">../user/bin/plot_map.tcl");
$line=<FH>;
print FHOUT "\#\!$dir/user/bin/tk_e3d\n";
while($line=<FH>) {
   print FHOUT "$line";
}
close(FHOUT);
close(FH);
system("chmod +x ../user/bin/plot_map.tcl");
print "plot_map.tcl installed OK\n";

#
# We create the required directories...
#
$home = $ENV{'HOME'};
mkdir("$home/.E3D", 0744) unless (-d "$HOME/.E3D");
mkdir("$home/.E3D/data", 0744) unless (-d "$HOME/.E3D/data");
# system("cp ../data/*.txt ~/.E3D/data/");
print "Done setting up ~/.E3D/ directory\n";

exit;
